/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc.translators;

import com.sap.dbtech.jdbc.packet.DataPart;
import com.sap.dbtech.jdbc.translators.InputStreamFilter;
import com.sap.dbtech.util.JoinStream;
import com.sap.dbtech.util.StructuredMem;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;

public class Putval {
    private byte[] descriptor;
    private byte[] sourceBytes;
    protected StructuredMem descriptorMark;
    private InputStream stream;
    protected StructuredMem requestedData = null;
    protected int requestedLen;
    private int bufpos;
    private boolean needsUpdate;

    Putval(byte[] stream, int bufpos, StructuredMem adescriptorMark) {
        this(stream, bufpos);
        this.descriptorMark = adescriptorMark;
    }

    Putval(InputStream stream, long length, int bufpos) {
        this.stream = length >= 0L ? new InputStreamFilter(stream, length) : stream;
        this.bufpos = bufpos;
    }

    Putval(byte[] bytes, int bufpos) {
        this.stream = new ByteArrayInputStream(bytes);
        this.sourceBytes = bytes;
        this.bufpos = bufpos;
    }

    public Object cloneForBatch() {
        if (this.sourceBytes == null) {
            return this;
        }
        return new Putval(this.sourceBytes, this.bufpos, this.descriptorMark);
    }

    protected Putval(int bufpos) {
        this.bufpos = bufpos;
        this.stream = null;
    }

    public boolean atEnd() {
        return this.stream == null;
    }

    private byte[] newDescriptor() {
        byte[] result = new byte[40];
        return result;
    }

    public void putDescriptor(DataPart mem, int pos) {
        if (this.descriptor == null) {
            this.descriptor = this.newDescriptor();
        }
        this.descriptorMark = mem.putDescriptor(pos, this.descriptor);
    }

    public void setDescriptor(byte[] descriptor) {
        this.descriptor = descriptor;
        this.needsUpdate = false;
    }

    public void markErrorStream() {
        this.descriptorMark.putInt1(8, 27);
        this.descriptorMark.putInt4(0, 32);
        this.descriptorMark.putInt4(0, 36);
        try {
            this.stream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.stream = null;
    }

    protected void transferStream(DataPart dataPart) throws SQLException {
        if (this.atEnd()) {
            dataPart.markEmptyStream(this.descriptorMark);
        } else {
            boolean streamExhausted = dataPart.fillWithStream(this.stream, this.descriptorMark, this);
            if (streamExhausted) {
                try {
                    this.stream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.stream = null;
            }
        }
    }

    public void transferStream(DataPart dataPart, int streamIndex) throws SQLException {
        this.transferStream(dataPart);
        this.descriptorMark.putInt2(streamIndex, 28);
    }

    public String toString() {
        return "<Putval " + this.stream + ">";
    }

    public void markAsLast(DataPart dataPart) {
        if (dataPart.size() - dataPart.getExtent() - 8 - 40 - 1 < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int descriptorPos = dataPart.getExtent();
        this.putDescriptor(dataPart, descriptorPos);
        dataPart.addArg(descriptorPos, 41);
        this.descriptorMark.putInt1(5, 27);
    }

    public void markRequestedChunk(StructuredMem requestedData, int requestedLen) {
        this.requestedData = requestedData;
        this.requestedLen = requestedLen;
    }

    public void reset() {
        if (this.requestedData != null) {
            byte[] data = this.requestedData.getBytes(0, this.requestedLen);
            ByteArrayInputStream firstChunk = new ByteArrayInputStream(data);
            this.stream = this.stream == null ? firstChunk : new JoinStream(new InputStream[]{firstChunk, this.stream});
            this.requestedData = null;
        }
    }

    public final int getBufpos() {
        return this.bufpos;
    }

    public void setNeedsDescriptorUpdate() {
        this.needsUpdate = true;
    }

    public boolean isDescriptorUpdated() {
        return !this.needsUpdate;
    }
}

