/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc.translators;

import com.sap.dbtech.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.dbtech.jdbc.translators.ABAPStreamTranslator;
import com.sap.dbtech.jdbc.translators.AbstractABAPStreamGetval;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;

public class BinaryABAPStreamGetval
extends AbstractABAPStreamGetval {
    public BinaryABAPStreamGetval(ABAPStreamTranslator translator) {
        super(translator);
        this.addColumn(1, 14, 1, 0, 1, 0);
    }

    public byte[] getBytes() throws SQLException {
        if (this.data == null) {
            throw SQLExceptionSapDB.generateSQLException("error.stream.nodata");
        }
        return this.data.bytes();
    }

    public Object getObject() throws SQLException {
        return this.getBytes();
    }

    public Blob getBlob() throws SQLException {
        if (this.data == null) {
            throw SQLExceptionSapDB.generateSQLException("error.stream.nodata");
        }
        return new BlobImplementation(this.data.bytes());
    }

    static class BlobImplementation
    implements Blob {
        byte[] data;

        BlobImplementation(byte[] data) {
            this.data = data;
        }

        public long length() throws SQLException {
            return this.data.length;
        }

        public void truncate(long len) throws SQLException {
            throw SQLExceptionSapDB.generateSQLException("error.stream.blob.unsupported", "truncate");
        }

        public byte[] getBytes(long pos, int length) throws SQLException {
            if (pos > (long)this.data.length || pos < 1L) {
                throw SQLExceptionSapDB.generateSQLException("error.invalid.blob.position", new Long(pos));
            }
            int copy = (int)Math.min((long)length, (long)(this.data.length + 1) - pos);
            byte[] result = new byte[copy];
            System.arraycopy(this.data, (int)(pos - 1L), result, 0, copy);
            return result;
        }

        public int setBytes(long pos, byte[] bytes) throws SQLException {
            throw SQLExceptionSapDB.generateSQLException("error.stream.blob.unsupported", "setBytes");
        }

        public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
            throw SQLExceptionSapDB.generateSQLException("error.stream.blob.unsupported", "setBytes");
        }

        public long position(byte[] pattern, long start) throws SQLException {
            throw SQLExceptionSapDB.generateSQLException("error.stream.blob.unsupported", "position");
        }

        public InputStream getBinaryStream() throws SQLException {
            return new ByteArrayInputStream(this.data);
        }

        public OutputStream setBinaryStream(long pos) throws SQLException {
            throw SQLExceptionSapDB.generateSQLException("error.stream.blob.unsupported", "setBinaryStream");
        }

        public long position(Blob pattern, long start) throws SQLException {
            throw SQLExceptionSapDB.generateSQLException("error.stream.blob.unsupported", "position");
        }

        public void free() throws SQLException {
            throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", "free", "BlobImplementation");
        }

        public InputStream getBinaryStream(long pos, long length) throws SQLException {
            throw SQLExceptionSapDB.generateSQLException("error.method.unsupported", "getBinaryStream", "BlobImplementation");
        }
    }
}

