/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.oracle.ui.wallet;

import com.dbeaver.db.oracle.ui.wallet.AuthModelWalletMessages;
import java.util.LinkedHashMap;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ext.oracle.ui.config.OracleAuthDatabaseNativeConfigurator;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.access.DBAAuthModel;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.TextWithOpenFolder;
import org.jkiss.utils.CommonUtils;

public class AuthModelWalletConfigurator
extends OracleAuthDatabaseNativeConfigurator {
    private TextWithOpenFolder walletFolder;
    private Text passwordText;

    public void createControl(@NotNull Composite parent, DBAAuthModel<?> object, @NotNull Runnable propertyChangeListener) {
        super.createControl(parent, object, propertyChangeListener);
        UIUtils.createControlLabel((Composite)parent, (String)AuthModelWalletMessages.model_wallet_folder);
        this.walletFolder = new TextWithOpenFolder(parent, AuthModelWalletMessages.model_wallet_folder);
        this.walletFolder.setLayoutData((Object)new GridData(768));
        this.walletFolder.setToolTipText(AuthModelWalletMessages.model_wallet_folder_help);
        this.walletFolder.getTextControl().addModifyListener(e -> propertyChangeListener.run());
        Label password = UIUtils.createControlLabel((Composite)parent, (String)AuthModelWalletMessages.model_wallet_password_label);
        password.setToolTipText(AuthModelWalletMessages.model_wallet_password_tip);
        this.passwordText = new Text(parent, 0x400800);
        this.passwordText.setLayoutData((Object)new GridData(768));
        GridData gd = new GridData(32);
        gd.widthHint = UIUtils.getFontHeight((Control)this.passwordText) * 30;
        this.passwordText.setLayoutData((Object)gd);
    }

    public void loadSettings(@NotNull DBPDataSourceContainer dataSource) {
        super.loadSettings(dataSource);
        DBPConnectionConfiguration configuration = dataSource.getConnectionConfiguration();
        this.walletFolder.setText(CommonUtils.notEmpty((String)configuration.getAuthProperty("oracle.wallet.dir")));
        if (this.passwordText != null) {
            this.passwordText.setText(CommonUtils.notEmpty((String)configuration.getAuthProperty("oracle.wallet.password")));
        }
    }

    public void saveSettings(@NotNull DBPDataSourceContainer dataSource) {
        super.saveSettings(dataSource);
        DBPConnectionConfiguration configuration = dataSource.getConnectionConfiguration();
        LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
        props.put("oracle.wallet.dir", this.walletFolder.getText());
        if (this.passwordText != null && CommonUtils.isNotEmpty((String)this.passwordText.getText())) {
            props.put("oracle.wallet.password", this.passwordText.getText());
        }
        configuration.setAuthProperties(props);
    }

    public void resetSettings(@NotNull DBPDataSourceContainer configuration) {
    }

    public boolean isComplete() {
        return this.walletFolder != null && CommonUtils.isNotEmpty((String)this.walletFolder.getText());
    }
}

