/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.graphiti.tb;

import org.eclipse.graphiti.features.IDeleteFeature;
import org.eclipse.graphiti.features.IFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IRemoveFeature;
import org.eclipse.graphiti.features.IUpdateFeature;
import org.eclipse.graphiti.features.context.IContext;
import org.eclipse.graphiti.features.context.impl.DeleteContext;
import org.eclipse.graphiti.features.context.impl.RemoveContext;
import org.eclipse.graphiti.features.context.impl.UpdateContext;
import org.eclipse.graphiti.internal.Messages;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.tb.ContextButtonEntry;
import org.eclipse.graphiti.tb.IContextButtonEntry;
import org.eclipse.graphiti.tb.IContextEntry;

public class ContextEntryHelper {
    public static final String NAME = Messages.ContextEntryHelper_5_xfld;

    public static IContextButtonEntry createDefaultUpdateContextButton(IFeatureProvider featureProvider, PictogramElement pe) {
        final UpdateContext updateContext = new UpdateContext(pe);
        final IUpdateFeature updateFeature = featureProvider.getUpdateFeature(updateContext);
        ContextButtonEntry ret = null;
        if (ContextEntryHelper.checkFeatureAvalability(updateFeature, updateContext)) {
            ret = new ContextButtonEntry(updateFeature, updateContext){

                @Override
                public boolean canExecute() {
                    return super.canExecute() && updateFeature.updateNeeded(updateContext).toBoolean();
                }
            };
            ContextEntryHelper.markAsUpdateContextEntry(ret);
        }
        return ret;
    }

    public static IContextButtonEntry createDefaultRemoveContextButton(IFeatureProvider featureProvider, PictogramElement pe) {
        RemoveContext removeContext = new RemoveContext(pe);
        IRemoveFeature removeFeature = featureProvider.getRemoveFeature(removeContext);
        ContextButtonEntry ret = null;
        if (ContextEntryHelper.checkFeatureAvalability(removeFeature, removeContext)) {
            ret = new ContextButtonEntry(removeFeature, removeContext);
            ContextEntryHelper.markAsRemoveContextEntry(ret);
        }
        return ret;
    }

    public static IContextButtonEntry createDefaultDeleteContextButton(IFeatureProvider featureProvider, PictogramElement pe) {
        DeleteContext deleteContext = new DeleteContext(pe);
        IDeleteFeature deleteFeature = featureProvider.getDeleteFeature(deleteContext);
        ContextButtonEntry ret = null;
        if (ContextEntryHelper.checkFeatureAvalability(deleteFeature, deleteContext)) {
            ret = new ContextButtonEntry(deleteFeature, deleteContext);
            ContextEntryHelper.markAsDeleteContextEntry(ret);
        }
        return ret;
    }

    public static IContextButtonEntry createCollapseContextButton(boolean collapse, IFeature customFeature, IContext customContext) {
        ContextButtonEntry ret = null;
        ret = new ContextButtonEntry(customFeature, customContext);
        if (collapse) {
            ret.setText(Messages.ContextEntryHelper_10_xfld);
            ret.setDescription(Messages.ContextEntryHelper_11_xfld);
            ret.setIconId("org.eclipse.graphiti.edit.collapse");
        } else {
            ret.setText(Messages.ContextEntryHelper_12_xfld);
            ret.setDescription(Messages.ContextEntryHelper_13_xfld);
            ret.setIconId("org.eclipse.graphiti.edit.expand");
        }
        return ret;
    }

    public static void markAsUpdateContextEntry(IContextEntry entry) {
        if (entry != null) {
            ContextEntryHelper.setTextAndDescription(entry, Messages.ContextEntryHelper_0_xfld, Messages.ContextEntryHelper_1_xfld);
            entry.setIconId("org.eclipse.graphiti.edit.refresh");
        }
    }

    public static void markAsRemoveContextEntry(IContextEntry entry) {
        if (entry != null) {
            ContextEntryHelper.setTextAndDescription(entry, Messages.ContextEntryHelper_2_xfld, Messages.ContextEntryHelper_3_xfld);
            entry.setIconId("org.eclipse.graphiti.edit.remove");
        }
    }

    public static void markAsDeleteContextEntry(IContextEntry entry) {
        if (entry != null) {
            ContextEntryHelper.setTextAndDescription(entry, Messages.ContextEntryHelper_4_xfld, Messages.ContextEntryHelper_5_xfld);
            entry.setIconId("org.eclipse.graphiti.edit.delete");
        }
    }

    public static void markAsCollapseContextEntry(IContextEntry entry, boolean collapse) {
        if (entry != null) {
            if (collapse) {
                entry.setText(Messages.ContextEntryHelper_6_xfld);
                entry.setDescription(Messages.ContextEntryHelper_7_xfld);
                entry.setIconId("org.eclipse.graphiti.edit.collapse");
            } else {
                entry.setText(Messages.ContextEntryHelper_8_xfld);
                entry.setDescription(Messages.ContextEntryHelper_9_xfld);
                entry.setIconId("org.eclipse.graphiti.edit.expand");
            }
        }
    }

    private static void setTextAndDescription(IContextEntry entry, String defaultText, String defaultDescription) {
        String entryText = defaultText;
        String entryDescription = defaultDescription;
        IFeature f = entry.getFeature();
        if (f != null) {
            if (f.getName() != null) {
                entryText = f.getName();
            }
            if (f.getDescription() != null) {
                entryDescription = f.getDescription();
            }
        }
        entry.setText(entryText);
        entry.setDescription(entryDescription);
    }

    private static boolean checkFeatureAvalability(IFeature feature, IContext context) {
        return feature != null && feature.isAvailable(context);
    }
}

