/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public enum DatabaseProduct {
    DERBY,
    MYSQL,
    POSTGRES,
    ORACLE,
    SQLSERVER;

    private static final Log LOG;

    public static DatabaseProduct determineDatabaseProduct(String productName) {
        switch (productName) {
            case "Apache Derby": {
                return DERBY;
            }
            case "Microsoft SQL Server": {
                return SQLSERVER;
            }
            case "MySQL": {
                return MYSQL;
            }
            case "Oracle": {
                return ORACLE;
            }
            case "PostgreSQL": {
                return POSTGRES;
            }
        }
        String msg = "Unrecognized database product name <" + productName + ">";
        LOG.error(msg);
        throw new IllegalStateException(msg);
    }

    static {
        LOG = LogFactory.getLog(DatabaseProduct.class.getName());
    }
}

