/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.jdbc.jdbc42.future;

import com.simba.athena.dsi.dataengine.interfaces.future.IResultSet;
import com.simba.athena.dsi.dataengine.utilities.MetadataSourceID;
import com.simba.athena.exceptions.ExceptionConverter;
import com.simba.athena.exceptions.JDBCMessageKey;
import com.simba.athena.jdbc.common.future.SDatabaseMetaData;
import com.simba.athena.jdbc.jdbc41.future.S41MetaDataProxy;
import com.simba.athena.support.ILogger;
import com.simba.athena.support.IWarningListener;
import com.simba.athena.support.LogUtilities;
import com.simba.athena.support.exceptions.ExceptionType;
import com.simba.athena.utilities.JDBCVersion;
import java.sql.SQLException;
import java.sql.SQLType;

public class S42MetaDataProxy
extends S41MetaDataProxy {
    public S42MetaDataProxy(SDatabaseMetaData sDatabaseMetaData, IResultSet iResultSet, MetadataSourceID metadataSourceID, ILogger iLogger) throws SQLException {
        this(sDatabaseMetaData, iResultSet, metadataSourceID, iLogger, JDBCVersion.JDBC42);
    }

    public S42MetaDataProxy(SDatabaseMetaData sDatabaseMetaData, IResultSet iResultSet, MetadataSourceID metadataSourceID, ILogger iLogger, JDBCVersion jDBCVersion) throws SQLException {
        super(sDatabaseMetaData, iResultSet, metadataSourceID, iLogger, jDBCVersion);
    }

    @Override
    public synchronized void updateObject(int n, Object object, SQLType sQLType) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, object, sQLType);
            this.checkIfOpen();
            this.checkIfValidColumnNumber(n);
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_READONLY_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void updateObject(int n, Object object, SQLType sQLType, int n2) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, object, sQLType, n2);
            this.checkIfOpen();
            this.checkIfValidColumnNumber(n);
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_READONLY_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void updateObject(String string, Object object, SQLType sQLType) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, object, sQLType);
        this.updateObject(this.findColumn(string), object, sQLType);
    }

    @Override
    public synchronized void updateObject(String string, Object object, SQLType sQLType, int n) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, object, sQLType, n);
        this.updateObject(this.findColumn(string), object, sQLType, n);
    }
}

