/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.jdbc.jdbc41;

import com.simba.athena.dsi.dataengine.interfaces.IArray;
import com.simba.athena.dsi.dataengine.interfaces.IResultSet;
import com.simba.athena.exceptions.ExceptionConverter;
import com.simba.athena.jdbc.common.SArray;
import com.simba.athena.jdbc.common.SForwardResultSet;
import com.simba.athena.jdbc.common.SStatement;
import com.simba.athena.jdbc.jdbc41.S41Array;
import com.simba.athena.jdbc.jdbc41.S41ResultSetMetaData;
import com.simba.athena.jdbc.jdbc41.utilities.ResultSetUtilities;
import com.simba.athena.support.ILogger;
import com.simba.athena.support.LogUtilities;
import com.simba.athena.utilities.JDBCVersion;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class S41ForwardResultSet
extends SForwardResultSet {
    public S41ForwardResultSet(SStatement sStatement, IResultSet iResultSet, ILogger iLogger) throws SQLException {
        super(sStatement, iResultSet, iLogger);
        this.m_jdbcVersion = JDBCVersion.JDBC41;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
            this.checkIfOpen();
            this.initializeColumnsIfNeeded();
            if (null == this.getResultSetMetaData()) {
                this.initializeResultSetColumns();
                this.setResultSetMetadata(new S41ResultSetMetaData(this.getResultSetColumns(), this.getLogger(), this.getWarningListener()));
            }
            return this.getResultSetMetaData();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    public <T> T getObject(int n, Class<T> clazz) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n, clazz);
            this.checkIfOpen();
            return ResultSetUtilities.getObjectByType(this, n, clazz);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    public <T> T getObject(String string, Class<T> clazz) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, string, clazz);
        return this.getObject(this.findColumn(string), clazz);
    }

    @Override
    protected SArray createArrayResult(IArray iArray) throws SQLException {
        return new S41Array(iArray, this.getParentConnection(), this.getLogger(), this.getWarningListener());
    }
}

