/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.jdbc.common;

import com.simba.athena.dsi.core.impl.DSIDriverSingleton;
import com.simba.athena.dsi.core.interfaces.IConnection;
import com.simba.athena.dsi.dataengine.interfaces.IColumn;
import com.simba.athena.dsi.dataengine.interfaces.future.IResultSet;
import com.simba.athena.exceptions.ExceptionConverter;
import com.simba.athena.exceptions.JDBCMessageKey;
import com.simba.athena.jdbc.common.SConnection;
import com.simba.athena.jdbc.common.SResultSetMetaData;
import com.simba.athena.jdbc.common.SWarningListener;
import com.simba.athena.jdbc.common.utilities.NameToIndexMap;
import com.simba.athena.jdbc.common.utilities.WrapperUtilities;
import com.simba.athena.jdbc.interfaces.IResultSetParent;
import com.simba.athena.support.ILogger;
import com.simba.athena.support.IWarningListener;
import com.simba.athena.support.LogUtilities;
import com.simba.athena.support.exceptions.ErrorException;
import com.simba.athena.support.exceptions.ExceptionType;
import com.simba.athena.utilities.CursorPosition;
import com.simba.athena.utilities.FunctionID;
import com.simba.athena.utilities.JDBCVersion;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;
import java.util.Map;

public abstract class BaseForwardResultSet<T extends IResultSetParent, R extends IResultSet>
implements ResultSet {
    protected ILogger m_logger = null;
    protected SResultSetMetaData m_resultMetaData = null;
    protected long m_currentRow = 0L;
    protected boolean m_isOpen = true;
    protected R m_resultSet = null;
    protected List<? extends IColumn> m_resultSetColumns = null;
    protected SWarningListener m_warningListener = new SWarningListener(DSIDriverSingleton.getInstance().getMessageSource(), null);
    protected boolean m_wasLastValueNull = false;
    private CursorPosition m_cursorPosition = CursorPosition.BEFORE_FIRST;
    private NameToIndexMap m_nameToIndexMap = null;
    private int m_numColumns;
    private final boolean m_canCallHasMoreRows;
    protected T m_parentStatement = null;
    protected JDBCVersion m_jdbcVersion;
    protected final int m_maxRows;
    private boolean m_columnInitializationStarted = false;

    protected BaseForwardResultSet(T t, R r, ILogger iLogger) throws SQLException {
        try {
            this.m_logger = iLogger;
            LogUtilities.logFunctionEntrance(this.m_logger, t, r, iLogger);
            this.m_isOpen = true;
            this.m_parentStatement = t;
            this.m_resultSet = r;
            if (this.m_parentStatement != null) {
                this.m_warningListener.setLocale(this.m_parentStatement.getJDBCConnection().getDSIConnection().getLocale());
            }
            this.m_maxRows = this.m_parentStatement instanceof Statement ? ((Statement)this.m_parentStatement).getMaxRows() : 0;
            this.m_warningListener.clearAndSetFunction(FunctionID.STATEMENT_EXECUTE);
            if (null != this.m_resultSet) {
                this.m_resultSet.registerWarningListener(this.m_warningListener);
                this.m_canCallHasMoreRows = r.supportsHasMoreRows();
            } else {
                this.m_canCallHasMoreRows = false;
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean absolute(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            if (n > 0 && (long)n >= this.m_currentRow) {
                while (this.m_currentRow < (long)n) {
                    if (this.next()) continue;
                    return false;
                }
                return !this.isAfterLast();
            }
            if (1003 == this.getType()) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_FORWARDONLY_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
            }
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void afterLast() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            if (1003 == this.getType()) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_FORWARDONLY_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
            }
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void beforeFirst() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            if (1003 == this.getType()) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_FORWARDONLY_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
            }
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_READONLY_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void clearWarnings() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            this.m_warningListener.clear();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public synchronized void close() throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.m_isOpen = false;
        if (null != this.m_resultSet) {
            this.m_resultSet.close();
            this.m_resultSet = null;
        }
        if (null != this.m_parentStatement) {
            this.m_parentStatement.onResultSetClosed(this);
            this.m_parentStatement = null;
        }
        if (null != this.m_resultMetaData) {
            this.m_resultMetaData = null;
        }
    }

    @Override
    public void deleteRow() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_READONLY_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int findColumn(String string) throws SQLException {
        try {
            LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
            this.checkIfOpen();
            this.initializeColumnsIfNeeded();
            int n = this.m_nameToIndexMap.getIndex(string);
            if (n <= 0) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_COLUMN_NAME, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, string);
            }
            return n;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean first() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            if (1003 == this.getType()) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_FORWARDONLY_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
            }
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public Array getArray(String string) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        return this.getArray(this.findColumn(string));
    }

    @Override
    public InputStream getAsciiStream(String string) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        return this.getAsciiStream(this.findColumn(string));
    }

    @Override
    public BigDecimal getBigDecimal(String string) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        return this.getBigDecimal(this.findColumn(string));
    }

    @Override
    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        LogUtilities.logFunctionEntranceOneObjOneLong(this.m_logger, string, n);
        return this.getBigDecimal(this.findColumn(string), n);
    }

    @Override
    public InputStream getBinaryStream(String string) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        return this.getBinaryStream(this.findColumn(string));
    }

    @Override
    public Blob getBlob(String string) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        return this.getBlob(this.findColumn(string));
    }

    @Override
    public boolean getBoolean(String string) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        return this.getBoolean(this.findColumn(string));
    }

    @Override
    public byte getByte(String string) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        return this.getByte(this.findColumn(string));
    }

    @Override
    public byte[] getBytes(String string) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        return this.getBytes(this.findColumn(string));
    }

    @Override
    public Reader getCharacterStream(String string) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        return this.getCharacterStream(this.findColumn(string));
    }

    @Override
    public Clob getClob(String string) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        return this.getClob(this.findColumn(string));
    }

    @Override
    public int getConcurrency() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            return 1007;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public String getCursorName() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            return this.m_parentStatement.getCursorName(this);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public Date getDate(String string) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        return this.getDate(this.findColumn(string));
    }

    @Override
    public Date getDate(String string, Calendar calendar) throws SQLException {
        LogUtilities.logFunctionEntranceTwoObj(this.m_logger, string, calendar);
        return this.getDate(this.findColumn(string), calendar);
    }

    @Override
    public double getDouble(String string) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        return this.getDouble(this.findColumn(string));
    }

    @Override
    public int getFetchDirection() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            return 1000;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            return this.m_resultSet.getFetchSize();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public float getFloat(String string) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        return this.getFloat(this.findColumn(string));
    }

    @Override
    public int getInt(String string) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        return this.getInt(this.findColumn(string));
    }

    public ILogger getLogger() {
        return this.m_logger;
    }

    @Override
    public long getLong(String string) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        return this.getLong(this.findColumn(string));
    }

    @Override
    public abstract ResultSetMetaData getMetaData() throws SQLException;

    @Override
    public Object getObject(String string) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        return this.getObject(this.findColumn(string));
    }

    @Override
    public Object getObject(String string, Map<String, Class<?>> map) throws SQLException {
        LogUtilities.logFunctionEntranceTwoObj(this.m_logger, string, map);
        return this.getObject(this.findColumn(string), map);
    }

    @Override
    public Ref getRef(String string) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        return this.getRef(this.findColumn(string));
    }

    protected List<? extends IColumn> getResultSetColumns() {
        return this.m_resultSetColumns;
    }

    protected SResultSetMetaData getResultSetMetaData() {
        return this.m_resultMetaData;
    }

    @Override
    public int getRow() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            if (CursorPosition.AFTER_LAST == this.m_cursorPosition || CursorPosition.BEFORE_FIRST == this.m_cursorPosition) {
                return 0;
            }
            return (int)this.m_currentRow;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    public long getRowCount() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            return this.m_resultSet.getRowCount();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public short getShort(String string) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        return this.getShort(this.findColumn(string));
    }

    @Override
    public Statement getStatement() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            if (this.m_parentStatement instanceof Statement) {
                return (Statement)this.m_parentStatement;
            }
            return null;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public String getString(String string) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        return this.getString(this.findColumn(string));
    }

    @Override
    public Time getTime(String string) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        return this.getTime(this.findColumn(string));
    }

    @Override
    public Time getTime(String string, Calendar calendar) throws SQLException {
        LogUtilities.logFunctionEntranceTwoObj(this.m_logger, string, calendar);
        return this.getTime(this.findColumn(string), calendar);
    }

    @Override
    public Timestamp getTimestamp(String string) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        return this.getTimestamp(this.findColumn(string));
    }

    @Override
    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        LogUtilities.logFunctionEntranceTwoObj(this.m_logger, string, calendar);
        return this.getTimestamp(this.findColumn(string), calendar);
    }

    @Override
    public int getType() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            return 1003;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public InputStream getUnicodeStream(String string) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        return this.getUnicodeStream(this.findColumn(string));
    }

    @Override
    public URL getURL(String string) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        return this.getURL(this.findColumn(string));
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            return this.m_warningListener.getSQLWarnings();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    public SWarningListener getWarningListener() {
        return this.m_warningListener;
    }

    @Override
    public void insertRow() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_READONLY_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            return CursorPosition.AFTER_LAST == this.m_cursorPosition;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            return CursorPosition.BEFORE_FIRST == this.m_cursorPosition;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean isFirst() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            return CursorPosition.AT_FIRST == this.m_cursorPosition || CursorPosition.AT_FIRST_AT_LAST == this.m_cursorPosition;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean isLast() throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.checkIfOpen();
        if (!this.m_canCallHasMoreRows) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        return CursorPosition.AT_LAST == this.m_cursorPosition || CursorPosition.AT_FIRST_AT_LAST == this.m_cursorPosition;
    }

    @Override
    public boolean last() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            if (1003 == this.getType()) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_FORWARDONLY_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
            }
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_READONLY_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_READONLY_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean next() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            if (null == this.m_resultSet) {
                return false;
            }
            boolean bl = this.isBelowRowLimit() && this.m_resultSet.moveToNextRow();
            this.updateCursorPosition(bl);
            ++this.m_currentRow;
            this.m_warningListener.clear();
            return bl;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean previous() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            if (1003 == this.getType()) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_FORWARDONLY_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
            }
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void refreshRow() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean relative(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            if (this.getType() == 1003) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_FORWARDONLY_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
            }
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, (IWarningListener)this.m_warningListener, ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            if (CursorPosition.BEFORE_FIRST == this.m_cursorPosition || CursorPosition.AFTER_LAST == this.m_cursorPosition) {
                return false;
            }
            return this.m_resultSet.rowDeleted();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean rowInserted() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            if (CursorPosition.BEFORE_FIRST == this.m_cursorPosition || CursorPosition.AFTER_LAST == this.m_cursorPosition) {
                return false;
            }
            return this.m_resultSet.rowInserted();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            if (CursorPosition.BEFORE_FIRST == this.m_cursorPosition || CursorPosition.AFTER_LAST == this.m_cursorPosition) {
                return false;
            }
            return this.m_resultSet.rowUpdated();
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void setFetchDirection(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            switch (n) {
                case 1000: 
                case 1001: 
                case 1002: {
                    break;
                }
                default: {
                    throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.UNKNOWN_FETCH_DIRECTION, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, String.valueOf(n));
                }
            }
            if (1003 == this.getType() && 1000 != n) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_FORWARDONLY_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
            }
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void setFetchSize(int n) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, n);
            this.checkIfOpen();
            if (n < 0) {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_FETCH_SIZE, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, String.valueOf(n), String.valueOf(0), String.valueOf(Integer.MAX_VALUE));
            }
            this.m_resultSet.setFetchSize(n);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    private void onUpdateMethodCalled(int n) throws SQLException {
        this.checkIfOpen();
        this.checkIfValidColumnNumber(n);
        throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_READONLY_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
    }

    @Override
    public void updateArray(int n, Array array) throws SQLException {
        LogUtilities.logFunctionEntranceOneLong(this.m_logger, n);
        this.onUpdateMethodCalled(n);
    }

    @Override
    public void updateArray(String string, Array array) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        this.updateArray(this.findColumn(string), array);
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        LogUtilities.logFunctionEntranceOneLong(this.m_logger, n);
        this.onUpdateMethodCalled(n);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        this.updateAsciiStream(this.findColumn(string), inputStream, n);
    }

    @Override
    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        LogUtilities.logFunctionEntranceOneLong(this.m_logger, n);
        this.onUpdateMethodCalled(n);
    }

    @Override
    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        this.updateBigDecimal(this.findColumn(string), bigDecimal);
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        LogUtilities.logFunctionEntranceOneLong(this.m_logger, n);
        this.onUpdateMethodCalled(n);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        this.updateBinaryStream(this.findColumn(string), inputStream, n);
    }

    @Override
    public void updateBlob(int n, Blob blob) throws SQLException {
        LogUtilities.logFunctionEntranceOneLong(this.m_logger, n);
        this.onUpdateMethodCalled(n);
    }

    @Override
    public void updateBlob(String string, Blob blob) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        this.updateBlob(this.findColumn(string), blob);
    }

    @Override
    public void updateBoolean(int n, boolean bl) throws SQLException {
        LogUtilities.logFunctionEntranceOneLong(this.m_logger, n);
        this.onUpdateMethodCalled(n);
    }

    @Override
    public void updateBoolean(String string, boolean bl) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        this.updateBoolean(this.findColumn(string), bl);
    }

    @Override
    public void updateByte(int n, byte by) throws SQLException {
        LogUtilities.logFunctionEntranceOneLong(this.m_logger, n);
        this.onUpdateMethodCalled(n);
    }

    @Override
    public void updateByte(String string, byte by) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        this.updateByte(this.findColumn(string), by);
    }

    @Override
    public void updateBytes(int n, byte[] byArray) throws SQLException {
        LogUtilities.logFunctionEntranceOneLong(this.m_logger, n);
        this.onUpdateMethodCalled(n);
    }

    @Override
    public void updateBytes(String string, byte[] byArray) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        this.updateBytes(this.findColumn(string), byArray);
    }

    @Override
    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        LogUtilities.logFunctionEntranceOneLong(this.m_logger, n);
        this.onUpdateMethodCalled(n);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        this.updateCharacterStream(this.findColumn(string), reader, n);
    }

    @Override
    public void updateClob(int n, Clob clob) throws SQLException {
        LogUtilities.logFunctionEntranceOneLong(this.m_logger, n);
        this.onUpdateMethodCalled(n);
    }

    @Override
    public void updateClob(String string, Clob clob) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        this.updateClob(this.findColumn(string), clob);
    }

    @Override
    public void updateDate(int n, Date date) throws SQLException {
        LogUtilities.logFunctionEntranceOneLong(this.m_logger, n);
        this.onUpdateMethodCalled(n);
    }

    @Override
    public void updateDate(String string, Date date) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        this.updateDate(this.findColumn(string), date);
    }

    @Override
    public void updateDouble(int n, double d) throws SQLException {
        LogUtilities.logFunctionEntranceOneLong(this.m_logger, n);
        this.onUpdateMethodCalled(n);
    }

    @Override
    public void updateDouble(String string, double d) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        this.updateDouble(this.findColumn(string), d);
    }

    @Override
    public void updateFloat(int n, float f) throws SQLException {
        LogUtilities.logFunctionEntranceOneLong(this.m_logger, n);
        this.onUpdateMethodCalled(n);
    }

    @Override
    public void updateFloat(String string, float f) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        this.updateFloat(this.findColumn(string), f);
    }

    @Override
    public void updateInt(int n, int n2) throws SQLException {
        LogUtilities.logFunctionEntranceOneLong(this.m_logger, n);
        this.onUpdateMethodCalled(n);
    }

    @Override
    public void updateInt(String string, int n) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        this.updateInt(this.findColumn(string), n);
    }

    @Override
    public void updateLong(int n, long l) throws SQLException {
        LogUtilities.logFunctionEntranceOneLong(this.m_logger, n);
        this.onUpdateMethodCalled(n);
    }

    @Override
    public void updateLong(String string, long l) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        this.updateLong(this.findColumn(string), l);
    }

    @Override
    public void updateNull(int n) throws SQLException {
        LogUtilities.logFunctionEntranceOneLong(this.m_logger, n);
        this.onUpdateMethodCalled(n);
    }

    @Override
    public void updateNull(String string) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        this.updateNull(this.findColumn(string));
    }

    @Override
    public void updateObject(int n, Object object) throws SQLException {
        LogUtilities.logFunctionEntranceOneLong(this.m_logger, n);
        this.onUpdateMethodCalled(n);
    }

    @Override
    public void updateObject(int n, Object object, int n2) throws SQLException {
        LogUtilities.logFunctionEntranceOneLong(this.m_logger, n);
        this.onUpdateMethodCalled(n);
    }

    @Override
    public void updateObject(String string, Object object) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        this.updateObject(this.findColumn(string), object);
    }

    @Override
    public void updateObject(String string, Object object, int n) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        this.updateObject(this.findColumn(string), object, n);
    }

    @Override
    public void updateRef(int n, Ref ref) throws SQLException {
        LogUtilities.logFunctionEntranceOneLong(this.m_logger, n);
        this.onUpdateMethodCalled(n);
    }

    @Override
    public void updateRef(String string, Ref ref) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        this.updateRef(this.findColumn(string), ref);
    }

    @Override
    public void updateRow() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_READONLY_ACTION, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void updateShort(int n, short s) throws SQLException {
        LogUtilities.logFunctionEntranceOneLong(this.m_logger, n);
        this.onUpdateMethodCalled(n);
    }

    @Override
    public void updateShort(String string, short s) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        this.updateShort(this.findColumn(string), s);
    }

    @Override
    public void updateString(int n, String string) throws SQLException {
        LogUtilities.logFunctionEntranceOneLong(this.m_logger, n);
        this.onUpdateMethodCalled(n);
    }

    @Override
    public void updateString(String string, String string2) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        this.updateString(this.findColumn(string), string2);
    }

    @Override
    public void updateTime(int n, Time time) throws SQLException {
        LogUtilities.logFunctionEntranceOneLong(this.m_logger, n);
        this.onUpdateMethodCalled(n);
    }

    @Override
    public void updateTime(String string, Time time) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        this.updateTime(this.findColumn(string), time);
    }

    @Override
    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        LogUtilities.logFunctionEntranceOneLong(this.m_logger, n);
        this.onUpdateMethodCalled(n);
    }

    @Override
    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        this.updateTimestamp(this.findColumn(string), timestamp);
    }

    @Override
    public boolean wasNull() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            return this.m_wasLastValueNull;
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
            this.checkIfOpen();
            return SConnection.getHoldability(this.m_parentStatement.getJDBCConnection().getDSIConnection(), this.m_warningListener);
        }
        catch (Exception exception) {
            throw ExceptionConverter.getInstance().toSQLException(exception, this.getWarningListener(), this.getLogger());
        }
    }

    @Override
    public Reader getNCharacterStream(String string) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntranceOneObj(this.getLogger(), string);
        return this.getNCharacterStream(this.findColumn(string));
    }

    @Override
    public NClob getNClob(String string) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntranceOneObj(this.getLogger(), string);
        return this.getNClob(this.findColumn(string));
    }

    @Override
    public String getNString(String string) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntranceOneObj(this.getLogger(), string);
        return this.getNString(this.findColumn(string));
    }

    @Override
    public RowId getRowId(String string) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntranceOneObj(this.getLogger(), string);
        return this.getRowId(this.findColumn(string));
    }

    @Override
    public SQLXML getSQLXML(String string) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntranceOneObj(this.getLogger(), string);
        return this.getSQLXML(this.findColumn(string));
    }

    @Override
    public boolean isClosed() throws SQLException {
        LogUtilities.logFunctionEntrance(this.getLogger(), new Object[0]);
        return !this.m_isOpen;
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return WrapperUtilities.isWrapperFor(clazz, this);
    }

    public <S> S unwrap(Class<S> clazz) throws SQLException {
        return WrapperUtilities.unwrap(clazz, this);
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntranceOneLong(this.m_logger, n);
        this.onUpdateMethodCalled(n);
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream, long l) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntranceOneLong(this.m_logger, n);
        this.onUpdateMethodCalled(n);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        this.updateAsciiStream(this.findColumn(string), inputStream);
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, long l) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        this.updateAsciiStream(this.findColumn(string), inputStream, l);
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntranceOneLong(this.m_logger, n);
        this.onUpdateMethodCalled(n);
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream, long l) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntranceOneLong(this.m_logger, n);
        this.onUpdateMethodCalled(n);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        this.updateBinaryStream(this.findColumn(string), inputStream);
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, long l) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        this.updateBinaryStream(this.findColumn(string), inputStream, l);
    }

    @Override
    public void updateBlob(int n, InputStream inputStream) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntranceOneLong(this.m_logger, n);
        this.onUpdateMethodCalled(n);
    }

    @Override
    public void updateBlob(int n, InputStream inputStream, long l) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntranceOneLong(this.m_logger, n);
        this.onUpdateMethodCalled(n);
    }

    @Override
    public void updateBlob(String string, InputStream inputStream) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntranceOneObj(this.getLogger(), string);
        this.updateBlob(this.findColumn(string), inputStream);
    }

    @Override
    public void updateBlob(String string, InputStream inputStream, long l) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntranceOneObj(this.getLogger(), string);
        this.updateBlob(this.findColumn(string), inputStream, l);
    }

    @Override
    public void updateCharacterStream(int n, Reader reader) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntranceOneLong(this.m_logger, n);
        this.onUpdateMethodCalled(n);
    }

    @Override
    public void updateCharacterStream(int n, Reader reader, long l) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntranceOneLong(this.m_logger, n);
        this.onUpdateMethodCalled(n);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        this.updateCharacterStream(this.findColumn(string), reader);
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, long l) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntranceOneObj(this.m_logger, string);
        this.updateCharacterStream(this.findColumn(string), reader, l);
    }

    @Override
    public void updateClob(int n, Reader reader) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntranceOneLong(this.m_logger, n);
        this.onUpdateMethodCalled(n);
    }

    @Override
    public void updateClob(int n, Reader reader, long l) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntranceOneLong(this.m_logger, n);
        this.onUpdateMethodCalled(n);
    }

    @Override
    public void updateClob(String string, Reader reader) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntranceOneObj(this.getLogger(), string);
        this.updateClob(this.findColumn(string), reader);
    }

    @Override
    public void updateClob(String string, Reader reader, long l) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntranceOneObj(this.getLogger(), string);
        this.updateClob(this.findColumn(string), reader, l);
    }

    @Override
    public void updateNCharacterStream(int n, Reader reader) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntranceOneLong(this.m_logger, n);
        this.onUpdateMethodCalled(n);
    }

    @Override
    public void updateNCharacterStream(int n, Reader reader, long l) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntranceOneLong(this.m_logger, n);
        this.onUpdateMethodCalled(n);
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntranceOneObj(this.getLogger(), string);
        this.updateNCharacterStream(this.findColumn(string), reader);
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader, long l) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntranceOneObj(this.getLogger(), string);
        this.updateNCharacterStream(this.findColumn(string), reader, l);
    }

    @Override
    public void updateNClob(int n, NClob nClob) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntranceOneLong(this.m_logger, n);
        this.onUpdateMethodCalled(n);
    }

    @Override
    public void updateNClob(int n, Reader reader) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntranceOneLong(this.m_logger, n);
        this.onUpdateMethodCalled(n);
    }

    @Override
    public void updateNClob(int n, Reader reader, long l) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntranceOneLong(this.m_logger, n);
        this.onUpdateMethodCalled(n);
    }

    @Override
    public void updateNClob(String string, NClob nClob) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntranceOneObj(this.getLogger(), string);
        this.updateNClob(this.findColumn(string), nClob);
    }

    @Override
    public void updateNClob(String string, Reader reader) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntranceOneObj(this.getLogger(), string);
        this.updateNClob(this.findColumn(string), reader);
    }

    @Override
    public void updateNClob(String string, Reader reader, long l) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntranceOneObj(this.getLogger(), string);
        this.updateNClob(this.findColumn(string), reader, l);
    }

    @Override
    public void updateNString(int n, String string) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntranceOneLong(this.m_logger, n);
        this.onUpdateMethodCalled(n);
    }

    @Override
    public void updateNString(String string, String string2) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntranceOneObj(this.getLogger(), string);
        this.updateNString(this.findColumn(string), string2);
    }

    @Override
    public void updateRowId(int n, RowId rowId) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntranceOneLong(this.m_logger, n);
        this.onUpdateMethodCalled(n);
    }

    @Override
    public void updateRowId(String string, RowId rowId) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntranceOneObj(this.getLogger(), string);
        this.updateRowId(this.findColumn(string), rowId);
    }

    @Override
    public void updateSQLXML(int n, SQLXML sQLXML) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntranceOneLong(this.m_logger, n);
        this.onUpdateMethodCalled(n);
    }

    @Override
    public void updateSQLXML(String string, SQLXML sQLXML) throws SQLException, SQLFeatureNotSupportedException {
        LogUtilities.logFunctionEntranceOneObj(this.getLogger(), string);
        this.updateSQLXML(this.findColumn(string), sQLXML);
    }

    protected void initializeResultSetColumns() throws ErrorException, SQLException {
        this.m_resultSetColumns = this.m_resultSet.getSelectColumns();
    }

    protected void setResultSetMetadata(SResultSetMetaData sResultSetMetaData) {
        this.m_resultMetaData = sResultSetMetaData;
    }

    protected final void initializeColumnsIfNeeded() throws SQLException {
        if (!this.m_columnInitializationStarted) {
            this.m_columnInitializationStarted = true;
            boolean bl = true;
            try {
                this.initializeColumnNameMap();
                bl = false;
            }
            finally {
                if (bl) {
                    this.m_columnInitializationStarted = false;
                }
            }
        }
    }

    protected void initializeColumnNameMap() throws SQLException {
        if (null == this.m_nameToIndexMap) {
            this.m_numColumns = this.getMetaData().getColumnCount();
            if (null != this.m_resultSet) {
                for (int i = 0; i < this.m_numColumns; ++i) {
                    this.m_resultSet.setDataNeeded(i, true);
                }
            }
            this.m_nameToIndexMap = new NameToIndexMap(this.m_resultSetColumns, new NameToIndexMap.NameGetter<IColumn>(){

                @Override
                public String getName(IColumn iColumn) {
                    return iColumn.getName();
                }
            });
        }
    }

    protected synchronized void checkIfOpen() throws SQLException {
        if (!this.m_isOpen) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.RESULTSET_CLOSED, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT, new Object[0]);
        }
    }

    protected void checkIfValidColumnNumber(int n) throws SQLException {
        this.initializeColumnsIfNeeded();
        if (1 > n || this.m_numColumns < n) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_COLUMN_INDEX, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, String.valueOf(n));
        }
    }

    protected void checkIfValidRowNumber() throws SQLException {
        if (0L == this.m_currentRow) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.CURSOR_BEFORE_FIRST_ROW, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
        }
        if (CursorPosition.AFTER_LAST == this.m_cursorPosition) {
            throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.CURSOR_AFTER_LAST_ROW, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
        }
    }

    protected abstract void closeCurrentStream() throws SQLException;

    protected void finalize() throws Throwable {
        this.close();
    }

    private void updateCursorPosition(boolean bl) throws SQLException, ErrorException {
        HAS_MORE_ROWS hAS_MORE_ROWS = null;
        if (!bl) {
            this.m_cursorPosition = CursorPosition.AFTER_LAST;
            return;
        }
        hAS_MORE_ROWS = this.m_canCallHasMoreRows ? (this.m_resultSet.hasMoreRows() ? HAS_MORE_ROWS.TRUE : HAS_MORE_ROWS.FALSE) : HAS_MORE_ROWS.UNKNOWN;
        switch (this.m_cursorPosition) {
            case BEFORE_FIRST: {
                if (HAS_MORE_ROWS.FALSE != hAS_MORE_ROWS) {
                    this.m_cursorPosition = CursorPosition.AT_FIRST;
                    break;
                }
                this.m_cursorPosition = CursorPosition.AT_FIRST_AT_LAST;
                break;
            }
            case AT_FIRST: {
                if (HAS_MORE_ROWS.TRUE == hAS_MORE_ROWS) {
                    this.m_cursorPosition = CursorPosition.DURING;
                    break;
                }
                if (HAS_MORE_ROWS.FALSE == hAS_MORE_ROWS) {
                    this.m_cursorPosition = CursorPosition.AT_LAST;
                    break;
                }
                this.m_cursorPosition = CursorPosition.UNKNOWN;
                break;
            }
            case UNKNOWN: 
            case DURING: {
                if (HAS_MORE_ROWS.FALSE != hAS_MORE_ROWS) break;
                this.m_cursorPosition = CursorPosition.AT_LAST;
                break;
            }
            case AT_LAST: 
            case AT_FIRST_AT_LAST: {
                if (HAS_MORE_ROWS.TRUE == hAS_MORE_ROWS) {
                    throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_CURSOR_TRANSITION, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, new Object[0]);
                }
                this.m_cursorPosition = CursorPosition.AFTER_LAST;
                break;
            }
            case AFTER_LAST: {
                break;
            }
            default: {
                throw ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_CURSOR_TRANSITION, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, this.m_cursorPosition.toString());
            }
        }
    }

    protected IConnection getParentConnection() throws SQLException {
        return this.m_parentStatement.getJDBCConnection().getDSIConnection();
    }

    private boolean isBelowRowLimit() {
        return this.m_maxRows == 0 || this.m_currentRow < (long)this.m_maxRows;
    }

    private static enum HAS_MORE_ROWS {
        TRUE,
        FALSE,
        UNKNOWN;

    }
}

