/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.iamsupport.plugin.httpserver;

import com.simba.athena.iamsupport.plugin.httpserver.InvalidHttpRequestHandler;
import com.simba.athena.iamsupport.plugin.httpserver.ValidHttpRequestHandler;
import com.simba.athena.iamsupport.plugin.utils.RequestProcess;
import com.simba.athena.shaded.apache.http.HttpException;
import com.simba.athena.shaded.apache.http.HttpRequest;
import com.simba.athena.shaded.apache.http.HttpResponse;
import com.simba.athena.shaded.apache.http.RequestLine;
import com.simba.athena.shaded.apache.http.client.utils.URLEncodedUtils;
import com.simba.athena.shaded.apache.http.message.BasicHttpEntityEnclosingRequest;
import com.simba.athena.shaded.apache.http.protocol.HttpContext;
import com.simba.athena.shaded.apache.http.protocol.HttpRequestHandler;
import java.io.IOException;

public class RequestHandler
implements HttpRequestHandler {
    public static final String ATHENA_PATH = "/athena";
    private static final String SUPPORTED_METHOD = "POST";
    private final RequestProcess m_requestProcessLogic;
    private final HttpRequestHandler m_invalidRequestHandler;
    private final HttpRequestHandler m_validRequestHandler;
    private Object m_result;

    public RequestHandler(RequestProcess requestProcess) {
        this.m_requestProcessLogic = requestProcess;
        this.m_invalidRequestHandler = new InvalidHttpRequestHandler();
        this.m_validRequestHandler = new ValidHttpRequestHandler();
    }

    @Override
    public void handle(HttpRequest httpRequest, HttpResponse httpResponse, HttpContext httpContext) throws HttpException, IOException {
        if (this.isRequestValid(httpRequest)) {
            this.m_result = this.m_requestProcessLogic.getAuthorizationCode(URLEncodedUtils.parse(((BasicHttpEntityEnclosingRequest)httpRequest).getEntity()));
            this.m_validRequestHandler.handle(httpRequest, httpResponse, httpContext);
        } else {
            this.m_invalidRequestHandler.handle(httpRequest, httpResponse, httpContext);
        }
    }

    private boolean isRequestValid(HttpRequest httpRequest) {
        RequestLine requestLine = httpRequest.getRequestLine();
        if (!SUPPORTED_METHOD.equalsIgnoreCase(requestLine.getMethod())) {
            return false;
        }
        return requestLine.getUri().startsWith(ATHENA_PATH);
    }

    public Object getResult() {
        return this.m_result;
    }

    public boolean hasResult() {
        return this.m_result != null;
    }
}

