/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.iamsupport.plugin;

import com.simba.athena.amazonaws.SdkClientException;
import com.simba.athena.amazonaws.util.IOUtils;
import com.simba.athena.amazonaws.util.StringUtils;
import com.simba.athena.amazonaws.util.json.Jackson;
import com.simba.athena.iamsupport.plugin.SamlCredentialsProvider;
import com.simba.athena.iamsupport.plugin.utils.LogUtils;
import com.simba.athena.shaded.apache.commons.codec.binary.Base64;
import com.simba.athena.shaded.apache.http.HttpHost;
import com.simba.athena.shaded.apache.http.NameValuePair;
import com.simba.athena.shaded.apache.http.auth.AuthScope;
import com.simba.athena.shaded.apache.http.auth.UsernamePasswordCredentials;
import com.simba.athena.shaded.apache.http.client.CredentialsProvider;
import com.simba.athena.shaded.apache.http.client.config.RequestConfig;
import com.simba.athena.shaded.apache.http.client.entity.UrlEncodedFormEntity;
import com.simba.athena.shaded.apache.http.client.methods.CloseableHttpResponse;
import com.simba.athena.shaded.apache.http.client.methods.HttpPost;
import com.simba.athena.shaded.apache.http.conn.ssl.NoopHostnameVerifier;
import com.simba.athena.shaded.apache.http.impl.client.BasicCredentialsProvider;
import com.simba.athena.shaded.apache.http.impl.client.CloseableHttpClient;
import com.simba.athena.shaded.apache.http.impl.client.HttpClients;
import com.simba.athena.shaded.apache.http.message.BasicNameValuePair;
import com.simba.athena.shaded.apache.http.util.EntityUtils;
import com.simba.athena.shaded.fasterxml.jackson.databind.JsonNode;
import com.simba.athena.support.LogUtilities;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.util.ArrayList;

public class AzureCredentialsProvider
extends SamlCredentialsProvider {
    private static final String KEY_TENANT_ID = "tenant_id";
    private static final String KEY_CLIENT_SECRET = "client_secret";
    private static final String KEY_CLIENT_ID = "client_id";
    private String m_idpTenant;
    private String m_clientSecret;
    private String m_clientId;

    @Override
    protected String getSamlAssertion() throws IOException {
        LogUtilities.logDebug("Entered", LogUtils.getLogger());
        if (StringUtils.isNullOrEmpty(this.m_idpTenant)) {
            throw new IOException("Missing required property: tenant_id");
        }
        if (StringUtils.isNullOrEmpty(this.m_userName)) {
            throw new IOException("Missing required property: UID or user");
        }
        if (StringUtils.isNullOrEmpty(this.m_password)) {
            throw new IOException("Missing required property: PWD or password");
        }
        if (StringUtils.isNullOrEmpty(this.m_clientSecret)) {
            throw new IOException("Missing required property: client_secret");
        }
        if (StringUtils.isNullOrEmpty(this.m_clientId)) {
            throw new IOException("Missing required property: client_id");
        }
        LogUtilities.logDebug("Exiting", LogUtils.getLogger());
        return this.azureOauthBasedAuthentication();
    }

    @Override
    public void addParameter(String string, String string2) {
        if (KEY_TENANT_ID.equalsIgnoreCase(string)) {
            this.m_idpTenant = string2;
        } else if (KEY_CLIENT_SECRET.equalsIgnoreCase(string)) {
            this.m_clientSecret = string2;
        } else if (KEY_CLIENT_ID.equalsIgnoreCase(string)) {
            this.m_clientId = string2;
        } else {
            super.addParameter(string, string2);
        }
    }

    private String azureOauthBasedAuthentication() throws IOException, SdkClientException {
        String string;
        LogUtilities.logDebug("Entered", LogUtils.getLogger());
        String string2 = "https://login.microsoftonline.com/" + this.m_idpTenant + "/oauth2/token";
        boolean bl = false;
        CloseableHttpClient closeableHttpClient = null;
        CloseableHttpResponse closeableHttpResponse = null;
        try {
            String string3;
            Object object;
            Object object2;
            Object object3;
            closeableHttpClient = this.getHttpClient();
            HttpPost httpPost = new HttpPost(string2);
            if (!(null == this.m_proxyHost || this.m_proxyHost.isEmpty() || !this.m_useProxyForIdpAuth.booleanValue() || (bl = this.CheckNonProxyHost("login.microsoftonline.com", this.m_nonProxyHosts)) || this.m_proxyUid == null || this.m_proxyUid.isEmpty() || this.m_proxyPwd == null || this.m_proxyPwd.isEmpty())) {
                object3 = new BasicCredentialsProvider();
                object3.setCredentials(new AuthScope(this.m_proxyHost, this.m_proxyPort), new UsernamePasswordCredentials(this.m_proxyUid, this.m_proxyPwd));
                closeableHttpClient = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)object3).setSSLHostnameVerifier(NoopHostnameVerifier.INSTANCE).build();
                object2 = new HttpHost(this.m_proxyHost, this.m_proxyPort);
                object = RequestConfig.custom().setProxy((HttpHost)object2).build();
                httpPost.setConfig((RequestConfig)object);
            }
            object3 = new ArrayList<BasicNameValuePair>(7);
            object3.add(new BasicNameValuePair("grant_type", "password"));
            object3.add(new BasicNameValuePair("requested_token_type", "urn:ietf:params:oauth:token-type:saml2"));
            object3.add(new BasicNameValuePair("username", this.m_userName));
            object3.add(new BasicNameValuePair("password", this.m_password));
            object3.add(new BasicNameValuePair(KEY_CLIENT_SECRET, this.m_clientSecret));
            object3.add(new BasicNameValuePair(KEY_CLIENT_ID, this.m_clientId));
            object3.add(new BasicNameValuePair("resource", this.m_clientId));
            httpPost.addHeader("Content-Type", "application/x-www-form-urlencoded");
            httpPost.addHeader("Accept", "application/json");
            httpPost.setEntity(new UrlEncodedFormEntity((Iterable<? extends NameValuePair>)object3, Charset.forName("UTF-8")));
            closeableHttpResponse = closeableHttpClient.execute(httpPost);
            object2 = EntityUtils.toString(closeableHttpResponse.getEntity());
            object = Jackson.jsonNodeOf((String)object2);
            if (closeableHttpResponse.getStatusLine().getStatusCode() != 200) {
                String string4 = "Authentication failed on the Azure server. Please check the tenant, user, password, client secret, and client id.";
                JsonNode jsonNode = ((JsonNode)object).findValue("error_description");
                if (jsonNode != null && !StringUtils.isNullOrEmpty(jsonNode.textValue())) {
                    String string5 = jsonNode.textValue().replaceAll("\r\n", " ");
                    JsonNode jsonNode2 = ((JsonNode)object).findValue("error");
                    string4 = jsonNode2 != null && !StringUtils.isNullOrEmpty(jsonNode2.textValue()) ? jsonNode2.textValue() + ": " + string5 : "Unexpected response: " + string5;
                }
                throw new IOException(string4);
            }
            JsonNode jsonNode = ((JsonNode)object).findValue("access_token");
            if (jsonNode != null) {
                string3 = jsonNode.textValue();
                if (StringUtils.isNullOrEmpty(string3)) {
                    throw new IOException("Invalid Azure access_token response");
                }
            } else {
                throw new IOException("Failed to find Azure access_token");
            }
            String string6 = new String(Base64.decodeBase64(string3), Charset.forName("UTF-8"));
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("<samlp:Response xmlns:samlp=\"urn:oasis:names:tc:SAML:2.0:protocol\">");
            stringBuilder.append("<samlp:Status>");
            stringBuilder.append("<samlp:StatusCode Value=\"urn:oasis:names:tc:SAML:2.0:status:Success\"/>");
            stringBuilder.append("</samlp:Status>");
            stringBuilder.append(string6);
            stringBuilder.append("</samlp:Response>");
            LogUtilities.logDebug("Exiting", LogUtils.getLogger());
            string = new String(Base64.encodeBase64(stringBuilder.toString().getBytes()));
        }
        catch (GeneralSecurityException generalSecurityException) {
            try {
                throw new SdkClientException("Failed to create SSLContext", generalSecurityException);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(closeableHttpResponse, null);
                IOUtils.closeQuietly(closeableHttpClient, null);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(closeableHttpResponse, null);
        IOUtils.closeQuietly(closeableHttpClient, null);
        return string;
    }
}

