/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.dsi.core.utilities.impl.future;

import com.simba.athena.dsi.core.utilities.impl.future.NumberJDBCDataSink;
import com.simba.athena.dsi.exceptions.IncorrectTypeException;
import com.simba.athena.support.IWarningListener;
import com.simba.athena.support.exceptions.ErrorException;
import java.math.BigDecimal;
import java.sql.SQLException;

public abstract class DoubleJDBCDataSink
extends NumberJDBCDataSink<Double> {
    public DoubleJDBCDataSink(IWarningListener iWarningListener) {
        super(iWarningListener);
    }

    @Override
    public void set(Object object) throws IncorrectTypeException, ErrorException {
        if (object == null || object instanceof Double) {
            this.doSet(null);
        } else if (object instanceof Number) {
            this.doSet(((Number)object).doubleValue());
        } else {
            throw new IncorrectTypeException();
        }
    }

    @Override
    public void setByte(byte by) throws IncorrectTypeException, SQLException, ErrorException {
        this.setDouble(by);
    }

    @Override
    public void setShort(short s) throws IncorrectTypeException, SQLException, ErrorException {
        this.setDouble(s);
    }

    @Override
    public void setInt(int n) throws IncorrectTypeException, SQLException, ErrorException {
        this.setDouble(n);
    }

    @Override
    public void setLong(long l) throws IncorrectTypeException, SQLException, ErrorException {
        this.setDouble(l);
    }

    @Override
    public void setFloat(float f) throws IncorrectTypeException, SQLException, ErrorException {
        this.setDouble(f);
    }

    @Override
    public void setDouble(double d) throws IncorrectTypeException, SQLException, ErrorException {
        this.doSet(d);
    }

    @Override
    public void setBigDecimal(BigDecimal bigDecimal) throws IncorrectTypeException, SQLException, ErrorException {
        if (bigDecimal == null) {
            this.setNull(3);
        } else {
            this.setDouble(bigDecimal.doubleValue());
        }
    }

    @Override
    public void setString(String string) throws IncorrectTypeException, SQLException, ErrorException {
        if (string == null) {
            this.setNull(1);
        } else {
            this.setDouble(Double.parseDouble(string));
        }
    }
}

