/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.athena.utilities;

import com.simba.athena.athena.api.AJClient;
import com.simba.athena.athena.core.AJDriver;
import com.simba.athena.athena.dataengine.metadata.AJSchemaMetadata;
import com.simba.athena.athena.exceptions.AJMessageKey;
import com.simba.athena.dsi.dataengine.utilities.TypeUtilities;
import com.simba.athena.support.exceptions.ErrorException;
import java.util.List;

public class AJMetadataHelperUtilities {
    public static int getBufferLength(int n, int n2, int n3, int n4) throws ErrorException {
        switch (n) {
            case -7: 
            case 16: {
                return TypeUtilities.getSizeInBytes(16);
            }
            case -6: {
                return TypeUtilities.getSizeInBytes(-6);
            }
            case 5: {
                return TypeUtilities.getSizeInBytes(5);
            }
            case 4: {
                return TypeUtilities.getSizeInBytes(4);
            }
            case -5: {
                return TypeUtilities.getSizeInBytes(-5);
            }
            case 7: {
                return TypeUtilities.getSizeInBytes(7);
            }
            case 6: {
                return TypeUtilities.getSizeInBytes(6);
            }
            case 8: {
                return TypeUtilities.getSizeInBytes(8);
            }
            case 3: {
                return n2 + 2;
            }
            case 91: {
                return TypeUtilities.getSizeInBytes(91);
            }
            case 93: {
                return TypeUtilities.getSizeInBytes(93);
            }
            case -3: {
                return n4;
            }
            case -9: 
            case -8: 
            case 1: 
            case 12: 
            case 2003: {
                return n3;
            }
        }
        throw AJDriver.s_AJMessages.createGeneralException(AJMessageKey.UNSUPPORTED_SQL_TYPE.name(), Integer.toString(n));
    }

    public static int getColumnSize(int n, int n2, int n3, int n4) throws ErrorException {
        switch (n) {
            case -7: 
            case 16: {
                return 1;
            }
            case -6: {
                return 3;
            }
            case 5: {
                return 5;
            }
            case 4: {
                return 10;
            }
            case -5: {
                return 19;
            }
            case 7: {
                return 24;
            }
            case 6: 
            case 8: {
                return 53;
            }
            case 3: {
                return n2;
            }
            case 91: {
                return 10;
            }
            case 93: {
                return 23;
            }
            case -3: {
                return n4;
            }
            case -9: 
            case -8: 
            case 1: 
            case 12: 
            case 2003: {
                return n3;
            }
        }
        throw AJDriver.s_AJMessages.createGeneralException(AJMessageKey.UNSUPPORTED_SQL_TYPE.name(), Integer.toString(n));
    }

    public static void getSchemasWithCatalogCheck(String string, String string2, AJClient aJClient, List<AJSchemaMetadata> list) throws ErrorException {
        if (null == string2 || !string2.isEmpty() && string2.equals(string)) {
            aJClient.getSchemas(string, list);
        }
    }
}

