/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.athena.dataengine;

import com.simba.athena.amazonaws.services.athena.model.Row;
import com.simba.athena.athena.api.AJExecutionContext;
import com.simba.athena.athena.core.AJConnection;
import com.simba.athena.athena.core.AJSettings;
import com.simba.athena.athena.dataengine.AJBaseResultSet;
import com.simba.athena.athena.dataengine.AJDoubleBufferManager;
import com.simba.athena.athena.dataengine.AJResultSetBuffer;
import com.simba.athena.athena.dataengine.AJStatementType;
import com.simba.athena.dsi.exceptions.OperationCanceledException;
import com.simba.athena.support.ILogger;
import com.simba.athena.support.IWarningListener;
import com.simba.athena.support.LogUtilities;
import com.simba.athena.support.exceptions.ErrorException;
import java.util.ListIterator;

public class AJResultSet
extends AJBaseResultSet {
    private AJDoubleBufferManager m_dbm;
    private AJResultSetBuffer m_resultBuffer = new AJResultSetBuffer();
    private ListIterator<Row> m_rowIterator;

    public AJResultSet(ILogger iLogger, IWarningListener iWarningListener, AJConnection aJConnection, AJSettings aJSettings, AJExecutionContext aJExecutionContext, AJStatementType aJStatementType) throws ErrorException {
        LogUtilities.logFunctionEntrance(iLogger, new Object[0]);
        this.m_logger = iLogger;
        this.m_warningListener = iWarningListener;
        this.m_connection = aJConnection;
        this.m_client = this.m_connection.getClient();
        this.m_settings = aJSettings;
        this.m_execContext = aJExecutionContext;
        this.m_client.fetchRows(this.m_execContext, this.m_resultBuffer);
        int n = 0;
        if (AJStatementType.SELECT_OR_VALUES_STATEMENT == aJStatementType || AJStatementType.EXECUTE_STATEMENT == aJStatementType) {
            n = 1;
        }
        this.m_rowIterator = this.m_resultBuffer.getResultRows().listIterator(n);
        this.initializeColumns(this.m_resultBuffer.getResultSetMetadata().getColumnInfo());
    }

    @Override
    public void close() {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        try {
            this.cleanupDoubleBuffer();
        }
        catch (ErrorException errorException) {
            LogUtilities.logError("Error during double buffering clean up. Details: " + errorException, this.m_logger);
        }
    }

    @Override
    public boolean hasMoreRows() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.checkCancelFlag();
        if (this.m_settings.m_enableDoubleBuffering) {
            if (null == this.m_dbm) {
                this.m_dbm = new AJDoubleBufferManager(this.m_logger, this.m_settings.m_rowsToFetchPerBlock, this.m_client, this.m_execContext);
                this.m_connection.getThreadPool().execute(this.m_dbm);
            }
            if (!this.m_rowIterator.hasNext()) {
                this.checkCancelFlag();
                if (this.m_dbm.getNextBuffer()) {
                    this.m_rowIterator = this.m_dbm.getDataFromBuffer().listIterator();
                }
            }
        } else if (!this.m_rowIterator.hasNext() && this.m_execContext.m_hasMoreRows) {
            this.checkCancelFlag();
            this.m_client.fetchRows(this.m_execContext, this.m_resultBuffer);
            this.m_rowIterator = this.m_resultBuffer.getResultRows().listIterator();
        }
        return this.m_rowIterator.hasNext();
    }

    @Override
    protected void doCloseCursor() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.cleanupDoubleBuffer();
    }

    @Override
    protected boolean doMoveToNextRow() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (this.hasMoreRows()) {
            this.m_currentRow = this.m_rowIterator.next();
            this.parseCurrentRow();
            return true;
        }
        return false;
    }

    @Override
    protected void checkCancelFlag() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        try {
            this.m_client.checkCancelFlag(this.m_execContext);
        }
        catch (OperationCanceledException operationCanceledException) {
            this.cleanupDoubleBuffer();
            throw operationCanceledException;
        }
    }

    private void cleanupDoubleBuffer() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (this.m_settings.m_enableDoubleBuffering && null != this.m_dbm) {
            this.m_dbm.stop();
            this.m_dbm = null;
        }
    }
}

