/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.athena.core;

import com.simba.athena.athena.core.AJConnection;
import com.simba.athena.athena.core.AJSettings;
import com.simba.athena.athena.dataengine.AJDataEngine;
import com.simba.athena.athena.dataengine.AJStatementQueryInfoHandler;
import com.simba.athena.dsi.core.impl.DSIStatement;
import com.simba.athena.dsi.dataengine.interfaces.IDataEngine;
import com.simba.athena.support.LogUtilities;
import com.simba.athena.support.exceptions.ErrorException;

public class AJStatement
extends DSIStatement {
    private AJStatementQueryInfoHandler m_queryInfoHandler;
    private final AJSettings m_settings;
    private String m_catalog = "AwsDataCatalog";
    private String m_preparedStatementName;
    private AJConnection m_connection;

    AJStatement(AJConnection aJConnection, AJSettings aJSettings, String string) throws ErrorException {
        super(aJConnection);
        LogUtilities.logFunctionEntrance(this.getLog(), aJConnection);
        this.m_connection = aJConnection;
        this.m_settings = aJSettings;
        this.m_catalog = string;
        this.m_queryInfoHandler = new AJStatementQueryInfoHandler();
    }

    @Override
    public void close() throws ErrorException {
        if (null != this.m_preparedStatementName && !this.m_preparedStatementName.isEmpty()) {
            this.m_connection.deallocatePrepareStatement(this.m_preparedStatementName);
        }
        LogUtilities.logFunctionEntrance(this.getLog(), new Object[0]);
    }

    @Override
    public IDataEngine createDataEngine() {
        LogUtilities.logFunctionEntrance(this.getLog(), new Object[0]);
        return new AJDataEngine(this, this.m_settings, this.m_catalog);
    }

    public AJStatementQueryInfoHandler getQueryInfoHandler() {
        LogUtilities.logFunctionEntrance(this.getLog(), new Object[0]);
        return this.m_queryInfoHandler;
    }

    public String getPrepareStatement() {
        return this.m_preparedStatementName;
    }

    public void setPrepareStatement(String string) {
        this.m_preparedStatementName = string;
    }
}

