/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.athena.api;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.simba.athena.amazonaws.ClientConfiguration;
import com.simba.athena.amazonaws.SdkClientException;
import com.simba.athena.amazonaws.client.builder.AwsClientBuilder;
import com.simba.athena.amazonaws.client.builder.AwsSyncClientBuilder;
import com.simba.athena.amazonaws.retry.PredefinedRetryPolicies;
import com.simba.athena.amazonaws.retry.RetryPolicy;
import com.simba.athena.amazonaws.services.athena.AmazonAthena;
import com.simba.athena.amazonaws.services.athena.AmazonAthenaClientBuilder;
import com.simba.athena.amazonaws.services.athena.model.AmazonAthenaException;
import com.simba.athena.amazonaws.services.athena.model.Column;
import com.simba.athena.amazonaws.services.athena.model.CreatePreparedStatementRequest;
import com.simba.athena.amazonaws.services.athena.model.CreatePreparedStatementResult;
import com.simba.athena.amazonaws.services.athena.model.DataCatalogSummary;
import com.simba.athena.amazonaws.services.athena.model.Database;
import com.simba.athena.amazonaws.services.athena.model.Datum;
import com.simba.athena.amazonaws.services.athena.model.DeletePreparedStatementRequest;
import com.simba.athena.amazonaws.services.athena.model.DeletePreparedStatementResult;
import com.simba.athena.amazonaws.services.athena.model.EncryptionConfiguration;
import com.simba.athena.amazonaws.services.athena.model.GetQueryExecutionRequest;
import com.simba.athena.amazonaws.services.athena.model.GetQueryExecutionResult;
import com.simba.athena.amazonaws.services.athena.model.GetQueryResultsRequest;
import com.simba.athena.amazonaws.services.athena.model.GetQueryResultsResult;
import com.simba.athena.amazonaws.services.athena.model.GetTableMetadataRequest;
import com.simba.athena.amazonaws.services.athena.model.GetTableMetadataResult;
import com.simba.athena.amazonaws.services.athena.model.GetWorkGroupRequest;
import com.simba.athena.amazonaws.services.athena.model.GetWorkGroupResult;
import com.simba.athena.amazonaws.services.athena.model.ListDataCatalogsRequest;
import com.simba.athena.amazonaws.services.athena.model.ListDataCatalogsResult;
import com.simba.athena.amazonaws.services.athena.model.ListDatabasesRequest;
import com.simba.athena.amazonaws.services.athena.model.ListDatabasesResult;
import com.simba.athena.amazonaws.services.athena.model.ListTableMetadataRequest;
import com.simba.athena.amazonaws.services.athena.model.ListTableMetadataResult;
import com.simba.athena.amazonaws.services.athena.model.QueryExecutionContext;
import com.simba.athena.amazonaws.services.athena.model.QueryExecutionState;
import com.simba.athena.amazonaws.services.athena.model.ResultConfiguration;
import com.simba.athena.amazonaws.services.athena.model.Row;
import com.simba.athena.amazonaws.services.athena.model.StartQueryExecutionRequest;
import com.simba.athena.amazonaws.services.athena.model.StartQueryExecutionResult;
import com.simba.athena.amazonaws.services.athena.model.StopQueryExecutionRequest;
import com.simba.athena.amazonaws.services.athena.model.StopQueryExecutionResult;
import com.simba.athena.amazonaws.services.athena.model.TableMetadata;
import com.simba.athena.amazonaws.services.athenastreamingservice.AthenaStreamingService;
import com.simba.athena.amazonaws.services.athenastreamingservice.AthenaStreamingServiceClient;
import com.simba.athena.amazonaws.services.athenastreamingservice.AthenaStreamingServiceClientBuilder;
import com.simba.athena.amazonaws.services.athenastreamingservice.model.GetQueryResultsStreamRequest;
import com.simba.athena.amazonaws.services.athenastreamingservice.model.GetQueryResultsStreamResult;
import com.simba.athena.amazonaws.services.glue.AWSGlue;
import com.simba.athena.amazonaws.services.glue.AWSGlueClientBuilder;
import com.simba.athena.amazonaws.services.glue.model.AWSGlueException;
import com.simba.athena.amazonaws.services.glue.model.GetCatalogImportStatusRequest;
import com.simba.athena.amazonaws.services.glue.model.GetCatalogImportStatusResult;
import com.simba.athena.amazonaws.services.glue.model.GetDatabasesRequest;
import com.simba.athena.amazonaws.services.glue.model.GetDatabasesResult;
import com.simba.athena.amazonaws.services.glue.model.GetTableRequest;
import com.simba.athena.amazonaws.services.glue.model.GetTableResult;
import com.simba.athena.amazonaws.services.glue.model.GetTablesRequest;
import com.simba.athena.amazonaws.services.glue.model.GetTablesResult;
import com.simba.athena.amazonaws.services.glue.model.Table;
import com.simba.athena.athena.AJMetadataRetrievalMethod;
import com.simba.athena.athena.api.AJExecutionContext;
import com.simba.athena.athena.core.AJConnection;
import com.simba.athena.athena.core.AJDriver;
import com.simba.athena.athena.core.AJSettings;
import com.simba.athena.athena.core.AJStatement;
import com.simba.athena.athena.dataengine.AJResultSetBuffer;
import com.simba.athena.athena.dataengine.metadata.AJColumnMetadata;
import com.simba.athena.athena.dataengine.metadata.AJSchemaMetadata;
import com.simba.athena.athena.dataengine.metadata.AJTableMetadata;
import com.simba.athena.athena.exceptions.AJMessageKey;
import com.simba.athena.athena.utilities.AJAWSLogAppender;
import com.simba.athena.athena.utilities.AJTypeUtilities;
import com.simba.athena.athena.utilities.AJUtilities;
import com.simba.athena.dsi.core.utilities.Variant;
import com.simba.athena.dsi.exceptions.OperationCanceledException;
import com.simba.athena.jdbc.core.DSDriver;
import com.simba.athena.jdbc.exceptions.CommonJDBCMessageKey;
import com.simba.athena.jdbc.utils.StringWrapperFilter;
import com.simba.athena.shaded.apache.http.conn.ConnectTimeoutException;
import com.simba.athena.shaded.apache.log4j.Appender;
import com.simba.athena.shaded.apache.log4j.Logger;
import com.simba.athena.support.ILogger;
import com.simba.athena.support.LogUtilities;
import com.simba.athena.support.Pair;
import com.simba.athena.support.exceptions.DiagState;
import com.simba.athena.support.exceptions.ErrorException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.TimeUnit;

public class AJClient {
    private static final int AJ_NO_QUERY_TIMEOUT = 0;
    private static final String AJ_REGEX_SERDE_ERROR = "GENERIC_INTERNAL_ERROR: error initializing deserializer: org.apache.hadoop.hive.serde2.RegexSerDe";
    private static final RetryPolicy AJ_GLUE_DETECTION_RETRY_POLICY = new RetryPolicy(PredefinedRetryPolicies.DEFAULT_RETRY_CONDITION, RetryPolicy.BackoffStrategy.NO_DELAY, 5, true);
    private static final String AJ_ENDPOINT_START = "https://";
    private static final String AJ_PRE_PRODUCTION_STRING = "athena-webservice-preprod";
    private static final String AJ_ATHENA_STRING = "athena";
    private static final String AJ_ENDPOINT_END = ".amazonaws.com:";
    private static final String AJ_CHINA_ENDPOINT_END = ".amazonaws.com.cn:";
    private static final String AJ_CHINA_REGION_START = "cn-";
    private static final String AJ_ATHENA_PORT = "443";
    private ILogger m_logger;
    private AmazonAthena m_athenaClient;
    private AWSGlue m_glueClient;
    private AthenaStreamingService m_streamClient;
    private final AJSettings m_settings;
    private final Object m_lockCancel = new Object();

    public AJClient(ILogger iLogger, AJSettings aJSettings) throws ErrorException {
        Object object;
        LogUtilities.logFunctionEntrance(iLogger, new Object[0]);
        this.m_logger = iLogger;
        this.m_settings = aJSettings;
        if (this.m_settings.m_useAwsLogger) {
            object = new AJAWSLogAppender(this.m_logger, this.m_logger.getLogLevel());
            Logger.getRootLogger().addAppender((Appender)object);
        }
        object = this.m_settings.m_usePreProduction ? AJ_PRE_PRODUCTION_STRING : AJ_ATHENA_STRING;
        AWSCredentialsProvider aWSCredentialsProvider = AJUtilities.createAwsCredentialsProvider(this.m_logger, this.m_settings);
        try {
            String string = null != this.m_settings.m_athenaEndpoint && !this.m_settings.m_athenaEndpoint.isEmpty() ? AJ_ENDPOINT_START + this.m_settings.m_athenaEndpoint : (this.m_settings.m_awsRegion.startsWith(AJ_CHINA_REGION_START) ? AJ_ENDPOINT_START + (String)object + "." + this.m_settings.m_awsRegion + AJ_CHINA_ENDPOINT_END + AJ_ATHENA_PORT : AJ_ENDPOINT_START + (String)object + "." + this.m_settings.m_awsRegion + AJ_ENDPOINT_END + AJ_ATHENA_PORT);
            LogUtilities.logDebug("Building Athena client with endpoint = '" + string + "' and region = '" + this.m_settings.m_awsRegion + "'.", this.m_logger);
            AmazonAthenaClientBuilder amazonAthenaClientBuilder = AmazonAthenaClientBuilder.standard();
            ((AmazonAthenaClientBuilder)((AmazonAthenaClientBuilder)amazonAthenaClientBuilder.withClientConfiguration(this.m_settings.m_clientConfig)).withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(string, this.m_settings.m_awsRegion))).withCredentials(aWSCredentialsProvider);
            this.m_athenaClient = (AmazonAthena)amazonAthenaClientBuilder.build();
            this.m_glueClient = this.buildGlueClient(aWSCredentialsProvider, this.m_settings.m_clientConfig);
            if (this.m_settings.m_useStreamClient) {
                Object object2;
                String string2;
                if (null != this.m_settings.m_streamingEndpointOverride && !this.m_settings.m_streamingEndpointOverride.isEmpty()) {
                    string2 = AJ_ENDPOINT_START + this.m_settings.m_streamingEndpointOverride;
                } else if (null != this.m_settings.m_athenaEndpoint && !this.m_settings.m_athenaEndpoint.isEmpty()) {
                    object2 = this.m_settings.m_athenaEndpoint.split(":");
                    string2 = AJ_ENDPOINT_START + object2[0] + ":" + this.m_settings.m_athenaStreamClientPort;
                } else {
                    string2 = this.m_settings.m_awsRegion.startsWith(AJ_CHINA_REGION_START) ? AJ_ENDPOINT_START + (String)object + "." + this.m_settings.m_awsRegion + AJ_CHINA_ENDPOINT_END + this.m_settings.m_athenaStreamClientPort : AJ_ENDPOINT_START + (String)object + "." + this.m_settings.m_awsRegion + AJ_ENDPOINT_END + this.m_settings.m_athenaStreamClientPort;
                }
                LogUtilities.logDebug("Building Athena Streaming client with endpoint = '" + string2 + "' and region = '" + this.m_settings.m_awsRegion + "'.", this.m_logger);
                object2 = AthenaStreamingServiceClient.builder();
                ((AthenaStreamingServiceClientBuilder)((AthenaStreamingServiceClientBuilder)((AwsClientBuilder)object2).withClientConfiguration(this.m_settings.m_clientConfig)).withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(string2, this.m_settings.m_awsRegion))).withCredentials(aWSCredentialsProvider);
                this.m_streamClient = (AthenaStreamingService)((AwsSyncClientBuilder)object2).build();
            }
        }
        catch (Exception exception) {
            this.checkAndThrowException(exception, null);
        }
        if (AJMetadataRetrievalMethod.AUTO_DETECT_GLUE == this.m_settings.m_metadataRetrievalMethod) {
            this.checkGlueSupport(aWSCredentialsProvider);
        } else if (AJMetadataRetrievalMethod.GET_METADATA_FROM_PROXY_API == this.m_settings.m_metadataRetrievalMethod) {
            this.checkCatalog(this.m_settings.m_defaultCatalog);
        }
        if (this.m_settings.m_performConnectionTest) {
            this.checkAthenaConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelQuery(AJExecutionContext aJExecutionContext) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, aJExecutionContext);
        Object object = this.m_lockCancel;
        synchronized (object) {
            aJExecutionContext.m_hasBeenCanceled = true;
            if (null == aJExecutionContext.m_queryExecId) {
                LogUtilities.logDebug("No query ID available for query: " + aJExecutionContext.getQuery() + ". Cancel request is not sent to server.", this.m_logger);
                return;
            }
            StopQueryExecutionRequest stopQueryExecutionRequest = new StopQueryExecutionRequest().withQueryExecutionId(aJExecutionContext.m_queryExecId);
            StopQueryExecutionResult stopQueryExecutionResult = this.m_athenaClient.stopQueryExecution(stopQueryExecutionRequest);
            if (200 != stopQueryExecutionResult.getSdkHttpMetadata().getHttpStatusCode()) {
                LogUtilities.logDebug("Error occurred while trying to cancel query: " + aJExecutionContext.getQuery() + ". HTTP Status Code: " + stopQueryExecutionResult.getSdkHttpMetadata().getHttpStatusCode(), this.m_logger);
                throw AJDriver.s_AJMessages.createCustomException(DiagState.DIAG_SERVER_DECLINED_CANCEL.name(), AJMessageKey.ATHENA_CLIENT_ERROR.name(), "Error occurred while trying to cancel query: " + aJExecutionContext.getQuery() + ". HTTP Status Code: " + stopQueryExecutionResult.getSdkHttpMetadata().getHttpStatusCode());
            }
            LogUtilities.logDebug("Successfully canceled query: " + aJExecutionContext.getQuery(), this.m_logger);
        }
    }

    public void checkAndThrowException(Exception exception, AJExecutionContext aJExecutionContext) throws ErrorException {
        if (exception instanceof AmazonAthenaException) {
            throw AJDriver.s_AJMessages.createGeneralException(AJMessageKey.ATHENA_CLIENT_ERROR.name(), new String[]{null == ((AmazonAthenaException)exception).getErrorMessage() ? " Unknown" : ((AmazonAthenaException)exception).getErrorMessage() + (null == aJExecutionContext || null == aJExecutionContext.m_queryExecId || aJExecutionContext.m_queryExecId.isEmpty() ? " [Execution ID not available]" : " [Execution ID: " + aJExecutionContext.m_queryExecId + "]")}, (Throwable)exception);
        }
        if (exception instanceof AWSGlueException) {
            throw AJDriver.s_AJMessages.createGeneralException(AJMessageKey.GLUE_CLIENT_ERROR.name(), new String[]{null == ((AWSGlueException)exception).getErrorMessage() ? " Unknown" : ((AWSGlueException)exception).getErrorMessage()}, (Throwable)exception);
        }
        if (exception instanceof SdkClientException) {
            throw AJDriver.s_AJMessages.createGeneralException(AJMessageKey.AWS_CLIENT_ERR.name(), new String[]{null == exception.getMessage() ? "Unknown" : exception.getMessage() + (null == aJExecutionContext || null == aJExecutionContext.m_queryExecId || aJExecutionContext.m_queryExecId.isEmpty() ? " [Execution ID not available]" : " [Execution ID: " + aJExecutionContext.m_queryExecId + "]")}, (Throwable)exception);
        }
        if (exception instanceof ErrorException) {
            throw (ErrorException)exception;
        }
        throw AJDriver.s_AJMessages.createGeneralException(AJMessageKey.GENERAL_ERROR.name(), (Throwable)exception);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkCancelFlag(AJExecutionContext aJExecutionContext) throws OperationCanceledException {
        LogUtilities.logFunctionEntrance(this.m_logger, aJExecutionContext);
        Object object = this.m_lockCancel;
        synchronized (object) {
            if (aJExecutionContext.m_hasBeenCanceled) {
                throw new OperationCanceledException(101, AJMessageKey.QUERY_CANCELED_ERR.name(), new String[]{aJExecutionContext.getQuery()});
            }
            return aJExecutionContext.m_hasBeenCanceled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCancel(AJExecutionContext aJExecutionContext) {
        LogUtilities.logFunctionEntrance(this.m_logger, aJExecutionContext);
        Object object = this.m_lockCancel;
        synchronized (object) {
            aJExecutionContext.m_hasBeenCanceled = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeQuery(AJExecutionContext aJExecutionContext, String string) throws ErrorException {
        boolean bl;
        Cloneable cloneable;
        LogUtilities.logFunctionEntrance(this.m_logger, aJExecutionContext);
        QueryExecutionContext queryExecutionContext = new QueryExecutionContext().withDatabase(this.m_settings.m_schema);
        if (null != string && !string.equals("AwsDataCatalog")) {
            queryExecutionContext.withCatalog(string);
        }
        ResultConfiguration resultConfiguration = new ResultConfiguration().withOutputLocation(this.m_settings.m_s3OutputLocation);
        if (null != this.m_settings.m_s3OutputEncryptionOption) {
            cloneable = new EncryptionConfiguration().withEncryptionOption(this.m_settings.m_s3OutputEncryptionOption);
            if (this.m_settings.m_s3OutputEncryptionOption.equals("SSE_KMS") || this.m_settings.m_s3OutputEncryptionOption.equals("CSE_KMS")) {
                cloneable.setKmsKey(this.m_settings.m_s3OutputEncryptionKmsKey);
            }
            resultConfiguration.setEncryptionConfiguration((EncryptionConfiguration)cloneable);
        }
        cloneable = new StartQueryExecutionRequest().withQueryExecutionContext(queryExecutionContext).withQueryString(aJExecutionContext.getQuery()).withResultConfiguration(resultConfiguration).withWorkGroup(this.m_settings.m_workgroup);
        StartQueryExecutionResult startQueryExecutionResult = null;
        this.readQueryTimeoutValue(aJExecutionContext);
        long l = 0L;
        boolean bl2 = bl = 0 < aJExecutionContext.m_queryTimeout;
        if (bl) {
            l = System.nanoTime();
        }
        Object object = this.m_lockCancel;
        synchronized (object) {
            try {
                startQueryExecutionResult = this.m_athenaClient.startQueryExecution((StartQueryExecutionRequest)cloneable);
            }
            catch (Exception exception) {
                this.checkAndThrowException(exception, aJExecutionContext);
            }
            aJExecutionContext.m_queryExecId = startQueryExecutionResult.getQueryExecutionId();
            if (null != aJExecutionContext.m_statement) {
                if (aJExecutionContext.m_isLimit0Query) {
                    ((AJStatement)aJExecutionContext.m_statement).getQueryInfoHandler().setPreparedQueryId(aJExecutionContext.m_queryExecId);
                } else {
                    ((AJStatement)aJExecutionContext.m_statement).getQueryInfoHandler().setQueryId(aJExecutionContext.m_queryExecId);
                }
            }
        }
        object = new GetQueryExecutionRequest().withQueryExecutionId(aJExecutionContext.m_queryExecId);
        GetQueryExecutionResult getQueryExecutionResult = null;
        boolean bl3 = true;
        int n = this.m_settings.m_minQueryExecPollingInterval;
        boolean bl4 = false;
        while (bl3) {
            long l2;
            long l3;
            if (bl && (l3 = TimeUnit.NANOSECONDS.toSeconds((l2 = System.nanoTime()) - l)) >= (long)aJExecutionContext.m_queryTimeout) {
                this.cancelQuery(aJExecutionContext);
            }
            getQueryExecutionResult = this.m_athenaClient.getQueryExecution((GetQueryExecutionRequest)object);
            String string2 = getQueryExecutionResult.getQueryExecution().getStatus().getState();
            String string3 = getQueryExecutionResult.getQueryExecution().getStatus().getStateChangeReason();
            if (string2.equals(QueryExecutionState.FAILED.toString())) {
                if (string3.equals(AJ_REGEX_SERDE_ERROR)) {
                    throw AJDriver.s_AJMessages.createGeneralException(AJMessageKey.MISSING_SERDE_PROPERTY_ERROR.name(), string3 + (aJExecutionContext.m_queryExecId.isEmpty() ? " [Execution ID not available]" : " [Execution ID: " + aJExecutionContext.m_queryExecId + "]"));
                }
                throw AJDriver.s_AJMessages.createGeneralException(AJMessageKey.ATHENA_CLIENT_ERROR.name(), string3 + (aJExecutionContext.m_queryExecId.isEmpty() ? " [Execution ID not available]" : " [Execution ID: " + aJExecutionContext.m_queryExecId + "]"));
            }
            if (string2.equals(QueryExecutionState.CANCELLED.toString())) {
                throw new OperationCanceledException(101, AJMessageKey.QUERY_CANCELED_ERR.name(), new String[]{aJExecutionContext.getQuery()});
            }
            if (string2.equals(QueryExecutionState.SUCCEEDED.toString())) {
                bl3 = false;
                return;
            }
            try {
                Thread.sleep(n);
                if (bl4) continue;
                if (Integer.MAX_VALUE / n >= this.m_settings.m_execPollingIntervalMultiplier) {
                    if ((n = this.m_settings.m_execPollingIntervalMultiplier * n) <= this.m_settings.m_maxQueryExecPollingInterval) continue;
                    n = this.m_settings.m_maxQueryExecPollingInterval;
                    bl4 = true;
                    continue;
                }
                bl4 = true;
            }
            catch (InterruptedException interruptedException) {
                throw AJDriver.s_AJMessages.createGeneralException(AJMessageKey.THREAD_INTERRUPTED_ERR.name(), interruptedException.getMessage());
            }
        }
    }

    public void fetchRows(AJExecutionContext aJExecutionContext, AJResultSetBuffer aJResultSetBuffer) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, aJExecutionContext);
        this.readFetchSizeValue(aJExecutionContext);
        GetQueryResultsRequest getQueryResultsRequest = new GetQueryResultsRequest().withQueryExecutionId(aJExecutionContext.m_queryExecId).withMaxResults(aJExecutionContext.m_fetchSize);
        if (null != aJExecutionContext.m_nextToken) {
            getQueryResultsRequest.withNextToken(aJExecutionContext.m_nextToken);
        }
        try {
            GetQueryResultsResult getQueryResultsResult = this.m_athenaClient.getQueryResults(getQueryResultsRequest);
            if (!aJExecutionContext.m_hasResultSetMetadata) {
                aJResultSetBuffer.setResultSetMetadata(getQueryResultsResult.getResultSet().getResultSetMetadata());
                aJExecutionContext.m_hasResultSetMetadata = true;
            }
            aJResultSetBuffer.setResultRows(getQueryResultsResult.getResultSet().getRows());
            aJExecutionContext.m_nextToken = getQueryResultsResult.getNextToken();
            aJExecutionContext.m_hasMoreRows = null != aJExecutionContext.m_nextToken;
        }
        catch (Exception exception) {
            this.checkAndThrowException(exception, aJExecutionContext);
        }
    }

    public GetQueryResultsStreamResult fetchStreamResults(AJExecutionContext aJExecutionContext) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, aJExecutionContext);
        this.readFetchSizeValue(aJExecutionContext);
        GetQueryResultsStreamRequest getQueryResultsStreamRequest = new GetQueryResultsStreamRequest().withMaxResults(aJExecutionContext.m_fetchSize).withQueryExecutionId(aJExecutionContext.m_queryExecId);
        if (null != aJExecutionContext.m_nextToken) {
            getQueryResultsStreamRequest.withNextToken(aJExecutionContext.m_nextToken);
        } else if (null != aJExecutionContext.m_retryNextToken) {
            getQueryResultsStreamRequest.withNextToken(aJExecutionContext.m_retryNextToken);
        }
        GetQueryResultsStreamResult getQueryResultsStreamResult = null;
        try {
            getQueryResultsStreamResult = this.m_streamClient.getQueryResultsStream(getQueryResultsStreamRequest);
        }
        catch (Exception exception) {
            this.checkAndThrowException(exception, aJExecutionContext);
        }
        return getQueryResultsStreamResult;
    }

    public void checkCatalog(String string) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (AJMetadataRetrievalMethod.GET_METADATA_FROM_PROXY_API != this.m_settings.m_metadataRetrievalMethod) {
            return;
        }
        List<DataCatalogSummary> list = this.getCatalogsWtihProxyApi();
        if (null == list) {
            list = new ArrayList<DataCatalogSummary>();
        }
        for (DataCatalogSummary dataCatalogSummary : list) {
            if (!dataCatalogSummary.getCatalogName().equalsIgnoreCase(string)) continue;
            return;
        }
        throw AJDriver.s_AJMessages.createGeneralException(AJMessageKey.INVALID_CATALOG_ERR, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DataCatalogSummary> getCatalogsWtihProxyApi() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        ListDataCatalogsRequest listDataCatalogsRequest = new ListDataCatalogsRequest();
        LogUtilities.logDebug("Aws::Athena - AthenaClient - GetCatalogs +++++ enter +++++", this.m_logger);
        ListDataCatalogsResult listDataCatalogsResult = null;
        try {
            listDataCatalogsResult = this.m_athenaClient.listDataCatalogs(listDataCatalogsRequest);
        }
        catch (Exception exception) {
            this.checkAndThrowException(exception, null);
        }
        finally {
            LogUtilities.logDebug("Aws::Athena - AthenaClient - GetCatalogs ----- exit -----", this.m_logger);
        }
        this.m_settings.m_performConnectionTest = false;
        return listDataCatalogsResult.getDataCatalogsSummary();
    }

    public void getColumnsMetadata(String string, String string2, StringWrapperFilter stringWrapperFilter, StringWrapperFilter stringWrapperFilter2, List<AJColumnMetadata> list) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, string2, stringWrapperFilter, stringWrapperFilter2, list);
        assert (AJMetadataRetrievalMethod.AUTO_DETECT_GLUE != this.m_settings.m_metadataRetrievalMethod);
        if (AJMetadataRetrievalMethod.GET_METADATA_FROM_PROXY_API == this.m_settings.m_metadataRetrievalMethod) {
            this.fetchColumnsMetadataWithProxyApi(string, string2, stringWrapperFilter, stringWrapperFilter2, list);
        } else if (AJMetadataRetrievalMethod.GET_METADATA_FROM_GLUE == this.m_settings.m_metadataRetrievalMethod) {
            this.fetchColumnsMetadataWithGlue(string2, stringWrapperFilter, stringWrapperFilter2, list);
        } else {
            this.fetchColumnsMetadataWithQuery(string2, stringWrapperFilter, stringWrapperFilter2, list);
        }
    }

    public void getColumnsMetadataForSpecificTable(String string, String string2, String string3, StringWrapperFilter stringWrapperFilter, StringWrapperFilter stringWrapperFilter2, List<AJColumnMetadata> list) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, string2, string3, stringWrapperFilter, stringWrapperFilter2, list);
        assert (AJMetadataRetrievalMethod.AUTO_DETECT_GLUE != this.m_settings.m_metadataRetrievalMethod);
        if (AJMetadataRetrievalMethod.GET_METADATA_FROM_PROXY_API == this.m_settings.m_metadataRetrievalMethod) {
            this.fetchColumnsMetadataForSpecificTableWithProxyApi(string, string2, string3, stringWrapperFilter, stringWrapperFilter2, list);
        } else if (AJMetadataRetrievalMethod.GET_METADATA_FROM_GLUE == this.m_settings.m_metadataRetrievalMethod) {
            this.fetchColumnsMetadataForSpecificTableWithGlue(string2, string3, stringWrapperFilter, stringWrapperFilter2, list);
        } else {
            this.fetchColumnsMetadataForSpecificTableWithQuery(string2, string3, stringWrapperFilter, stringWrapperFilter2, list);
        }
    }

    public AJMetadataRetrievalMethod getMetadataRetrievalMethod() {
        return this.m_settings.m_metadataRetrievalMethod;
    }

    public void getSchemas(String string, List<AJSchemaMetadata> list) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, list);
        assert (AJMetadataRetrievalMethod.AUTO_DETECT_GLUE != this.m_settings.m_metadataRetrievalMethod);
        if (AJMetadataRetrievalMethod.GET_METADATA_FROM_PROXY_API == this.m_settings.m_metadataRetrievalMethod) {
            this.fetchSchemasWithProxyApi(string, list);
        } else if (AJMetadataRetrievalMethod.GET_METADATA_FROM_GLUE == this.m_settings.m_metadataRetrievalMethod || AJMetadataRetrievalMethod.GET_METADATA_WITH_QUERY == this.m_settings.m_metadataRetrievalMethod) {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (AJMetadataRetrievalMethod.GET_METADATA_FROM_GLUE == this.m_settings.m_metadataRetrievalMethod) {
                this.fetchSchemasWithGlue(arrayList);
            } else {
                this.fetchSchemasWithQuery(arrayList);
            }
            for (String string2 : arrayList) {
                list.add(new AJSchemaMetadata(string, string2));
            }
        }
    }

    public void getTablesMetadata(String string, String string2, List<AJTableMetadata> list) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, string2, list);
        assert (AJMetadataRetrievalMethod.AUTO_DETECT_GLUE != this.m_settings.m_metadataRetrievalMethod);
        if (AJMetadataRetrievalMethod.GET_METADATA_FROM_PROXY_API == this.m_settings.m_metadataRetrievalMethod) {
            ArrayList<TableMetadata> arrayList = new ArrayList<TableMetadata>();
            this.fetchTablesWithProxyApi(string, string2, arrayList);
            for (TableMetadata tableMetadata : arrayList) {
                String string3 = tableMetadata.getTableType();
                if (this.m_settings.m_forceTableTypeTable) {
                    string3 = "TABLE";
                } else if (null == string3 || string3.isEmpty()) {
                    string3 = "EXTERNAL_TABLE";
                } else if (this.m_settings.m_mapAllViewTypeToView && string3.toUpperCase().contains("VIEW")) {
                    string3 = "VIEW";
                }
                list.add(new AJTableMetadata(string, string2, tableMetadata.getName(), string3));
            }
        } else if (AJMetadataRetrievalMethod.GET_METADATA_FROM_GLUE == this.m_settings.m_metadataRetrievalMethod) {
            ArrayList<Table> arrayList = new ArrayList<Table>();
            this.fetchTablesWithGlue(string2, arrayList);
            for (Table table : arrayList) {
                String string4 = table.getTableType();
                if (this.m_settings.m_forceTableTypeTable) {
                    string4 = "TABLE";
                } else if (null == string4 || string4.isEmpty()) {
                    string4 = "EXTERNAL_TABLE";
                } else if (this.m_settings.m_mapAllViewTypeToView && string4.toUpperCase().contains("VIEW")) {
                    string4 = "VIEW";
                }
                list.add(new AJTableMetadata("AwsDataCatalog", string2, table.getName(), string4));
            }
        } else {
            ArrayList<String> arrayList = new ArrayList<String>();
            this.fetchTablesWithQuery(string2, arrayList);
            for (String string5 : arrayList) {
                list.add(new AJTableMetadata("AwsDataCatalog", string2, string5, "TABLE"));
            }
        }
    }

    public void getTableMetadata(String string, String string2, String string3, List<AJTableMetadata> list) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, string2, list);
        assert (AJMetadataRetrievalMethod.AUTO_DETECT_GLUE != this.m_settings.m_metadataRetrievalMethod);
        if (AJMetadataRetrievalMethod.GET_METADATA_FROM_PROXY_API == this.m_settings.m_metadataRetrievalMethod) {
            TableMetadata tableMetadata = this.fetchSpecificTableWithProxyApi(string, string2, string3);
            if (null != tableMetadata) {
                String string4 = tableMetadata.getTableType();
                if (this.m_settings.m_forceTableTypeTable) {
                    string4 = "TABLE";
                } else if (null == string4 || string4.isEmpty()) {
                    string4 = "EXTERNAL_TABLE";
                } else if (this.m_settings.m_mapAllViewTypeToView && string4.toUpperCase().contains("VIEW")) {
                    string4 = "VIEW";
                }
                list.add(new AJTableMetadata(string, string2, tableMetadata.getName(), string4));
            }
        } else if (AJMetadataRetrievalMethod.GET_METADATA_FROM_GLUE == this.m_settings.m_metadataRetrievalMethod) {
            Table table = this.fetchSpecificTableWithGlue(string2, string3);
            if (null != table) {
                String string5 = table.getTableType();
                if (this.m_settings.m_forceTableTypeTable) {
                    string5 = "TABLE";
                } else if (null == string5 || string5.isEmpty()) {
                    string5 = "EXTERNAL_TABLE";
                } else if (this.m_settings.m_mapAllViewTypeToView && string5.toUpperCase().contains("VIEW")) {
                    string5 = "VIEW";
                }
                list.add(new AJTableMetadata("AwsDataCatalog", string2, table.getName(), string5));
            }
        } else {
            ArrayList<String> arrayList = new ArrayList<String>();
            this.fetchSpecificTableWithQuery(string2, string3, arrayList);
            if (!arrayList.isEmpty()) {
                list.add(new AJTableMetadata("AwsDataCatalog", string2, (String)arrayList.get(0), "TABLE"));
            }
        }
    }

    public Long getUpdateCountNonStream(AJExecutionContext aJExecutionContext) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, aJExecutionContext);
        Long l = 0L;
        this.readFetchSizeValue(aJExecutionContext);
        GetQueryResultsRequest getQueryResultsRequest = new GetQueryResultsRequest().withQueryExecutionId(aJExecutionContext.m_queryExecId).withMaxResults(aJExecutionContext.m_fetchSize);
        try {
            GetQueryResultsResult getQueryResultsResult = this.m_athenaClient.getQueryResults(getQueryResultsRequest);
            l = getQueryResultsResult.getUpdateCount();
        }
        catch (Exception exception) {
            this.checkAndThrowException(exception, aJExecutionContext);
        }
        return l;
    }

    public void prepareStatement(AJStatement aJStatement, String string, AJConnection aJConnection) throws ErrorException {
        String string2 = aJConnection.getPreparedStatementCounter();
        CreatePreparedStatementRequest createPreparedStatementRequest = new CreatePreparedStatementRequest().withQueryStatement(string).withWorkGroup(this.m_settings.m_workgroup).withStatementName(string2);
        CreatePreparedStatementResult createPreparedStatementResult = new CreatePreparedStatementResult();
        createPreparedStatementResult = this.m_athenaClient.createPreparedStatement(createPreparedStatementRequest);
        if (200 != createPreparedStatementResult.getSdkHttpMetadata().getHttpStatusCode()) {
            throw AJDriver.s_AJMessages.createGeneralException(AJMessageKey.PREPARED_STATEMENT_ERROR.name(), String.valueOf(createPreparedStatementResult.getSdkHttpMetadata().getHttpStatusCode()));
        }
        aJConnection.addPreparedStatement(string2, string);
        aJStatement.setPrepareStatement(string2);
    }

    public boolean deallocatePrepareStatement(String string) throws ErrorException {
        DeletePreparedStatementRequest deletePreparedStatementRequest = new DeletePreparedStatementRequest().withStatementName(string).withWorkGroup(this.m_settings.m_workgroup);
        DeletePreparedStatementResult deletePreparedStatementResult = new DeletePreparedStatementResult();
        deletePreparedStatementResult = this.m_athenaClient.deletePreparedStatement(deletePreparedStatementRequest);
        if (200 == deletePreparedStatementResult.getSdkHttpMetadata().getHttpStatusCode()) {
            return true;
        }
        throw AJDriver.s_AJMessages.createGeneralException(AJMessageKey.DEALLOCATE_STATEMENT_ERROR.name(), String.valueOf(deletePreparedStatementResult.getSdkHttpMetadata().getHttpStatusCode()));
    }

    private void addColumnMetadata(String string, String string2, String string3, String string4, String string5, int n, String string6, List<AJColumnMetadata> list) throws ErrorException {
        int n2 = AJTypeUtilities.mapAthenaTypeNameToSqlType(string6, this.m_settings);
        String string7 = AJTypeUtilities.canonicalizeTypeName(string6);
        Pair<Integer, Integer> pair = AJTypeUtilities.extractDecimalPrecisionAndScale(string6);
        int n3 = AJTypeUtilities.extractCharacterTypeColMaxLen(string6);
        if (string7.equalsIgnoreCase("string")) {
            n3 = this.m_settings.m_stringColumnLength;
        } else if (AJTypeUtilities.isComplexType(string7)) {
            n3 = this.m_settings.m_complexTypeColumnLength;
        }
        int n4 = this.m_settings.m_binaryColumnLength;
        string7 = string7.equalsIgnoreCase("varchar") ? AJTypeUtilities.rectifyTypeName(string7, n3) : AJTypeUtilities.rectifyTypeName(string7);
        list.add(new AJColumnMetadata(string, string2, string3, string4, n2, string7, string5, n, pair.key(), pair.value(), n3, n4));
    }

    private AWSGlue buildGlueClient(AWSCredentialsProvider aWSCredentialsProvider, ClientConfiguration clientConfiguration) {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        AWSGlueClientBuilder aWSGlueClientBuilder = AWSGlueClientBuilder.standard();
        if (null != this.m_settings.m_glueEndpointOverride && !this.m_settings.m_glueEndpointOverride.isEmpty()) {
            String string = AJ_ENDPOINT_START + this.m_settings.m_glueEndpointOverride;
            LogUtilities.logDebug("Building Glue client with endpoint = '" + string + "' and region = '" + this.m_settings.m_awsRegion + "'.", this.m_logger);
            ((AWSGlueClientBuilder)((AWSGlueClientBuilder)aWSGlueClientBuilder.withClientConfiguration(clientConfiguration)).withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(string, this.m_settings.m_awsRegion))).withCredentials(aWSCredentialsProvider);
        } else {
            LogUtilities.logDebug("Building Glue client with region = '" + this.m_settings.m_awsRegion + "'.", this.m_logger);
            ((AWSGlueClientBuilder)((AWSGlueClientBuilder)aWSGlueClientBuilder.withRegion(this.m_settings.m_awsRegion)).withClientConfiguration(clientConfiguration)).withCredentials(aWSCredentialsProvider);
        }
        return (AWSGlue)aWSGlueClientBuilder.build();
    }

    private void checkAthenaConnection() throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        try {
            if (AJMetadataRetrievalMethod.GET_METADATA_FROM_PROXY_API == this.m_settings.m_metadataRetrievalMethod) {
                LogUtilities.logDebug("Testing connection by confirming current catalog.", this.m_logger);
                this.checkCatalog(this.m_settings.m_defaultCatalog);
            } else if (AJMetadataRetrievalMethod.GET_METADATA_FROM_GLUE == this.m_settings.m_metadataRetrievalMethod) {
                LogUtilities.logDebug("Testing connection with getDatabases().", this.m_logger);
                GetDatabasesRequest getDatabasesRequest = new GetDatabasesRequest().withMaxResults(1);
                GetDatabasesResult getDatabasesResult = this.m_glueClient.getDatabases(getDatabasesRequest);
                getDatabasesResult.getDatabaseList();
            } else {
                LogUtilities.logDebug("Testing connection with query.", this.m_logger);
                AJExecutionContext aJExecutionContext = new AJExecutionContext();
                aJExecutionContext.setQuery("SELECT 1");
                this.executeQuery(aJExecutionContext, "AwsDataCatalog");
            }
        }
        catch (Exception exception) {
            if (null != exception && exception instanceof SdkClientException && null != exception.getCause() && exception.getCause() instanceof ConnectTimeoutException) {
                throw new ErrorException(DiagState.DIAG_CONN_TIMEOUT_EXPIRED, 105, CommonJDBCMessageKey.CONN_LOGINTIMEOUT_ERR.name(), new String[]{null == exception.getCause().getMessage() ? "None" : exception.getCause().getMessage()});
            }
            if (null != exception && null != exception.getCause() && exception.getCause() instanceof SdkClientException && null != exception.getCause().getCause() && exception.getCause().getCause() instanceof ConnectTimeoutException) {
                throw new ErrorException(DiagState.DIAG_CONN_TIMEOUT_EXPIRED, 105, CommonJDBCMessageKey.CONN_LOGINTIMEOUT_ERR.name(), new String[]{null == exception.getCause().getMessage() ? "None" : exception.getCause().getMessage()});
            }
            if (null != exception && exception instanceof ErrorException) {
                throw (ErrorException)exception;
            }
            throw DSDriver.s_CommonMessages.createGeneralException(CommonJDBCMessageKey.CONN_UNEXP_SESSION_ERR.name(), null == exception.getMessage() ? "Unknown" : exception.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkGlueSupport(AWSCredentialsProvider aWSCredentialsProvider) throws ErrorException {
        ArrayList<String> arrayList;
        Object object;
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        try {
            LogUtilities.logDebug("Performing AWS Glue availability detection.", this.m_logger);
            LogUtilities.logDebug("Aws::Glue - GlueClient - getCatalogImportStatus +++++ enter +++++", this.m_logger);
            object = new ClientConfiguration(this.m_settings.m_clientConfig);
            ((ClientConfiguration)object).withRetryPolicy(AJ_GLUE_DETECTION_RETRY_POLICY).withMaxErrorRetry(this.m_settings.m_glueDetectionMaxRetry);
            LogUtilities.logDebug("Build a test AWS Glue Client with the retry policy.", this.m_logger);
            arrayList = this.buildGlueClient(aWSCredentialsProvider, (ClientConfiguration)object);
            GetCatalogImportStatusRequest getCatalogImportStatusRequest = new GetCatalogImportStatusRequest();
            GetCatalogImportStatusResult getCatalogImportStatusResult = arrayList.getCatalogImportStatus(getCatalogImportStatusRequest);
            if (null != getCatalogImportStatusResult) {
                this.m_settings.m_metadataRetrievalMethod = getCatalogImportStatusResult.getImportStatus().isImportCompleted() != false ? AJMetadataRetrievalMethod.GET_METADATA_FROM_GLUE : AJMetadataRetrievalMethod.GET_METADATA_WITH_QUERY;
                LogUtilities.logDebug("GetCatalogImportStatusResult is valid. Setting metadata retrieval method as: " + this.m_settings.m_metadataRetrievalMethod.toString(), this.m_logger);
                this.m_settings.m_performConnectionTest = false;
                return;
            }
            LogUtilities.logDebug("GetCatalogImportStatusResult is invalid. GetCatalogImportStatusResult is null.", this.m_logger);
        }
        catch (Exception exception) {
            arrayList = "An exception was caught during AWS Glue availability detection operation. Detail: " + exception;
            LogUtilities.logDebug((String)((Object)arrayList), this.m_logger);
            if (exception instanceof SdkClientException && null != exception.getCause() && exception.getCause() instanceof UnknownHostException) {
                this.m_settings.m_metadataRetrievalMethod = AJMetadataRetrievalMethod.GET_METADATA_WITH_QUERY;
                return;
            }
        }
        finally {
            LogUtilities.logDebug("Aws::Glue - GlueClient - getCatalogImportStatus ----- exit -----", this.m_logger);
        }
        LogUtilities.logDebug("Trying to detect AWS Glue availability by comparing the schema list returned by GetDatabases Glue API and SHOW SCHEMAS query.", this.m_logger);
        object = new ArrayList();
        arrayList = new ArrayList<String>();
        this.m_settings.m_metadataRetrievalMethod = AJMetadataRetrievalMethod.GET_METADATA_FROM_GLUE;
        try {
            this.fetchSchemasWithGlue((List<String>)object);
        }
        catch (ErrorException errorException) {
            LogUtilities.logError(errorException, this.m_logger);
            this.m_settings.m_metadataRetrievalMethod = AJMetadataRetrievalMethod.GET_METADATA_WITH_QUERY;
            return;
        }
        this.fetchSchemasWithQuery(arrayList);
        if (!object.equals(arrayList)) {
            this.m_settings.m_metadataRetrievalMethod = AJMetadataRetrievalMethod.GET_METADATA_WITH_QUERY;
        }
    }

    private void fetchColumnsMetadataForSpecificTableWithGlue(String string, String string2, StringWrapperFilter stringWrapperFilter, StringWrapperFilter stringWrapperFilter2, List<AJColumnMetadata> list) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        Table table = this.fetchSpecificTableWithGlue(string, string2);
        if (null != table && stringWrapperFilter.filter(table.getName())) {
            List<com.simba.athena.amazonaws.services.glue.model.Column> list2 = table.getStorageDescriptor().getColumns();
            if (null != table.getPartitionKeys()) {
                list2.addAll(table.getPartitionKeys());
            }
            int n = 0;
            for (com.simba.athena.amazonaws.services.glue.model.Column column : list2) {
                String string3 = column.getName();
                if (!stringWrapperFilter2.filter(string3)) continue;
                String string4 = column.getType();
                String string5 = column.getComment();
                this.addColumnMetadata("AwsDataCatalog", string, table.getName(), string3, string5, ++n, string4, list);
            }
        }
    }

    private void fetchColumnsMetadataWithGlue(String string, StringWrapperFilter stringWrapperFilter, StringWrapperFilter stringWrapperFilter2, List<AJColumnMetadata> list) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        ArrayList<Table> arrayList = new ArrayList<Table>();
        this.fetchTablesWithGlue(string, arrayList);
        for (Table table : arrayList) {
            if (!stringWrapperFilter.filter(table.getName())) continue;
            List<com.simba.athena.amazonaws.services.glue.model.Column> list2 = table.getStorageDescriptor().getColumns();
            if (null != table.getPartitionKeys()) {
                list2.addAll(table.getPartitionKeys());
            }
            int n = 0;
            for (com.simba.athena.amazonaws.services.glue.model.Column column : list2) {
                String string2 = column.getName();
                if (!stringWrapperFilter2.filter(string2)) continue;
                String string3 = column.getType();
                String string4 = column.getComment();
                this.addColumnMetadata("AwsDataCatalog", string, table.getName(), string2, string4, ++n, string3, list);
            }
        }
    }

    private void fetchColumnsMetadataForSpecificTableWithProxyApi(String string, String string2, String string3, StringWrapperFilter stringWrapperFilter, StringWrapperFilter stringWrapperFilter2, List<AJColumnMetadata> list) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        TableMetadata tableMetadata = this.fetchSpecificTableWithProxyApi(string, string2, string3);
        if (null != tableMetadata && stringWrapperFilter.filter(tableMetadata.getName())) {
            List<Column> list2 = tableMetadata.getColumns();
            if (null != tableMetadata.getPartitionKeys()) {
                list2.addAll(tableMetadata.getPartitionKeys());
            }
            int n = 0;
            for (Column column : list2) {
                String string4 = column.getName();
                if (!stringWrapperFilter2.filter(string4)) continue;
                String string5 = column.getType();
                String string6 = column.getComment();
                this.addColumnMetadata(string, string2, tableMetadata.getName(), string4, string6, ++n, string5, list);
            }
        }
    }

    private void fetchColumnsMetadataWithProxyApi(String string, String string2, StringWrapperFilter stringWrapperFilter, StringWrapperFilter stringWrapperFilter2, List<AJColumnMetadata> list) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        ArrayList<TableMetadata> arrayList = new ArrayList<TableMetadata>();
        this.fetchTablesWithProxyApi(string, string2, arrayList);
        for (TableMetadata tableMetadata : arrayList) {
            if (!stringWrapperFilter.filter(tableMetadata.getName())) continue;
            List<Column> list2 = tableMetadata.getColumns();
            if (null != tableMetadata.getPartitionKeys()) {
                list2.addAll(tableMetadata.getPartitionKeys());
            }
            int n = 0;
            for (Column column : list2) {
                String string3 = column.getName();
                if (!stringWrapperFilter2.filter(string3)) continue;
                String string4 = column.getType();
                String string5 = column.getComment();
                this.addColumnMetadata(string, string2, tableMetadata.getName(), string3, string5, ++n, string4, list);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void fetchColumnsMetadataForSpecificTableWithQuery(String string, String string2, StringWrapperFilter stringWrapperFilter, StringWrapperFilter stringWrapperFilter2, List<AJColumnMetadata> list) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        ArrayList<String> arrayList = new ArrayList<String>();
        this.fetchSpecificTableWithQuery(string, string2, arrayList);
        if (null == arrayList || !stringWrapperFilter.filter((String)arrayList.get(0))) return;
        String string3 = "DESCRIBE `" + string + "`.`" + (String)arrayList.get(0) + "`";
        AJExecutionContext aJExecutionContext = new AJExecutionContext();
        aJExecutionContext.setQuery(string3);
        this.executeQuery(aJExecutionContext, "AwsDataCatalog");
        AJResultSetBuffer aJResultSetBuffer = new AJResultSetBuffer();
        int n = 0;
        block0: do {
            String string4;
            String string5;
            Object object;
            this.fetchRows(aJExecutionContext, aJResultSetBuffer);
            List<Row> list2 = aJResultSetBuffer.getResultRows();
            int n2 = aJResultSetBuffer.getResultSetMetadata().getColumnInfo().size();
            int n3 = aJResultSetBuffer.getResultRows().get(0).getData().size();
            if (n2 != n3) {
                if (1 != n3) throw AJDriver.s_AJMessages.createGeneralException(AJMessageKey.UNEXPECTED_NUM_RESULT_COLUMNS, new String[]{String.valueOf(n3), String.valueOf(n2)});
                for (Row row : list2) {
                    object = new ArrayList();
                    AJUtilities.parseCellAsTabDelimited(this.m_logger, row.getData().get(0).getVarCharValue(), n2, (List<String>)object);
                    String string6 = string5 = this.m_settings.m_rightTrimNonGlueColumnName ? AJUtilities.rtrim((String)object.get(0)) : (String)object.get(0);
                    if (null == string5 || string5.trim().isEmpty()) continue block0;
                    if (!stringWrapperFilter2.filter(string5)) continue;
                    string4 = (String)object.get(1);
                    String string7 = (String)object.get(2);
                    this.addColumnMetadata("AwsDataCatalog", string, (String)arrayList.get(0), string5, string7, ++n, string4.trim(), list);
                }
            } else {
                for (Row row : list2) {
                    object = row.getData().get(0).getVarCharValue();
                    if (!stringWrapperFilter2.filter((String)object)) continue;
                    string5 = row.getData().get(1).getVarCharValue();
                    string4 = row.getData().get(2).getVarCharValue();
                    this.addColumnMetadata("AwsDataCatalog", string, (String)arrayList.get(0), (String)object, string4, ++n, string5.trim(), list);
                }
            }
        } while (aJExecutionContext.m_hasMoreRows);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void fetchColumnsMetadataWithQuery(String string, StringWrapperFilter stringWrapperFilter, StringWrapperFilter stringWrapperFilter2, List<AJColumnMetadata> list) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        ArrayList<String> arrayList = new ArrayList<String>();
        this.fetchTablesWithQuery(string, arrayList);
        for (String string2 : arrayList) {
            if (!stringWrapperFilter.filter(string2)) continue;
            String string3 = "DESCRIBE `" + string + "`.`" + string2 + "`";
            AJExecutionContext aJExecutionContext = new AJExecutionContext();
            aJExecutionContext.setQuery(string3);
            this.executeQuery(aJExecutionContext, "AwsDataCatalog");
            AJResultSetBuffer aJResultSetBuffer = new AJResultSetBuffer();
            int n = 0;
            block1: do {
                String string4;
                String string5;
                Object object;
                this.fetchRows(aJExecutionContext, aJResultSetBuffer);
                List<Row> list2 = aJResultSetBuffer.getResultRows();
                int n2 = aJResultSetBuffer.getResultSetMetadata().getColumnInfo().size();
                int n3 = aJResultSetBuffer.getResultRows().get(0).getData().size();
                if (n2 != n3) {
                    if (1 != n3) throw AJDriver.s_AJMessages.createGeneralException(AJMessageKey.UNEXPECTED_NUM_RESULT_COLUMNS, new String[]{String.valueOf(n3), String.valueOf(n2)});
                    for (Row row : list2) {
                        object = new ArrayList();
                        AJUtilities.parseCellAsTabDelimited(this.m_logger, row.getData().get(0).getVarCharValue(), n2, (List<String>)object);
                        String string6 = string5 = this.m_settings.m_rightTrimNonGlueColumnName ? AJUtilities.rtrim((String)object.get(0)) : (String)object.get(0);
                        if (null == string5 || string5.trim().isEmpty()) continue block1;
                        if (!stringWrapperFilter2.filter(string5)) continue;
                        string4 = (String)object.get(1);
                        String string7 = (String)object.get(2);
                        this.addColumnMetadata("AwsDataCatalog", string, string2, string5, string7, ++n, string4.trim(), list);
                    }
                } else {
                    for (Row row : list2) {
                        object = row.getData().get(0).getVarCharValue();
                        if (!stringWrapperFilter2.filter((String)object)) continue;
                        string5 = row.getData().get(1).getVarCharValue();
                        string4 = row.getData().get(2).getVarCharValue();
                        this.addColumnMetadata("AwsDataCatalog", string, string2, (String)object, string4, ++n, string5.trim(), list);
                    }
                }
            } while (aJExecutionContext.m_hasMoreRows);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchSchemasWithGlue(List<String> list) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        String string = null;
        do {
            GetDatabasesRequest getDatabasesRequest = new GetDatabasesRequest().withMaxResults(this.nonStreamFetchSizeCorrection(this.m_settings.m_rowsToFetchPerBlock));
            if (null != string) {
                getDatabasesRequest.withNextToken(string);
            }
            LogUtilities.logDebug("Aws::Glue - GlueClient - GetDatabases +++++ enter +++++", this.m_logger);
            GetDatabasesResult getDatabasesResult = null;
            try {
                getDatabasesResult = this.m_glueClient.getDatabases(getDatabasesRequest);
            }
            catch (Exception exception) {
                this.checkAndThrowException(exception, null);
            }
            finally {
                LogUtilities.logDebug("Aws::Glue - GlueClient - GetDatabases ----- exit -----", this.m_logger);
            }
            List<com.simba.athena.amazonaws.services.glue.model.Database> list2 = getDatabasesResult.getDatabaseList();
            if (null == list2) {
                list2 = new ArrayList<com.simba.athena.amazonaws.services.glue.model.Database>();
            }
            for (com.simba.athena.amazonaws.services.glue.model.Database database : list2) {
                if (null == database.getName() || database.getName().isEmpty()) {
                    LogUtilities.logInfo("A schema with empty name was encountered and ignored when fetching list of schemas.", this.m_logger);
                    continue;
                }
                list.add(database.getName());
            }
            string = getDatabasesResult.getNextToken();
            this.m_settings.m_performConnectionTest = false;
        } while (null != string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchSchemasWithProxyApi(String string, List<AJSchemaMetadata> list) throws ErrorException {
        ListDatabasesResult listDatabasesResult;
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        String string2 = null;
        do {
            ListDatabasesRequest listDatabasesRequest = new ListDatabasesRequest().withCatalogName(string);
            if (null != string2) {
                listDatabasesRequest.withNextToken(string2);
            }
            LogUtilities.logDebug("Aws::Athena - AthenaClient - GetNameSpaces +++++ enter +++++", this.m_logger);
            listDatabasesResult = null;
            try {
                listDatabasesResult = this.m_athenaClient.listDatabases(listDatabasesRequest);
            }
            catch (Exception exception) {
                this.checkAndThrowException(exception, null);
            }
            finally {
                LogUtilities.logDebug("Aws::Athena - AthenaClient - GetNameSpaces ----- exit -----", this.m_logger);
            }
            List<Database> list2 = listDatabasesResult.getDatabaseList();
            if (null == list2) {
                list2 = new ArrayList<Database>();
            }
            for (Database database : list2) {
                if (null == database.getName() || database.getName().isEmpty()) {
                    LogUtilities.logInfo("A schema with empty name was encountered and ignored when fetching list of schemas.", this.m_logger);
                    continue;
                }
                AJSchemaMetadata aJSchemaMetadata = new AJSchemaMetadata(string, database.getName());
                list.add(aJSchemaMetadata);
            }
        } while (null != (string2 = listDatabasesResult.getNextToken()));
    }

    private void fetchSchemasWithQuery(List<String> list) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        String string = "SHOW SCHEMAS";
        this.getMetadataStringResults(string, list);
        this.m_settings.m_performConnectionTest = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Table fetchSpecificTableWithGlue(String string, String string2) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        GetTableRequest getTableRequest = new GetTableRequest().withDatabaseName(string).withName(string2);
        LogUtilities.logDebug("Aws::Glue - GlueClient - GetTable +++++ enter +++++", this.m_logger);
        GetTableResult getTableResult = null;
        try {
            getTableResult = this.m_glueClient.getTable(getTableRequest);
        }
        catch (Exception exception) {
            Table table = null;
            return table;
        }
        finally {
            LogUtilities.logDebug("Aws::Glue - GlueClient - GetTable ----- exit -----", this.m_logger);
        }
        return getTableResult.getTable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchTablesWithGlue(String string, List<Table> list) throws ErrorException {
        GetTablesResult getTablesResult;
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        String string2 = null;
        do {
            GetTablesRequest getTablesRequest = new GetTablesRequest().withDatabaseName(string).withMaxResults(this.nonStreamFetchSizeCorrection(this.m_settings.m_rowsToFetchPerBlock));
            if (null != string2) {
                getTablesRequest.withNextToken(string2);
            }
            LogUtilities.logDebug("Aws::Glue - GlueClient - GetTables +++++ enter +++++", this.m_logger);
            getTablesResult = null;
            try {
                getTablesResult = this.m_glueClient.getTables(getTablesRequest);
            }
            catch (Exception exception) {
                this.checkAndThrowException(exception, null);
            }
            finally {
                LogUtilities.logDebug("Aws::Glue - GlueClient - GetTables ----- exit -----", this.m_logger);
            }
            List<Table> list2 = getTablesResult.getTableList();
            if (null == list2) {
                list2 = new ArrayList<Table>();
            }
            list.addAll(list2);
        } while (null != (string2 = getTablesResult.getNextToken()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TableMetadata fetchSpecificTableWithProxyApi(String string, String string2, String string3) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        GetTableMetadataRequest getTableMetadataRequest = new GetTableMetadataRequest().withCatalogName(string).withDatabaseName(string2).withTableName(string3);
        LogUtilities.logDebug("Aws::Athena - AthenaClient - GetTable +++++ enter +++++", this.m_logger);
        GetTableMetadataResult getTableMetadataResult = null;
        try {
            getTableMetadataResult = this.m_athenaClient.getTableMetadata(getTableMetadataRequest);
        }
        catch (Exception exception) {
            TableMetadata tableMetadata = null;
            return tableMetadata;
        }
        finally {
            LogUtilities.logDebug("Aws::Athena - AthenaClient - GetTable ----- exit -----", this.m_logger);
        }
        return getTableMetadataResult.getTableMetadata();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchTablesWithProxyApi(String string, String string2, List<TableMetadata> list) throws ErrorException {
        ListTableMetadataResult listTableMetadataResult;
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        String string3 = null;
        do {
            ListTableMetadataRequest listTableMetadataRequest = new ListTableMetadataRequest().withCatalogName(string).withDatabaseName(string2);
            if (null != string3) {
                listTableMetadataRequest.withNextToken(string3);
            }
            LogUtilities.logDebug("Aws::Athena - AthenaClient - GetTables +++++ enter +++++", this.m_logger);
            listTableMetadataResult = null;
            try {
                listTableMetadataResult = this.m_athenaClient.listTableMetadata(listTableMetadataRequest);
            }
            catch (Exception exception) {
                this.checkAndThrowException(exception, null);
            }
            finally {
                LogUtilities.logDebug("Aws::Athena - AthenaClient - GetTables ----- exit -----", this.m_logger);
            }
            List<TableMetadata> list2 = listTableMetadataResult.getTableMetadataList();
            if (null == list2) {
                list2 = new ArrayList<TableMetadata>();
            }
            list.addAll(list2);
        } while (null != (string3 = listTableMetadataResult.getNextToken()));
    }

    private void fetchTablesWithQuery(String string, List<String> list) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        String string2 = "SHOW TABLES IN `" + string + "`";
        this.getMetadataStringResults(string2, list);
    }

    private void fetchSpecificTableWithQuery(String string, String string2, List<String> list) throws ErrorException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        String string3 = "SHOW TABLES IN `" + string + "` '" + string2 + "'";
        this.getMetadataStringResults(string3, list);
    }

    private void getMetadataStringResults(String string, List<String> list) throws ErrorException {
        AJExecutionContext aJExecutionContext = new AJExecutionContext();
        aJExecutionContext.setQuery(string);
        this.executeQuery(aJExecutionContext, "AwsDataCatalog");
        AJResultSetBuffer aJResultSetBuffer = new AJResultSetBuffer();
        do {
            this.fetchRows(aJExecutionContext, aJResultSetBuffer);
            ListIterator<Row> listIterator = aJResultSetBuffer.getResultRows().listIterator(0);
            while (listIterator.hasNext()) {
                Datum datum = listIterator.next().getData().get(0);
                list.add(datum.getVarCharValue());
            }
        } while (aJExecutionContext.m_hasMoreRows);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readFetchSizeValue(AJExecutionContext aJExecutionContext) {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        try {
            Variant variant = aJExecutionContext.m_statement.getProperty(6);
            int n = variant.getInt();
            aJExecutionContext.m_fetchSize = 0 < n ? (n < this.m_settings.m_rowsToFetchPerBlock ? n : this.m_settings.m_rowsToFetchPerBlock) : this.m_settings.m_rowsToFetchPerBlock;
        }
        catch (Exception exception) {
            aJExecutionContext.m_fetchSize = this.m_settings.m_rowsToFetchPerBlock;
        }
        finally {
            if (!aJExecutionContext.m_fetchWithStream) {
                aJExecutionContext.m_fetchSize = this.nonStreamFetchSizeCorrection(aJExecutionContext.m_fetchSize);
            }
        }
    }

    private void readQueryTimeoutValue(AJExecutionContext aJExecutionContext) {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        try {
            Variant variant = aJExecutionContext.m_statement.getProperty(3);
            if (-1 < variant.getInt()) {
                aJExecutionContext.m_queryTimeout = variant.getInt();
            }
        }
        catch (Exception exception) {
            aJExecutionContext.m_queryTimeout = 0;
        }
    }

    private int nonStreamFetchSizeCorrection(int n) {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        if (n > this.m_settings.m_maxNumRowsToFetchPerBlock) {
            return this.m_settings.m_maxNumRowsToFetchPerBlock;
        }
        return n;
    }

    public GetWorkGroupResult fetchWorkGroup() throws ErrorException {
        GetWorkGroupResult getWorkGroupResult = null;
        try {
            GetWorkGroupRequest getWorkGroupRequest = new GetWorkGroupRequest().withWorkGroup(this.m_settings.m_workgroup);
            getWorkGroupResult = this.m_athenaClient.getWorkGroup(getWorkGroupRequest);
        }
        catch (Exception exception) {
            this.checkAndThrowException(exception, null);
        }
        return getWorkGroupResult;
    }
}

