/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.amazonaws.services.securitytoken.model.transform;

import com.simba.athena.amazonaws.DefaultRequest;
import com.simba.athena.amazonaws.Request;
import com.simba.athena.amazonaws.SdkClientException;
import com.simba.athena.amazonaws.http.HttpMethodName;
import com.simba.athena.amazonaws.services.securitytoken.model.AssumeRoleWithSAMLRequest;
import com.simba.athena.amazonaws.services.securitytoken.model.PolicyDescriptorType;
import com.simba.athena.amazonaws.transform.Marshaller;
import com.simba.athena.amazonaws.util.StringUtils;
import java.util.List;

public class AssumeRoleWithSAMLRequestMarshaller
implements Marshaller<Request<AssumeRoleWithSAMLRequest>, AssumeRoleWithSAMLRequest> {
    @Override
    public Request<AssumeRoleWithSAMLRequest> marshall(AssumeRoleWithSAMLRequest assumeRoleWithSAMLRequest) {
        if (assumeRoleWithSAMLRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<AssumeRoleWithSAMLRequest> request = new DefaultRequest<AssumeRoleWithSAMLRequest>(assumeRoleWithSAMLRequest, "AWSSecurityTokenService");
        request.addParameter("Action", "AssumeRoleWithSAML");
        request.addParameter("Version", "2011-06-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (assumeRoleWithSAMLRequest.getRoleArn() != null) {
            request.addParameter("RoleArn", StringUtils.fromString(assumeRoleWithSAMLRequest.getRoleArn()));
        }
        if (assumeRoleWithSAMLRequest.getPrincipalArn() != null) {
            request.addParameter("PrincipalArn", StringUtils.fromString(assumeRoleWithSAMLRequest.getPrincipalArn()));
        }
        if (assumeRoleWithSAMLRequest.getSAMLAssertion() != null) {
            request.addParameter("SAMLAssertion", StringUtils.fromString(assumeRoleWithSAMLRequest.getSAMLAssertion()));
        }
        if (assumeRoleWithSAMLRequest.getPolicyArns() != null) {
            List<PolicyDescriptorType> policyArnsList = assumeRoleWithSAMLRequest.getPolicyArns();
            if (policyArnsList.isEmpty()) {
                request.addParameter("PolicyArns", "");
            } else {
                int policyArnsListIndex = 1;
                for (PolicyDescriptorType policyArnsListValue : policyArnsList) {
                    if (policyArnsListValue != null && policyArnsListValue.getArn() != null) {
                        request.addParameter("PolicyArns.member." + policyArnsListIndex + ".arn", StringUtils.fromString(policyArnsListValue.getArn()));
                    }
                    ++policyArnsListIndex;
                }
            }
        }
        if (assumeRoleWithSAMLRequest.getPolicy() != null) {
            request.addParameter("Policy", StringUtils.fromString(assumeRoleWithSAMLRequest.getPolicy()));
        }
        if (assumeRoleWithSAMLRequest.getDurationSeconds() != null) {
            request.addParameter("DurationSeconds", StringUtils.fromInteger(assumeRoleWithSAMLRequest.getDurationSeconds()));
        }
        return request;
    }
}

