/*
 * Decompiled with CFR 0.152.
 */
package com.simba.athena.amazonaws.auth;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSSessionCredentials;
import com.amazonaws.auth.AWSSessionCredentialsProvider;
import com.simba.athena.amazonaws.ClientConfiguration;
import com.simba.athena.amazonaws.annotation.ThreadSafe;
import com.simba.athena.amazonaws.auth.RefreshableTask;
import com.simba.athena.amazonaws.auth.SessionCredentialsHolder;
import com.simba.athena.amazonaws.auth.ShouldDoAsyncSessionRefresh;
import com.simba.athena.amazonaws.auth.ShouldDoBlockingSessionRefresh;
import com.simba.athena.amazonaws.internal.StaticCredentialsProvider;
import com.simba.athena.amazonaws.services.securitytoken.AWSSecurityTokenService;
import com.simba.athena.amazonaws.services.securitytoken.AWSSecurityTokenServiceClient;
import com.simba.athena.amazonaws.services.securitytoken.model.AssumeRoleRequest;
import com.simba.athena.amazonaws.services.securitytoken.model.AssumeRoleResult;
import com.simba.athena.amazonaws.services.securitytoken.model.Tag;
import com.simba.athena.amazonaws.util.ValidationUtils;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.Callable;

@ThreadSafe
public class STSAssumeRoleSessionCredentialsProvider
implements AWSSessionCredentialsProvider,
Closeable {
    public static final int DEFAULT_DURATION_SECONDS = 900;
    private final AWSSecurityTokenService securityTokenService;
    private final String roleArn;
    private final String roleSessionName;
    private final String roleExternalId;
    private final int roleSessionDurationSeconds;
    private final String scopeDownPolicy;
    private final Collection<Tag> sessionTags;
    private final Collection<String> transitiveTagKeys;
    private final Callable<SessionCredentialsHolder> refreshCallable = new Callable<SessionCredentialsHolder>(){

        @Override
        public SessionCredentialsHolder call() throws Exception {
            return STSAssumeRoleSessionCredentialsProvider.this.newSession();
        }
    };
    private volatile RefreshableTask<SessionCredentialsHolder> refreshableTask;

    @Deprecated
    public STSAssumeRoleSessionCredentialsProvider(String roleArn, String roleSessionName) {
        this(new Builder(roleArn, roleSessionName));
    }

    @Deprecated
    public STSAssumeRoleSessionCredentialsProvider(AWSCredentials longLivedCredentials, String roleArn, String roleSessionName) {
        this(longLivedCredentials, roleArn, roleSessionName, new ClientConfiguration());
    }

    @Deprecated
    public STSAssumeRoleSessionCredentialsProvider(AWSCredentials longLivedCredentials, String roleArn, String roleSessionName, ClientConfiguration clientConfiguration) {
        this(new Builder(roleArn, roleSessionName).withLongLivedCredentials(longLivedCredentials).withClientConfiguration(clientConfiguration));
    }

    @Deprecated
    public STSAssumeRoleSessionCredentialsProvider(AWSCredentialsProvider longLivedCredentialsProvider, String roleArn, String roleSessionName) {
        this(new Builder(roleArn, roleSessionName).withLongLivedCredentialsProvider(longLivedCredentialsProvider));
    }

    @Deprecated
    public STSAssumeRoleSessionCredentialsProvider(AWSCredentialsProvider longLivedCredentialsProvider, String roleArn, String roleSessionName, ClientConfiguration clientConfiguration) {
        this(new Builder(roleArn, roleSessionName).withLongLivedCredentialsProvider(longLivedCredentialsProvider).withClientConfiguration(clientConfiguration));
    }

    private RefreshableTask<SessionCredentialsHolder> createRefreshableTask() {
        return new RefreshableTask.Builder<SessionCredentialsHolder>().withRefreshCallable(this.refreshCallable).withBlockingRefreshPredicate(new ShouldDoBlockingSessionRefresh()).withAsyncRefreshPredicate(new ShouldDoAsyncSessionRefresh()).build();
    }

    private STSAssumeRoleSessionCredentialsProvider(Builder builder) {
        if (builder.sts != null) {
            ValidationUtils.assertAllAreNull("If a custom STS client is set you must not set any other client related fields (ClientConfiguration, AWSCredentials, Endpoint, etc", builder.longLivedCredentials, builder.longLivedCredentialsProvider, builder.clientConfiguration, builder.serviceEndpoint);
            this.securityTokenService = builder.sts;
        } else {
            this.securityTokenService = STSAssumeRoleSessionCredentialsProvider.buildStsClient(builder);
            if (builder.serviceEndpoint != null) {
                this.securityTokenService.setEndpoint(builder.serviceEndpoint);
            }
        }
        this.roleArn = builder.roleArn;
        this.roleSessionName = builder.roleSessionName;
        this.roleExternalId = builder.roleExternalId;
        this.roleSessionDurationSeconds = builder.roleSessionDurationSeconds != 0 ? builder.roleSessionDurationSeconds : 900;
        this.refreshableTask = this.createRefreshableTask();
        this.scopeDownPolicy = builder.scopeDownPolicy;
        this.sessionTags = builder.sessionTags;
        this.transitiveTagKeys = builder.transitiveTagKeys;
    }

    private static AWSSecurityTokenService buildStsClient(Builder builder) throws IllegalArgumentException {
        if (builder.longLivedCredentials != null && builder.longLivedCredentialsProvider != null) {
            throw new IllegalArgumentException("It is illegal to set both an AWSCredentials and an AWSCredentialsProvider for an " + STSAssumeRoleSessionCredentialsProvider.class.getName());
        }
        AWSCredentialsProvider longLivedCredentialsProvider = null;
        if (builder.longLivedCredentials != null) {
            longLivedCredentialsProvider = new StaticCredentialsProvider(builder.longLivedCredentials);
        } else if (builder.longLivedCredentialsProvider != null) {
            longLivedCredentialsProvider = builder.longLivedCredentialsProvider;
        }
        if (longLivedCredentialsProvider == null) {
            if (builder.clientConfiguration == null) {
                return new AWSSecurityTokenServiceClient();
            }
            return new AWSSecurityTokenServiceClient(builder.clientConfiguration);
        }
        if (builder.clientConfiguration == null) {
            return new AWSSecurityTokenServiceClient(longLivedCredentialsProvider);
        }
        return new AWSSecurityTokenServiceClient(longLivedCredentialsProvider, builder.clientConfiguration);
    }

    @Deprecated
    public synchronized void setSTSClientEndpoint(String endpoint) {
        this.securityTokenService.setEndpoint(endpoint);
        this.refreshableTask = this.createRefreshableTask();
    }

    @Override
    public AWSSessionCredentials getCredentials() {
        return this.refreshableTask.getValue().getSessionCredentials();
    }

    @Override
    public void refresh() {
        this.refreshableTask.forceGetValue();
    }

    private SessionCredentialsHolder newSession() {
        AssumeRoleRequest assumeRoleRequest = new AssumeRoleRequest().withRoleArn(this.roleArn).withDurationSeconds(this.roleSessionDurationSeconds).withRoleSessionName(this.roleSessionName).withPolicy(this.scopeDownPolicy);
        if (this.roleExternalId != null) {
            assumeRoleRequest = assumeRoleRequest.withExternalId(this.roleExternalId);
        }
        if (this.sessionTags != null) {
            assumeRoleRequest = assumeRoleRequest.withTags(this.sessionTags);
        }
        if (this.transitiveTagKeys != null) {
            assumeRoleRequest = assumeRoleRequest.withTransitiveTagKeys(this.transitiveTagKeys);
        }
        AssumeRoleResult assumeRoleResult = this.securityTokenService.assumeRole(assumeRoleRequest);
        return new SessionCredentialsHolder(assumeRoleResult.getCredentials());
    }

    @Override
    public void close() {
        this.refreshableTask.close();
    }

    public static final class Builder {
        private final String roleArn;
        private final String roleSessionName;
        private AWSCredentialsProvider longLivedCredentialsProvider;
        private AWSCredentials longLivedCredentials;
        private ClientConfiguration clientConfiguration;
        private String roleExternalId;
        private String serviceEndpoint;
        private int roleSessionDurationSeconds;
        private String scopeDownPolicy;
        private AWSSecurityTokenService sts;
        private Collection<Tag> sessionTags;
        private Collection<String> transitiveTagKeys;

        public Builder(String roleArn, String roleSessionName) {
            if (roleArn == null || roleSessionName == null) {
                throw new NullPointerException("You must specify a value for roleArn and roleSessionName");
            }
            this.roleArn = roleArn;
            this.roleSessionName = roleSessionName;
        }

        @Deprecated
        public Builder withLongLivedCredentials(AWSCredentials longLivedCredentials) {
            this.longLivedCredentials = longLivedCredentials;
            return this;
        }

        @Deprecated
        public Builder withLongLivedCredentialsProvider(AWSCredentialsProvider longLivedCredentialsProvider) {
            this.longLivedCredentialsProvider = longLivedCredentialsProvider;
            return this;
        }

        @Deprecated
        public Builder withClientConfiguration(ClientConfiguration clientConfiguration) {
            this.clientConfiguration = clientConfiguration;
            return this;
        }

        public Builder withExternalId(String roleExternalId) {
            this.roleExternalId = roleExternalId;
            return this;
        }

        public Builder withRoleSessionDurationSeconds(int roleSessionDurationSeconds) {
            this.roleSessionDurationSeconds = roleSessionDurationSeconds;
            return this;
        }

        public Builder withSessionTags(Collection<Tag> sessionTags) {
            if (sessionTags == null) {
                this.sessionTags = null;
                return this;
            }
            this.sessionTags = Collections.unmodifiableCollection(new ArrayList<Tag>(sessionTags));
            return this;
        }

        public Builder withTransitiveTagKeys(Collection<String> transitiveTagKeys) {
            if (transitiveTagKeys == null) {
                this.transitiveTagKeys = null;
                return this;
            }
            this.transitiveTagKeys = Collections.unmodifiableCollection(new ArrayList<String>(transitiveTagKeys));
            return this;
        }

        @Deprecated
        public Builder withServiceEndpoint(String serviceEndpoint) {
            this.serviceEndpoint = serviceEndpoint;
            return this;
        }

        public Builder withScopeDownPolicy(String scopeDownPolicy) {
            this.scopeDownPolicy = scopeDownPolicy;
            return this;
        }

        public Builder withStsClient(AWSSecurityTokenService sts) {
            this.sts = sts;
            return this;
        }

        public STSAssumeRoleSessionCredentialsProvider build() {
            return new STSAssumeRoleSessionCredentialsProvider(this);
        }
    }
}

