/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc.jdbc41;

import com.vertica.dsi.core.interfaces.IConnection;
import com.vertica.dsi.core.utilities.PropertyUtilities;
import com.vertica.dsi.core.utilities.Variant;
import com.vertica.dsi.dataengine.interfaces.IArray;
import com.vertica.exceptions.ExceptionConverter;
import com.vertica.exceptions.JDBCMessageKey;
import com.vertica.jdbc.common.SConnection;
import com.vertica.jdbc.jdbc41.S41Array;
import com.vertica.support.LogUtilities;
import com.vertica.support.exceptions.ExceptionType;
import com.vertica.utilities.FunctionID;
import java.sql.Array;
import java.sql.SQLException;
import java.sql.SQLPermission;
import java.util.concurrent.Executor;

public class S41Connection
extends SConnection {
    private static final SQLPermission ABORT_PERM = new SQLPermission("callAbort");

    public S41Connection(IConnection conn, String url) throws SQLException {
        super(conn, url);
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, schema);
            this.checkIfOpen();
            if (!PropertyUtilities.hasSchemaSupport(this.m_connection)) {
                return;
            }
            Variant currentSchemaVar = null;
            currentSchemaVar = null == schema ? new Variant(0, "") : new Variant(0, schema);
            this.m_warningListener.clearAndSetFunction(FunctionID.CONNECTION_SET_PROPERTY);
            this.m_connection.setProperty(1008, currentSchemaVar);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public String getSchema() throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            if (!PropertyUtilities.hasSchemaSupport(this.m_connection)) {
                return null;
            }
            Variant var = this.m_connection.getProperty(1008);
            return var.getString();
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void abort(Executor executor) throws SQLException, SecurityException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
            this.checkIfOpen();
            SecurityManager sec = System.getSecurityManager();
            if (null != sec) {
                sec.checkPermission(ABORT_PERM);
            }
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    block2: {
                        try {
                            S41Connection.this.abortInternal();
                        }
                        catch (SQLException e) {
                            if (null == S41Connection.this.m_logger) break block2;
                            LogUtilities.logError(e, S41Connection.this.m_logger);
                        }
                    }
                }
            });
            this.markConnectionClosed();
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, milliseconds);
        this.checkIfOpen();
        SQLException exception = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(exception, this.m_logger);
        throw exception;
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        LogUtilities.logFunctionEntrance(this.m_logger, new Object[0]);
        this.checkIfOpen();
        SQLException exception = ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.DRIVER_NOT_CAPABLE, this.getWarningListener(), ExceptionType.FEATURE_NOT_IMPLEMENTED, new Object[0]);
        LogUtilities.logError(exception, this.m_logger);
        throw exception;
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        try {
            LogUtilities.logFunctionEntrance(this.m_logger, typeName, elements);
            IConnection dsiConnection = this.getDSIConnection();
            IArray dsiArray = dsiConnection.createArrayOf(typeName, elements);
            return new S41Array(dsiArray, dsiConnection, this.m_logger, this.m_warningListener);
        }
        catch (Exception e) {
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener, this.m_logger);
        }
    }
}

