/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.jdbc.common;

import com.vertica.dsi.core.impl.DSIDriverFactory;
import com.vertica.dsi.core.impl.DSIDriverSingleton;
import com.vertica.dsi.core.interfaces.IConnection;
import com.vertica.dsi.core.interfaces.IDriver;
import com.vertica.dsi.core.utilities.ConnSettingRequestMap;
import com.vertica.dsi.core.utilities.ConnSettingResponseMap;
import com.vertica.dsi.core.utilities.Variant;
import com.vertica.exceptions.ExceptionConverter;
import com.vertica.exceptions.JDBCMessageKey;
import com.vertica.jdbc.common.BaseConnectionFactory;
import com.vertica.jdbc.common.JDBCObjectFactory;
import com.vertica.jdbc.common.SWarningListener;
import com.vertica.support.ILogger;
import com.vertica.support.IWarningListener;
import com.vertica.support.LogUtilities;
import com.vertica.support.Pair;
import com.vertica.support.SettingReader;
import com.vertica.support.Warning;
import com.vertica.support.exceptions.ErrorException;
import com.vertica.support.exceptions.ExceptionType;
import com.vertica.utilities.FunctionID;
import com.vertica.utilities.PropertyTypeConverter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;

public abstract class AbstractDriver
extends BaseConnectionFactory
implements Driver {
    private static final String VERSION_SEPARATOR = ".";
    public static final String URL_PROTOCOL = "jdbc";
    protected static boolean s_isInitialized = false;
    private static String s_messageComponentName = "[JDBC Driver]";
    private SWarningListener m_warningListener;

    public static String getErrorMessageComponentName() {
        return s_messageComponentName;
    }

    public static void initialize(AbstractDriver jdbcDriver, String dsiiDriver) throws SQLException {
        DSIDriverFactory.setDriverClassName(dsiiDriver);
        try {
            jdbcDriver.initializeDriver();
        }
        catch (SQLException e) {
            ExceptionConverter.getInstance().toSQLException("HY000", "A database access error occurred while registering the driver", 0, ExceptionType.DEFAULT);
        }
    }

    public void initializeDriver() throws SQLException {
        throw ExceptionConverter.getInstance().toSQLException("HY000", "A database access error occurred while registering the driver", 0, ExceptionType.DEFAULT);
    }

    public static void setErrorMessageComponentName(String name) {
        s_messageComponentName = "[" + name + "]";
    }

    public AbstractDriver() {
        SettingReader.loadSimbaSettings();
    }

    @Override
    public final boolean acceptsURL(String url) {
        return this.acceptsURL(url, new Properties());
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        Properties connectionProperties = new Properties();
        if (null != info) {
            this.copyProperties(connectionProperties, info);
        }
        this.doInitialize();
        if (!this.acceptsURL(url, connectionProperties)) {
            return null;
        }
        Pair<IConnection, ConnSettingRequestMap> connInfo = this.getConnection(connectionProperties);
        return this.doConnect(connInfo, url);
    }

    @Override
    public int getMajorVersion() {
        int majorVersion = 1;
        try {
            this.doInitialize();
            IDriver driver = DSIDriverSingleton.getInstance();
            Variant version = driver.getProperty(5);
            if (null == version.getString()) {
                ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_VERSION, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, version.getString());
            }
            StringTokenizer strTokenizer = new StringTokenizer(version.getString(), VERSION_SEPARATOR);
            String majorVersionString = strTokenizer.nextToken();
            majorVersion = Integer.parseInt(majorVersionString);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return majorVersion;
    }

    @Override
    public int getMinorVersion() {
        int minorVersion = 0;
        try {
            this.doInitialize();
            IDriver driver = DSIDriverSingleton.getInstance();
            Variant version = driver.getProperty(5);
            if (null == version.getString()) {
                ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_VERSION, (IWarningListener)this.m_warningListener, ExceptionType.DEFAULT, version.getString());
            }
            StringTokenizer strTokenizer = new StringTokenizer(version.getString(), VERSION_SEPARATOR);
            strTokenizer.nextToken();
            String minorVersionString = strTokenizer.nextToken();
            minorVersion = Integer.parseInt(minorVersionString);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return minorVersion;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        Properties connectionProperties = new Properties();
        if (null != info) {
            this.copyProperties(connectionProperties, info);
        }
        this.doInitialize();
        if (!this.acceptsURL(url, connectionProperties)) {
            ExceptionConverter.getInstance().toSQLException(JDBCMessageKey.INVALID_URL, (IWarningListener)this.m_warningListener, ExceptionType.NON_TRANSIENT_CONNECTION, new Object[0]);
        }
        try {
            Pair<IConnection, ConnSettingRequestMap> connInfo = this.getConnection(connectionProperties);
            IConnection con = connInfo.key();
            IWarningListener warningListener = con.getWarningListener();
            ConnSettingResponseMap responseMap = null;
            if (null == warningListener) {
                warningListener = new SWarningListener(DSIDriverSingleton.getInstance().getMessageSource(), FunctionID.CONNECTION_UPDATE_SETTINGS);
                con.registerWarningListener(warningListener);
            }
            responseMap = con.updateConnectionSettings(connInfo.value());
            for (Warning warning : warningListener.getWarnings()) {
                LogUtilities.logWarning(warning.getMessage(), DSIDriverSingleton.getInstance().getDriverLog());
            }
            con.disconnect();
            con.close();
            SettingReader.clearAllSettings();
            return PropertyTypeConverter.toDriverPropertyInfo(responseMap);
        }
        catch (Exception e) {
            SettingReader.clearAllSettings();
            throw ExceptionConverter.getInstance().toSQLException(e, this.m_warningListener);
        }
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    protected abstract JDBCObjectFactory createJDBCObjectFactory();

    private void copyProperties(Properties dest, Properties source) {
        Enumeration<?> names = source.propertyNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            dest.put(name, source.get(name));
        }
    }

    private void doInitialize() throws SQLException {
        if (!s_isInitialized) {
            ExceptionConverter.getInstance().toSQLException("HY000", "Class has not been initialized.Please initialize by calling AbstractDriver.initialize()", 0, ExceptionType.DEFAULT);
        } else if (null == DSIDriverSingleton.getInstance()) {
            try {
                IDriver driver = DSIDriverFactory.createDriver();
                DSIDriverSingleton.setInstance(driver);
                this.m_warningListener = new SWarningListener(DSIDriverSingleton.getInstance().getMessageSource(), FunctionID.BEFORE_CONNECTION);
                ILogger log = driver.getDriverLog();
                try {
                    Variant ver = driver.getProperty(5);
                    LogUtilities.logInfo("Driver version is: " + ver.getString(), log);
                }
                catch (ErrorException e) {
                    LogUtilities.logInfo("Wasn't able to retrieve the driver version.", log);
                    LogUtilities.logInfo(e, log);
                }
            }
            catch (ErrorException e) {
                SQLException se = new SQLException(e.getLocalizedMessage());
                se.initCause(e);
                throw se;
            }
        }
    }
}

