/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.io;

import com.vertica.core.VConnection;
import com.vertica.io.MessageType;
import com.vertica.io.ResponseMessage;
import com.vertica.io.VStream;
import com.vertica.support.ILogger;
import com.vertica.support.LogLevel;
import com.vertica.util.ServerErrorData;
import java.io.IOException;

public final class NoticeResponseMessage
extends ResponseMessage {
    private String m_noticeRaw;
    private ServerErrorData m_notice;
    private LogLevel m_logLevel;
    private VConnection m_conn;

    protected NoticeResponseMessage(VConnection vConnection, VStream vStream, ILogger iLogger) {
        super(vStream);
        this.m_logLevel = iLogger.getLogLevel();
        this.m_conn = vConnection;
    }

    @Override
    protected void buildMessage(int n) throws IOException {
        int n2 = this.m_vStream.ReceiveChar();
        this.m_noticeRaw = "";
        while (n2 != 0) {
            this.m_noticeRaw = this.m_noticeRaw + (char)n2 + this.m_vStream.ReceiveString() + '\u0000';
            n2 = this.m_vStream.ReceiveChar();
        }
        this.m_noticeRaw = this.m_noticeRaw + (char)n2;
        this.m_notice = new ServerErrorData(this.m_noticeRaw, this.m_logLevel, this.m_conn);
    }

    public ServerErrorData getNotice() {
        return this.m_notice;
    }

    @Override
    public MessageType getType() {
        return MessageType.Notice;
    }
}

