/*
 * Decompiled with CFR 0.152.
 */
package com.vertica.dsi.dataengine.filters;

import com.vertica.dsi.dataengine.filters.IFilter;
import com.vertica.dsi.dataengine.utilities.DataWrapper;
import com.vertica.dsi.dataengine.utilities.MetadataSourceColumnTag;
import com.vertica.dsi.exceptions.IncorrectTypeException;
import java.util.ArrayList;

public class StringListFilter
implements IFilter {
    private MetadataSourceColumnTag m_columnTag;
    private ArrayList<String> m_values = null;
    private final String m_originalValue;

    public StringListFilter(MetadataSourceColumnTag columnTag, String value) {
        this.m_columnTag = columnTag;
        this.m_originalValue = value;
    }

    @Override
    public boolean filter(DataWrapper data) {
        if (null == this.m_originalValue) {
            return true;
        }
        if (null == this.m_values) {
            String[] values = this.m_originalValue.split(",");
            this.m_values = new ArrayList(values.length);
            for (String splitValue : values) {
                if (1 < (splitValue = splitValue.trim()).length() && splitValue.startsWith("'") && splitValue.endsWith("'")) {
                    this.m_values.add(splitValue.substring(1, splitValue.length() - 1));
                    continue;
                }
                if (0 >= splitValue.length()) continue;
                this.m_values.add(splitValue);
            }
        }
        String value = null;
        try {
            switch (data.getType()) {
                case -8: 
                case 1: {
                    value = data.getChar();
                    break;
                }
                case -9: 
                case 12: {
                    value = data.getVarChar();
                    break;
                }
                case -10: 
                case -1: {
                    value = data.getLongVarChar();
                    break;
                }
            }
        }
        catch (IncorrectTypeException e) {
            assert (false);
            return false;
        }
        for (String filter : this.m_values) {
            if (!filter.equalsIgnoreCase(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public MetadataSourceColumnTag getColumnTag() {
        return this.m_columnTag;
    }
}

