/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.snowflake.model.auth;

import java.io.FileReader;
import java.io.Reader;
import java.nio.file.Paths;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.util.Properties;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JceOpenSSLPKCS8DecryptorProviderBuilder;
import org.bouncycastle.operator.InputDecryptorProvider;
import org.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.snowflake.model.auth.SnowflakeAuthModelSnowflake;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.impl.auth.AuthModelDatabaseNativeCredentials;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class SnowflakeAuthModelPrivateKey
extends SnowflakeAuthModelSnowflake {
    public static final String PROP_AUTH_PRIVATE_KEY_PATH = "private-key";
    public static final String PROP_AUTH_PRIVATE_KEY_PASSWORD = "private-ley-password";
    private static final boolean PARSE_KEY = false;

    public Object initAuthentication(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSource dataSource, AuthModelDatabaseNativeCredentials credentials, DBPConnectionConfiguration configuration, @NotNull Properties connProperties) throws DBException {
        String pkPath = configuration.getAuthProperty(PROP_AUTH_PRIVATE_KEY_PATH);
        if (!CommonUtils.isEmpty((String)pkPath)) {
            connProperties.put("private_key_file", pkPath);
            String pkPassword = configuration.getAuthProperty(PROP_AUTH_PRIVATE_KEY_PASSWORD);
            if (!CommonUtils.isEmpty((String)pkPassword)) {
                connProperties.put("private_key_file_pwd", pkPassword);
            }
        } else {
            throw new DBException("Private key path is missing");
        }
        return super.initAuthentication(monitor, dataSource, credentials, configuration, connProperties);
    }

    public void endAuthentication(@NotNull DBPDataSourceContainer dataSource, @NotNull DBPConnectionConfiguration configuration, @NotNull Properties connProperties) {
        super.endAuthentication(dataSource, configuration, connProperties);
    }

    protected String getAuthenticator(DBPDataSource dataSource, AuthModelDatabaseNativeCredentials credentials, DBPConnectionConfiguration configuration) {
        return null;
    }

    static class PrivateKeyReader {
        PrivateKeyReader() {
        }

        private static String getPrivateKeyPassphrase() {
            return "<private_key_passphrase>";
        }

        static PrivateKey get(String filename) throws Exception {
            PrivateKeyInfo privateKeyInfo = null;
            Security.addProvider((Provider)new BouncyCastleProvider());
            PEMParser pemParser = new PEMParser((Reader)new FileReader(Paths.get(filename, new String[0]).toFile()));
            Object pemObject = pemParser.readObject();
            if (pemObject instanceof PKCS8EncryptedPrivateKeyInfo) {
                PKCS8EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = (PKCS8EncryptedPrivateKeyInfo)pemObject;
                String passphrase = PrivateKeyReader.getPrivateKeyPassphrase();
                InputDecryptorProvider pkcs8Prov = new JceOpenSSLPKCS8DecryptorProviderBuilder().build(passphrase.toCharArray());
                privateKeyInfo = encryptedPrivateKeyInfo.decryptPrivateKeyInfo(pkcs8Prov);
            } else if (pemObject instanceof PrivateKeyInfo) {
                privateKeyInfo = (PrivateKeyInfo)pemObject;
            } else {
                throw new DBException("No private key pair found in '" + filename + "'\nFound: " + pemObject);
            }
            pemParser.close();
            JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider("BC");
            return converter.getPrivateKey(privateKeyInfo);
        }
    }
}

