/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.snowflake.model;

import com.dbeaver.db.snowflake.model.SnowflakeTable;
import com.dbeaver.db.snowflake.model.SnowflakeUniqueKey;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.model.GenericCatalog;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericSchema;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericTableBase;
import org.jkiss.dbeaver.ext.generic.model.GenericTableColumn;
import org.jkiss.dbeaver.ext.generic.model.GenericTableConstraintColumn;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBPQualifiedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCCompositeCache;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCStructCache;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTableConstraint;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyLength;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class SnowflakeSchema
extends GenericSchema
implements DBPQualifiedObject {
    private String name;
    private String owner;
    private long retentionTime;
    private Date createTime;
    private Date lastAltered;
    private boolean isTransient;
    private boolean isManagedAccess;
    private String description;
    private final UniqueConstraintCache uniqueConstraintCache;

    public SnowflakeSchema(@NotNull GenericDataSource dataSource, @Nullable GenericCatalog catalog, @NotNull String schemaName, @Nullable JDBCResultSet dbResult) {
        super(dataSource, catalog, schemaName);
        this.name = schemaName;
        if (dbResult != null) {
            this.owner = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"SCHEMA_OWNER");
            this.retentionTime = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"RETENTION_TIME");
            this.createTime = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"CREATED");
            this.lastAltered = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"LAST_ALTERED");
            this.isTransient = CommonUtils.notEmpty((String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"IS_TRANSIENT")).equals("YES");
            this.isManagedAccess = CommonUtils.notEmpty((String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"IS_MANAGED_ACCESS")).equals("YES");
            this.description = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"COMMENT");
        }
        this.uniqueConstraintCache = new UniqueConstraintCache();
    }

    @Property(viewable=true, order=1)
    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Property(viewable=true, order=3)
    @Nullable
    public String getOwner() {
        return this.owner;
    }

    @Property(viewable=true, updatable=true, order=4)
    public long getRetentionTime() {
        return this.retentionTime;
    }

    public void setRetentionTime(long retentionTime) {
        this.retentionTime = retentionTime;
    }

    @Property(viewable=true, order=5)
    public Date getCreateTime() {
        return this.createTime;
    }

    @Property(viewable=true, order=6)
    public Date getLastAltered() {
        return this.lastAltered;
    }

    @Property(viewable=true, order=7)
    public boolean isTransient() {
        return this.isTransient;
    }

    @Property(viewable=true, updatable=true, order=8)
    public boolean isManagedAccess() {
        return this.isManagedAccess;
    }

    public void setManagedAccess(boolean managedAccess) {
        this.isManagedAccess = managedAccess;
    }

    @Property(viewable=true, updatable=true, length=PropertyLength.MULTILINE, order=100)
    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Association
    public Collection<SnowflakeUniqueKey> getUniqueKeys(DBRProgressMonitor monitor) throws DBException {
        return this.uniqueConstraintCache.getAllObjects(monitor, (DBSObject)this);
    }

    public UniqueConstraintCache getUniqueConstraintCache() {
        return this.uniqueConstraintCache;
    }

    public synchronized DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.uniqueConstraintCache.clearCache();
        return super.refreshObject(monitor);
    }

    @NotNull
    public String getFullyQualifiedName(DBPEvaluationContext context) {
        return DBUtils.getFullQualifiedName((DBPDataSource)this.getDataSource(), (DBPNamedObject[])new DBPNamedObject[]{this.getCatalog(), this});
    }

    public class UniqueConstraintCache
    extends JDBCCompositeCache<GenericStructContainer, SnowflakeTable, SnowflakeUniqueKey, GenericTableConstraintColumn> {
        UniqueConstraintCache() {
            super((JDBCStructCache)SnowflakeSchema.this.getTableCache(), SnowflakeTable.class, (Object)"table_name", (Object)"constraint_name");
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(JDBCSession session, GenericStructContainer snowflakeSchema, SnowflakeTable forParent) throws SQLException {
            String sql = "SHOW UNIQUE KEYS IN ";
            sql = forParent != null ? String.valueOf(sql) + "TABLE " + forParent.getFullyQualifiedName(DBPEvaluationContext.DDL) : String.valueOf(sql) + "SCHEMA " + DBUtils.getObjectFullName((DBPNamedObject)snowflakeSchema, (DBPEvaluationContext)DBPEvaluationContext.DDL);
            return session.prepareStatement(sql);
        }

        @Nullable
        protected SnowflakeUniqueKey fetchObject(JDBCSession session, GenericStructContainer snowflakeSchema, SnowflakeTable snowflakeTable, String childName, JDBCResultSet resultSet) throws SQLException, DBException {
            String description = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"comment");
            return new SnowflakeUniqueKey((GenericTableBase)snowflakeTable, childName, description, true);
        }

        @Nullable
        protected GenericTableConstraintColumn[] fetchObjectRow(JDBCSession session, SnowflakeTable snowflakeTable, SnowflakeUniqueKey forObject, JDBCResultSet resultSet) throws SQLException, DBException {
            String columnName = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"column_name");
            if (CommonUtils.isEmpty((String)columnName)) {
                log.debug((Object)("Can't find constraint table column name for " + forObject.getName()));
                return null;
            }
            GenericTableColumn tableColumn = snowflakeTable.getAttribute(session.getProgressMonitor(), columnName);
            if (tableColumn == null) {
                log.debug((Object)("Can't find constraint table column for " + forObject.getName()));
                return null;
            }
            int keySeq = JDBCUtils.safeGetInt((ResultSet)resultSet, (String)"key_sequence");
            return new GenericTableConstraintColumn[]{new GenericTableConstraintColumn((JDBCTableConstraint)forObject, tableColumn, keySeq)};
        }

        protected void cacheChildren(DBRProgressMonitor monitor, SnowflakeUniqueKey object, List<GenericTableConstraintColumn> children) {
            object.setColumns(children);
        }
    }
}

