/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.snowflake.edit;

import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.edit.GenericProcedureManager;
import org.jkiss.dbeaver.ext.generic.model.GenericProcedure;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.edit.DBEObjectRenamer;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class SnowflakeProcedureManager
extends GenericProcedureManager
implements DBEObjectRenamer<GenericProcedure> {
    protected void addObjectExtraActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.NestedObjectCommand<GenericProcedure, SQLObjectEditor.PropertyHandler> command, Map<String, Object> options) {
        GenericProcedure procedure = (GenericProcedure)command.getObject();
        String procedureFullName = this.getProcedureFullNameWithParameters(monitor, procedure);
        if (command.hasProperty((Object)"description")) {
            actions.add((DBEPersistAction)new SQLDatabasePersistAction("Comment sequence", "ALTER " + procedure.getProcedureType().name() + " " + procedureFullName + " SET COMMENT = " + SQLUtils.quoteString((DBSObject)procedure, (String)CommonUtils.notEmpty((String)procedure.getDescription()))));
        }
    }

    public void renameObject(@NotNull DBECommandContext commandContext, @NotNull GenericProcedure object, @NotNull Map<String, Object> options, @NotNull String newName) throws DBException {
        this.processObjectRename(commandContext, (DBSObject)object, options, newName);
    }

    protected void addObjectRenameActions(DBRProgressMonitor monitor, DBCExecutionContext executionContext, List<DBEPersistAction> actions, SQLObjectEditor.ObjectRenameCommand command, Map<String, Object> options) {
        GenericProcedure procedure = (GenericProcedure)command.getObject();
        String fullName = DBUtils.getQuotedIdentifier((DBPDataSource)procedure.getDataSource(), (String)command.getNewName());
        DBSObject schema = procedure.getParentObject();
        if (schema != null) {
            fullName = String.valueOf(DBUtils.getQuotedIdentifier((DBSObject)schema)) + "." + fullName;
            DBSObject catalog = schema.getParentObject();
            if (catalog != null) {
                fullName = String.valueOf(DBUtils.getQuotedIdentifier((DBSObject)catalog)) + "." + fullName;
            }
        }
        String procedureFullName = this.getProcedureFullNameWithParameters(monitor, procedure);
        actions.add((DBEPersistAction)new SQLDatabasePersistAction("Rename procedure", "ALTER " + procedure.getProcedureType().name() + " " + procedureFullName + " RENAME TO " + fullName));
    }

    private String getProcedureFullNameWithParameters(DBRProgressMonitor monitor, @NotNull GenericProcedure procedure) {
        String procedureFullName;
        try {
            procedureFullName = procedure.getProcedureSignature(monitor, false);
        }
        catch (DBException e) {
            log.debug((Object)"Can't read procedure/function parameters", (Throwable)e);
            procedureFullName = procedure.getFullyQualifiedName(DBPEvaluationContext.DDL);
        }
        return procedureFullName;
    }
}

