/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.resources;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.wizard.IWizard;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.app.DBPPlatformEclipse;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.app.DBPResourceHandler;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNProject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.MultiPageWizardDialog;
import org.jkiss.dbeaver.ui.project.EditProjectWizard;
import org.jkiss.dbeaver.ui.resources.AbstractResourceHandler;

public class ProjectHandlerImpl
extends AbstractResourceHandler {
    @NotNull
    public String getTypeName(@NotNull IResource resource) {
        return "project";
    }

    public int getFeatures(IResource resource) {
        boolean distributed = DBWorkbench.getPlatform().getApplication().isDistributed();
        int features = 4;
        if (!distributed) {
            features |= 8;
            DBPProject activeProject = DBWorkbench.getPlatform().getWorkspace().getActiveProject();
            if (activeProject == null || resource != activeProject.getEclipseProject()) {
                features |= 2;
            }
        }
        return features;
    }

    @NotNull
    public DBNProject makeNavigatorNode(@NotNull DBNNode parentNode, @NotNull IResource resource) {
        return new DBNProject(parentNode, DBPPlatformEclipse.getInstance().getWorkspace().getProject((IProject)resource), (DBPResourceHandler)this);
    }

    public void openResource(@NotNull IResource resource) {
        DBPProject project = DBPPlatformEclipse.getInstance().getWorkspace().getProject((IProject)resource);
        if (project == null) {
            DBWorkbench.getPlatformUI().showError("No project", "Can't get project metadata for resource " + resource.getName());
            return;
        }
        MultiPageWizardDialog dialog = new MultiPageWizardDialog(UIUtils.getActiveWorkbenchWindow(), (IWizard)new EditProjectWizard(project));
        dialog.open();
    }
}

