/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.remote.client.interceptor;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.jkiss.code.Nullable;
import org.jkiss.utils.CommonUtils;

public class DCTrustedServiceInterceptor
implements Interceptor {
    @Nullable
    private final String dcCertificate;

    public DCTrustedServiceInterceptor(@Nullable String dcCertificate) {
        this.dcCertificate = dcCertificate;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        return chain.proceed(this.addDcCertificateHeader(request));
    }

    private Request addDcCertificateHeader(Request request) {
        if (CommonUtils.isEmpty((String)this.dcCertificate)) {
            return request;
        }
        return request.newBuilder().header("DC-Client-Cert", Base64.getEncoder().encodeToString(this.dcCertificate.getBytes(StandardCharsets.UTF_8))).build();
    }
}

