/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.remote.client.interceptor;

import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.auth.SMCredentials;
import org.jkiss.dbeaver.model.auth.SMCredentialsProvider;

public class DCAuthInterceptor
implements Interceptor {
    @NotNull
    private final SMCredentialsProvider smCredentialsProvider;

    public DCAuthInterceptor(@Nullable SMCredentialsProvider smCredentialsProvider) {
        this.smCredentialsProvider = smCredentialsProvider;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        return chain.proceed(this.addDCAuthTokenToHeader(request));
    }

    private Request addDCAuthTokenToHeader(Request request) {
        if (this.smCredentialsProvider.getActiveUserCredentials() == null) {
            return request;
        }
        SMCredentials smCredentials = this.smCredentialsProvider.getActiveUserCredentials();
        return request.newBuilder().header("Authorization", smCredentials.getSmToken()).build();
    }
}

