/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.remote.client;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import org.jkiss.utils.Base64;

public class GsonUtils {
    public static GsonBuilder gsonBuilder() {
        return new GsonBuilder().registerTypeHierarchyAdapter(byte[].class, (Object)new ByteArrayToBase64TypeAdapter()).serializeNulls().setPrettyPrinting();
    }

    public static class ByteArrayToBase64TypeAdapter
    implements JsonSerializer<byte[]>,
    JsonDeserializer<byte[]> {
        public byte[] deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return Base64.decode((String)json.getAsString());
        }

        public JsonElement serialize(byte[] src, Type typeOfSrc, JsonSerializationContext context) {
            return new JsonPrimitive(Base64.encode((byte[])src));
        }
    }
}

