/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.remote.client;

import com.dbeaver.remote.client.GsonUtils;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;

public class BodyConverter {
    public static final MediaType JSON = MediaType.get((String)"application/json");
    public static final MediaType TEXT_PLAIN = MediaType.get((String)"text/plain");

    @NotNull
    public static RequestBody convertFrom(@Nullable Object body, @NotNull MediaType mediaType) {
        if (body == null) {
            return RequestBody.create((String)"", (MediaType)mediaType);
        }
        if (body instanceof byte[]) {
            return RequestBody.create((byte[])((byte[])body), (MediaType)mediaType);
        }
        if (body instanceof String) {
            return RequestBody.create((String)((String)body), (MediaType)mediaType);
        }
        return RequestBody.create((String)GsonUtils.gsonBuilder().create().toJson(body), (MediaType)mediaType);
    }
}

