/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.remote.client;

import com.dbeaver.remote.client.BodyConverter;
import com.dbeaver.remote.client.GsonUtils;
import com.dbeaver.remote.client.RefreshSMSessionFunction;
import com.google.gson.Gson;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.security.exception.SMAccessTokenExpiredException;
import org.jkiss.utils.CommonUtils;

public abstract class AbstractRemoteClient {
    public static final int TOKEN_EXPIRED_ERROR_CODE = 440;
    private static final Gson gson = GsonUtils.gsonBuilder().create();
    private final OkHttpClient httpClient;
    private final String apiUrl;
    @Nullable
    private final RefreshSMSessionFunction authRefreshFunction;

    public AbstractRemoteClient(String apiUrl, List<Interceptor> interceptors, @Nullable RefreshSMSessionFunction authRefreshFunction) {
        this(apiUrl, 30000, 120000, interceptors, authRefreshFunction);
    }

    public AbstractRemoteClient(String apiUrl, int connectTimeout, int readTimeout, List<Interceptor> interceptors) {
        this(apiUrl, connectTimeout, readTimeout, interceptors, null);
    }

    public AbstractRemoteClient(String apiUrl, int connectTimeout, int readTimeout, List<Interceptor> interceptors, @Nullable RefreshSMSessionFunction authRefreshFunction) {
        this.apiUrl = apiUrl;
        this.authRefreshFunction = authRefreshFunction;
        this.httpClient = this.buildClient(connectTimeout, readTimeout, interceptors);
    }

    @NotNull
    private OkHttpClient buildClient(int connectTimeout, int readTimeout, List<Interceptor> interceptors) {
        OkHttpClient.Builder httpClientBuilder = new OkHttpClient().newBuilder();
        if (connectTimeout > 0) {
            httpClientBuilder.connectTimeout((long)connectTimeout, TimeUnit.MILLISECONDS);
        }
        if (readTimeout > 0) {
            httpClientBuilder.readTimeout((long)readTimeout, TimeUnit.MILLISECONDS);
        }
        interceptors.forEach(arg_0 -> ((OkHttpClient.Builder)httpClientBuilder).addInterceptor(arg_0));
        return httpClientBuilder.build();
    }

    protected OkHttpClient getHttpClient() {
        return this.httpClient;
    }

    protected <T> T executeGetRequest(String endpointUrl, Type type) throws DBException {
        return this.executeGetRequest(endpointUrl, Map.of(), type);
    }

    protected <T> T executeGetRequest(String endpointUrl, Map<String, ?> parameters, Type type) throws DBException {
        HttpUrl url = this.buildUrl(endpointUrl, parameters);
        Request request = new Request.Builder().url(url).build();
        return this.executeRequest(request, BodyConverter.JSON, type);
    }

    protected <T> T executeDeleteRequest(String endpointUrl, Type type) throws DBException {
        return this.executeDeleteRequest(endpointUrl, Map.of(), type);
    }

    protected <T> T executeDeleteRequest(String endpointUrl, Map<String, ?> parameters, Type type) throws DBException {
        return this.executeDeleteRequest(endpointUrl, parameters, null, type);
    }

    protected <T> T executeDeleteRequest(String endpointUrl, Map<String, ?> parameters, Object body, Type type) throws DBException {
        HttpUrl url = this.buildUrl(endpointUrl, parameters);
        Request request = new Request.Builder().url(url).delete(BodyConverter.convertFrom(body, BodyConverter.JSON)).build();
        return this.executeRequest(request, BodyConverter.JSON, type);
    }

    protected <T> T executePostRequest(String endpointUrl, Map<String, ?> parameters, Type type) throws DBException {
        return this.executePostRequest(endpointUrl, parameters, null, type);
    }

    protected <T> T executePostRequest(String endpointUrl, Object body, Type type) throws DBException {
        return this.executePostRequest(endpointUrl, Map.of(), body, type);
    }

    protected <T> T executePostRequest(String endpointUrl, @NotNull Map<String, ?> parameters, @Nullable Object body, Type type) throws DBException {
        return this.executePostRequest(endpointUrl, parameters, body, BodyConverter.JSON, type);
    }

    protected <T> T executePostRequest(String endpointUrl, @NotNull Map<String, ?> parameters, @Nullable Object body, @NotNull MediaType mediaType, Type type) throws DBException {
        HttpUrl url = this.buildUrl(endpointUrl, parameters);
        RequestBody requestBody = BodyConverter.convertFrom(body, mediaType);
        Request request = new Request.Builder().url(url).post(requestBody).build();
        return this.executeRequest(request, mediaType, type);
    }

    protected <T> T executePutRequest(@NotNull String endpointUrl, @NotNull Map<String, ?> parameters, @NotNull Type type) throws DBException {
        return this.executePutRequest(endpointUrl, parameters, null, type);
    }

    protected <T> T executePutRequest(@NotNull String endpointUrl, @Nullable Object body, @NotNull Type type) throws DBException {
        return this.executePutRequest(endpointUrl, Map.of(), body, type);
    }

    protected <T> T executePutRequest(@NotNull String endpointUrl, @NotNull Map<String, ?> parameters, @Nullable Object body, @NotNull Type type) throws DBException {
        Request request = new Request.Builder().url(this.buildUrl(endpointUrl, parameters)).put(BodyConverter.convertFrom(body, BodyConverter.JSON)).build();
        return this.executeRequest(request, BodyConverter.JSON, type);
    }

    protected HttpUrl buildUrl(String endpointUrl, Map<String, ?> parameters) throws DBException {
        HttpUrl baseUrl = HttpUrl.parse((String)this.apiUrl);
        if (baseUrl == null) {
            throw new DBException("Could not parse url: " + this.apiUrl);
        }
        HttpUrl.Builder urlBuilder = baseUrl.newBuilder().addPathSegments(endpointUrl);
        parameters.forEach((paramName, value) -> {
            if (value == null) {
                return;
            }
            if (value instanceof byte[]) {
                urlBuilder.addQueryParameter(paramName, new String((byte[])value, StandardCharsets.UTF_8));
            } else if (value.getClass().isArray()) {
                Object[] array;
                Object[] objectArray = array = (Object[])value;
                int n = array.length;
                int n2 = 0;
                while (n2 < n) {
                    Object v = objectArray[n2];
                    urlBuilder.addQueryParameter(paramName, v.toString());
                    ++n2;
                }
            } else if (Collection.class.isAssignableFrom(value.getClass())) {
                Collection array = (Collection)value;
                for (Object v : array) {
                    urlBuilder.addQueryParameter(paramName, v.toString());
                }
            } else {
                urlBuilder.addQueryParameter(paramName, value.toString());
            }
        });
        return urlBuilder.build();
    }

    private <T> T executeRequest(Request request, MediaType mediaType, Type type) throws DBException {
        return this.executeRequest(request, mediaType, type, true);
    }

    private <T> T executeRequest(Request request, MediaType mediaType, Type type, boolean shouldRefreshTokens) throws DBException {
        Call call = this.httpClient.newCall(request);
        try {
            Throwable throwable = null;
            Object var7_9 = null;
            try (Response response = call.execute();){
                if (response.code() == 440 && this.authRefreshFunction != null && shouldRefreshTokens) {
                    this.authRefreshFunction.refresh();
                    return this.executeRequest(request, mediaType, type, false);
                }
                if (!response.isSuccessful()) {
                    String message = response.body().string();
                    if (CommonUtils.isEmpty((String)message)) {
                        message = "Error processing HTTP request: " + response.message();
                    }
                    if (response.code() == 440) {
                        throw new SMAccessTokenExpiredException(message);
                    }
                    throw new DBException(message);
                }
                String jsonResponse = response.body().string();
                if (type == String.class) {
                    return (T)jsonResponse;
                }
                return (T)gson.fromJson(jsonResponse, type);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            this.handleRequestException(e);
            return null;
        }
    }

    protected static String buildEndpointUrl(String ... pathParts) {
        return String.join((CharSequence)"/", pathParts);
    }

    protected abstract void handleRequestException(Exception var1) throws DBException;
}

