/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.jdbc.jdbc;

import com.teradata.jdbc.AuthMechanism;
import com.teradata.jdbc.ErrorMessage;
import com.teradata.jdbc.jdbc.GenericTeraEncrypt;
import com.teradata.jdbc.jdbc.GenericTeradataConnection;
import com.teradata.jdbc.jdbc_4.LogonInformation;
import com.teradata.jdbc.jdbc_4.TDSession;
import com.teradata.jdbc.jdbc_4.io.TDPacket;
import com.teradata.jdbc.jdbc_4.logging.Log;
import com.teradata.jdbc.jdbc_4.parcel.AssignParcel;
import com.teradata.jdbc.jdbc_4.parcel.AssignRspParcel;
import com.teradata.jdbc.jdbc_4.parcel.AuthMechParcel;
import com.teradata.jdbc.jdbc_4.parcel.ClientAttributesParcel;
import com.teradata.jdbc.jdbc_4.parcel.ClientConfigParcel;
import com.teradata.jdbc.jdbc_4.parcel.ConfigRspParcel;
import com.teradata.jdbc.jdbc_4.parcel.ConnectParcel;
import com.teradata.jdbc.jdbc_4.parcel.EndRequestParcel;
import com.teradata.jdbc.jdbc_4.parcel.ErrorParcel;
import com.teradata.jdbc.jdbc_4.parcel.FailureParcel;
import com.teradata.jdbc.jdbc_4.parcel.GtwConfigParcel;
import com.teradata.jdbc.jdbc_4.parcel.LogonDataParcel;
import com.teradata.jdbc.jdbc_4.parcel.LogonParcel;
import com.teradata.jdbc.jdbc_4.parcel.LogonSequenceNumberParcel;
import com.teradata.jdbc.jdbc_4.parcel.Parcel;
import com.teradata.jdbc.jdbc_4.parcel.SSORequestParcel;
import com.teradata.jdbc.jdbc_4.parcel.SSOResponseParcel;
import com.teradata.jdbc.jdbc_4.parcel.SessionOptionsParcel;
import com.teradata.jdbc.jdbc_4.parcel.StatementStatusParcel;
import com.teradata.jdbc.jdbc_4.util.ErrorFactory;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Iterator;
import org.ietf.jgss.Oid;

public class GenericLogonController {
    private LogonInformation m_logonInfo;
    private GenericTeradataConnection m_con;
    private Reconnect m_reconnect;
    private boolean m_bConfigOnly;

    public GenericLogonController(GenericTeradataConnection genericTeradataConnection) {
        this.m_logonInfo = genericTeradataConnection.getLogonInformation();
        this.m_con = genericTeradataConnection;
    }

    public void setReconnect(Reconnect reconnect) {
        this.m_reconnect = reconnect;
    }

    public void setConfigOnly() {
        this.m_bConfigOnly = true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() throws SQLException {
        Parcel parcel;
        Object object;
        Object object2;
        AuthMechanism authMechanism;
        Object object3;
        Object object4;
        Object object5;
        TDPacket tDPacket;
        Log log;
        block81: {
            Object object6;
            Object object7;
            Object object8;
            block82: {
                boolean bl;
                boolean bl2;
                Oid oid;
                Oid oid2;
                boolean bl3;
                Object object9;
                Object object10;
                block83: {
                    boolean bl4;
                    log = this.m_con.getLog();
                    tDPacket = this.m_con.createPacket(1);
                    boolean bl5 = bl4 = this.m_reconnect != null || this.m_con.getConfigResponse() == null || this.m_con.getGtwConfig() == null || this.m_con.getAuthMechParcels().isEmpty();
                    if (log.isDebugEnabled()) {
                        log.debug("GenericLogonController.run: reconnect=" + (this.m_reconnect != null) + " ConfigResponse=" + (this.m_con.getConfigResponse() != null) + " GtwConfig=" + (this.m_con.getGtwConfig() != null) + " AuthMech=" + !this.m_con.getAuthMechParcels().isEmpty() + " bNeedConfigResponseMessage=" + bl4 + " m_bConfigOnly=" + this.m_bConfigOnly);
                    }
                    if (bl4) {
                        tDPacket.setInitParcelPosition();
                        tDPacket.setLANKind((byte)10);
                        tDPacket.setByteVar((byte)7);
                        tDPacket.setHostCharSet((byte)-1);
                        if (this.m_reconnect != null) {
                            tDPacket.setSessionNumber(this.m_con.getSessionNum());
                            tDPacket.setAuthentication(this.m_reconnect.nAuthenticationNonce);
                        }
                        object5 = new ClientConfigParcel(this.m_con);
                        tDPacket.addParcel((Parcel)object5);
                        tDPacket.toStream();
                        tDPacket.getBuffer().writeStream(this.m_con.getIO(), null, false);
                        tDPacket.clear();
                        tDPacket.getBuffer().readStream(this.m_con.getIO(), null, this.m_con.checkRemainingLoginTime(), false);
                        tDPacket.initParcelFactory(this.m_con);
                        block30: while ((object10 = tDPacket.nextParcel()) != null) {
                            switch (((Parcel)object10).getFlavor()) {
                                case 43: {
                                    object8 = (ConfigRspParcel)object10;
                                    this.m_con.setConfigResponse((ConfigRspParcel)object8);
                                    continue block30;
                                }
                                case 165: {
                                    object7 = (GtwConfigParcel)object10;
                                    this.m_con.setGtwConfig((GtwConfigParcel)object7);
                                    continue block30;
                                }
                                case 167: {
                                    object6 = (AuthMechParcel)object10;
                                    this.m_con.addAuthMechParcel((AuthMechParcel)object6);
                                    continue block30;
                                }
                                case 9: {
                                    FailureParcel failureParcel = (FailureParcel)object10;
                                    throw ErrorFactory.makeDatabaseSQLException(failureParcel.getMsg(), failureParcel.getCode());
                                }
                                case 49: {
                                    ErrorParcel errorParcel = (ErrorParcel)object10;
                                    throw ErrorFactory.makeDatabaseSQLException(errorParcel.getMsg(), errorParcel.getCode());
                                }
                            }
                            throw ErrorFactory.makeDriverJDBCException("TJ305", Integer.toString(((Parcel)object10).getFlavor()));
                        }
                    }
                    if (this.m_con.getConfigResponse() == null || this.m_con.getGtwConfig() == null || this.m_con.getAuthMechParcels().isEmpty()) {
                        throw ErrorFactory.makeDriverJDBCException("TJ1560");
                    }
                    if (this.m_bConfigOnly) {
                        return;
                    }
                    object5 = this.m_con.getTeraEncrypt();
                    object10 = new ArrayList<AuthMechanism>();
                    object8 = null;
                    object7 = null;
                    object6 = this.m_con.getAuthMechParcels().iterator();
                    while (object6.hasNext()) {
                        AuthMechParcel authMechParcel = (AuthMechParcel)object6.next();
                        object9 = new AuthMechanism((GenericTeraEncrypt)object5, authMechParcel.getMechOid());
                        if (log.isDebugEnabled()) {
                            log.debug("New Server Mechanism: " + ((AuthMechanism)object9).getUserName() + "   " + ((AuthMechanism)object9).getName());
                        }
                        object10.add(object9);
                        if (authMechParcel.isDefaultMechanism()) {
                            object8 = authMechParcel.getMechOid();
                            if (log.isDebugEnabled()) {
                                log.debug(" Default Server Mechanism is: " + authMechParcel.getMechOidString());
                            }
                        }
                        if (!authMechParcel.isDefaultNegotiatingMechanism()) continue;
                        object7 = authMechParcel.getMechOid();
                        if (!log.isDebugEnabled()) continue;
                        log.debug(" Negotiation Mechanism Supported: " + this.m_con.getGtwConfig().isNegotiationMechanismSupported() + "   Default Server Negotiating Mechanism is: " + authMechParcel.getMechOidString());
                    }
                    object6 = this.m_con.getlogmech();
                    if ("NONE".equalsIgnoreCase((String)object6)) {
                        this.m_con.getIO().close();
                        return;
                    }
                    if (object10.isEmpty()) {
                        throw ErrorFactory.makeDriverJDBCException("TJ334");
                    }
                    bl3 = false;
                    object9 = null;
                    oid2 = ((GenericTeraEncrypt)object5).getClientDefaultMech(false);
                    Oid oid3 = oid = this.m_con.getGtwConfig().isNegotiationMechanismSupported() ? ((GenericTeraEncrypt)object5).getClientDefaultMech(true) : null;
                    if (object6 == null && oid2 == null && oid == null) break block82;
                    if (object6 != null && (object9 = ((GenericTeraEncrypt)object5).getOidForName((String)object6)) == null) {
                        throw ErrorFactory.makeDriverJDBCException("TJ335", (String)object6);
                    }
                    boolean bl6 = false;
                    bl2 = false;
                    bl = false;
                    object4 = object10.iterator();
                    while (object4.hasNext()) {
                        object3 = (AuthMechanism)object4.next();
                        if (object9 != null && ((Oid)object9).equals(((AuthMechanism)object3).getOid())) {
                            bl6 = true;
                        }
                        if (oid2 != null && oid2.equals(((AuthMechanism)object3).getOid())) {
                            bl2 = true;
                        }
                        if (oid == null || !oid.equals(((AuthMechanism)object3).getOid())) continue;
                        bl = true;
                    }
                    if (!bl6) break block83;
                    authMechanism = new AuthMechanism((GenericTeraEncrypt)object5, (Oid)object9);
                    break block81;
                }
                if (bl) {
                    authMechanism = new AuthMechanism((GenericTeraEncrypt)object5, oid);
                    bl3 = true;
                    break block81;
                } else if (bl2) {
                    authMechanism = new AuthMechanism((GenericTeraEncrypt)object5, oid2);
                    bl3 = true;
                    break block81;
                } else {
                    object4 = null;
                    if (object9 != null) {
                        object4 = object6;
                    } else if (oid != null) {
                        object4 = oid.toString();
                    } else if (oid2 != null) {
                        object4 = oid2.toString();
                    }
                    object3 = new StringBuffer(Log.LINE_SEP + ErrorMessage.Format1(ErrorMessage.messages.getString("TJ340"), (String)object4) + Log.LINE_SEP + ErrorMessage.messages.getString("TJ337"));
                    Iterator iterator = object10.iterator();
                    while (true) {
                        if (!iterator.hasNext()) {
                            throw ErrorFactory.makeDriverJDBCException("TJ341", ((StringBuffer)object3).toString());
                        }
                        AuthMechanism authMechanism2 = (AuthMechanism)iterator.next();
                        ((StringBuffer)object3).append(Log.LINE_SEP + authMechanism2.getUserName() + "  " + authMechanism2.getName());
                    }
                }
            }
            if (this.m_con.getGtwConfig().isNegotiationMechanismSupported() && object7 != null) {
                authMechanism = new AuthMechanism((GenericTeraEncrypt)object5, (Oid)object7);
            } else {
                if (object8 == null) {
                    throw ErrorFactory.makeDriverJDBCException("TJ333", (String)object6);
                }
                authMechanism = new AuthMechanism((GenericTeraEncrypt)object5, (Oid)object8);
            }
        }
        tDPacket.clear();
        tDPacket.newLanHeader();
        tDPacket.setInitParcelPosition();
        tDPacket.setLANKind(this.m_reconnect != null ? (byte)2 : 1);
        tDPacket.setByteVar((byte)7);
        tDPacket.setAuthentication(this.m_reconnect != null ? this.m_reconnect.nAuthenticationNonce : this.m_con.getAuthenticationNonce());
        tDPacket.setHostCharSet(this.m_con.getTdSessionCharSetCode());
        if (this.m_reconnect != null) {
            tDPacket.setSessionNumber(this.m_con.getSessionNum());
        }
        AssignParcel assignParcel = new AssignParcel(this.m_con);
        ((GenericTeraEncrypt)object5).useAuthMech(this.m_con, authMechanism.getName());
        byte[] byArray = ((GenericTeraEncrypt)object5).getIntoken();
        byte[] byArray2 = ((GenericTeraEncrypt)object5).initSecContext(byArray, 0, byArray.length);
        if (byArray2 == null) {
            throw ErrorFactory.makeDriverJDBCException("TJ343");
        }
        object4 = new SSORequestParcel(this.m_con);
        ((SSORequestParcel)object4).setTrip(((GenericTeraEncrypt)object5).getTrip());
        ((GenericTeraEncrypt)object5).incTrip();
        ((SSORequestParcel)object4).setAuthData(byArray2);
        ((SSORequestParcel)object4).setMethod(((GenericTeraEncrypt)object5).getSSOAuthMethod());
        tDPacket.addParcel((Parcel)object4);
        ((GenericTeraEncrypt)object5).updateGeneratedCredentials();
        if (!this.m_con.isExtObjectNameParcelSupported()) {
            assignParcel.setUserName(((GenericTeraEncrypt)object5).isUsingGeneratedCredentials() ? "" : this.m_logonInfo.getUserName());
        }
        tDPacket.addParcel(assignParcel);
        tDPacket.toStream();
        tDPacket.getBuffer().writeStream(this.m_con.getIO(), null, false);
        tDPacket.clear();
        tDPacket.getBuffer().readStream(this.m_con.getIO(), null, this.m_con.checkRemainingLoginTime(), false);
        tDPacket.initParcelFactory(this.m_con);
        if (log.isDebugEnabled()) {
            log.debug("packet.getEncryption=" + tDPacket.getEncryption());
        }
        this.m_con.setSessionNum(tDPacket.getLANSessionNumber());
        block34: while ((object3 = tDPacket.nextParcel()) != null) {
            switch (((Parcel)object3).getFlavor()) {
                case 101: {
                    this.m_con.setAssignRspParcel((AssignRspParcel)object3);
                    continue block34;
                }
                case 43: {
                    continue block34;
                }
                case 134: {
                    object2 = (SSOResponseParcel)object3;
                    this.m_con.getTeraEncrypt().setIntoken(((SSOResponseParcel)object2).getAuthData());
                    continue block34;
                }
                case 9: {
                    FailureParcel failureParcel = (FailureParcel)object3;
                    throw ErrorFactory.makeDatabaseSQLException(failureParcel.getMsg(), failureParcel.getCode());
                }
                case 49: {
                    ErrorParcel errorParcel = (ErrorParcel)object3;
                    throw ErrorFactory.makeDatabaseSQLException(errorParcel.getMsg(), errorParcel.getCode());
                }
            }
            log.error("AssignRspState receive an un-expected parcel with flavor: " + ((Parcel)object3).getFlavor());
            throw ErrorFactory.makeDriverJDBCException("TJ305", Integer.toString(((Parcel)object3).getFlavor()));
        }
        try {
            byArray = ((GenericTeraEncrypt)object5).getIntoken();
            do {
                tDPacket.clear();
                tDPacket.newLanHeader();
                tDPacket.setInitParcelPosition();
                tDPacket.setLANKind((byte)12);
                tDPacket.setByteVar((byte)7);
                tDPacket.setHostCharSet(this.m_con.getTdSessionCharSetCode());
                tDPacket.setSessionNumber(this.m_con.getSessionNum());
                log.debugByteArray("EncryptContextState calling initSecContext with", byArray);
                byArray2 = ((GenericTeraEncrypt)object5).initSecContext(byArray, 0, byArray.length);
                log.debugByteArray("EncryptContextState called initSecContext and got", byArray2);
                ((GenericTeraEncrypt)object5).updateGeneratedCredentials();
                if (byArray2 == null && !((GenericTeraEncrypt)object5).isEstablished()) {
                    byArray2 = new byte[]{};
                }
                if (byArray2 == null) continue;
                tDPacket.setAuthentication(this.m_con.getAuthenticationNonce());
                object4 = new SSORequestParcel(this.m_con);
                ((SSORequestParcel)object4).setTrip(((GenericTeraEncrypt)object5).getTrip());
                ((GenericTeraEncrypt)object5).incTrip();
                ((SSORequestParcel)object4).setAuthData(byArray2);
                ((SSORequestParcel)object4).setMethod(((GenericTeraEncrypt)object5).getSSOAuthMethod());
                tDPacket.addParcel((Parcel)object4);
                tDPacket.toStream();
                tDPacket.getBuffer().writeStream(this.m_con.getIO(), null, false);
                tDPacket.clear();
                tDPacket.getBuffer().readStream(this.m_con.getIO(), null, this.m_con.checkRemainingLoginTime(), false);
                tDPacket.initParcelFactory(this.m_con);
                block36: while ((object3 = tDPacket.nextParcel()) != null) {
                    switch (((Parcel)object3).getFlavor()) {
                        case 134: {
                            object2 = (SSOResponseParcel)object3;
                            byArray = ((SSOResponseParcel)object2).getAuthData();
                            log.debugByteArray("EncryptContextState called getAuthData and got", byArray);
                            continue block36;
                        }
                        case 9: {
                            FailureParcel failureParcel = (FailureParcel)object3;
                            throw ErrorFactory.makeDatabaseSQLException(failureParcel.getMsg(), failureParcel.getCode());
                        }
                        case 49: {
                            ErrorParcel errorParcel = (ErrorParcel)object3;
                            throw ErrorFactory.makeDatabaseSQLException(errorParcel.getMsg(), errorParcel.getCode());
                        }
                    }
                    throw ErrorFactory.makeIoJDBCException("TJ305", Integer.toString(((Parcel)object3).getFlavor()), this.m_con.getIO(), null, log);
                }
            } while (!((GenericTeraEncrypt)object5).isEstablished());
            if (log.isDebugEnabled()) {
                ((GenericTeraEncrypt)object5).showContext();
            }
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Throwable throwable) {
            throw ErrorFactory.makeIoJDBCException("TJ331", "GenericEncryptContextState action", this.m_con.getIO(), throwable, log);
        }
        tDPacket.clear();
        tDPacket.newLanHeader();
        tDPacket.setInitParcelPosition();
        tDPacket.setLANKind(this.m_reconnect != null ? (byte)4 : 3);
        tDPacket.setHostCharSet(this.m_con.getTdSessionCharSetCode());
        tDPacket.setSessionNumber(this.m_con.getSessionNum());
        tDPacket.setAuthentication(this.m_con.getAuthenticationNonce());
        if (this.m_reconnect != null) {
            tDPacket.setRequestNumber(this.m_reconnect.nRequestNumber);
            tDPacket.setByteVar((byte)1);
        }
        object3 = new LogonParcel(this.m_con);
        if (!((GenericTeraEncrypt)object5).isUsingGeneratedCredentials()) {
            ((LogonParcel)object3).setLogonInformation(this.m_logonInfo);
        } else {
            object2 = this.m_logonInfo.getAccount();
            if (object2 != null && ((String)object2).length() > 0) {
                object = new LogonInformation(null, null);
                ((LogonInformation)object).setAccount((String)object2);
                ((LogonParcel)object3).setLogonInformation((LogonInformation)object);
            }
        }
        tDPacket.addParcel((Parcel)object3);
        object2 = new SessionOptionsParcel(this.m_con);
        ((SessionOptionsParcel)object2).setSemantics(this.m_con.getTransactionSemantics());
        if (this.m_con.getConfigResponse().statementStatusLevel() >= 1) {
            ((SessionOptionsParcel)object2).setEssFlag((byte)69);
            ((SessionOptionsParcel)object2).setEssLevel((byte)1);
        }
        if (this.m_con.getURLParameters().getConnectFunction() == 1 && this.m_con instanceof TDSession && ((TDSession)this.m_con).useCheckWorkload()) {
            ((SessionOptionsParcel)object2).setCheckWorkload((byte)49);
        }
        if (this.m_con.desiredRedriveLevel() >= 4 && this.m_con.databaseCapableOfRedriveLevel() >= 3) {
            ((SessionOptionsParcel)object2).setRedrive((byte)89);
        }
        tDPacket.addParcel((Parcel)object2);
        object = new ConnectParcel(this.m_con);
        ((ConnectParcel)object).setPartitionName(this.m_con.getURLParameters().getPartition());
        if (this.m_con.getURLParameters().getLogonSequenceNumber() != null) {
            ((ConnectParcel)object).setLogonSequenceNumber(this.m_con.getURLParameters().getLogonSequenceNumber());
        }
        ((ConnectParcel)object).setFunction(this.m_con.getURLParameters().getConnectFunction());
        tDPacket.addParcel((Parcel)object);
        byte by = this.m_con.getConfigResponse().getClientAttributesSupport();
        LogonDataParcel logonDataParcel = new LogonDataParcel(this.m_con.getIO(), this.m_con.getURLParameters().getLssType(), this.m_con);
        if (by <= 1) {
            tDPacket.addParcel(logonDataParcel);
        }
        ClientAttributesParcel clientAttributesParcel = new ClientAttributesParcel(this.m_con);
        if (by >= 1) {
            tDPacket.addParcel(clientAttributesParcel);
        }
        tDPacket.toStream();
        tDPacket.getBuffer().writeStream(this.m_con.getIO(), null, false);
        tDPacket.clear();
        tDPacket.getBuffer().readStream(this.m_con.getIO(), null, this.m_con.checkRemainingLoginTime(), false);
        tDPacket.initParcelFactory(this.m_con);
        block37: while (true) {
            if ((parcel = tDPacket.nextParcel()) == null) {
                return;
            }
            switch (parcel.getFlavor()) {
                case 8: 
                case 205: {
                    StatementStatusParcel statementStatusParcel = (StatementStatusParcel)parcel;
                    statementStatusParcel.verifySuccess();
                    if (statementStatusParcel.getSQLWarnings() == null) continue block37;
                    this.m_con.setNeedNewPassword(statementStatusParcel.hasWarningCode(3032));
                    if (this.m_con.supportsPasswordChange()) continue block37;
                    Object object11 = statementStatusParcel.getSQLWarnings();
                    this.m_con.addWarning((SQLWarning)object11);
                    continue block37;
                }
                case 137: {
                    continue block37;
                }
                case 89: {
                    this.m_con.setLogonSequenceNumberParcel((LogonSequenceNumberParcel)parcel);
                    continue block37;
                }
                case 9: {
                    Object object11 = (FailureParcel)parcel;
                    throw ErrorFactory.makeDatabaseSQLException(((ErrorParcel)object11).getMsg(), ((ErrorParcel)object11).getCode());
                }
                case 12: {
                    EndRequestParcel endRequestParcel = (EndRequestParcel)parcel;
                    continue block37;
                }
                case 49: {
                    ErrorParcel errorParcel = (ErrorParcel)parcel;
                    throw ErrorFactory.makeDatabaseSQLException(errorParcel.getMsg(), errorParcel.getCode());
                }
            }
            break;
        }
        throw ErrorFactory.makeDriverJDBCException("TJ305", Integer.toString(parcel.getFlavor()));
    }

    public static class Reconnect {
        public long nAuthenticationNonce;
        public int nRequestNumber;
    }
}

