/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.dialogs;

import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.impl.sql.BasicSQLDialect;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.dbeaver.ui.editors.StringEditorInput;
import org.jkiss.dbeaver.ui.editors.SubEditorSite;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorBase;
import org.jkiss.dbeaver.ui.editors.sql.internal.SQLEditorMessages;
import org.jkiss.dbeaver.utils.GeneralUtils;

public abstract class BaseSQLDialog
extends BaseDialog {
    private static final Log log = Log.getLog(BaseSQLDialog.class);
    private IEditorSite subSite;
    private SQLEditorBase sqlViewer;
    private StringEditorInput sqlInput;

    public BaseSQLDialog(IWorkbenchPartSite parentSite, String title, @Nullable DBPImage image) {
        this(parentSite.getShell(), parentSite, title, image);
    }

    public BaseSQLDialog(Shell shell, IWorkbenchPartSite parentSite, String title, @Nullable DBPImage image) {
        super(shell, title, image);
        this.subSite = new SubEditorSite(parentSite);
        this.sqlInput = new StringEditorInput(title, (CharSequence)"", true, GeneralUtils.getDefaultFileEncoding());
    }

    public boolean isReadOnly() {
        return this.sqlInput.isReadOnly();
    }

    public void setReadOnly(boolean readOnly) {
        this.sqlInput.setReadOnly(readOnly);
    }

    public String getText() {
        return this.sqlInput.getBuffer().toString();
    }

    protected boolean isWordWrap() {
        return false;
    }

    protected boolean isLabelVisible() {
        return true;
    }

    protected Composite createSQLPanel(Composite parent) {
        Control text;
        Composite panel = UIUtils.createPlaceholder((Composite)parent, (int)1);
        panel.setLayoutData((Object)new GridData(1808));
        if (this.isLabelVisible()) {
            UIUtils.createControlLabel((Composite)panel, (String)SQLEditorMessages.pref_page_sql_format_label_SQLPreview);
        }
        Composite editorPH = new Composite(panel, 2048);
        GridData gd = new GridData(1808);
        gd.verticalIndent = 3;
        gd.horizontalSpan = 1;
        gd.minimumHeight = 100;
        gd.minimumWidth = 100;
        editorPH.setLayoutData((Object)gd);
        editorPH.setLayout((Layout)new FillLayout());
        this.sqlViewer = new SQLEditorBase(){

            @Override
            @NotNull
            public SQLDialect getSQLDialect() {
                return BaseSQLDialog.this.getSQLDialect();
            }

            public DBCExecutionContext getExecutionContext() {
                return BaseSQLDialog.this.getExecutionContext();
            }
        };
        this.updateSQL();
        this.sqlViewer.createPartControl(editorPH);
        if (this.isWordWrap() && (text = this.sqlViewer.getAdapter(Control.class)) instanceof StyledText) {
            ((StyledText)text).setWordWrap(true);
        }
        this.sqlViewer.reloadSyntaxRules();
        UIUtils.asyncExec(() -> ((Composite)editorPH).layout());
        return panel;
    }

    protected SQLDialect getSQLDialect() {
        DBCExecutionContext executionContext = this.getExecutionContext();
        if (executionContext != null) {
            return executionContext.getDataSource().getSQLDialect();
        }
        return BasicSQLDialect.INSTANCE;
    }

    protected abstract DBCExecutionContext getExecutionContext();

    protected abstract String getSQLText();

    protected void createCopyButton(Composite parent) {
        this.createButton(parent, 13, SQLEditorMessages.dialog_view_sql_button_copy, false);
    }

    protected void saveToClipboard() {
        String text = this.getSQLText();
        UIUtils.setClipboardContents((Display)this.getShell().getDisplay(), (Transfer)TextTransfer.getInstance(), (Object)text);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 13) {
            this.saveToClipboard();
            super.buttonPressed(1);
        } else {
            super.buttonPressed(buttonId);
        }
    }

    protected void okPressed() {
        if (this.sqlViewer != null && this.sqlViewer.getTextViewer() != null && this.sqlViewer.getTextViewer().getDocument() != null) {
            this.sqlInput.setText(this.sqlViewer.getTextViewer().getDocument().get());
        }
        super.okPressed();
    }

    public boolean close() {
        if (this.sqlViewer != null) {
            try {
                this.sqlViewer.dispose();
            }
            catch (Exception e) {
                log.debug((Object)"Error disposing embedded SQL editor", (Throwable)e);
            }
        }
        return super.close();
    }

    protected void updateSQL() {
        try {
            this.sqlInput.setText(this.getSQLText());
            if (this.sqlViewer.getSite() != null) {
                this.sqlViewer.setInput((IEditorInput)this.sqlInput);
            } else {
                this.sqlViewer.init(this.subSite, (IEditorInput)this.sqlInput);
            }
            this.sqlViewer.reloadSyntaxRules();
        }
        catch (PartInitException e) {
            DBWorkbench.getPlatformUI().showError(this.getShell().getText(), null, (Throwable)e);
        }
    }
}

