/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.iam.v1;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.iam.v1.IamRequest;
import com.google.api.services.iam.v1.IamRequestInitializer;
import com.google.api.services.iam.v1.model.CreateRoleRequest;
import com.google.api.services.iam.v1.model.CreateServiceAccountKeyRequest;
import com.google.api.services.iam.v1.model.CreateServiceAccountRequest;
import com.google.api.services.iam.v1.model.DisableServiceAccountRequest;
import com.google.api.services.iam.v1.model.Empty;
import com.google.api.services.iam.v1.model.EnableServiceAccountRequest;
import com.google.api.services.iam.v1.model.LintPolicyRequest;
import com.google.api.services.iam.v1.model.LintPolicyResponse;
import com.google.api.services.iam.v1.model.ListRolesResponse;
import com.google.api.services.iam.v1.model.ListServiceAccountKeysResponse;
import com.google.api.services.iam.v1.model.ListServiceAccountsResponse;
import com.google.api.services.iam.v1.model.PatchServiceAccountRequest;
import com.google.api.services.iam.v1.model.Policy;
import com.google.api.services.iam.v1.model.QueryAuditableServicesRequest;
import com.google.api.services.iam.v1.model.QueryAuditableServicesResponse;
import com.google.api.services.iam.v1.model.QueryGrantableRolesRequest;
import com.google.api.services.iam.v1.model.QueryGrantableRolesResponse;
import com.google.api.services.iam.v1.model.QueryTestablePermissionsRequest;
import com.google.api.services.iam.v1.model.QueryTestablePermissionsResponse;
import com.google.api.services.iam.v1.model.Role;
import com.google.api.services.iam.v1.model.ServiceAccount;
import com.google.api.services.iam.v1.model.ServiceAccountKey;
import com.google.api.services.iam.v1.model.SetIamPolicyRequest;
import com.google.api.services.iam.v1.model.SignBlobRequest;
import com.google.api.services.iam.v1.model.SignBlobResponse;
import com.google.api.services.iam.v1.model.SignJwtRequest;
import com.google.api.services.iam.v1.model.SignJwtResponse;
import com.google.api.services.iam.v1.model.TestIamPermissionsRequest;
import com.google.api.services.iam.v1.model.TestIamPermissionsResponse;
import com.google.api.services.iam.v1.model.UndeleteRoleRequest;
import com.google.api.services.iam.v1.model.UndeleteServiceAccountRequest;
import com.google.api.services.iam.v1.model.UndeleteServiceAccountResponse;
import com.google.api.services.iam.v1.model.UploadServiceAccountKeyRequest;
import java.io.IOException;
import java.util.List;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Iam
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://iam.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://iam.googleapis.com/";

    public Iam(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(httpTransport, jsonFactory, httpRequestInitializer));
    }

    Iam(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> abstractGoogleClientRequest) throws IOException {
        super.initialize(abstractGoogleClientRequest);
    }

    public IamPolicies iamPolicies() {
        return new IamPolicies();
    }

    public Organizations organizations() {
        return new Organizations();
    }

    public Permissions permissions() {
        return new Permissions();
    }

    public Projects projects() {
        return new Projects();
    }

    public Roles roles() {
        return new Roles();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && GoogleUtils.MINOR_VERSION >= 15 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.15 of google-api-client to run version 1.25.0 of the Identity and Access Management (IAM) API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        public Builder(HttpTransport httpTransport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(httpTransport, jsonFactory, "https://iam.googleapis.com/", Iam.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(Iam.DEFAULT_BATCH_PATH);
        }

        public Iam build() {
            return new Iam(this);
        }

        public Builder setRootUrl(String string) {
            return (Builder)super.setRootUrl(string);
        }

        public Builder setServicePath(String string) {
            return (Builder)super.setServicePath(string);
        }

        public Builder setBatchPath(String string) {
            return (Builder)super.setBatchPath(string);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String string) {
            return (Builder)super.setApplicationName(string);
        }

        public Builder setSuppressPatternChecks(boolean bl) {
            return (Builder)super.setSuppressPatternChecks(bl);
        }

        public Builder setSuppressRequiredParameterChecks(boolean bl) {
            return (Builder)super.setSuppressRequiredParameterChecks(bl);
        }

        public Builder setSuppressAllChecks(boolean bl) {
            return (Builder)super.setSuppressAllChecks(bl);
        }

        public Builder setIamRequestInitializer(IamRequestInitializer iamRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)iamRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Roles {
        public Get get(String string) throws IOException {
            Get get = new Get(string);
            Iam.this.initialize((AbstractGoogleClientRequest<?>)get);
            return get;
        }

        public List list() throws IOException {
            List list = new List();
            Iam.this.initialize((AbstractGoogleClientRequest<?>)list);
            return list;
        }

        public QueryGrantableRoles queryGrantableRoles(QueryGrantableRolesRequest queryGrantableRolesRequest) throws IOException {
            QueryGrantableRoles queryGrantableRoles = new QueryGrantableRoles(queryGrantableRolesRequest);
            Iam.this.initialize((AbstractGoogleClientRequest<?>)queryGrantableRoles);
            return queryGrantableRoles;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class QueryGrantableRoles
        extends IamRequest<QueryGrantableRolesResponse> {
            private static final String REST_PATH = "v1/roles:queryGrantableRoles";

            protected QueryGrantableRoles(QueryGrantableRolesRequest queryGrantableRolesRequest) {
                super(Iam.this, "POST", REST_PATH, (Object)queryGrantableRolesRequest, QueryGrantableRolesResponse.class);
            }

            public QueryGrantableRoles set$Xgafv(String string) {
                return (QueryGrantableRoles)super.set$Xgafv(string);
            }

            public QueryGrantableRoles setAccessToken(String string) {
                return (QueryGrantableRoles)super.setAccessToken(string);
            }

            public QueryGrantableRoles setAlt(String string) {
                return (QueryGrantableRoles)super.setAlt(string);
            }

            public QueryGrantableRoles setCallback(String string) {
                return (QueryGrantableRoles)super.setCallback(string);
            }

            public QueryGrantableRoles setFields(String string) {
                return (QueryGrantableRoles)super.setFields(string);
            }

            public QueryGrantableRoles setKey(String string) {
                return (QueryGrantableRoles)super.setKey(string);
            }

            public QueryGrantableRoles setOauthToken(String string) {
                return (QueryGrantableRoles)super.setOauthToken(string);
            }

            public QueryGrantableRoles setPrettyPrint(Boolean bl) {
                return (QueryGrantableRoles)super.setPrettyPrint(bl);
            }

            public QueryGrantableRoles setQuotaUser(String string) {
                return (QueryGrantableRoles)super.setQuotaUser(string);
            }

            public QueryGrantableRoles setUploadType(String string) {
                return (QueryGrantableRoles)super.setUploadType(string);
            }

            public QueryGrantableRoles setUploadProtocol(String string) {
                return (QueryGrantableRoles)super.setUploadProtocol(string);
            }

            @Override
            public QueryGrantableRoles set(String string, Object object) {
                return (QueryGrantableRoles)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class List
        extends IamRequest<ListRolesResponse> {
            private static final String REST_PATH = "v1/roles";
            @Key
            private String view;
            @Key
            private String parent;
            @Key
            private Boolean showDeleted;
            @Key
            private String pageToken;
            @Key
            private Integer pageSize;

            protected List() {
                super(Iam.this, "GET", REST_PATH, null, ListRolesResponse.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String string) {
                return (List)super.set$Xgafv(string);
            }

            public List setAccessToken(String string) {
                return (List)super.setAccessToken(string);
            }

            public List setAlt(String string) {
                return (List)super.setAlt(string);
            }

            public List setCallback(String string) {
                return (List)super.setCallback(string);
            }

            public List setFields(String string) {
                return (List)super.setFields(string);
            }

            public List setKey(String string) {
                return (List)super.setKey(string);
            }

            public List setOauthToken(String string) {
                return (List)super.setOauthToken(string);
            }

            public List setPrettyPrint(Boolean bl) {
                return (List)super.setPrettyPrint(bl);
            }

            public List setQuotaUser(String string) {
                return (List)super.setQuotaUser(string);
            }

            public List setUploadType(String string) {
                return (List)super.setUploadType(string);
            }

            public List setUploadProtocol(String string) {
                return (List)super.setUploadProtocol(string);
            }

            public String getView() {
                return this.view;
            }

            public List setView(String string) {
                this.view = string;
                return this;
            }

            public String getParent() {
                return this.parent;
            }

            public List setParent(String string) {
                this.parent = string;
                return this;
            }

            public Boolean getShowDeleted() {
                return this.showDeleted;
            }

            public List setShowDeleted(Boolean bl) {
                this.showDeleted = bl;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String string) {
                this.pageToken = string;
                return this;
            }

            public Integer getPageSize() {
                return this.pageSize;
            }

            public List setPageSize(Integer n) {
                this.pageSize = n;
                return this;
            }

            @Override
            public List set(String string, Object object) {
                return (List)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class Get
        extends IamRequest<Role> {
            private static final String REST_PATH = "v1/{+name}";
            private final Pattern NAME_PATTERN;
            @Key
            private String name;

            protected Get(String string) {
                super(Iam.this, "GET", REST_PATH, null, Role.class);
                this.NAME_PATTERN = Pattern.compile("^roles/[^/]+$");
                this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                if (!Iam.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^roles/[^/]+$");
                }
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String string) {
                return (Get)super.set$Xgafv(string);
            }

            public Get setAccessToken(String string) {
                return (Get)super.setAccessToken(string);
            }

            public Get setAlt(String string) {
                return (Get)super.setAlt(string);
            }

            public Get setCallback(String string) {
                return (Get)super.setCallback(string);
            }

            public Get setFields(String string) {
                return (Get)super.setFields(string);
            }

            public Get setKey(String string) {
                return (Get)super.setKey(string);
            }

            public Get setOauthToken(String string) {
                return (Get)super.setOauthToken(string);
            }

            public Get setPrettyPrint(Boolean bl) {
                return (Get)super.setPrettyPrint(bl);
            }

            public Get setQuotaUser(String string) {
                return (Get)super.setQuotaUser(string);
            }

            public Get setUploadType(String string) {
                return (Get)super.setUploadType(string);
            }

            public Get setUploadProtocol(String string) {
                return (Get)super.setUploadProtocol(string);
            }

            public String getName() {
                return this.name;
            }

            public Get setName(String string) {
                if (!Iam.this.getSuppressPatternChecks()) {
                    Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^roles/[^/]+$");
                }
                this.name = string;
                return this;
            }

            @Override
            public Get set(String string, Object object) {
                return (Get)super.set(string, object);
            }
        }
    }

    public class Projects {
        public Roles roles() {
            return new Roles();
        }

        public ServiceAccounts serviceAccounts() {
            return new ServiceAccounts();
        }

        public class ServiceAccounts {
            public Create create(String string, CreateServiceAccountRequest createServiceAccountRequest) throws IOException {
                Create create = new Create(string, createServiceAccountRequest);
                Iam.this.initialize((AbstractGoogleClientRequest<?>)create);
                return create;
            }

            public Delete delete(String string) throws IOException {
                Delete delete = new Delete(string);
                Iam.this.initialize((AbstractGoogleClientRequest<?>)delete);
                return delete;
            }

            public Disable disable(String string, DisableServiceAccountRequest disableServiceAccountRequest) throws IOException {
                Disable disable = new Disable(string, disableServiceAccountRequest);
                Iam.this.initialize((AbstractGoogleClientRequest<?>)disable);
                return disable;
            }

            public Enable enable(String string, EnableServiceAccountRequest enableServiceAccountRequest) throws IOException {
                Enable enable = new Enable(string, enableServiceAccountRequest);
                Iam.this.initialize((AbstractGoogleClientRequest<?>)enable);
                return enable;
            }

            public Get get(String string) throws IOException {
                Get get = new Get(string);
                Iam.this.initialize((AbstractGoogleClientRequest<?>)get);
                return get;
            }

            public GetIamPolicy getIamPolicy(String string) throws IOException {
                GetIamPolicy getIamPolicy = new GetIamPolicy(string);
                Iam.this.initialize((AbstractGoogleClientRequest<?>)getIamPolicy);
                return getIamPolicy;
            }

            public List list(String string) throws IOException {
                List list = new List(string);
                Iam.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            public Patch patch(String string, PatchServiceAccountRequest patchServiceAccountRequest) throws IOException {
                Patch patch = new Patch(string, patchServiceAccountRequest);
                Iam.this.initialize((AbstractGoogleClientRequest<?>)patch);
                return patch;
            }

            public SetIamPolicy setIamPolicy(String string, SetIamPolicyRequest setIamPolicyRequest) throws IOException {
                SetIamPolicy setIamPolicy = new SetIamPolicy(string, setIamPolicyRequest);
                Iam.this.initialize((AbstractGoogleClientRequest<?>)setIamPolicy);
                return setIamPolicy;
            }

            public SignBlob signBlob(String string, SignBlobRequest signBlobRequest) throws IOException {
                SignBlob signBlob = new SignBlob(string, signBlobRequest);
                Iam.this.initialize((AbstractGoogleClientRequest<?>)signBlob);
                return signBlob;
            }

            public SignJwt signJwt(String string, SignJwtRequest signJwtRequest) throws IOException {
                SignJwt signJwt = new SignJwt(string, signJwtRequest);
                Iam.this.initialize((AbstractGoogleClientRequest<?>)signJwt);
                return signJwt;
            }

            public TestIamPermissions testIamPermissions(String string, TestIamPermissionsRequest testIamPermissionsRequest) throws IOException {
                TestIamPermissions testIamPermissions = new TestIamPermissions(string, testIamPermissionsRequest);
                Iam.this.initialize((AbstractGoogleClientRequest<?>)testIamPermissions);
                return testIamPermissions;
            }

            public Undelete undelete(String string, UndeleteServiceAccountRequest undeleteServiceAccountRequest) throws IOException {
                Undelete undelete = new Undelete(string, undeleteServiceAccountRequest);
                Iam.this.initialize((AbstractGoogleClientRequest<?>)undelete);
                return undelete;
            }

            public Update update(String string, ServiceAccount serviceAccount) throws IOException {
                Update update = new Update(string, serviceAccount);
                Iam.this.initialize((AbstractGoogleClientRequest<?>)update);
                return update;
            }

            public Keys keys() {
                return new Keys();
            }

            public class Keys {
                public Create create(String string, CreateServiceAccountKeyRequest createServiceAccountKeyRequest) throws IOException {
                    Create create = new Create(string, createServiceAccountKeyRequest);
                    Iam.this.initialize((AbstractGoogleClientRequest<?>)create);
                    return create;
                }

                public Delete delete(String string) throws IOException {
                    Delete delete = new Delete(string);
                    Iam.this.initialize((AbstractGoogleClientRequest<?>)delete);
                    return delete;
                }

                public Get get(String string) throws IOException {
                    Get get = new Get(string);
                    Iam.this.initialize((AbstractGoogleClientRequest<?>)get);
                    return get;
                }

                public List list(String string) throws IOException {
                    List list = new List(string);
                    Iam.this.initialize((AbstractGoogleClientRequest<?>)list);
                    return list;
                }

                public Upload upload(String string, UploadServiceAccountKeyRequest uploadServiceAccountKeyRequest) throws IOException {
                    Upload upload = new Upload(string, uploadServiceAccountKeyRequest);
                    Iam.this.initialize((AbstractGoogleClientRequest<?>)upload);
                    return upload;
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Upload
                extends IamRequest<ServiceAccountKey> {
                    private static final String REST_PATH = "v1/{+name}/keys:upload";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Upload(String string, UploadServiceAccountKeyRequest uploadServiceAccountKeyRequest) {
                        super(Iam.this, "POST", REST_PATH, (Object)uploadServiceAccountKeyRequest, ServiceAccountKey.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/serviceAccounts/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                        if (!Iam.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+$");
                        }
                    }

                    public Upload set$Xgafv(String string) {
                        return (Upload)super.set$Xgafv(string);
                    }

                    public Upload setAccessToken(String string) {
                        return (Upload)super.setAccessToken(string);
                    }

                    public Upload setAlt(String string) {
                        return (Upload)super.setAlt(string);
                    }

                    public Upload setCallback(String string) {
                        return (Upload)super.setCallback(string);
                    }

                    public Upload setFields(String string) {
                        return (Upload)super.setFields(string);
                    }

                    public Upload setKey(String string) {
                        return (Upload)super.setKey(string);
                    }

                    public Upload setOauthToken(String string) {
                        return (Upload)super.setOauthToken(string);
                    }

                    public Upload setPrettyPrint(Boolean bl) {
                        return (Upload)super.setPrettyPrint(bl);
                    }

                    public Upload setQuotaUser(String string) {
                        return (Upload)super.setQuotaUser(string);
                    }

                    public Upload setUploadType(String string) {
                        return (Upload)super.setUploadType(string);
                    }

                    public Upload setUploadProtocol(String string) {
                        return (Upload)super.setUploadProtocol(string);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Upload setName(String string) {
                        if (!Iam.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+$");
                        }
                        this.name = string;
                        return this;
                    }

                    @Override
                    public Upload set(String string, Object object) {
                        return (Upload)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class List
                extends IamRequest<ListServiceAccountKeysResponse> {
                    private static final String REST_PATH = "v1/{+name}/keys";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;
                    @Key
                    private java.util.List<String> keyTypes;

                    protected List(String string) {
                        super(Iam.this, "GET", REST_PATH, null, ListServiceAccountKeysResponse.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/serviceAccounts/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                        if (!Iam.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String string) {
                        return (List)super.set$Xgafv(string);
                    }

                    public List setAccessToken(String string) {
                        return (List)super.setAccessToken(string);
                    }

                    public List setAlt(String string) {
                        return (List)super.setAlt(string);
                    }

                    public List setCallback(String string) {
                        return (List)super.setCallback(string);
                    }

                    public List setFields(String string) {
                        return (List)super.setFields(string);
                    }

                    public List setKey(String string) {
                        return (List)super.setKey(string);
                    }

                    public List setOauthToken(String string) {
                        return (List)super.setOauthToken(string);
                    }

                    public List setPrettyPrint(Boolean bl) {
                        return (List)super.setPrettyPrint(bl);
                    }

                    public List setQuotaUser(String string) {
                        return (List)super.setQuotaUser(string);
                    }

                    public List setUploadType(String string) {
                        return (List)super.setUploadType(string);
                    }

                    public List setUploadProtocol(String string) {
                        return (List)super.setUploadProtocol(string);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public List setName(String string) {
                        if (!Iam.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+$");
                        }
                        this.name = string;
                        return this;
                    }

                    public java.util.List<String> getKeyTypes() {
                        return this.keyTypes;
                    }

                    public List setKeyTypes(java.util.List<String> list) {
                        this.keyTypes = list;
                        return this;
                    }

                    @Override
                    public List set(String string, Object object) {
                        return (List)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Get
                extends IamRequest<ServiceAccountKey> {
                    private static final String REST_PATH = "v1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;
                    @Key
                    private String publicKeyType;

                    protected Get(String string) {
                        super(Iam.this, "GET", REST_PATH, null, ServiceAccountKey.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/serviceAccounts/[^/]+/keys/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                        if (!Iam.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+/keys/[^/]+$");
                        }
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String string) {
                        return (Get)super.set$Xgafv(string);
                    }

                    public Get setAccessToken(String string) {
                        return (Get)super.setAccessToken(string);
                    }

                    public Get setAlt(String string) {
                        return (Get)super.setAlt(string);
                    }

                    public Get setCallback(String string) {
                        return (Get)super.setCallback(string);
                    }

                    public Get setFields(String string) {
                        return (Get)super.setFields(string);
                    }

                    public Get setKey(String string) {
                        return (Get)super.setKey(string);
                    }

                    public Get setOauthToken(String string) {
                        return (Get)super.setOauthToken(string);
                    }

                    public Get setPrettyPrint(Boolean bl) {
                        return (Get)super.setPrettyPrint(bl);
                    }

                    public Get setQuotaUser(String string) {
                        return (Get)super.setQuotaUser(string);
                    }

                    public Get setUploadType(String string) {
                        return (Get)super.setUploadType(string);
                    }

                    public Get setUploadProtocol(String string) {
                        return (Get)super.setUploadProtocol(string);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Get setName(String string) {
                        if (!Iam.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+/keys/[^/]+$");
                        }
                        this.name = string;
                        return this;
                    }

                    public String getPublicKeyType() {
                        return this.publicKeyType;
                    }

                    public Get setPublicKeyType(String string) {
                        this.publicKeyType = string;
                        return this;
                    }

                    @Override
                    public Get set(String string, Object object) {
                        return (Get)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Delete
                extends IamRequest<Empty> {
                    private static final String REST_PATH = "v1/{+name}";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Delete(String string) {
                        super(Iam.this, "DELETE", REST_PATH, null, Empty.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/serviceAccounts/[^/]+/keys/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                        if (!Iam.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+/keys/[^/]+$");
                        }
                    }

                    public Delete set$Xgafv(String string) {
                        return (Delete)super.set$Xgafv(string);
                    }

                    public Delete setAccessToken(String string) {
                        return (Delete)super.setAccessToken(string);
                    }

                    public Delete setAlt(String string) {
                        return (Delete)super.setAlt(string);
                    }

                    public Delete setCallback(String string) {
                        return (Delete)super.setCallback(string);
                    }

                    public Delete setFields(String string) {
                        return (Delete)super.setFields(string);
                    }

                    public Delete setKey(String string) {
                        return (Delete)super.setKey(string);
                    }

                    public Delete setOauthToken(String string) {
                        return (Delete)super.setOauthToken(string);
                    }

                    public Delete setPrettyPrint(Boolean bl) {
                        return (Delete)super.setPrettyPrint(bl);
                    }

                    public Delete setQuotaUser(String string) {
                        return (Delete)super.setQuotaUser(string);
                    }

                    public Delete setUploadType(String string) {
                        return (Delete)super.setUploadType(string);
                    }

                    public Delete setUploadProtocol(String string) {
                        return (Delete)super.setUploadProtocol(string);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Delete setName(String string) {
                        if (!Iam.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+/keys/[^/]+$");
                        }
                        this.name = string;
                        return this;
                    }

                    @Override
                    public Delete set(String string, Object object) {
                        return (Delete)super.set(string, object);
                    }
                }

                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                public class Create
                extends IamRequest<ServiceAccountKey> {
                    private static final String REST_PATH = "v1/{+name}/keys";
                    private final Pattern NAME_PATTERN;
                    @Key
                    private String name;

                    protected Create(String string, CreateServiceAccountKeyRequest createServiceAccountKeyRequest) {
                        super(Iam.this, "POST", REST_PATH, (Object)createServiceAccountKeyRequest, ServiceAccountKey.class);
                        this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/serviceAccounts/[^/]+$");
                        this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                        if (!Iam.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+$");
                        }
                    }

                    public Create set$Xgafv(String string) {
                        return (Create)super.set$Xgafv(string);
                    }

                    public Create setAccessToken(String string) {
                        return (Create)super.setAccessToken(string);
                    }

                    public Create setAlt(String string) {
                        return (Create)super.setAlt(string);
                    }

                    public Create setCallback(String string) {
                        return (Create)super.setCallback(string);
                    }

                    public Create setFields(String string) {
                        return (Create)super.setFields(string);
                    }

                    public Create setKey(String string) {
                        return (Create)super.setKey(string);
                    }

                    public Create setOauthToken(String string) {
                        return (Create)super.setOauthToken(string);
                    }

                    public Create setPrettyPrint(Boolean bl) {
                        return (Create)super.setPrettyPrint(bl);
                    }

                    public Create setQuotaUser(String string) {
                        return (Create)super.setQuotaUser(string);
                    }

                    public Create setUploadType(String string) {
                        return (Create)super.setUploadType(string);
                    }

                    public Create setUploadProtocol(String string) {
                        return (Create)super.setUploadProtocol(string);
                    }

                    public String getName() {
                        return this.name;
                    }

                    public Create setName(String string) {
                        if (!Iam.this.getSuppressPatternChecks()) {
                            Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+$");
                        }
                        this.name = string;
                        return this;
                    }

                    @Override
                    public Create set(String string, Object object) {
                        return (Create)super.set(string, object);
                    }
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Update
            extends IamRequest<ServiceAccount> {
                private static final String REST_PATH = "v1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Update(String string, ServiceAccount serviceAccount) {
                    super(Iam.this, "PUT", REST_PATH, (Object)serviceAccount, ServiceAccount.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/serviceAccounts/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+$");
                    }
                }

                public Update set$Xgafv(String string) {
                    return (Update)super.set$Xgafv(string);
                }

                public Update setAccessToken(String string) {
                    return (Update)super.setAccessToken(string);
                }

                public Update setAlt(String string) {
                    return (Update)super.setAlt(string);
                }

                public Update setCallback(String string) {
                    return (Update)super.setCallback(string);
                }

                public Update setFields(String string) {
                    return (Update)super.setFields(string);
                }

                public Update setKey(String string) {
                    return (Update)super.setKey(string);
                }

                public Update setOauthToken(String string) {
                    return (Update)super.setOauthToken(string);
                }

                public Update setPrettyPrint(Boolean bl) {
                    return (Update)super.setPrettyPrint(bl);
                }

                public Update setQuotaUser(String string) {
                    return (Update)super.setQuotaUser(string);
                }

                public Update setUploadType(String string) {
                    return (Update)super.setUploadType(string);
                }

                public Update setUploadProtocol(String string) {
                    return (Update)super.setUploadProtocol(string);
                }

                public String getName() {
                    return this.name;
                }

                public Update setName(String string) {
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+$");
                    }
                    this.name = string;
                    return this;
                }

                @Override
                public Update set(String string, Object object) {
                    return (Update)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Undelete
            extends IamRequest<UndeleteServiceAccountResponse> {
                private static final String REST_PATH = "v1/{+name}:undelete";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Undelete(String string, UndeleteServiceAccountRequest undeleteServiceAccountRequest) {
                    super(Iam.this, "POST", REST_PATH, (Object)undeleteServiceAccountRequest, UndeleteServiceAccountResponse.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/serviceAccounts/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+$");
                    }
                }

                public Undelete set$Xgafv(String string) {
                    return (Undelete)super.set$Xgafv(string);
                }

                public Undelete setAccessToken(String string) {
                    return (Undelete)super.setAccessToken(string);
                }

                public Undelete setAlt(String string) {
                    return (Undelete)super.setAlt(string);
                }

                public Undelete setCallback(String string) {
                    return (Undelete)super.setCallback(string);
                }

                public Undelete setFields(String string) {
                    return (Undelete)super.setFields(string);
                }

                public Undelete setKey(String string) {
                    return (Undelete)super.setKey(string);
                }

                public Undelete setOauthToken(String string) {
                    return (Undelete)super.setOauthToken(string);
                }

                public Undelete setPrettyPrint(Boolean bl) {
                    return (Undelete)super.setPrettyPrint(bl);
                }

                public Undelete setQuotaUser(String string) {
                    return (Undelete)super.setQuotaUser(string);
                }

                public Undelete setUploadType(String string) {
                    return (Undelete)super.setUploadType(string);
                }

                public Undelete setUploadProtocol(String string) {
                    return (Undelete)super.setUploadProtocol(string);
                }

                public String getName() {
                    return this.name;
                }

                public Undelete setName(String string) {
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+$");
                    }
                    this.name = string;
                    return this;
                }

                @Override
                public Undelete set(String string, Object object) {
                    return (Undelete)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class TestIamPermissions
            extends IamRequest<TestIamPermissionsResponse> {
                private static final String REST_PATH = "v1/{+resource}:testIamPermissions";
                private final Pattern RESOURCE_PATTERN;
                @Key
                private String resource;

                protected TestIamPermissions(String string, TestIamPermissionsRequest testIamPermissionsRequest) {
                    super(Iam.this, "POST", REST_PATH, (Object)testIamPermissionsRequest, TestIamPermissionsResponse.class);
                    this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/serviceAccounts/[^/]+$");
                    this.resource = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter resource must be specified.");
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+$");
                    }
                }

                public TestIamPermissions set$Xgafv(String string) {
                    return (TestIamPermissions)super.set$Xgafv(string);
                }

                public TestIamPermissions setAccessToken(String string) {
                    return (TestIamPermissions)super.setAccessToken(string);
                }

                public TestIamPermissions setAlt(String string) {
                    return (TestIamPermissions)super.setAlt(string);
                }

                public TestIamPermissions setCallback(String string) {
                    return (TestIamPermissions)super.setCallback(string);
                }

                public TestIamPermissions setFields(String string) {
                    return (TestIamPermissions)super.setFields(string);
                }

                public TestIamPermissions setKey(String string) {
                    return (TestIamPermissions)super.setKey(string);
                }

                public TestIamPermissions setOauthToken(String string) {
                    return (TestIamPermissions)super.setOauthToken(string);
                }

                public TestIamPermissions setPrettyPrint(Boolean bl) {
                    return (TestIamPermissions)super.setPrettyPrint(bl);
                }

                public TestIamPermissions setQuotaUser(String string) {
                    return (TestIamPermissions)super.setQuotaUser(string);
                }

                public TestIamPermissions setUploadType(String string) {
                    return (TestIamPermissions)super.setUploadType(string);
                }

                public TestIamPermissions setUploadProtocol(String string) {
                    return (TestIamPermissions)super.setUploadProtocol(string);
                }

                public String getResource() {
                    return this.resource;
                }

                public TestIamPermissions setResource(String string) {
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+$");
                    }
                    this.resource = string;
                    return this;
                }

                @Override
                public TestIamPermissions set(String string, Object object) {
                    return (TestIamPermissions)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class SignJwt
            extends IamRequest<SignJwtResponse> {
                private static final String REST_PATH = "v1/{+name}:signJwt";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected SignJwt(String string, SignJwtRequest signJwtRequest) {
                    super(Iam.this, "POST", REST_PATH, (Object)signJwtRequest, SignJwtResponse.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/serviceAccounts/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+$");
                    }
                }

                public SignJwt set$Xgafv(String string) {
                    return (SignJwt)super.set$Xgafv(string);
                }

                public SignJwt setAccessToken(String string) {
                    return (SignJwt)super.setAccessToken(string);
                }

                public SignJwt setAlt(String string) {
                    return (SignJwt)super.setAlt(string);
                }

                public SignJwt setCallback(String string) {
                    return (SignJwt)super.setCallback(string);
                }

                public SignJwt setFields(String string) {
                    return (SignJwt)super.setFields(string);
                }

                public SignJwt setKey(String string) {
                    return (SignJwt)super.setKey(string);
                }

                public SignJwt setOauthToken(String string) {
                    return (SignJwt)super.setOauthToken(string);
                }

                public SignJwt setPrettyPrint(Boolean bl) {
                    return (SignJwt)super.setPrettyPrint(bl);
                }

                public SignJwt setQuotaUser(String string) {
                    return (SignJwt)super.setQuotaUser(string);
                }

                public SignJwt setUploadType(String string) {
                    return (SignJwt)super.setUploadType(string);
                }

                public SignJwt setUploadProtocol(String string) {
                    return (SignJwt)super.setUploadProtocol(string);
                }

                public String getName() {
                    return this.name;
                }

                public SignJwt setName(String string) {
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+$");
                    }
                    this.name = string;
                    return this;
                }

                @Override
                public SignJwt set(String string, Object object) {
                    return (SignJwt)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class SignBlob
            extends IamRequest<SignBlobResponse> {
                private static final String REST_PATH = "v1/{+name}:signBlob";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected SignBlob(String string, SignBlobRequest signBlobRequest) {
                    super(Iam.this, "POST", REST_PATH, (Object)signBlobRequest, SignBlobResponse.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/serviceAccounts/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+$");
                    }
                }

                public SignBlob set$Xgafv(String string) {
                    return (SignBlob)super.set$Xgafv(string);
                }

                public SignBlob setAccessToken(String string) {
                    return (SignBlob)super.setAccessToken(string);
                }

                public SignBlob setAlt(String string) {
                    return (SignBlob)super.setAlt(string);
                }

                public SignBlob setCallback(String string) {
                    return (SignBlob)super.setCallback(string);
                }

                public SignBlob setFields(String string) {
                    return (SignBlob)super.setFields(string);
                }

                public SignBlob setKey(String string) {
                    return (SignBlob)super.setKey(string);
                }

                public SignBlob setOauthToken(String string) {
                    return (SignBlob)super.setOauthToken(string);
                }

                public SignBlob setPrettyPrint(Boolean bl) {
                    return (SignBlob)super.setPrettyPrint(bl);
                }

                public SignBlob setQuotaUser(String string) {
                    return (SignBlob)super.setQuotaUser(string);
                }

                public SignBlob setUploadType(String string) {
                    return (SignBlob)super.setUploadType(string);
                }

                public SignBlob setUploadProtocol(String string) {
                    return (SignBlob)super.setUploadProtocol(string);
                }

                public String getName() {
                    return this.name;
                }

                public SignBlob setName(String string) {
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+$");
                    }
                    this.name = string;
                    return this;
                }

                @Override
                public SignBlob set(String string, Object object) {
                    return (SignBlob)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class SetIamPolicy
            extends IamRequest<Policy> {
                private static final String REST_PATH = "v1/{+resource}:setIamPolicy";
                private final Pattern RESOURCE_PATTERN;
                @Key
                private String resource;

                protected SetIamPolicy(String string, SetIamPolicyRequest setIamPolicyRequest) {
                    super(Iam.this, "POST", REST_PATH, (Object)setIamPolicyRequest, Policy.class);
                    this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/serviceAccounts/[^/]+$");
                    this.resource = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter resource must be specified.");
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+$");
                    }
                }

                public SetIamPolicy set$Xgafv(String string) {
                    return (SetIamPolicy)super.set$Xgafv(string);
                }

                public SetIamPolicy setAccessToken(String string) {
                    return (SetIamPolicy)super.setAccessToken(string);
                }

                public SetIamPolicy setAlt(String string) {
                    return (SetIamPolicy)super.setAlt(string);
                }

                public SetIamPolicy setCallback(String string) {
                    return (SetIamPolicy)super.setCallback(string);
                }

                public SetIamPolicy setFields(String string) {
                    return (SetIamPolicy)super.setFields(string);
                }

                public SetIamPolicy setKey(String string) {
                    return (SetIamPolicy)super.setKey(string);
                }

                public SetIamPolicy setOauthToken(String string) {
                    return (SetIamPolicy)super.setOauthToken(string);
                }

                public SetIamPolicy setPrettyPrint(Boolean bl) {
                    return (SetIamPolicy)super.setPrettyPrint(bl);
                }

                public SetIamPolicy setQuotaUser(String string) {
                    return (SetIamPolicy)super.setQuotaUser(string);
                }

                public SetIamPolicy setUploadType(String string) {
                    return (SetIamPolicy)super.setUploadType(string);
                }

                public SetIamPolicy setUploadProtocol(String string) {
                    return (SetIamPolicy)super.setUploadProtocol(string);
                }

                public String getResource() {
                    return this.resource;
                }

                public SetIamPolicy setResource(String string) {
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+$");
                    }
                    this.resource = string;
                    return this;
                }

                @Override
                public SetIamPolicy set(String string, Object object) {
                    return (SetIamPolicy)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Patch
            extends IamRequest<ServiceAccount> {
                private static final String REST_PATH = "v1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Patch(String string, PatchServiceAccountRequest patchServiceAccountRequest) {
                    super(Iam.this, "PATCH", REST_PATH, (Object)patchServiceAccountRequest, ServiceAccount.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/serviceAccounts/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+$");
                    }
                }

                public Patch set$Xgafv(String string) {
                    return (Patch)super.set$Xgafv(string);
                }

                public Patch setAccessToken(String string) {
                    return (Patch)super.setAccessToken(string);
                }

                public Patch setAlt(String string) {
                    return (Patch)super.setAlt(string);
                }

                public Patch setCallback(String string) {
                    return (Patch)super.setCallback(string);
                }

                public Patch setFields(String string) {
                    return (Patch)super.setFields(string);
                }

                public Patch setKey(String string) {
                    return (Patch)super.setKey(string);
                }

                public Patch setOauthToken(String string) {
                    return (Patch)super.setOauthToken(string);
                }

                public Patch setPrettyPrint(Boolean bl) {
                    return (Patch)super.setPrettyPrint(bl);
                }

                public Patch setQuotaUser(String string) {
                    return (Patch)super.setQuotaUser(string);
                }

                public Patch setUploadType(String string) {
                    return (Patch)super.setUploadType(string);
                }

                public Patch setUploadProtocol(String string) {
                    return (Patch)super.setUploadProtocol(string);
                }

                public String getName() {
                    return this.name;
                }

                public Patch setName(String string) {
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+$");
                    }
                    this.name = string;
                    return this;
                }

                @Override
                public Patch set(String string, Object object) {
                    return (Patch)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends IamRequest<ListServiceAccountsResponse> {
                private static final String REST_PATH = "v1/{+name}/serviceAccounts";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;
                @Key
                private String pageToken;
                @Key
                private Integer pageSize;

                protected List(String string) {
                    super(Iam.this, "GET", REST_PATH, null, ListServiceAccountsResponse.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String string) {
                    return (List)super.set$Xgafv(string);
                }

                public List setAccessToken(String string) {
                    return (List)super.setAccessToken(string);
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setCallback(String string) {
                    return (List)super.setCallback(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUploadType(String string) {
                    return (List)super.setUploadType(string);
                }

                public List setUploadProtocol(String string) {
                    return (List)super.setUploadProtocol(string);
                }

                public String getName() {
                    return this.name;
                }

                public List setName(String string) {
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+$");
                    }
                    this.name = string;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String string) {
                    this.pageToken = string;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer n) {
                    this.pageSize = n;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class GetIamPolicy
            extends IamRequest<Policy> {
                private static final String REST_PATH = "v1/{+resource}:getIamPolicy";
                private final Pattern RESOURCE_PATTERN;
                @Key
                private String resource;
                @Key(value="options.requestedPolicyVersion")
                private Integer optionsRequestedPolicyVersion;

                protected GetIamPolicy(String string) {
                    super(Iam.this, "POST", REST_PATH, null, Policy.class);
                    this.RESOURCE_PATTERN = Pattern.compile("^projects/[^/]+/serviceAccounts/[^/]+$");
                    this.resource = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter resource must be specified.");
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+$");
                    }
                }

                public GetIamPolicy set$Xgafv(String string) {
                    return (GetIamPolicy)super.set$Xgafv(string);
                }

                public GetIamPolicy setAccessToken(String string) {
                    return (GetIamPolicy)super.setAccessToken(string);
                }

                public GetIamPolicy setAlt(String string) {
                    return (GetIamPolicy)super.setAlt(string);
                }

                public GetIamPolicy setCallback(String string) {
                    return (GetIamPolicy)super.setCallback(string);
                }

                public GetIamPolicy setFields(String string) {
                    return (GetIamPolicy)super.setFields(string);
                }

                public GetIamPolicy setKey(String string) {
                    return (GetIamPolicy)super.setKey(string);
                }

                public GetIamPolicy setOauthToken(String string) {
                    return (GetIamPolicy)super.setOauthToken(string);
                }

                public GetIamPolicy setPrettyPrint(Boolean bl) {
                    return (GetIamPolicy)super.setPrettyPrint(bl);
                }

                public GetIamPolicy setQuotaUser(String string) {
                    return (GetIamPolicy)super.setQuotaUser(string);
                }

                public GetIamPolicy setUploadType(String string) {
                    return (GetIamPolicy)super.setUploadType(string);
                }

                public GetIamPolicy setUploadProtocol(String string) {
                    return (GetIamPolicy)super.setUploadProtocol(string);
                }

                public String getResource() {
                    return this.resource;
                }

                public GetIamPolicy setResource(String string) {
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.RESOURCE_PATTERN.matcher(string).matches(), (Object)"Parameter resource must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+$");
                    }
                    this.resource = string;
                    return this;
                }

                public Integer getOptionsRequestedPolicyVersion() {
                    return this.optionsRequestedPolicyVersion;
                }

                public GetIamPolicy setOptionsRequestedPolicyVersion(Integer n) {
                    this.optionsRequestedPolicyVersion = n;
                    return this;
                }

                @Override
                public GetIamPolicy set(String string, Object object) {
                    return (GetIamPolicy)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Get
            extends IamRequest<ServiceAccount> {
                private static final String REST_PATH = "v1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Get(String string) {
                    super(Iam.this, "GET", REST_PATH, null, ServiceAccount.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/serviceAccounts/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String string) {
                    return (Get)super.set$Xgafv(string);
                }

                public Get setAccessToken(String string) {
                    return (Get)super.setAccessToken(string);
                }

                public Get setAlt(String string) {
                    return (Get)super.setAlt(string);
                }

                public Get setCallback(String string) {
                    return (Get)super.setCallback(string);
                }

                public Get setFields(String string) {
                    return (Get)super.setFields(string);
                }

                public Get setKey(String string) {
                    return (Get)super.setKey(string);
                }

                public Get setOauthToken(String string) {
                    return (Get)super.setOauthToken(string);
                }

                public Get setPrettyPrint(Boolean bl) {
                    return (Get)super.setPrettyPrint(bl);
                }

                public Get setQuotaUser(String string) {
                    return (Get)super.setQuotaUser(string);
                }

                public Get setUploadType(String string) {
                    return (Get)super.setUploadType(string);
                }

                public Get setUploadProtocol(String string) {
                    return (Get)super.setUploadProtocol(string);
                }

                public String getName() {
                    return this.name;
                }

                public Get setName(String string) {
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+$");
                    }
                    this.name = string;
                    return this;
                }

                @Override
                public Get set(String string, Object object) {
                    return (Get)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Enable
            extends IamRequest<Empty> {
                private static final String REST_PATH = "v1/{+name}:enable";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Enable(String string, EnableServiceAccountRequest enableServiceAccountRequest) {
                    super(Iam.this, "POST", REST_PATH, (Object)enableServiceAccountRequest, Empty.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/serviceAccounts/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+$");
                    }
                }

                public Enable set$Xgafv(String string) {
                    return (Enable)super.set$Xgafv(string);
                }

                public Enable setAccessToken(String string) {
                    return (Enable)super.setAccessToken(string);
                }

                public Enable setAlt(String string) {
                    return (Enable)super.setAlt(string);
                }

                public Enable setCallback(String string) {
                    return (Enable)super.setCallback(string);
                }

                public Enable setFields(String string) {
                    return (Enable)super.setFields(string);
                }

                public Enable setKey(String string) {
                    return (Enable)super.setKey(string);
                }

                public Enable setOauthToken(String string) {
                    return (Enable)super.setOauthToken(string);
                }

                public Enable setPrettyPrint(Boolean bl) {
                    return (Enable)super.setPrettyPrint(bl);
                }

                public Enable setQuotaUser(String string) {
                    return (Enable)super.setQuotaUser(string);
                }

                public Enable setUploadType(String string) {
                    return (Enable)super.setUploadType(string);
                }

                public Enable setUploadProtocol(String string) {
                    return (Enable)super.setUploadProtocol(string);
                }

                public String getName() {
                    return this.name;
                }

                public Enable setName(String string) {
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+$");
                    }
                    this.name = string;
                    return this;
                }

                @Override
                public Enable set(String string, Object object) {
                    return (Enable)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Disable
            extends IamRequest<Empty> {
                private static final String REST_PATH = "v1/{+name}:disable";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Disable(String string, DisableServiceAccountRequest disableServiceAccountRequest) {
                    super(Iam.this, "POST", REST_PATH, (Object)disableServiceAccountRequest, Empty.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/serviceAccounts/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+$");
                    }
                }

                public Disable set$Xgafv(String string) {
                    return (Disable)super.set$Xgafv(string);
                }

                public Disable setAccessToken(String string) {
                    return (Disable)super.setAccessToken(string);
                }

                public Disable setAlt(String string) {
                    return (Disable)super.setAlt(string);
                }

                public Disable setCallback(String string) {
                    return (Disable)super.setCallback(string);
                }

                public Disable setFields(String string) {
                    return (Disable)super.setFields(string);
                }

                public Disable setKey(String string) {
                    return (Disable)super.setKey(string);
                }

                public Disable setOauthToken(String string) {
                    return (Disable)super.setOauthToken(string);
                }

                public Disable setPrettyPrint(Boolean bl) {
                    return (Disable)super.setPrettyPrint(bl);
                }

                public Disable setQuotaUser(String string) {
                    return (Disable)super.setQuotaUser(string);
                }

                public Disable setUploadType(String string) {
                    return (Disable)super.setUploadType(string);
                }

                public Disable setUploadProtocol(String string) {
                    return (Disable)super.setUploadProtocol(string);
                }

                public String getName() {
                    return this.name;
                }

                public Disable setName(String string) {
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+$");
                    }
                    this.name = string;
                    return this;
                }

                @Override
                public Disable set(String string, Object object) {
                    return (Disable)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Delete
            extends IamRequest<Empty> {
                private static final String REST_PATH = "v1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Delete(String string) {
                    super(Iam.this, "DELETE", REST_PATH, null, Empty.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/serviceAccounts/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+$");
                    }
                }

                public Delete set$Xgafv(String string) {
                    return (Delete)super.set$Xgafv(string);
                }

                public Delete setAccessToken(String string) {
                    return (Delete)super.setAccessToken(string);
                }

                public Delete setAlt(String string) {
                    return (Delete)super.setAlt(string);
                }

                public Delete setCallback(String string) {
                    return (Delete)super.setCallback(string);
                }

                public Delete setFields(String string) {
                    return (Delete)super.setFields(string);
                }

                public Delete setKey(String string) {
                    return (Delete)super.setKey(string);
                }

                public Delete setOauthToken(String string) {
                    return (Delete)super.setOauthToken(string);
                }

                public Delete setPrettyPrint(Boolean bl) {
                    return (Delete)super.setPrettyPrint(bl);
                }

                public Delete setQuotaUser(String string) {
                    return (Delete)super.setQuotaUser(string);
                }

                public Delete setUploadType(String string) {
                    return (Delete)super.setUploadType(string);
                }

                public Delete setUploadProtocol(String string) {
                    return (Delete)super.setUploadProtocol(string);
                }

                public String getName() {
                    return this.name;
                }

                public Delete setName(String string) {
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/serviceAccounts/[^/]+$");
                    }
                    this.name = string;
                    return this;
                }

                @Override
                public Delete set(String string, Object object) {
                    return (Delete)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Create
            extends IamRequest<ServiceAccount> {
                private static final String REST_PATH = "v1/{+name}/serviceAccounts";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Create(String string, CreateServiceAccountRequest createServiceAccountRequest) {
                    super(Iam.this, "POST", REST_PATH, (Object)createServiceAccountRequest, ServiceAccount.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public Create set$Xgafv(String string) {
                    return (Create)super.set$Xgafv(string);
                }

                public Create setAccessToken(String string) {
                    return (Create)super.setAccessToken(string);
                }

                public Create setAlt(String string) {
                    return (Create)super.setAlt(string);
                }

                public Create setCallback(String string) {
                    return (Create)super.setCallback(string);
                }

                public Create setFields(String string) {
                    return (Create)super.setFields(string);
                }

                public Create setKey(String string) {
                    return (Create)super.setKey(string);
                }

                public Create setOauthToken(String string) {
                    return (Create)super.setOauthToken(string);
                }

                public Create setPrettyPrint(Boolean bl) {
                    return (Create)super.setPrettyPrint(bl);
                }

                public Create setQuotaUser(String string) {
                    return (Create)super.setQuotaUser(string);
                }

                public Create setUploadType(String string) {
                    return (Create)super.setUploadType(string);
                }

                public Create setUploadProtocol(String string) {
                    return (Create)super.setUploadProtocol(string);
                }

                public String getName() {
                    return this.name;
                }

                public Create setName(String string) {
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+$");
                    }
                    this.name = string;
                    return this;
                }

                @Override
                public Create set(String string, Object object) {
                    return (Create)super.set(string, object);
                }
            }
        }

        public class Roles {
            public Create create(String string, CreateRoleRequest createRoleRequest) throws IOException {
                Create create = new Create(string, createRoleRequest);
                Iam.this.initialize((AbstractGoogleClientRequest<?>)create);
                return create;
            }

            public Delete delete(String string) throws IOException {
                Delete delete = new Delete(string);
                Iam.this.initialize((AbstractGoogleClientRequest<?>)delete);
                return delete;
            }

            public Get get(String string) throws IOException {
                Get get = new Get(string);
                Iam.this.initialize((AbstractGoogleClientRequest<?>)get);
                return get;
            }

            public List list(String string) throws IOException {
                List list = new List(string);
                Iam.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            public Patch patch(String string, Role role) throws IOException {
                Patch patch = new Patch(string, role);
                Iam.this.initialize((AbstractGoogleClientRequest<?>)patch);
                return patch;
            }

            public Undelete undelete(String string, UndeleteRoleRequest undeleteRoleRequest) throws IOException {
                Undelete undelete = new Undelete(string, undeleteRoleRequest);
                Iam.this.initialize((AbstractGoogleClientRequest<?>)undelete);
                return undelete;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Undelete
            extends IamRequest<Role> {
                private static final String REST_PATH = "v1/{+name}:undelete";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Undelete(String string, UndeleteRoleRequest undeleteRoleRequest) {
                    super(Iam.this, "POST", REST_PATH, (Object)undeleteRoleRequest, Role.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/roles/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/roles/[^/]+$");
                    }
                }

                public Undelete set$Xgafv(String string) {
                    return (Undelete)super.set$Xgafv(string);
                }

                public Undelete setAccessToken(String string) {
                    return (Undelete)super.setAccessToken(string);
                }

                public Undelete setAlt(String string) {
                    return (Undelete)super.setAlt(string);
                }

                public Undelete setCallback(String string) {
                    return (Undelete)super.setCallback(string);
                }

                public Undelete setFields(String string) {
                    return (Undelete)super.setFields(string);
                }

                public Undelete setKey(String string) {
                    return (Undelete)super.setKey(string);
                }

                public Undelete setOauthToken(String string) {
                    return (Undelete)super.setOauthToken(string);
                }

                public Undelete setPrettyPrint(Boolean bl) {
                    return (Undelete)super.setPrettyPrint(bl);
                }

                public Undelete setQuotaUser(String string) {
                    return (Undelete)super.setQuotaUser(string);
                }

                public Undelete setUploadType(String string) {
                    return (Undelete)super.setUploadType(string);
                }

                public Undelete setUploadProtocol(String string) {
                    return (Undelete)super.setUploadProtocol(string);
                }

                public String getName() {
                    return this.name;
                }

                public Undelete setName(String string) {
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/roles/[^/]+$");
                    }
                    this.name = string;
                    return this;
                }

                @Override
                public Undelete set(String string, Object object) {
                    return (Undelete)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Patch
            extends IamRequest<Role> {
                private static final String REST_PATH = "v1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;
                @Key
                private String updateMask;

                protected Patch(String string, Role role) {
                    super(Iam.this, "PATCH", REST_PATH, (Object)role, Role.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/roles/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/roles/[^/]+$");
                    }
                }

                public Patch set$Xgafv(String string) {
                    return (Patch)super.set$Xgafv(string);
                }

                public Patch setAccessToken(String string) {
                    return (Patch)super.setAccessToken(string);
                }

                public Patch setAlt(String string) {
                    return (Patch)super.setAlt(string);
                }

                public Patch setCallback(String string) {
                    return (Patch)super.setCallback(string);
                }

                public Patch setFields(String string) {
                    return (Patch)super.setFields(string);
                }

                public Patch setKey(String string) {
                    return (Patch)super.setKey(string);
                }

                public Patch setOauthToken(String string) {
                    return (Patch)super.setOauthToken(string);
                }

                public Patch setPrettyPrint(Boolean bl) {
                    return (Patch)super.setPrettyPrint(bl);
                }

                public Patch setQuotaUser(String string) {
                    return (Patch)super.setQuotaUser(string);
                }

                public Patch setUploadType(String string) {
                    return (Patch)super.setUploadType(string);
                }

                public Patch setUploadProtocol(String string) {
                    return (Patch)super.setUploadProtocol(string);
                }

                public String getName() {
                    return this.name;
                }

                public Patch setName(String string) {
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/roles/[^/]+$");
                    }
                    this.name = string;
                    return this;
                }

                public String getUpdateMask() {
                    return this.updateMask;
                }

                public Patch setUpdateMask(String string) {
                    this.updateMask = string;
                    return this;
                }

                @Override
                public Patch set(String string, Object object) {
                    return (Patch)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends IamRequest<ListRolesResponse> {
                private static final String REST_PATH = "v1/{+parent}/roles";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key
                private String view;
                @Key
                private Boolean showDeleted;
                @Key
                private String pageToken;
                @Key
                private Integer pageSize;

                protected List(String string) {
                    super(Iam.this, "GET", REST_PATH, null, ListRolesResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String string) {
                    return (List)super.set$Xgafv(string);
                }

                public List setAccessToken(String string) {
                    return (List)super.setAccessToken(string);
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setCallback(String string) {
                    return (List)super.setCallback(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUploadType(String string) {
                    return (List)super.setUploadType(string);
                }

                public List setUploadProtocol(String string) {
                    return (List)super.setUploadProtocol(string);
                }

                public String getParent() {
                    return this.parent;
                }

                public List setParent(String string) {
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                    this.parent = string;
                    return this;
                }

                public String getView() {
                    return this.view;
                }

                public List setView(String string) {
                    this.view = string;
                    return this;
                }

                public Boolean getShowDeleted() {
                    return this.showDeleted;
                }

                public List setShowDeleted(Boolean bl) {
                    this.showDeleted = bl;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String string) {
                    this.pageToken = string;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer n) {
                    this.pageSize = n;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Get
            extends IamRequest<Role> {
                private static final String REST_PATH = "v1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Get(String string) {
                    super(Iam.this, "GET", REST_PATH, null, Role.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/roles/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/roles/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String string) {
                    return (Get)super.set$Xgafv(string);
                }

                public Get setAccessToken(String string) {
                    return (Get)super.setAccessToken(string);
                }

                public Get setAlt(String string) {
                    return (Get)super.setAlt(string);
                }

                public Get setCallback(String string) {
                    return (Get)super.setCallback(string);
                }

                public Get setFields(String string) {
                    return (Get)super.setFields(string);
                }

                public Get setKey(String string) {
                    return (Get)super.setKey(string);
                }

                public Get setOauthToken(String string) {
                    return (Get)super.setOauthToken(string);
                }

                public Get setPrettyPrint(Boolean bl) {
                    return (Get)super.setPrettyPrint(bl);
                }

                public Get setQuotaUser(String string) {
                    return (Get)super.setQuotaUser(string);
                }

                public Get setUploadType(String string) {
                    return (Get)super.setUploadType(string);
                }

                public Get setUploadProtocol(String string) {
                    return (Get)super.setUploadProtocol(string);
                }

                public String getName() {
                    return this.name;
                }

                public Get setName(String string) {
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/roles/[^/]+$");
                    }
                    this.name = string;
                    return this;
                }

                @Override
                public Get set(String string, Object object) {
                    return (Get)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Delete
            extends IamRequest<Role> {
                private static final String REST_PATH = "v1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;
                @Key
                private String etag;

                protected Delete(String string) {
                    super(Iam.this, "DELETE", REST_PATH, null, Role.class);
                    this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/roles/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/roles/[^/]+$");
                    }
                }

                public Delete set$Xgafv(String string) {
                    return (Delete)super.set$Xgafv(string);
                }

                public Delete setAccessToken(String string) {
                    return (Delete)super.setAccessToken(string);
                }

                public Delete setAlt(String string) {
                    return (Delete)super.setAlt(string);
                }

                public Delete setCallback(String string) {
                    return (Delete)super.setCallback(string);
                }

                public Delete setFields(String string) {
                    return (Delete)super.setFields(string);
                }

                public Delete setKey(String string) {
                    return (Delete)super.setKey(string);
                }

                public Delete setOauthToken(String string) {
                    return (Delete)super.setOauthToken(string);
                }

                public Delete setPrettyPrint(Boolean bl) {
                    return (Delete)super.setPrettyPrint(bl);
                }

                public Delete setQuotaUser(String string) {
                    return (Delete)super.setQuotaUser(string);
                }

                public Delete setUploadType(String string) {
                    return (Delete)super.setUploadType(string);
                }

                public Delete setUploadProtocol(String string) {
                    return (Delete)super.setUploadProtocol(string);
                }

                public String getName() {
                    return this.name;
                }

                public Delete setName(String string) {
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/roles/[^/]+$");
                    }
                    this.name = string;
                    return this;
                }

                public String getEtag() {
                    return this.etag;
                }

                public Delete setEtag(String string) {
                    this.etag = string;
                    return this;
                }

                @Override
                public Delete set(String string, Object object) {
                    return (Delete)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Create
            extends IamRequest<Role> {
                private static final String REST_PATH = "v1/{+parent}/roles";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;

                protected Create(String string, CreateRoleRequest createRoleRequest) {
                    super(Iam.this, "POST", REST_PATH, (Object)createRoleRequest, Role.class);
                    this.PARENT_PATTERN = Pattern.compile("^projects/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                }

                public Create set$Xgafv(String string) {
                    return (Create)super.set$Xgafv(string);
                }

                public Create setAccessToken(String string) {
                    return (Create)super.setAccessToken(string);
                }

                public Create setAlt(String string) {
                    return (Create)super.setAlt(string);
                }

                public Create setCallback(String string) {
                    return (Create)super.setCallback(string);
                }

                public Create setFields(String string) {
                    return (Create)super.setFields(string);
                }

                public Create setKey(String string) {
                    return (Create)super.setKey(string);
                }

                public Create setOauthToken(String string) {
                    return (Create)super.setOauthToken(string);
                }

                public Create setPrettyPrint(Boolean bl) {
                    return (Create)super.setPrettyPrint(bl);
                }

                public Create setQuotaUser(String string) {
                    return (Create)super.setQuotaUser(string);
                }

                public Create setUploadType(String string) {
                    return (Create)super.setUploadType(string);
                }

                public Create setUploadProtocol(String string) {
                    return (Create)super.setUploadProtocol(string);
                }

                public String getParent() {
                    return this.parent;
                }

                public Create setParent(String string) {
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^projects/[^/]+$");
                    }
                    this.parent = string;
                    return this;
                }

                @Override
                public Create set(String string, Object object) {
                    return (Create)super.set(string, object);
                }
            }
        }
    }

    public class Permissions {
        public QueryTestablePermissions queryTestablePermissions(QueryTestablePermissionsRequest queryTestablePermissionsRequest) throws IOException {
            QueryTestablePermissions queryTestablePermissions = new QueryTestablePermissions(queryTestablePermissionsRequest);
            Iam.this.initialize((AbstractGoogleClientRequest<?>)queryTestablePermissions);
            return queryTestablePermissions;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class QueryTestablePermissions
        extends IamRequest<QueryTestablePermissionsResponse> {
            private static final String REST_PATH = "v1/permissions:queryTestablePermissions";

            protected QueryTestablePermissions(QueryTestablePermissionsRequest queryTestablePermissionsRequest) {
                super(Iam.this, "POST", REST_PATH, (Object)queryTestablePermissionsRequest, QueryTestablePermissionsResponse.class);
            }

            public QueryTestablePermissions set$Xgafv(String string) {
                return (QueryTestablePermissions)super.set$Xgafv(string);
            }

            public QueryTestablePermissions setAccessToken(String string) {
                return (QueryTestablePermissions)super.setAccessToken(string);
            }

            public QueryTestablePermissions setAlt(String string) {
                return (QueryTestablePermissions)super.setAlt(string);
            }

            public QueryTestablePermissions setCallback(String string) {
                return (QueryTestablePermissions)super.setCallback(string);
            }

            public QueryTestablePermissions setFields(String string) {
                return (QueryTestablePermissions)super.setFields(string);
            }

            public QueryTestablePermissions setKey(String string) {
                return (QueryTestablePermissions)super.setKey(string);
            }

            public QueryTestablePermissions setOauthToken(String string) {
                return (QueryTestablePermissions)super.setOauthToken(string);
            }

            public QueryTestablePermissions setPrettyPrint(Boolean bl) {
                return (QueryTestablePermissions)super.setPrettyPrint(bl);
            }

            public QueryTestablePermissions setQuotaUser(String string) {
                return (QueryTestablePermissions)super.setQuotaUser(string);
            }

            public QueryTestablePermissions setUploadType(String string) {
                return (QueryTestablePermissions)super.setUploadType(string);
            }

            public QueryTestablePermissions setUploadProtocol(String string) {
                return (QueryTestablePermissions)super.setUploadProtocol(string);
            }

            @Override
            public QueryTestablePermissions set(String string, Object object) {
                return (QueryTestablePermissions)super.set(string, object);
            }
        }
    }

    public class Organizations {
        public Roles roles() {
            return new Roles();
        }

        public class Roles {
            public Create create(String string, CreateRoleRequest createRoleRequest) throws IOException {
                Create create = new Create(string, createRoleRequest);
                Iam.this.initialize((AbstractGoogleClientRequest<?>)create);
                return create;
            }

            public Delete delete(String string) throws IOException {
                Delete delete = new Delete(string);
                Iam.this.initialize((AbstractGoogleClientRequest<?>)delete);
                return delete;
            }

            public Get get(String string) throws IOException {
                Get get = new Get(string);
                Iam.this.initialize((AbstractGoogleClientRequest<?>)get);
                return get;
            }

            public List list(String string) throws IOException {
                List list = new List(string);
                Iam.this.initialize((AbstractGoogleClientRequest<?>)list);
                return list;
            }

            public Patch patch(String string, Role role) throws IOException {
                Patch patch = new Patch(string, role);
                Iam.this.initialize((AbstractGoogleClientRequest<?>)patch);
                return patch;
            }

            public Undelete undelete(String string, UndeleteRoleRequest undeleteRoleRequest) throws IOException {
                Undelete undelete = new Undelete(string, undeleteRoleRequest);
                Iam.this.initialize((AbstractGoogleClientRequest<?>)undelete);
                return undelete;
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Undelete
            extends IamRequest<Role> {
                private static final String REST_PATH = "v1/{+name}:undelete";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Undelete(String string, UndeleteRoleRequest undeleteRoleRequest) {
                    super(Iam.this, "POST", REST_PATH, (Object)undeleteRoleRequest, Role.class);
                    this.NAME_PATTERN = Pattern.compile("^organizations/[^/]+/roles/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^organizations/[^/]+/roles/[^/]+$");
                    }
                }

                public Undelete set$Xgafv(String string) {
                    return (Undelete)super.set$Xgafv(string);
                }

                public Undelete setAccessToken(String string) {
                    return (Undelete)super.setAccessToken(string);
                }

                public Undelete setAlt(String string) {
                    return (Undelete)super.setAlt(string);
                }

                public Undelete setCallback(String string) {
                    return (Undelete)super.setCallback(string);
                }

                public Undelete setFields(String string) {
                    return (Undelete)super.setFields(string);
                }

                public Undelete setKey(String string) {
                    return (Undelete)super.setKey(string);
                }

                public Undelete setOauthToken(String string) {
                    return (Undelete)super.setOauthToken(string);
                }

                public Undelete setPrettyPrint(Boolean bl) {
                    return (Undelete)super.setPrettyPrint(bl);
                }

                public Undelete setQuotaUser(String string) {
                    return (Undelete)super.setQuotaUser(string);
                }

                public Undelete setUploadType(String string) {
                    return (Undelete)super.setUploadType(string);
                }

                public Undelete setUploadProtocol(String string) {
                    return (Undelete)super.setUploadProtocol(string);
                }

                public String getName() {
                    return this.name;
                }

                public Undelete setName(String string) {
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^organizations/[^/]+/roles/[^/]+$");
                    }
                    this.name = string;
                    return this;
                }

                @Override
                public Undelete set(String string, Object object) {
                    return (Undelete)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Patch
            extends IamRequest<Role> {
                private static final String REST_PATH = "v1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;
                @Key
                private String updateMask;

                protected Patch(String string, Role role) {
                    super(Iam.this, "PATCH", REST_PATH, (Object)role, Role.class);
                    this.NAME_PATTERN = Pattern.compile("^organizations/[^/]+/roles/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^organizations/[^/]+/roles/[^/]+$");
                    }
                }

                public Patch set$Xgafv(String string) {
                    return (Patch)super.set$Xgafv(string);
                }

                public Patch setAccessToken(String string) {
                    return (Patch)super.setAccessToken(string);
                }

                public Patch setAlt(String string) {
                    return (Patch)super.setAlt(string);
                }

                public Patch setCallback(String string) {
                    return (Patch)super.setCallback(string);
                }

                public Patch setFields(String string) {
                    return (Patch)super.setFields(string);
                }

                public Patch setKey(String string) {
                    return (Patch)super.setKey(string);
                }

                public Patch setOauthToken(String string) {
                    return (Patch)super.setOauthToken(string);
                }

                public Patch setPrettyPrint(Boolean bl) {
                    return (Patch)super.setPrettyPrint(bl);
                }

                public Patch setQuotaUser(String string) {
                    return (Patch)super.setQuotaUser(string);
                }

                public Patch setUploadType(String string) {
                    return (Patch)super.setUploadType(string);
                }

                public Patch setUploadProtocol(String string) {
                    return (Patch)super.setUploadProtocol(string);
                }

                public String getName() {
                    return this.name;
                }

                public Patch setName(String string) {
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^organizations/[^/]+/roles/[^/]+$");
                    }
                    this.name = string;
                    return this;
                }

                public String getUpdateMask() {
                    return this.updateMask;
                }

                public Patch setUpdateMask(String string) {
                    this.updateMask = string;
                    return this;
                }

                @Override
                public Patch set(String string, Object object) {
                    return (Patch)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class List
            extends IamRequest<ListRolesResponse> {
                private static final String REST_PATH = "v1/{+parent}/roles";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;
                @Key
                private Boolean showDeleted;
                @Key
                private String pageToken;
                @Key
                private Integer pageSize;
                @Key
                private String view;

                protected List(String string) {
                    super(Iam.this, "GET", REST_PATH, null, ListRolesResponse.class);
                    this.PARENT_PATTERN = Pattern.compile("^organizations/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^organizations/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String string) {
                    return (List)super.set$Xgafv(string);
                }

                public List setAccessToken(String string) {
                    return (List)super.setAccessToken(string);
                }

                public List setAlt(String string) {
                    return (List)super.setAlt(string);
                }

                public List setCallback(String string) {
                    return (List)super.setCallback(string);
                }

                public List setFields(String string) {
                    return (List)super.setFields(string);
                }

                public List setKey(String string) {
                    return (List)super.setKey(string);
                }

                public List setOauthToken(String string) {
                    return (List)super.setOauthToken(string);
                }

                public List setPrettyPrint(Boolean bl) {
                    return (List)super.setPrettyPrint(bl);
                }

                public List setQuotaUser(String string) {
                    return (List)super.setQuotaUser(string);
                }

                public List setUploadType(String string) {
                    return (List)super.setUploadType(string);
                }

                public List setUploadProtocol(String string) {
                    return (List)super.setUploadProtocol(string);
                }

                public String getParent() {
                    return this.parent;
                }

                public List setParent(String string) {
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^organizations/[^/]+$");
                    }
                    this.parent = string;
                    return this;
                }

                public Boolean getShowDeleted() {
                    return this.showDeleted;
                }

                public List setShowDeleted(Boolean bl) {
                    this.showDeleted = bl;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String string) {
                    this.pageToken = string;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer n) {
                    this.pageSize = n;
                    return this;
                }

                public String getView() {
                    return this.view;
                }

                public List setView(String string) {
                    this.view = string;
                    return this;
                }

                @Override
                public List set(String string, Object object) {
                    return (List)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Get
            extends IamRequest<Role> {
                private static final String REST_PATH = "v1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;

                protected Get(String string) {
                    super(Iam.this, "GET", REST_PATH, null, Role.class);
                    this.NAME_PATTERN = Pattern.compile("^organizations/[^/]+/roles/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^organizations/[^/]+/roles/[^/]+$");
                    }
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String string) {
                    return (Get)super.set$Xgafv(string);
                }

                public Get setAccessToken(String string) {
                    return (Get)super.setAccessToken(string);
                }

                public Get setAlt(String string) {
                    return (Get)super.setAlt(string);
                }

                public Get setCallback(String string) {
                    return (Get)super.setCallback(string);
                }

                public Get setFields(String string) {
                    return (Get)super.setFields(string);
                }

                public Get setKey(String string) {
                    return (Get)super.setKey(string);
                }

                public Get setOauthToken(String string) {
                    return (Get)super.setOauthToken(string);
                }

                public Get setPrettyPrint(Boolean bl) {
                    return (Get)super.setPrettyPrint(bl);
                }

                public Get setQuotaUser(String string) {
                    return (Get)super.setQuotaUser(string);
                }

                public Get setUploadType(String string) {
                    return (Get)super.setUploadType(string);
                }

                public Get setUploadProtocol(String string) {
                    return (Get)super.setUploadProtocol(string);
                }

                public String getName() {
                    return this.name;
                }

                public Get setName(String string) {
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^organizations/[^/]+/roles/[^/]+$");
                    }
                    this.name = string;
                    return this;
                }

                @Override
                public Get set(String string, Object object) {
                    return (Get)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Delete
            extends IamRequest<Role> {
                private static final String REST_PATH = "v1/{+name}";
                private final Pattern NAME_PATTERN;
                @Key
                private String name;
                @Key
                private String etag;

                protected Delete(String string) {
                    super(Iam.this, "DELETE", REST_PATH, null, Role.class);
                    this.NAME_PATTERN = Pattern.compile("^organizations/[^/]+/roles/[^/]+$");
                    this.name = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter name must be specified.");
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^organizations/[^/]+/roles/[^/]+$");
                    }
                }

                public Delete set$Xgafv(String string) {
                    return (Delete)super.set$Xgafv(string);
                }

                public Delete setAccessToken(String string) {
                    return (Delete)super.setAccessToken(string);
                }

                public Delete setAlt(String string) {
                    return (Delete)super.setAlt(string);
                }

                public Delete setCallback(String string) {
                    return (Delete)super.setCallback(string);
                }

                public Delete setFields(String string) {
                    return (Delete)super.setFields(string);
                }

                public Delete setKey(String string) {
                    return (Delete)super.setKey(string);
                }

                public Delete setOauthToken(String string) {
                    return (Delete)super.setOauthToken(string);
                }

                public Delete setPrettyPrint(Boolean bl) {
                    return (Delete)super.setPrettyPrint(bl);
                }

                public Delete setQuotaUser(String string) {
                    return (Delete)super.setQuotaUser(string);
                }

                public Delete setUploadType(String string) {
                    return (Delete)super.setUploadType(string);
                }

                public Delete setUploadProtocol(String string) {
                    return (Delete)super.setUploadProtocol(string);
                }

                public String getName() {
                    return this.name;
                }

                public Delete setName(String string) {
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(string).matches(), (Object)"Parameter name must conform to the pattern ^organizations/[^/]+/roles/[^/]+$");
                    }
                    this.name = string;
                    return this;
                }

                public String getEtag() {
                    return this.etag;
                }

                public Delete setEtag(String string) {
                    this.etag = string;
                    return this;
                }

                @Override
                public Delete set(String string, Object object) {
                    return (Delete)super.set(string, object);
                }
            }

            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            public class Create
            extends IamRequest<Role> {
                private static final String REST_PATH = "v1/{+parent}/roles";
                private final Pattern PARENT_PATTERN;
                @Key
                private String parent;

                protected Create(String string, CreateRoleRequest createRoleRequest) {
                    super(Iam.this, "POST", REST_PATH, (Object)createRoleRequest, Role.class);
                    this.PARENT_PATTERN = Pattern.compile("^organizations/[^/]+$");
                    this.parent = (String)Preconditions.checkNotNull((Object)string, (Object)"Required parameter parent must be specified.");
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^organizations/[^/]+$");
                    }
                }

                public Create set$Xgafv(String string) {
                    return (Create)super.set$Xgafv(string);
                }

                public Create setAccessToken(String string) {
                    return (Create)super.setAccessToken(string);
                }

                public Create setAlt(String string) {
                    return (Create)super.setAlt(string);
                }

                public Create setCallback(String string) {
                    return (Create)super.setCallback(string);
                }

                public Create setFields(String string) {
                    return (Create)super.setFields(string);
                }

                public Create setKey(String string) {
                    return (Create)super.setKey(string);
                }

                public Create setOauthToken(String string) {
                    return (Create)super.setOauthToken(string);
                }

                public Create setPrettyPrint(Boolean bl) {
                    return (Create)super.setPrettyPrint(bl);
                }

                public Create setQuotaUser(String string) {
                    return (Create)super.setQuotaUser(string);
                }

                public Create setUploadType(String string) {
                    return (Create)super.setUploadType(string);
                }

                public Create setUploadProtocol(String string) {
                    return (Create)super.setUploadProtocol(string);
                }

                public String getParent() {
                    return this.parent;
                }

                public Create setParent(String string) {
                    if (!Iam.this.getSuppressPatternChecks()) {
                        Preconditions.checkArgument((boolean)this.PARENT_PATTERN.matcher(string).matches(), (Object)"Parameter parent must conform to the pattern ^organizations/[^/]+$");
                    }
                    this.parent = string;
                    return this;
                }

                @Override
                public Create set(String string, Object object) {
                    return (Create)super.set(string, object);
                }
            }
        }
    }

    public class IamPolicies {
        public LintPolicy lintPolicy(LintPolicyRequest lintPolicyRequest) throws IOException {
            LintPolicy lintPolicy = new LintPolicy(lintPolicyRequest);
            Iam.this.initialize((AbstractGoogleClientRequest<?>)lintPolicy);
            return lintPolicy;
        }

        public QueryAuditableServices queryAuditableServices(QueryAuditableServicesRequest queryAuditableServicesRequest) throws IOException {
            QueryAuditableServices queryAuditableServices = new QueryAuditableServices(queryAuditableServicesRequest);
            Iam.this.initialize((AbstractGoogleClientRequest<?>)queryAuditableServices);
            return queryAuditableServices;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class QueryAuditableServices
        extends IamRequest<QueryAuditableServicesResponse> {
            private static final String REST_PATH = "v1/iamPolicies:queryAuditableServices";

            protected QueryAuditableServices(QueryAuditableServicesRequest queryAuditableServicesRequest) {
                super(Iam.this, "POST", REST_PATH, (Object)queryAuditableServicesRequest, QueryAuditableServicesResponse.class);
            }

            public QueryAuditableServices set$Xgafv(String string) {
                return (QueryAuditableServices)super.set$Xgafv(string);
            }

            public QueryAuditableServices setAccessToken(String string) {
                return (QueryAuditableServices)super.setAccessToken(string);
            }

            public QueryAuditableServices setAlt(String string) {
                return (QueryAuditableServices)super.setAlt(string);
            }

            public QueryAuditableServices setCallback(String string) {
                return (QueryAuditableServices)super.setCallback(string);
            }

            public QueryAuditableServices setFields(String string) {
                return (QueryAuditableServices)super.setFields(string);
            }

            public QueryAuditableServices setKey(String string) {
                return (QueryAuditableServices)super.setKey(string);
            }

            public QueryAuditableServices setOauthToken(String string) {
                return (QueryAuditableServices)super.setOauthToken(string);
            }

            public QueryAuditableServices setPrettyPrint(Boolean bl) {
                return (QueryAuditableServices)super.setPrettyPrint(bl);
            }

            public QueryAuditableServices setQuotaUser(String string) {
                return (QueryAuditableServices)super.setQuotaUser(string);
            }

            public QueryAuditableServices setUploadType(String string) {
                return (QueryAuditableServices)super.setUploadType(string);
            }

            public QueryAuditableServices setUploadProtocol(String string) {
                return (QueryAuditableServices)super.setUploadProtocol(string);
            }

            @Override
            public QueryAuditableServices set(String string, Object object) {
                return (QueryAuditableServices)super.set(string, object);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class LintPolicy
        extends IamRequest<LintPolicyResponse> {
            private static final String REST_PATH = "v1/iamPolicies:lintPolicy";

            protected LintPolicy(LintPolicyRequest lintPolicyRequest) {
                super(Iam.this, "POST", REST_PATH, (Object)lintPolicyRequest, LintPolicyResponse.class);
            }

            public LintPolicy set$Xgafv(String string) {
                return (LintPolicy)super.set$Xgafv(string);
            }

            public LintPolicy setAccessToken(String string) {
                return (LintPolicy)super.setAccessToken(string);
            }

            public LintPolicy setAlt(String string) {
                return (LintPolicy)super.setAlt(string);
            }

            public LintPolicy setCallback(String string) {
                return (LintPolicy)super.setCallback(string);
            }

            public LintPolicy setFields(String string) {
                return (LintPolicy)super.setFields(string);
            }

            public LintPolicy setKey(String string) {
                return (LintPolicy)super.setKey(string);
            }

            public LintPolicy setOauthToken(String string) {
                return (LintPolicy)super.setOauthToken(string);
            }

            public LintPolicy setPrettyPrint(Boolean bl) {
                return (LintPolicy)super.setPrettyPrint(bl);
            }

            public LintPolicy setQuotaUser(String string) {
                return (LintPolicy)super.setQuotaUser(string);
            }

            public LintPolicy setUploadType(String string) {
                return (LintPolicy)super.setUploadType(string);
            }

            public LintPolicy setUploadProtocol(String string) {
                return (LintPolicy)super.setUploadProtocol(string);
            }

            @Override
            public LintPolicy set(String string, Object object) {
                return (LintPolicy)super.set(string, object);
            }
        }
    }
}

