/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.text.quicksearch.internal.core;

import java.util.PriorityQueue;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.text.quicksearch.internal.core.priority.DefaultPriorityFunction;
import org.eclipse.text.quicksearch.internal.core.priority.PriorityFunction;
import org.eclipse.text.quicksearch.internal.ui.Messages;
import org.eclipse.text.quicksearch.internal.ui.QuickSearchActivator;

public abstract class ResourceWalker
extends Job {
    private PriorityQueue<QItem> queue = null;
    private boolean suspend = false;
    private PriorityFunction prioritFun = new DefaultPriorityFunction();

    public ResourceWalker() {
        super(Messages.QuickSearchDialog_title);
        this.init();
    }

    protected void init() {
        this.queue = new PriorityQueue();
        this.queue.add(new QItem(0.0, (IResource)ResourcesPlugin.getWorkspace().getRoot()));
    }

    public boolean isDone() {
        return this.queue == null;
    }

    public void suspend() {
        this.suspend = true;
    }

    public void stop() {
        this.queue = null;
        this.suspend = false;
    }

    public void resume() {
        if (this.isDone()) {
            return;
        }
        this.suspend = false;
        this.schedule();
    }

    public IStatus run(IProgressMonitor monitor) {
        while (!this.suspend && this.queue != null) {
            if (monitor.isCanceled()) {
                this.queue = null;
                continue;
            }
            IResource r = this.getWork();
            if (r != null) {
                IFile f;
                if (r instanceof IFile) {
                    f = (IFile)r;
                    this.visit(f, monitor);
                    continue;
                }
                if (!(r instanceof IContainer) || !(f = (IContainer)r).isAccessible()) continue;
                try {
                    IResource[] iResourceArray = f.members();
                    int n = iResourceArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IResource child = iResourceArray[n2];
                        this.enqueue(child);
                        ++n2;
                    }
                }
                catch (CoreException e) {
                    QuickSearchActivator.log(e);
                }
                continue;
            }
            this.queue = null;
        }
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    private void enqueue(IResource child) {
        PriorityQueue<QItem> q = this.queue;
        if (q != null) {
            double p = this.priority(child);
            if (p == Double.NEGATIVE_INFINITY) {
                return;
            }
            q.add(new QItem(p, child));
        }
    }

    protected abstract void visit(IFile var1, IProgressMonitor var2);

    final double priority(IResource r) {
        return this.prioritFun.priority(r);
    }

    public void setPriorityFun(PriorityFunction f) {
        Assert.isNotNull((Object)f, (String)"PriorityFunction should never be null");
        this.prioritFun = f;
    }

    private IResource getWork() {
        PriorityQueue<QItem> q = this.queue;
        if (q != null && !q.isEmpty()) {
            return ((QItem)q.remove()).resource;
        }
        return null;
    }

    private static class QItem
    implements Comparable<QItem> {
        public final double priority;
        public final IResource resource;

        public QItem(double p, IResource r) {
            this.priority = p;
            this.resource = r;
        }

        @Override
        public int compareTo(QItem other) {
            return Double.compare(other.priority, this.priority);
        }
    }
}

