/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.access.DBAPasswordChangeInfo;
import org.jkiss.dbeaver.model.access.DBAUserPasswordManager;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.navigator.DBNDataSource;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.internal.UIConnectionMessages;
import org.jkiss.dbeaver.ui.navigator.NavigatorUtils;

public class ChangePasswordDialogHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent executionEvent) throws ExecutionException {
        DBAUserPasswordManager changePassword;
        DBNDataSource dataSource;
        DBPDataSourceContainer dataSourceContainer;
        DBPDataSource dbpDataSource;
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)executionEvent);
        if (!(selection instanceof IStructuredSelection)) {
            return null;
        }
        DBNNode node = NavigatorUtils.getSelectedNode((ISelection)selection);
        if (node instanceof DBNDataSource && (dbpDataSource = (dataSourceContainer = (dataSource = (DBNDataSource)node).getDataSourceContainer()).getDataSource()) instanceof IAdaptable && (changePassword = (DBAUserPasswordManager)((IAdaptable)dbpDataSource).getAdapter(DBAUserPasswordManager.class)) != null) {
            DBPConnectionConfiguration connectionInfo = dataSourceContainer.getConnectionConfiguration();
            String oldPassword = connectionInfo.getUserPassword();
            String userName = connectionInfo.getUserName();
            DBAPasswordChangeInfo userPassword = DBWorkbench.getPlatformUI().promptUserPasswordChange(UIConnectionMessages.dialog_user_password_change_label, userName, oldPassword, false, false);
            if (userPassword != null) {
                String newPassword = userPassword.getNewPassword();
                try {
                    UIUtils.runInProgressService(monitor -> {
                        try {
                            changePassword.changeUserPassword(monitor, userName, newPassword, oldPassword);
                            if (DBWorkbench.getPlatformUI().confirmAction(UIConnectionMessages.dialog_user_password_change_question_label, UIConnectionMessages.dialog_user_password_change_question_message)) {
                                connectionInfo.setUserPassword(newPassword);
                                dataSourceContainer.getRegistry().flushConfig();
                            }
                        }
                        catch (DBException e) {
                            DBWorkbench.getPlatformUI().showError("Change user password", "Password change error for user: " + userName, (Throwable)e);
                        }
                    });
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (InterruptedException e) {
                    DBWorkbench.getPlatformUI().showError("Change user password", "User password change error", (Throwable)e);
                }
            }
        }
        return null;
    }
}

