/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.netezza.model;

import com.dbeaver.db.netezza.model.NetezzaGenericDatabase;
import com.dbeaver.db.netezza.model.NetezzaSourceObject;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.generic.model.GenericSequence;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyLength;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class NetezzaGenericSequence
extends GenericSequence
implements NetezzaSourceObject {
    private String source;
    private String dataTypeName;
    private boolean isCycled;
    private String description;
    private String databaseName;
    private String schemaName;
    private Date createDate;
    private String owner;
    private final int middleMaxValue = Integer.MAX_VALUE;
    private final long maxValue = Long.MAX_VALUE;

    public NetezzaGenericSequence(GenericStructContainer container, String name, String description, @NotNull JDBCResultSet dbResult) {
        super(container, name, description, null, null, null, null);
        this.description = description;
        this.databaseName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"DATABASE");
        this.schemaName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"SCHEMA");
        this.createDate = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"CREATEDATE");
        this.owner = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"OWNER");
    }

    public Number getLastValue() {
        return super.getLastValue();
    }

    public Number getMinValue() {
        return super.getMinValue();
    }

    public Number getMaxValue() {
        return super.getMaxValue();
    }

    public Number getIncrementBy() {
        return super.getIncrementBy();
    }

    @Property(viewable=true, order=2)
    public Number getLastValue(DBRProgressMonitor monitor) throws DBCException {
        this.readSequenceInfo(monitor);
        return super.getLastValue();
    }

    @Property(viewable=true, order=3)
    public Number getMinValue(DBRProgressMonitor monitor) throws DBCException {
        this.readSequenceInfo(monitor);
        return super.getMinValue();
    }

    @Property(viewable=true, order=4)
    public Number getMaxValue(DBRProgressMonitor monitor) throws DBCException {
        this.readSequenceInfo(monitor);
        return super.getMaxValue();
    }

    @Property(viewable=true, order=5)
    public Number getIncrementBy(DBRProgressMonitor monitor) throws DBCException {
        this.readSequenceInfo(monitor);
        return super.getIncrementBy();
    }

    @Property(viewable=true, order=6)
    public boolean isCycled() {
        return this.isCycled;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    @Property(viewable=true, order=7)
    public Date getCreateDate() {
        return this.createDate;
    }

    @Property(viewable=true, order=8)
    public String getOwner() {
        return this.owner;
    }

    @Property(viewable=true, updatable=true, editable=true, length=PropertyLength.MULTILINE, order=10)
    @Nullable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    private void readSequenceInfo(DBRProgressMonitor monitor) throws DBCException {
        if (this.getLastValue() != null) {
            return;
        }
        NetezzaGenericDatabase catalog = null;
        DBSObject parentObject = this.getParentObject();
        boolean hideSchemas = false;
        if (parentObject instanceof NetezzaGenericDatabase) {
            catalog = (NetezzaGenericDatabase)parentObject;
            hideSchemas = true;
        } else if (parentObject instanceof GenericStructContainer) {
            catalog = ((GenericStructContainer)parentObject).getCatalog();
        }
        String fullSeqName = this.getFullyQualifiedName(DBPEvaluationContext.DML);
        if (hideSchemas && CommonUtils.isNotEmpty((String)this.schemaName)) {
            fullSeqName = String.valueOf(DBUtils.getQuotedIdentifier((DBSObject)parentObject)) + "." + DBUtils.getQuotedIdentifier((DBPDataSource)this.getDataSource(), (String)this.schemaName) + "." + DBUtils.getQuotedIdentifier((DBSObject)this);
        }
        String sql = "SELECT s.*, vd.DATATYPE AS DATATYPE_NAME FROM " + fullSeqName + " s JOIN ";
        if (catalog != null) {
            sql = String.valueOf(sql) + DBUtils.getQuotedIdentifier((DBSObject)catalog) + ".DEFINITION_SCHEMA.";
        }
        sql = String.valueOf(sql) + "_V_DATATYPE vd ON s.DATATYPE = vd.OBJID";
        Throwable throwable = null;
        Object var8_9 = null;
        try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Read sequence info");){
            try {
                Throwable throwable2 = null;
                Object var11_15 = null;
                try (JDBCPreparedStatement dbSeqStat = session.prepareStatement(sql);){
                    Throwable throwable3 = null;
                    Object var14_20 = null;
                    try (JDBCResultSet seqResults = dbSeqStat.executeQuery();){
                        if (seqResults.next()) {
                            this.setLastValue(JDBCUtils.safeGetLong((ResultSet)seqResults, (String)"LAST_VALUE"));
                            this.setMinValue(JDBCUtils.safeGetLong((ResultSet)seqResults, (String)"MIN_VALUE"));
                            this.setMaxValue(JDBCUtils.safeGetLong((ResultSet)seqResults, (String)"MAX_VALUE"));
                            this.setIncrementBy(JDBCUtils.safeGetLong((ResultSet)seqResults, (String)"INCREMENT_BY"));
                            this.dataTypeName = JDBCUtils.safeGetString((ResultSet)seqResults, (String)"DATATYPE_NAME");
                            this.isCycled = JDBCUtils.safeGetBoolean((ResultSet)seqResults, (String)"IS_CYCLED");
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable2 == null) {
                        throwable2 = throwable5;
                    } else if (throwable2 != throwable5) {
                        throwable2.addSuppressed(throwable5);
                    }
                    throw throwable2;
                }
            }
            catch (SQLException e) {
                throw new DBCException("Error reading sequence last value", (Throwable)e);
            }
        }
        catch (Throwable throwable6) {
            if (throwable == null) {
                throwable = throwable6;
            } else if (throwable != throwable6) {
                throwable.addSuppressed(throwable6);
            }
            throw throwable;
        }
    }

    public String getObjectDefinitionText(DBRProgressMonitor monitor, Map<String, Object> options) throws DBException {
        if (this.source == null && this.getLastValue(monitor) != null) {
            StringBuilder ddl = new StringBuilder();
            ddl.append("CREATE SEQUENCE ").append(this.getFullyQualifiedName(DBPEvaluationContext.DML)).append("\nAS ").append(this.dataTypeName).append("\nSTART WITH ").append(this.getLastValue()).append("\nINCREMENT BY ").append(this.getIncrementBy()).append("\nMINVALUE ").append(this.getMinValue());
            Number maxValueSequence = this.getMaxValue();
            if (maxValueSequence.intValue() == Integer.MAX_VALUE) {
                ddl.append("\nNO MAXVALUE");
            } else if (maxValueSequence.longValue() != Long.MAX_VALUE) {
                ddl.append("\nMAXVALUE ").append(maxValueSequence);
            }
            if (this.isCycled) {
                ddl.append("\nCYCLE");
            } else {
                ddl.append("\nNO CYCLE");
            }
            this.source = ddl.toString();
        }
        return this.source;
    }

    @Override
    public void setObjectDefinitionText(String sourceText) throws DBException {
        this.source = sourceText;
    }
}

