/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.netezza.model;

import com.dbeaver.db.netezza.model.NetezzaDataSourceExt;
import com.dbeaver.db.netezza.model.NetezzaTableCache;
import com.dbeaver.db.netezza.model.NetezzaUser;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.generic.model.GenericCatalog;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericSchema;
import org.jkiss.dbeaver.ext.generic.model.TableCache;
import org.jkiss.dbeaver.model.DBPObjectStatistics;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectCache;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.preferences.DBPPropertySource;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.ByteNumberFormat;
import org.jkiss.utils.CommonUtils;

public class NetezzaGenericDatabase
extends GenericCatalog
implements DBPObjectStatistics {
    private static final Log log = Log.getLog(NetezzaGenericDatabase.class);
    private Long databaseFullSize;
    private Long databaseSize;
    private Long databaseFreeSize;
    private final NetezzaUserCache userCache = new NetezzaUserCache();

    public NetezzaGenericDatabase(@NotNull GenericDataSource dataSource, @NotNull String catalogName) {
        super(dataSource, catalogName);
    }

    public Collection<GenericSchema> getSchemaList(DBRProgressMonitor monitor) throws DBException {
        return super.getSchemaList(monitor);
    }

    public Collection<? extends DBSObject> getChildren(@NotNull DBRProgressMonitor monitor) throws DBException {
        List userList = this.userCache.getAllObjects(monitor, (DBSObject)this);
        Collection schemas = this.getSchemas(monitor);
        if (!CommonUtils.isEmpty((Collection)schemas)) {
            return Stream.concat(schemas.stream(), userList.stream()).collect(Collectors.toList());
        }
        List tables = this.getTables(monitor);
        return Stream.concat(userList.stream(), tables.stream()).collect(Collectors.toList());
    }

    public DBSObject getChild(@NotNull DBRProgressMonitor monitor, @NotNull String childName) throws DBException {
        GenericSchema schema;
        if (!CommonUtils.isEmpty((Collection)this.getSchemas(monitor)) && (schema = this.getSchema(monitor, childName)) != null) {
            return schema;
        }
        NetezzaUser user = (NetezzaUser)this.userCache.getObject(monitor, (DBSObject)this, childName);
        if (user != null) {
            return user;
        }
        return this.getTable(monitor, childName);
    }

    public TableCache createTableCache(GenericDataSource datasource) {
        return new NetezzaTableCache(datasource);
    }

    @Association
    public List<NetezzaUser> getUsers(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.userCache.getAllObjects(monitor, (DBSObject)this);
    }

    @Association
    public NetezzaUser getUser(@NotNull DBRProgressMonitor monitor, @NotNull String userName) throws DBException {
        return (NetezzaUser)this.userCache.getObject(monitor, (DBSObject)this, userName);
    }

    public NetezzaUserCache getUserCache() {
        return this.userCache;
    }

    @Property(viewable=false, order=3, category="Statistics", formatter=ByteNumberFormat.class)
    public Long getDatabaseSize(DBRProgressMonitor monitor) {
        this.readStatistics(monitor);
        return this.databaseSize;
    }

    @Property(viewable=false, order=4, category="Statistics", formatter=ByteNumberFormat.class)
    public Long getDatabaseFullSize(DBRProgressMonitor monitor) {
        this.readStatistics(monitor);
        return this.databaseFullSize;
    }

    @Property(viewable=false, order=5, category="Statistics", formatter=ByteNumberFormat.class)
    public Long getDatabaseFreeSize(DBRProgressMonitor monitor) {
        this.readStatistics(monitor);
        return this.databaseFreeSize;
    }

    public boolean hasStatistics() {
        return this.databaseSize != null;
    }

    public long getStatObjectSize() {
        return this.databaseSize == null ? 0L : this.databaseSize;
    }

    @Nullable
    public DBPPropertySource getStatProperties() {
        return null;
    }

    private void readStatistics(DBRProgressMonitor monitor) {
        if (this.hasStatistics()) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (DBCSession session = DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Read database statistics");){
                Throwable throwable2 = null;
                Object var6_10 = null;
                try (JDBCPreparedStatement dbStat = ((JDBCSession)session).prepareStatement("SELECT\n\to.dbname AS DATABASENAME,\n\tSUM(z.ALLOCATED_BYTES) AS ALLOCATESPACE,\n\tSUM(z.Used_BYTES) AS USEDSPACE,\n\t(ALLOCATESPACE-USEDSPACE) AS FREESPACE\nFROM\n\tSYSTEM.DEFINITION_SCHEMA._V_SYS_OBJECT_STORAGE_SIZE z\nJOIN _v_object_data o ON\n\to.objid = z.tblid\nWHERE DATABASENAME = ?\nGROUP BY\n\to.dbname");){
                    dbStat.setString(1, this.getName());
                    Throwable throwable3 = null;
                    Object var9_15 = null;
                    try (JDBCResultSet dbResult = dbStat.executeQuery();){
                        if (dbResult.next()) {
                            this.fetchStatistics(dbResult);
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable2 == null) {
                        throwable2 = throwable5;
                    } else if (throwable2 != throwable5) {
                        throwable2.addSuppressed(throwable5);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable6) {
                if (throwable == null) {
                    throwable = throwable6;
                } else if (throwable != throwable6) {
                    throwable.addSuppressed(throwable6);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            log.error((Object)"Error reading database statistics", (Throwable)e);
        }
    }

    void fetchStatistics(JDBCResultSet dbResult) throws SQLException {
        this.databaseFullSize = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"ALLOCATESPACE");
        this.databaseSize = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"USEDSPACE");
        this.databaseFreeSize = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"FREESPACE");
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.userCache.clearCache();
        return super.refreshObject(monitor);
    }

    private static class NetezzaUserCache
    extends JDBCObjectCache<NetezzaGenericDatabase, NetezzaUser> {
        private NetezzaUserCache() {
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull NetezzaGenericDatabase database) throws SQLException {
            return session.prepareStatement("SELECT * FROM " + DBUtils.getQuotedIdentifier((DBSObject)database) + ".DEFINITION_SCHEMA._V_USER");
        }

        @Nullable
        protected NetezzaUser fetchObject(@NotNull JDBCSession session, @NotNull NetezzaGenericDatabase database, @NotNull JDBCResultSet resultSet) {
            String userName = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"USERNAME");
            if (!CommonUtils.isEmpty((String)userName)) {
                return new NetezzaUser(userName, (NetezzaDataSourceExt)database.getDataSource(), database, resultSet);
            }
            return null;
        }
    }
}

