/*
 * Decompiled with CFR 0.152.
 */
package org.netezza.sql.query.parser;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netezza.internal.ParseException;
import org.netezza.sql.NzConnection;
import org.netezza.sql.query.NzCallableQuery;
import org.netezza.sql.query.parser.ParameterizedQueryParser;
import org.netezza.sql.query.parser.SimpleQueryParser;

public final class CallableQueryParser
extends SimpleQueryParser
implements ParameterizedQueryParser {
    private NzCallableQuery callableQuery;
    private int paramIndex;

    public CallableQueryParser(NzConnection connection, NzCallableQuery callableQuery) {
        super(connection, callableQuery, callableQuery.getQuery(), callableQuery.getIndexOfLastCloseBrace());
        this.callableQuery = callableQuery;
    }

    public NzCallableQuery.ParseResult validate() throws ParseException {
        String method = "validate";
        this.connection.LOGGER.entry(this.getClass(), method);
        if (this.isInVaildProcedureCall(this.callableQuery.getIndexOfFirstOpenBrace(), this.callableQuery.getIndexOfLastCloseBrace())) {
            this.connection.LOGGER.exit(this.getClass(), method);
            return NzCallableQuery.ParseResult.INVALID_PROCEDURE;
        }
        if (this.isProcedureCall(this.callableQuery.getIndexOfFirstOpenBrace(), this.callableQuery.getIndexOfLastCloseBrace())) {
            this.connection.LOGGER.exit(this.getClass(), method);
            return NzCallableQuery.ParseResult.PROCEDURE_CALL;
        }
        this.connection.LOGGER.exit(this.getClass(), method);
        return NzCallableQuery.ParseResult.NOT_A_PROCEDURE;
    }

    @Override
    public NzCallableQuery parse() throws ParseException {
        String method = "parse";
        this.connection.LOGGER.entry(this.getClass(), method);
        this.curPos = this.callableQuery.getIndexOfFirstOpenBrace() + 1;
        char c = '\u0000';
        block8: while (this.curPos < this.queryLength) {
            c = this.queryString.charAt(this.curPos++);
            switch (c) {
                case '\"': 
                case '\'': {
                    this.curPos = this.processStringLiterals(c);
                    continue block8;
                }
                case '/': {
                    this.nativeQueryToken.append(c);
                    this.parameterizedQueryToken.append(c);
                    if (this.curPos == this.queryLength) continue block8;
                    this.curPos = this.processMultiLineComment();
                    continue block8;
                }
                case '-': {
                    this.nativeQueryToken.append(c);
                    this.parameterizedQueryToken.append(c);
                    if (this.curPos == this.queryLength) continue block8;
                    this.curPos = this.processSingleLineComment();
                    continue block8;
                }
                case '?': {
                    this.curPos = this.processPrameterMarker();
                    continue block8;
                }
                case '{': {
                    this.curPos = this.processEscapedFunctionCalls(c);
                    continue block8;
                }
                case ' ': {
                    this.nativeQueryToken.append(c);
                    this.parameterizedQueryToken.append(c);
                    this.curPos = this.removeWhiteSpaces();
                    continue block8;
                }
            }
            this.nativeQueryToken.append(c);
            this.parameterizedQueryToken.append(c);
        }
        this.callableQuery.update(this.nativeQueryToken, this.parameterizedQueryToken);
        this.callableQuery.getParam().update(this.paramIndex);
        this.connection.LOGGER.debug(this.getClass(), method, "Native Query: " + this.nativeQueryToken);
        this.connection.LOGGER.exit(this.getClass(), method);
        return this.callableQuery;
    }

    @Override
    public int processPrameterMarker() {
        String method = "processPrameterMarker";
        this.connection.LOGGER.entry(this.getClass(), method);
        ++this.paramIndex;
        if (this.curPos == this.queryLength) {
            this.connection.LOGGER.exit(this.getClass(), method);
            return this.curPos;
        }
        this.curPos = this.removeWhiteSpaces();
        if (this.curPos == this.queryLength) {
            this.connection.LOGGER.exit(this.getClass(), method);
            return this.curPos;
        }
        char next = this.queryString.charAt(this.curPos);
        if (next == '=') {
            this.processOutParameters();
            ++this.curPos;
            this.connection.LOGGER.exit(this.getClass(), method);
            return this.curPos;
        }
        this.processInParameters();
        this.connection.LOGGER.exit(this.getClass(), method);
        return this.curPos;
    }

    private boolean isInVaildProcedureCall(int indexOfFirstOpenBrace, int indexOfLastCloseBrace) throws ParseException {
        Pattern pattern = Pattern.compile("(\\?\\s*=)?\\s*call", 2);
        if (indexOfFirstOpenBrace != 0) {
            Matcher matcher = pattern.matcher(this.queryString.trim());
            return matcher.find() && matcher.start() == 0;
        }
        if (indexOfFirstOpenBrace == 0 && (indexOfLastCloseBrace < 0 || indexOfLastCloseBrace != this.callableQuery.getQuery().length() - 1)) {
            return true;
        }
        String strippedQuery = this.queryString.substring(indexOfFirstOpenBrace + 1, indexOfLastCloseBrace).trim();
        Matcher matcher = pattern.matcher(strippedQuery);
        if (matcher.find()) {
            return matcher.start() != 0;
        }
        return true;
    }

    private boolean isProcedureCall(int indexOfFirstOpenBrace, int indexOfLastCloseBrace) throws ParseException {
        return indexOfFirstOpenBrace == 0;
    }

    private void processInParameters() {
        this.callableQuery.getParam().getInParam().getInParamIndex().add(this.paramIndex);
        this.parameterizedQueryToken.append(this.callableQuery.shouldAddZero() ? "0" : null);
        this.callableQuery.update(this.nativeQueryToken, this.parameterizedQueryToken);
        this.nativeQueryToken.setLength(0);
        this.parameterizedQueryToken.setLength(0);
    }

    private void processOutParameters() {
        this.callableQuery.getParam().getOutParam().update(this.paramIndex);
    }
}

