/*
 * Decompiled with CFR 0.152.
 */
package org.netezza.internal;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.net.SocketTimeoutException;
import org.netezza.datasource.NzDatasource;

public class NzSocket {
    private Socket socket;
    private InputStream in;
    private BufferedOutputStream out;
    private final NzDatasource datasource;

    public NzSocket(NzDatasource datasource) {
        this.datasource = datasource;
    }

    public void open() throws IOException {
        String host = this.datasource.getHost();
        int port = this.datasource.getPort();
        Socket socket = new Socket(host, port);
        socket.setTcpNoDelay(true);
        this.refreshStreams(socket);
    }

    public void refreshStreams(Socket socket) throws IOException {
        int buffSize = this.datasource.getSocketBufferSize();
        this.in = new BufferedInputStream(socket.getInputStream(), buffSize);
        this.out = new BufferedOutputStream(socket.getOutputStream(), buffSize);
        this.socket = socket;
    }

    public void sendInt(int i, int size) throws IOException {
        byte[] buf = new byte[size];
        while (size-- > 0) {
            buf[size] = (byte)(i & 0xFF);
            i >>= 8;
        }
        this.sendBytes(buf);
    }

    public void sendChar(char val) throws IOException {
        this.out.write(val);
    }

    public void sendByte(byte b) throws IOException {
        this.out.write(b);
    }

    public void sendBytes(byte[] bs) throws IOException {
        this.out.write(bs);
    }

    public void sendBytes(byte[] bs, int len) throws IOException {
        this.sendBytes(bs, 0, len);
    }

    public void sendBytes(byte[] bs, int off, int len) throws IOException {
        this.out.write(bs, off, bs.length - off < len ? bs.length - off : len);
        if (bs.length - off < len) {
            for (int i = bs.length - off; i < len; ++i) {
                this.out.write(0);
            }
        }
    }

    public byte receiveByte() throws IOException {
        return (byte)this.in.read();
    }

    public int receiveInt() throws IOException {
        return this.in.read();
    }

    public char receiveChar() throws IOException {
        return (char)this.receiveByte();
    }

    public int receiveInt(int len) throws IOException {
        int n = 0;
        for (int i = 0; i < len; ++i) {
            int b = this.in.read();
            if (b < 0) {
                throw new IOException("The action you have attempted has caused the back end to close the connection.");
            }
            n |= b << 8 * i;
        }
        return n;
    }

    public int receiveIntR(int len) throws IOException {
        int n = 0;
        for (int i = 0; i < len; ++i) {
            int b = this.in.read();
            if (b < 0) {
                throw new IOException("The action you have attempted has caused the back end to close the connection.");
            }
            n = b | n << 8;
        }
        return n;
    }

    public byte[] receiveBytes(int len) throws IOException {
        byte[] bs = new byte[len];
        this.receiveBytes(bs, 0, len);
        return bs;
    }

    public int receiveBytes(byte[] b, int off, int len) throws IOException {
        int s;
        int w;
        for (s = 0; s < len; s += w) {
            w = this.in.read(b, off + s, len - s);
            if (w >= 0) continue;
            throw new IOException("The action you have attempted has caused the back end to close the connection.");
        }
        return s;
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void close() throws IOException {
        this.in.close();
        this.out.close();
        this.socket.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDataAvailable(long qTimeout) throws IOException {
        if (this.in.available() > 0) {
            return true;
        }
        try {
            this.in.mark(1);
            this.socket.setSoTimeout((int)qTimeout);
            this.in.read();
            boolean bl = true;
            return bl;
        }
        catch (SocketTimeoutException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.in.reset();
            this.socket.setSoTimeout(0);
        }
    }

    public void resetSocket() throws IOException {
        int cmdnum = 1;
        int cmdleng = 1;
        boolean clear = false;
        this.sendChar('P');
        this.sendInt(cmdnum, 4);
        this.sendBytes(" ".getBytes());
        this.sendChar('\u0000');
        this.flush();
        block4: while (true) {
            char id = this.receiveChar();
            int command_number = this.receiveIntR(4);
            cmdleng = this.receiveIntR(4);
            switch (id) {
                case 'I': {
                    this.receiveChar();
                    if (command_number != cmdnum) continue block4;
                    clear = true;
                    continue block4;
                }
                case 'Z': {
                    if (!clear || command_number != cmdnum) break;
                    return;
                }
            }
            this.receiveBytes(cmdleng);
        }
    }

    public Socket getSocket() {
        return this.socket;
    }
}

