/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.db2.model.DB2DataSource;
import org.jkiss.dbeaver.ext.db2.model.DB2IndexColumn;
import org.jkiss.dbeaver.ext.db2.model.DB2Schema;
import org.jkiss.dbeaver.ext.db2.model.DB2TableBase;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2IndexPageSplit;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2IndexType;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2UniqueRule;
import org.jkiss.dbeaver.ext.db2.model.dict.DB2YesNo;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTable;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTableIndex;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.meta.PropertyLength;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;
import org.jkiss.dbeaver.model.struct.rdb.DBSIndexType;
import org.jkiss.utils.CommonUtils;

public class DB2Index
extends JDBCTableIndex<DB2Schema, DB2TableBase> {
    private static final Log LOG = Log.getLog(DB2Index.class);
    private DB2UniqueRule uniqueRule;
    private Integer colCount;
    private Integer uniqueColCount;
    private DB2IndexType db2IndexType;
    private Integer pctFree;
    private Integer indexId;
    private Integer minPctUsed;
    private Boolean reverseScans;
    private Integer tablespaceId;
    private DB2IndexPageSplit pageSplit;
    private Boolean compression;
    private String remarks;
    private Timestamp createTime;
    private Boolean madeUnique;
    private Timestamp statsTime;
    private Long fullKeycard;
    private Long firstKeycard;
    private Long first2Keycard;
    private Long first3Keycard;
    private Long first4Keycard;
    private Integer clusterRatio;

    public DB2Index(DBRProgressMonitor monitor, DB2Schema schema, DB2TableBase table, ResultSet dbResult) {
        super((DBSObjectContainer)schema, (JDBCTable)table, JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"INDNAME"), null, true);
        DB2DataSource db2DataSource = schema.getDataSource();
        this.uniqueRule = (DB2UniqueRule)CommonUtils.valueOf(DB2UniqueRule.class, (String)JDBCUtils.safeGetString((ResultSet)dbResult, (String)"UNIQUERULE"));
        this.colCount = JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"COLCOUNT");
        this.uniqueColCount = JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"UNIQUE_COLCOUNT");
        this.pctFree = JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"PCTFREE");
        this.indexId = JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"IID");
        this.minPctUsed = JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"MINPCTUSED");
        this.reverseScans = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"REVERSE_SCANS", (String)DB2YesNo.Y.name());
        this.tablespaceId = JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"TBSPACEID");
        this.pageSplit = (DB2IndexPageSplit)CommonUtils.valueOf(DB2IndexPageSplit.class, (String)JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"PAGESPLIT"));
        this.remarks = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"REMARKS");
        this.createTime = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"CREATE_TIME");
        this.madeUnique = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"MADE_UNIQUE");
        this.statsTime = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"STATS_TIME");
        this.fullKeycard = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"FULLKEYCARD");
        this.firstKeycard = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"FIRSTKEYCARD");
        this.first2Keycard = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"FIRST2KEYCARD");
        this.first3Keycard = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"FIRST3KEYCARD");
        this.first4Keycard = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"FIRST4KEYCARD");
        this.clusterRatio = JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"CLUSTERRATIO");
        if (db2DataSource.isAtLeastV9_5()) {
            this.compression = JDBCUtils.safeGetBoolean((ResultSet)dbResult, (String)"COMPRESSION", (String)DB2YesNo.Y.name());
        }
        this.db2IndexType = (DB2IndexType)CommonUtils.valueOf(DB2IndexType.class, (String)JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"INDEXTYPE"));
        this.indexType = this.db2IndexType == null ? DBSIndexType.UNKNOWN : this.db2IndexType.getDBSIndexType();
    }

    public DB2Index(DB2TableBase db2Table, String indexName, DBSIndexType indexType, DB2UniqueRule uniqueRule) {
        super((DBSObjectContainer)db2Table.getSchema(), (JDBCTable)db2Table, indexName, indexType, false);
        this.uniqueRule = uniqueRule;
    }

    public boolean isUnique() {
        return this.uniqueRule.isUnique();
    }

    @NotNull
    public DB2DataSource getDataSource() {
        return (DB2DataSource)((DB2TableBase)this.getTable()).getDataSource();
    }

    @NotNull
    public String getFullyQualifiedName(DBPEvaluationContext context) {
        return String.valueOf(((DB2Schema)this.getContainer()).getName()) + "." + this.getName();
    }

    public List<DB2IndexColumn> getAttributeReferences(DBRProgressMonitor monitor) {
        try {
            return ((DB2Schema)this.getContainer()).getIndexCache().getChildren(monitor, (DB2Schema)this.getContainer(), (DBSObject)this);
        }
        catch (DBException e) {
            LOG.error((Object)"DBException swallowed during getAttributeReferences", (Throwable)e);
            return null;
        }
    }

    public void addColumn(DB2IndexColumn ixColumn) {
        DBSObjectCache cols = ((DB2Schema)this.getContainer()).getIndexCache().getChildrenCache((DBSObject)this);
        cols.cacheObject((DBSObject)ixColumn);
    }

    @Property(viewable=true, editable=true, valueTransformer=DBObjectNameCaseTransformer.class, order=1)
    @NotNull
    public String getName() {
        return super.getName();
    }

    @Property(viewable=true, editable=false, order=2)
    public DB2Schema getIndSchema() {
        return (DB2Schema)this.getContainer();
    }

    @Property(viewable=true, editable=false, order=5)
    public DB2UniqueRule getUniqueRule() {
        return this.uniqueRule;
    }

    public void setUniqueRule(DB2UniqueRule uniqueRule) {
        this.uniqueRule = uniqueRule;
    }

    @Property(viewable=false, editable=false, order=10)
    public Boolean getMadeUnique() {
        return this.madeUnique;
    }

    @Property(viewable=false, editable=false, order=11)
    public Integer getColCount() {
        return this.colCount;
    }

    @Property(viewable=false, editable=false, order=12)
    public Integer getUniqueColCount() {
        return this.uniqueColCount;
    }

    @Property(viewable=false, editable=false, order=70)
    public Integer getIndexId() {
        return this.indexId;
    }

    @Property(viewable=false, editable=false, order=71)
    public Integer getTablespaceId() {
        return this.tablespaceId;
    }

    @Property(viewable=false, order=20, editable=false)
    public Integer getPctFree() {
        return this.pctFree;
    }

    @Property(viewable=false, order=21, editable=false)
    public Integer getMinPctUsed() {
        return this.minPctUsed;
    }

    @Property(viewable=false, order=22, editable=false)
    public Boolean getReverseScans() {
        return this.reverseScans;
    }

    @Property(viewable=false, order=23, editable=false)
    public DB2IndexPageSplit getPageSplit() {
        return this.pageSplit;
    }

    @Property(viewable=false, order=24, editable=false)
    public Boolean getCompression() {
        return this.compression;
    }

    @Property(viewable=false, editable=false, length=PropertyLength.MULTILINE)
    @Nullable
    public String getDescription() {
        return this.remarks;
    }

    @Property(viewable=false, editable=false, category="Date & Time")
    public Timestamp getCreateTime() {
        return this.createTime;
    }

    @Property(viewable=false, editable=false, order=30, category="Statistics")
    public Timestamp getStatsTime() {
        return this.statsTime;
    }

    @Property(viewable=true, editable=false, order=31, category="Statistics")
    public Long getFullKeycard() {
        return this.fullKeycard;
    }

    @Property(viewable=false, editable=false, order=32, category="Statistics")
    public Long getFirstKeycard() {
        return this.firstKeycard;
    }

    @Property(viewable=false, editable=false, order=33, category="Statistics")
    public Long getFirst2Keycard() {
        return this.first2Keycard;
    }

    @Property(viewable=false, editable=false, order=34, category="Statistics")
    public Long getFirst3Keycard() {
        return this.first3Keycard;
    }

    @Property(viewable=false, editable=false, order=35, category="Statistics")
    public Long getFirst4Keycard() {
        return this.first4Keycard;
    }

    @Property(viewable=false, editable=false, order=36, category="Statistics")
    public Integer getClusterRatio() {
        return this.clusterRatio;
    }
}

