/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.model;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.db2.DB2Constants;
import org.jkiss.dbeaver.ext.db2.DB2DataSourceProvider;
import org.jkiss.dbeaver.ext.db2.DB2Messages;
import org.jkiss.dbeaver.ext.db2.DB2SQLDialect;
import org.jkiss.dbeaver.ext.db2.DB2Utils;
import org.jkiss.dbeaver.ext.db2.editors.DB2StructureAssistant;
import org.jkiss.dbeaver.ext.db2.info.DB2Parameter;
import org.jkiss.dbeaver.ext.db2.info.DB2XMLString;
import org.jkiss.dbeaver.ext.db2.model.DB2Bufferpool;
import org.jkiss.dbeaver.ext.db2.model.DB2CurrentUserPrivileges;
import org.jkiss.dbeaver.ext.db2.model.DB2DataSourceInfo;
import org.jkiss.dbeaver.ext.db2.model.DB2DataType;
import org.jkiss.dbeaver.ext.db2.model.DB2ExecutionContext;
import org.jkiss.dbeaver.ext.db2.model.DB2PlanConfig;
import org.jkiss.dbeaver.ext.db2.model.DB2Schema;
import org.jkiss.dbeaver.ext.db2.model.DB2StorageGroup;
import org.jkiss.dbeaver.ext.db2.model.DB2Tablespace;
import org.jkiss.dbeaver.ext.db2.model.DB2Variable;
import org.jkiss.dbeaver.ext.db2.model.app.DB2ServerApplicationManager;
import org.jkiss.dbeaver.ext.db2.model.fed.DB2RemoteServer;
import org.jkiss.dbeaver.ext.db2.model.fed.DB2UserMapping;
import org.jkiss.dbeaver.ext.db2.model.fed.DB2Wrapper;
import org.jkiss.dbeaver.ext.db2.model.plan.DB2PlanAnalyser;
import org.jkiss.dbeaver.ext.db2.model.security.DB2AuthIDType;
import org.jkiss.dbeaver.ext.db2.model.security.DB2Grantee;
import org.jkiss.dbeaver.ext.db2.model.security.DB2GranteeCache;
import org.jkiss.dbeaver.ext.db2.model.security.DB2Role;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceInfo;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.DBPObjectStatisticsCollector;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.admin.sessions.DBAServerSessionManager;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.edit.DBEObjectConfigurator;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCDatabaseMetaData;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.exec.plan.DBCPlan;
import org.jkiss.dbeaver.model.exec.plan.DBCPlanStyle;
import org.jkiss.dbeaver.model.exec.plan.DBCQueryPlanner;
import org.jkiss.dbeaver.model.exec.plan.DBCQueryPlannerConfiguration;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCExecutionContext;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCRemoteInstance;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectSimpleCache;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSStructureAssistant;
import org.jkiss.dbeaver.model.struct.cache.DBSObjectCache;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class DB2DataSource
extends JDBCDataSource
implements DBCQueryPlanner,
IAdaptable,
DBPObjectStatisticsCollector {
    private static final Log log = Log.getLog(DB2DataSource.class);
    private static final String GET_SESSION_USER = "VALUES(SESSION_USER)";
    private static final String C_SCHEMA = "SELECT * FROM SYSCAT.SCHEMATA ORDER BY SCHEMANAME WITH UR";
    private static final String C_DT = "SELECT * FROM SYSCAT.DATATYPES WHERE METATYPE = 'S' ORDER BY TYPESCHEMA,TYPENAME WITH UR";
    private static final String C_BP = "SELECT * FROM SYSCAT.BUFFERPOOLS ORDER BY BPNAME WITH UR";
    private static final String C_TS = "SELECT * FROM SYSCAT.TABLESPACES ORDER BY TBSPACE WITH UR";
    private static final String C_SG = "SELECT * FROM SYSCAT.STOGROUPS ORDER BY SGNAME WITH UR";
    private static final String C_RL = "SELECT * FROM SYSCAT.ROLES ORDER BY ROLENAME WITH UR";
    private static final String C_VR = "SELECT * FROM SYSCAT.VARIABLES WHERE VARMODULENAME IS NULL ORDER BY VARNAME WITH UR";
    private static final String C_SV = "SELECT * FROM SYSCAT.SERVERS ORDER BY SERVERNAME WITH UR";
    private static final String C_WR = "SELECT * FROM SYSCAT.WRAPPERS ORDER BY WRAPNAME WITH UR";
    private static final String C_UM = "SELECT * FROM SYSCAT.USEROPTIONS WHERE OPTION = 'REMOTE_AUTHID' ORDER BY SERVERNAME,AUTHID WITH UR";
    private final DBSObjectCache<DB2DataSource, DB2Schema> schemaCache = new JDBCObjectSimpleCache(DB2Schema.class, "SELECT * FROM SYSCAT.SCHEMATA ORDER BY SCHEMANAME WITH UR", new Object[0]);
    private final DBSObjectCache<DB2DataSource, DB2DataType> dataTypeCache = new JDBCObjectSimpleCache(DB2DataType.class, "SELECT * FROM SYSCAT.DATATYPES WHERE METATYPE = 'S' ORDER BY TYPESCHEMA,TYPENAME WITH UR", new Object[0]);
    private final DBSObjectCache<DB2DataSource, DB2Bufferpool> bufferpoolCache = new JDBCObjectSimpleCache(DB2Bufferpool.class, "SELECT * FROM SYSCAT.BUFFERPOOLS ORDER BY BPNAME WITH UR", new Object[0]);
    private final DBSObjectCache<DB2DataSource, DB2Tablespace> tablespaceCache = new JDBCObjectSimpleCache(DB2Tablespace.class, "SELECT * FROM SYSCAT.TABLESPACES ORDER BY TBSPACE WITH UR", new Object[0]);
    private final DBSObjectCache<DB2DataSource, DB2RemoteServer> remoteServerCache = new JDBCObjectSimpleCache(DB2RemoteServer.class, "SELECT * FROM SYSCAT.SERVERS ORDER BY SERVERNAME WITH UR", new Object[0]);
    private final DBSObjectCache<DB2DataSource, DB2Wrapper> wrapperCache = new JDBCObjectSimpleCache(DB2Wrapper.class, "SELECT * FROM SYSCAT.WRAPPERS ORDER BY WRAPNAME WITH UR", new Object[0]);
    private final DBSObjectCache<DB2DataSource, DB2UserMapping> userMappingCache = new JDBCObjectSimpleCache(DB2UserMapping.class, "SELECT * FROM SYSCAT.USEROPTIONS WHERE OPTION = 'REMOTE_AUTHID' ORDER BY SERVERNAME,AUTHID WITH UR", new Object[0]);
    private final DB2GranteeCache groupCache = new DB2GranteeCache(DB2AuthIDType.G);
    private final DB2GranteeCache userCache = new DB2GranteeCache(DB2AuthIDType.U);
    private final DBSObjectCache<DB2DataSource, DB2StorageGroup> storagegroupCache = new JDBCObjectSimpleCache(DB2StorageGroup.class, "SELECT * FROM SYSCAT.STOGROUPS ORDER BY SGNAME WITH UR", new Object[0]);
    private final DBSObjectCache<DB2DataSource, DB2Role> roleCache = new JDBCObjectSimpleCache(DB2Role.class, "SELECT * FROM SYSCAT.ROLES ORDER BY ROLENAME WITH UR", new Object[0]);
    private final DBSObjectCache<DB2DataSource, DB2Variable> variableCache = new JDBCObjectSimpleCache(DB2Variable.class, "SELECT * FROM SYSCAT.VARIABLES WHERE VARMODULENAME IS NULL ORDER BY VARNAME WITH UR", new Object[0]);
    private List<DB2Parameter> listDBParameters;
    private List<DB2Parameter> listDBMParameters;
    private List<DB2XMLString> listXMLStrings;
    private DB2CurrentUserPrivileges db2CurrentUserPrivileges;
    private String schemaForExplainTables;
    private Double version;
    private volatile transient boolean hasStatistics;

    public DB2DataSource(DBRProgressMonitor monitor, DBPDataSourceContainer container) throws DBException {
        super(monitor, container, (SQLDialect)new DB2SQLDialect());
        this.hasStatistics = !container.getPreferenceStore().getBoolean("database.stats.expensive");
    }

    public Object getDataSourceFeature(String featureId) {
        switch (featureId) {
            case "datasource.max-string-type-length": {
                return 32764;
            }
        }
        return super.getDataSourceFeature(featureId);
    }

    protected boolean isConnectionReadOnlyBroken() {
        return true;
    }

    public void initialize(@NotNull DBRProgressMonitor monitor) throws DBException {
        super.initialize(monitor);
        try {
            Throwable throwable = null;
            Object var3_6 = null;
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBPDataSource)this, (String)"Load data source meta info");){
                DB2Schema defaultSchema = this.getDefaultSchema();
                if (defaultSchema != null) {
                    this.db2CurrentUserPrivileges = new DB2CurrentUserPrivileges(monitor, session, defaultSchema.getName(), this);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            log.warn((Object)"Error reading active schema", (Throwable)e);
        }
        ((JDBCObjectSimpleCache)this.dataTypeCache).setCaseSensitive(false);
        try {
            this.dataTypeCache.getAllObjects(monitor, (DBSObject)this);
        }
        catch (DBException e) {
            log.warn((Object)"Error reading types info", (Throwable)e);
            this.dataTypeCache.setCache(Collections.emptyList());
        }
    }

    protected JDBCExecutionContext createExecutionContext(JDBCRemoteInstance instance, String type) {
        return new DB2ExecutionContext(instance, type);
    }

    protected void initializeContextState(@NotNull DBRProgressMonitor monitor, @NotNull JDBCExecutionContext context, JDBCExecutionContext initFrom) throws DBException {
        if (initFrom != null) {
            ((DB2ExecutionContext)context).setCurrentSchema(monitor, ((DB2ExecutionContext)initFrom).getDefaultSchema());
        } else {
            ((DB2ExecutionContext)context).refreshDefaults(monitor, true);
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == DBSStructureAssistant.class) {
            return adapter.cast(new DB2StructureAssistant(this));
        }
        if (adapter == DBAServerSessionManager.class) {
            return adapter.cast(new DB2ServerApplicationManager(this));
        }
        return (T)super.getAdapter(adapter);
    }

    public void cacheStructure(@NotNull DBRProgressMonitor monitor, int scope) throws DBException {
    }

    @NotNull
    public DB2DataSource getDataSource() {
        return this;
    }

    protected DBPDataSourceInfo createDataSourceInfo(DBRProgressMonitor monitor, @NotNull JDBCDatabaseMetaData metaData) {
        DB2DataSourceInfo info = new DB2DataSourceInfo(metaData);
        this.version = DB2Constants.DB2v9_1;
        try {
            this.version = Integer.valueOf(metaData.getDatabaseMajorVersion()).doubleValue();
            this.version = this.version + Integer.valueOf(metaData.getDatabaseMinorVersion()).doubleValue() / 10.0;
        }
        catch (SQLException e) {
            log.warn((Object)("SQLException when reading database version. Set it to lowest supported version : " + DB2Constants.DB2v9_1 + " : " + e.getMessage()));
        }
        log.debug((Object)(String.valueOf(this.getName()) + " is version v" + this.version));
        info.setSupportsResultSetScroll(false);
        return info;
    }

    protected Map<String, String> getInternalConnectionProperties(DBRProgressMonitor monitor, DBPDriver driver, JDBCExecutionContext context, String purpose, DBPConnectionConfiguration connectionInfo) throws DBCException {
        HashMap<String, String> props = new HashMap<String, String>();
        props.putAll(DB2DataSourceProvider.getConnectionsProps());
        if (this.getContainer().isConnectionReadOnly()) {
            props.put("readOnly", "true");
        }
        return props;
    }

    protected Connection openConnection(@NotNull DBRProgressMonitor monitor, @Nullable JDBCExecutionContext context, @NotNull String purpose) throws DBCException {
        Connection db2Connection = super.openConnection(monitor, context, purpose);
        if (!this.getContainer().getPreferenceStore().getBoolean("database.meta.client.name.disable")) {
            try {
                db2Connection.setClientInfo("ApplicationName", CommonUtils.truncateString((String)DBUtils.getClientApplicationName((DBPDataSourceContainer)this.getContainer(), (DBCExecutionContext)context, (String)purpose), (int)255));
            }
            catch (Throwable throwable) {}
        }
        return db2Connection;
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        super.refreshObject(monitor);
        this.userCache.clearCache();
        this.groupCache.clearCache();
        this.roleCache.clearCache();
        this.variableCache.clearCache();
        this.tablespaceCache.clearCache();
        this.storagegroupCache.clearCache();
        this.bufferpoolCache.clearCache();
        this.schemaCache.clearCache();
        this.dataTypeCache.clearCache();
        this.remoteServerCache.clearCache();
        this.wrapperCache.clearCache();
        this.userMappingCache.clearCache();
        this.listDBMParameters = null;
        this.listDBParameters = null;
        this.hasStatistics = false;
        this.initialize(monitor);
        return this;
    }

    public Collection<DB2DataType> getLocalDataTypes() {
        try {
            return this.getDataTypes((DBRProgressMonitor)new VoidProgressMonitor());
        }
        catch (DBException e) {
            log.error((Object)"DBException occurred when reading system dataTypes: ", (Throwable)e);
            return null;
        }
    }

    public DB2DataType getLocalDataType(String typeName) {
        try {
            return this.getDataType((DBRProgressMonitor)new VoidProgressMonitor(), typeName);
        }
        catch (DBException e) {
            log.error((Object)("DBException occurred when reading system dataTYpe : " + typeName), (Throwable)e);
            return null;
        }
    }

    @NotNull
    public Class<? extends DB2Schema> getPrimaryChildType(@Nullable DBRProgressMonitor monitor) throws DBException {
        return DB2Schema.class;
    }

    public Collection<DB2Schema> getChildren(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.getSchemas(monitor);
    }

    public DB2Schema getChild(@NotNull DBRProgressMonitor monitor, @NotNull String childName) throws DBException {
        return this.getSchema(monitor, childName);
    }

    public DB2Schema getDefaultSchema() {
        return (DB2Schema)DBUtils.getDefaultContext((DBSObject)this, (boolean)true).getContextDefaults().getDefaultSchema();
    }

    @NotNull
    public DBCPlan planQueryExecution(@NotNull DBCSession session, @NotNull String query, @NotNull DBCQueryPlannerConfiguration configuration) throws DBCException {
        String ptSchemaname = this.getExplainTablesSchemaName(session);
        if (ptSchemaname == null) {
            throw new DBCException(DB2Messages.dialog_explain_no_tables_found_ex);
        }
        DB2PlanAnalyser plan = new DB2PlanAnalyser(query, ptSchemaname);
        plan.explain((JDBCSession)session);
        return plan;
    }

    @NotNull
    public DBCPlanStyle getPlanStyle() {
        return DBCPlanStyle.PLAN;
    }

    private String getExplainTablesSchemaName(DBCSession session) throws DBCException {
        String sessionUserSchema;
        DBRProgressMonitor monitor = session.getProgressMonitor();
        try {
            sessionUserSchema = CommonUtils.trim((String)JDBCUtils.queryString((Connection)((JDBCSession)session), (String)GET_SESSION_USER, (Object[])new Object[0]));
        }
        catch (SQLException e) {
            throw new DBCException((Throwable)e, session.getExecutionContext());
        }
        Boolean ok = DB2Utils.checkExplainTables(monitor, this, sessionUserSchema);
        if (ok.booleanValue()) {
            log.debug((Object)("Valid explain tables found in " + sessionUserSchema));
            this.schemaForExplainTables = sessionUserSchema;
            return this.schemaForExplainTables;
        }
        ok = DB2Utils.checkExplainTables(monitor, this, "SYSTOOLS");
        if (ok.booleanValue()) {
            log.debug((Object)"Valid explain tables found in SYSTOOLS");
            this.schemaForExplainTables = "SYSTOOLS";
            return this.schemaForExplainTables;
        }
        DB2PlanConfig cfg = new DB2PlanConfig();
        DBEObjectConfigurator configurator = (DBEObjectConfigurator)GeneralUtils.adapt((Object)cfg, DBEObjectConfigurator.class);
        if (configurator == null || configurator.configureObject(monitor, (Object)this, (DBPObject)cfg, Collections.emptyMap()) == null) {
            return null;
        }
        String tablespaceName = cfg.getTablespace();
        if (tablespaceName == null) {
            return null;
        }
        DB2Utils.createExplainTables(session.getProgressMonitor(), this, sessionUserSchema, tablespaceName);
        this.schemaForExplainTables = sessionUserSchema;
        return sessionUserSchema;
    }

    @Association
    public Collection<DB2Schema> getSchemas(DBRProgressMonitor monitor) throws DBException {
        return this.schemaCache.getAllObjects(monitor, (DBSObject)this);
    }

    public DB2Schema getSchema(DBRProgressMonitor monitor, String name) throws DBException {
        return (DB2Schema)this.schemaCache.getObject(monitor, (DBSObject)this, name);
    }

    @Association
    public Collection<DB2DataType> getDataTypes(DBRProgressMonitor monitor) throws DBException {
        return this.dataTypeCache.getAllObjects(monitor, (DBSObject)this);
    }

    public DB2DataType getDataType(DBRProgressMonitor monitor, String name) throws DBException {
        return (DB2DataType)this.dataTypeCache.getObject(monitor, (DBSObject)this, name);
    }

    @Association
    public Collection<DB2Tablespace> getTablespaces(DBRProgressMonitor monitor) throws DBException {
        return this.tablespaceCache.getAllObjects(monitor, (DBSObject)this);
    }

    public DB2Tablespace getTablespace(DBRProgressMonitor monitor, String name) throws DBException {
        return (DB2Tablespace)this.tablespaceCache.getObject(monitor, (DBSObject)this, name);
    }

    @Association
    public Collection<DB2StorageGroup> getStorageGroups(DBRProgressMonitor monitor) throws DBException {
        return this.storagegroupCache.getAllObjects(monitor, (DBSObject)this);
    }

    public DB2StorageGroup getStorageGroup(DBRProgressMonitor monitor, String name) throws DBException {
        return (DB2StorageGroup)this.storagegroupCache.getObject(monitor, (DBSObject)this, name);
    }

    @Association
    public Collection<DB2Bufferpool> getBufferpools(DBRProgressMonitor monitor) throws DBException {
        return this.bufferpoolCache.getAllObjects(monitor, (DBSObject)this);
    }

    public DB2Bufferpool getBufferpool(DBRProgressMonitor monitor, String name) throws DBException {
        return (DB2Bufferpool)this.bufferpoolCache.getObject(monitor, (DBSObject)this, name);
    }

    @Association
    public Collection<DB2Wrapper> getWrappers(DBRProgressMonitor monitor) throws DBException {
        return this.wrapperCache.getAllObjects(monitor, (DBSObject)this);
    }

    public DB2Wrapper getWrapper(DBRProgressMonitor monitor, String name) throws DBException {
        return (DB2Wrapper)this.wrapperCache.getObject(monitor, (DBSObject)this, name);
    }

    @Association
    public Collection<DB2UserMapping> getUserMappings(DBRProgressMonitor monitor) throws DBException {
        return this.userMappingCache.getAllObjects(monitor, (DBSObject)this);
    }

    public DB2UserMapping getUserMapping(DBRProgressMonitor monitor, String name) throws DBException {
        return (DB2UserMapping)this.userMappingCache.getObject(monitor, (DBSObject)this, name);
    }

    @Association
    public Collection<DB2RemoteServer> getRemoteServers(DBRProgressMonitor monitor) throws DBException {
        return this.remoteServerCache.getAllObjects(monitor, (DBSObject)this);
    }

    public DB2RemoteServer getRemoteServer(DBRProgressMonitor monitor, String name) throws DBException {
        return (DB2RemoteServer)this.remoteServerCache.getObject(monitor, (DBSObject)this, name);
    }

    @Association
    public Collection<DB2Grantee> getUsers(DBRProgressMonitor monitor) throws DBException {
        return this.userCache.getAllObjects(monitor, (DBSObject)this);
    }

    public DB2Grantee getUser(DBRProgressMonitor monitor, String name) throws DBException {
        return (DB2Grantee)this.userCache.getObject(monitor, (DBSObject)this, name);
    }

    @Association
    public Collection<DB2Grantee> getGroups(DBRProgressMonitor monitor) throws DBException {
        return this.groupCache.getAllObjects(monitor, (DBSObject)this);
    }

    public DB2Grantee getGroup(DBRProgressMonitor monitor, String name) throws DBException {
        return (DB2Grantee)this.groupCache.getObject(monitor, (DBSObject)this, name);
    }

    @Association
    public Collection<DB2Role> getRoles(DBRProgressMonitor monitor) throws DBException {
        return this.roleCache.getAllObjects(monitor, (DBSObject)this);
    }

    public DB2Role getRole(DBRProgressMonitor monitor, String name) throws DBException {
        return (DB2Role)this.roleCache.getObject(monitor, (DBSObject)this, name);
    }

    @Association
    public Collection<DB2Variable> getVariables(DBRProgressMonitor monitor) throws DBException {
        return this.variableCache.getAllObjects(monitor, (DBSObject)this);
    }

    public DB2Variable getVariable(DBRProgressMonitor monitor, String name) throws DBException {
        return (DB2Variable)this.variableCache.getObject(monitor, (DBSObject)this, name);
    }

    public List<DB2Parameter> getDbParameters(DBRProgressMonitor monitor) throws DBException {
        if (this.listDBParameters == null) {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBPDataSource)this, (String)"Load Database Parameters");){
                    this.listDBParameters = DB2Utils.readDBCfg(monitor, session);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (SQLException e) {
                log.warn((Object)e);
            }
        }
        return this.listDBParameters;
    }

    public List<DB2Parameter> getDbmParameters(DBRProgressMonitor monitor) throws DBException {
        if (this.listDBMParameters == null) {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBPDataSource)this, (String)"Load Instance Parameters");){
                    this.listDBMParameters = DB2Utils.readDBMCfg(monitor, session);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (SQLException e) {
                log.warn((Object)e);
            }
        }
        return this.listDBMParameters;
    }

    public List<DB2XMLString> getXmlStrings(DBRProgressMonitor monitor) throws DBException {
        if (this.listXMLStrings == null) {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBPDataSource)this, (String)"Load Global XMLStrings");){
                    this.listXMLStrings = DB2Utils.readXMLStrings(monitor, session);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (SQLException e) {
                log.warn((Object)e);
            }
        }
        return this.listXMLStrings;
    }

    public boolean isAuthorisedForApplications() {
        return this.db2CurrentUserPrivileges != null && this.db2CurrentUserPrivileges.userIsAuthorisedForApplications() != false;
    }

    public boolean isAuthorisedForContainers() {
        return this.db2CurrentUserPrivileges != null && this.db2CurrentUserPrivileges.userIsAuthorisedForContainers() != false;
    }

    public boolean isAuthorisedForDBCFG() {
        return this.db2CurrentUserPrivileges != null && this.db2CurrentUserPrivileges.userIsAuthorisedForDBCFG() != false;
    }

    public boolean isAuthorisedForAdminister() {
        return this.db2CurrentUserPrivileges != null && this.db2CurrentUserPrivileges.userIsAuthorisedForAdminister() != false;
    }

    public boolean isAtLeastV9_5() {
        return this.version >= DB2Constants.DB2v9_5;
    }

    public boolean isAtLeastV9_7() {
        return this.version >= DB2Constants.DB2v9_7;
    }

    public boolean isAtLeastV10_1() {
        return this.version >= DB2Constants.DB2v10_1;
    }

    public boolean isAtLeastV10_5() {
        return this.version >= DB2Constants.DB2v10_5;
    }

    public boolean isAtLeastV11_1() {
        return this.version >= DB2Constants.DB2v11_1;
    }

    public Double getVersion() {
        return this.version;
    }

    public DBSObjectCache<DB2DataSource, DB2Bufferpool> getBufferpoolCache() {
        return this.bufferpoolCache;
    }

    public DBSObjectCache<DB2DataSource, DB2RemoteServer> getRemoteServerCache() {
        return this.remoteServerCache;
    }

    public DBSObjectCache<DB2DataSource, DB2Schema> getSchemaCache() {
        return this.schemaCache;
    }

    public DBSObjectCache<DB2DataSource, DB2DataType> getDataTypeCache() {
        return this.dataTypeCache;
    }

    public DBSObjectCache<DB2DataSource, DB2Tablespace> getTablespaceCache() {
        return this.tablespaceCache;
    }

    public DBSObjectCache<DB2DataSource, DB2StorageGroup> getStorageGroupCache() {
        return this.storagegroupCache;
    }

    public DBSObjectCache<DB2DataSource, DB2Variable> getVariableCache() {
        return this.variableCache;
    }

    public DBSObjectCache<DB2DataSource, DB2Role> getRoleCache() {
        return this.roleCache;
    }

    public DBSObjectCache<DB2DataSource, DB2Wrapper> getWrapperCache() {
        return this.wrapperCache;
    }

    public boolean isStatisticsCollected() {
        return this.hasStatistics;
    }

    public void collectObjectStatistics(DBRProgressMonitor monitor, boolean totalSizeOnly, boolean forceRefresh) throws DBException {
        if (this.hasStatistics && !forceRefresh) {
            return;
        }
        try {
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBPDataSource)this, (String)"Load schema statistics");){
                    Throwable throwable2 = null;
                    Object var8_12 = null;
                    try (JDBCStatement dbStat = session.createStatement();){
                        Throwable throwable3 = null;
                        Object var11_17 = null;
                        try (JDBCResultSet dbResult = dbStat.executeQuery("SELECT\n    TABSCHEMA,\n    SUM(DATA_OBJECT_P_SIZE + INDEX_OBJECT_P_SIZE + LONG_OBJECT_P_SIZE + LOB_OBJECT_P_SIZE + XML_OBJECT_P_SIZE) AS TOTAL_SIZE_IN_KB\nFROM SYSIBMADM.ADMINTABINFO\nGROUP BY TABSCHEMA");){
                            while (dbResult.next()) {
                                String schemaName = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (int)1);
                                long bytes = dbResult.getLong(2) * 1024L;
                                DB2Schema schema = this.getSchema(monitor, schemaName);
                                if (schema == null) continue;
                                schema.setSchemaTotalSize(bytes);
                            }
                            for (DB2Schema schema : this.getSchemas(monitor)) {
                                if (schema.hasStatistics()) continue;
                                schema.setSchemaTotalSize(0L);
                            }
                        }
                        catch (Throwable throwable4) {
                            if (throwable3 == null) {
                                throwable3 = throwable4;
                            } else if (throwable3 != throwable4) {
                                throwable3.addSuppressed(throwable4);
                            }
                            throw throwable3;
                        }
                    }
                    catch (Throwable throwable5) {
                        if (throwable2 == null) {
                            throwable2 = throwable5;
                        } else if (throwable2 != throwable5) {
                            throwable2.addSuppressed(throwable5);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable6) {
                    if (throwable == null) {
                        throwable = throwable6;
                    } else if (throwable != throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    throw throwable;
                }
            }
            catch (SQLException e) {
                throw new DBCException("Error reading table statistics", (Throwable)e);
            }
        }
        finally {
            this.hasStatistics = true;
        }
    }
}

