/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry.driver;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.connection.DBPAuthInfo;
import org.jkiss.dbeaver.model.connection.DBPDriverLibrary;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.registry.driver.DriverDescriptor;
import org.jkiss.dbeaver.registry.driver.DriverLibraryAbstract;
import org.jkiss.dbeaver.registry.driver.DriverLibraryMavenDependency;
import org.jkiss.dbeaver.registry.maven.MavenArtifactDependency;
import org.jkiss.dbeaver.registry.maven.MavenArtifactReference;
import org.jkiss.dbeaver.registry.maven.MavenArtifactVersion;
import org.jkiss.dbeaver.registry.maven.MavenRegistry;
import org.jkiss.dbeaver.registry.maven.MavenRepository;
import org.jkiss.utils.CommonUtils;

public class DriverLibraryMavenArtifact
extends DriverLibraryAbstract {
    private static final Log log = Log.getLog(DriverLibraryMavenArtifact.class);
    public static final String PATH_PREFIX = "maven:/";
    private MavenArtifactReference reference;
    protected MavenArtifactVersion localVersion;
    private String preferredVersion;
    private boolean ignoreDependencies;
    private boolean loadOptionalDependencies;
    private final String originalPreferredVersion;

    public DriverLibraryMavenArtifact(DriverDescriptor driver, DBPDriverLibrary.FileType type, String path, String preferredVersion) {
        super(driver, type, path);
        this.initArtifactReference(preferredVersion);
        this.originalPreferredVersion = this.preferredVersion;
    }

    public DriverLibraryMavenArtifact(DriverDescriptor driver, IConfigurationElement config) {
        super(driver, config);
        this.ignoreDependencies = CommonUtils.toBoolean((Object)config.getAttribute("ignore-dependencies"));
        this.loadOptionalDependencies = CommonUtils.toBoolean((Object)config.getAttribute("load-optional-dependencies"));
        this.initArtifactReference(null);
        this.originalPreferredVersion = this.preferredVersion;
    }

    private DriverLibraryMavenArtifact(DriverDescriptor driver, DriverLibraryMavenArtifact copyFrom) {
        super(driver, copyFrom);
        this.reference = copyFrom.reference;
        this.localVersion = copyFrom.localVersion;
        this.preferredVersion = copyFrom.preferredVersion;
        this.ignoreDependencies = copyFrom.ignoreDependencies;
        this.loadOptionalDependencies = copyFrom.loadOptionalDependencies;
        this.originalPreferredVersion = copyFrom.originalPreferredVersion;
    }

    public MavenArtifactReference getReference() {
        return this.reference;
    }

    public void setReference(MavenArtifactReference reference) {
        this.reference = reference;
        this.path = PATH_PREFIX + reference.toString();
        this.localVersion = null;
    }

    private void initArtifactReference(String preferredVersion) {
        int divPos;
        if (this.path.endsWith("]") && (divPos = this.path.lastIndexOf(91)) != -1) {
            String version = this.path.substring(divPos + 1, this.path.length() - 1);
            this.path = this.path.substring(0, divPos);
            if (preferredVersion == null) {
                preferredVersion = version;
            }
        }
        this.reference = new MavenArtifactReference(this.path);
        if (this.loadOptionalDependencies) {
            this.reference.setResolveOptionalDependencies(true);
        }
        this.preferredVersion = preferredVersion;
    }

    @Override
    public String getDescription() {
        if (this.localVersion != null) {
            return this.localVersion.getDescription();
        }
        return null;
    }

    public boolean isDownloadable() {
        return true;
    }

    public boolean isIgnoreDependencies() {
        return this.ignoreDependencies;
    }

    public void setIgnoreDependencies(boolean ignoreDependencies) {
        this.ignoreDependencies = ignoreDependencies;
    }

    public boolean isLoadOptionalDependencies() {
        return this.loadOptionalDependencies;
    }

    public void setLoadOptionalDependencies(boolean loadOptionalDependencies) {
        this.loadOptionalDependencies = loadOptionalDependencies;
    }

    @Override
    @NotNull
    public Collection<String> getAvailableVersions(DBRProgressMonitor monitor) throws IOException {
        Collection<String> availableVersions;
        MavenArtifactVersion artifactVersion = this.getArtifactVersion(monitor);
        if (artifactVersion != null && (availableVersions = artifactVersion.getArtifact().getAvailableVersions(monitor, this.reference.getVersion())) != null) {
            return availableVersions;
        }
        return Collections.emptyList();
    }

    @Override
    public String getPreferredVersion() {
        return this.preferredVersion;
    }

    @Override
    public void setPreferredVersion(String version) {
        this.preferredVersion = version;
        this.localVersion = null;
    }

    public void resetVersion() {
        this.localVersion = null;
        this.preferredVersion = this.originalPreferredVersion;
        MavenRegistry.getInstance().resetArtifactInfo(this.reference);
    }

    public boolean isSecureDownload(DBRProgressMonitor monitor) {
        MavenArtifactVersion localVersion;
        block3: {
            try {
                localVersion = this.resolveLocalVersion(monitor, false);
                if (localVersion != null) break block3;
                return true;
            }
            catch (IOException e) {
                log.warn((Object)"Error resolving artifact version", (Throwable)e);
                return true;
            }
        }
        return localVersion.getArtifact().getRepository().isSecureRepository();
    }

    @Nullable
    protected MavenArtifactVersion getArtifactVersion(DBRProgressMonitor monitor) {
        if (this.localVersion == null) {
            MavenArtifactReference ref = this.reference;
            if (this.preferredVersion != null) {
                ref = new MavenArtifactReference(this.reference.getGroupId(), this.reference.getArtifactId(), this.reference.getFallbackVersion(), this.preferredVersion);
                if (this.loadOptionalDependencies) {
                    ref.setResolveOptionalDependencies(true);
                }
            }
            this.localVersion = MavenRegistry.getInstance().findArtifact(monitor, null, ref);
        }
        return this.localVersion;
    }

    @Nullable
    public String getExternalURL(DBRProgressMonitor monitor) {
        MavenArtifactVersion localVersion = this.getArtifactVersion(monitor);
        if (localVersion != null) {
            return localVersion.getExternalURL();
        }
        return null;
    }

    @Nullable
    public File getLocalFile() {
        File platformFile = this.detectLocalFile();
        if (platformFile != null && platformFile.exists()) {
            return platformFile;
        }
        return platformFile;
    }

    private File detectLocalFile() {
        if (this.localVersion != null) {
            return this.localVersion.getCacheFile();
        }
        return null;
    }

    @Nullable
    public Collection<? extends DBPDriverLibrary> getDependencies(@NotNull DBRProgressMonitor monitor) throws IOException {
        List<MavenArtifactDependency> artifactDeps;
        ArrayList<DriverLibraryMavenDependency> dependencies = new ArrayList<DriverLibraryMavenDependency>();
        if (this.ignoreDependencies) {
            return dependencies;
        }
        MavenArtifactVersion localVersion = this.resolveLocalVersion(monitor, false);
        if (localVersion != null && !CommonUtils.isEmpty(artifactDeps = localVersion.getDependencies())) {
            for (MavenArtifactDependency dependency : artifactDeps) {
                if (this.isDependencyExcluded(monitor, dependency)) continue;
                MavenArtifactVersion depArtifact = MavenRegistry.getInstance().findArtifact(monitor, localVersion, dependency);
                if (depArtifact != null) {
                    dependencies.add(new DriverLibraryMavenDependency(this, depArtifact, dependency));
                    continue;
                }
                dependency.setBroken(true);
            }
        }
        return dependencies;
    }

    protected boolean isDependencyExcluded(DBRProgressMonitor monitor, MavenArtifactDependency dependency) {
        return false;
    }

    @NotNull
    public String getDisplayName() {
        return this.reference.toString();
    }

    public String getId() {
        return this.reference.getId();
    }

    @Override
    public String getVersion() {
        if (this.preferredVersion != null && !this.preferredVersion.isEmpty()) {
            return this.preferredVersion;
        }
        if (this.localVersion != null) {
            return this.localVersion.getVersion();
        }
        return this.reference.getVersion();
    }

    @NotNull
    public DBIcon getIcon() {
        return DBIcon.APACHE;
    }

    @Override
    public void downloadLibraryFile(@NotNull DBRProgressMonitor monitor, boolean forceUpdate, String taskName) throws IOException, InterruptedException {
        MavenArtifactVersion localVersion = this.resolveLocalVersion(monitor, forceUpdate);
        if (localVersion.getArtifact().getRepository().getType() == MavenRepository.RepositoryType.LOCAL) {
            return;
        }
        super.downloadLibraryFile(monitor, forceUpdate, taskName);
    }

    @Override
    @Nullable
    protected DBPAuthInfo getAuthInfo(DBRProgressMonitor monitor) {
        MavenArtifactVersion localVersion = this.getArtifactVersion(monitor);
        if (localVersion != null) {
            return localVersion.getArtifact().getRepository().getAuthInfo();
        }
        return null;
    }

    @Override
    public DBPDriverLibrary copyLibrary(DriverDescriptor driverDescriptor) {
        return new DriverLibraryMavenArtifact(this.driver, this);
    }

    protected MavenArtifactVersion resolveLocalVersion(DBRProgressMonitor monitor, boolean forceUpdate) throws IOException {
        MavenArtifactVersion version;
        if (forceUpdate) {
            MavenRegistry.getInstance().resetArtifactInfo(this.reference);
        }
        if ((version = this.getArtifactVersion(monitor)) == null) {
            throw new IOException("Maven artifact '" + this.path + "' not found");
        }
        return version;
    }
}

