/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry;

import java.io.File;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPExternalFileManager;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistry;
import org.jkiss.dbeaver.model.app.DBPPlatform;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.app.DBPProjectListener;
import org.jkiss.dbeaver.model.app.DBPResourceHandler;
import org.jkiss.dbeaver.model.app.DBPResourceHandlerDescriptor;
import org.jkiss.dbeaver.model.app.DBPWorkspace;
import org.jkiss.dbeaver.model.app.DBPWorkspaceEclipse;
import org.jkiss.dbeaver.model.auth.SMSession;
import org.jkiss.dbeaver.model.auth.SMSessionContext;
import org.jkiss.dbeaver.model.impl.auth.SessionContextImpl;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.LoggingProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.virtual.DBVModel;
import org.jkiss.dbeaver.registry.BasicWorkspaceSession;
import org.jkiss.dbeaver.registry.ProjectMetadata;
import org.jkiss.dbeaver.registry.ResourceHandlerDescriptor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.SecurityUtils;

public abstract class BaseWorkspaceImpl
implements DBPWorkspaceEclipse,
DBPExternalFileManager {
    private static final Log log = Log.getLog(BaseWorkspaceImpl.class);
    public static final String DEFAULT_RESOURCES_ROOT = "Resources";
    private static final String PROP_PROJECT_ACTIVE = "project.active";
    private static final String EXT_FILES_PROPS_STORE = "dbeaver-external-files.data";
    private static final String WORKSPACE_ID = "workspace-id";
    private final DBPPlatform platform;
    private final IWorkspace eclipseWorkspace;
    private final SessionContextImpl workspaceAuthContext;
    private final Map<IProject, ProjectMetadata> projects = new LinkedHashMap<IProject, ProjectMetadata>();
    private final ProjectListener projectListener;
    private ProjectMetadata activeProject;
    private final List<DBPProjectListener> projectListeners = new ArrayList<DBPProjectListener>();
    private final List<ResourceHandlerDescriptor> handlerDescriptors = new ArrayList<ResourceHandlerDescriptor>();
    private final Map<String, Map<String, Object>> externalFileProperties = new HashMap<String, Map<String, Object>>();
    private final AbstractJob externalFileSaver = new WorkspaceFilesMetadataJob();

    protected BaseWorkspaceImpl(DBPPlatform platform, IWorkspace eclipseWorkspace) {
        this.platform = platform;
        this.eclipseWorkspace = eclipseWorkspace;
        this.workspaceAuthContext = new SessionContextImpl(null);
        this.projectListener = new ProjectListener();
        this.eclipseWorkspace.addResourceChangeListener((IResourceChangeListener)this.projectListener);
        this.loadExtensions(Platform.getExtensionRegistry());
        this.loadExternalFileProperties();
    }

    private void loadWorkspaceProjects() {
        try {
            this.workspaceAuthContext.addSession(this.acquireWorkspaceSession((DBRProgressMonitor)new VoidProgressMonitor()));
        }
        catch (DBException e) {
            log.error((Object)e);
            DBWorkbench.getPlatformUI().showMessageBox("Authentication error", "Error authenticating application user: \n" + e.getMessage(), true);
            System.exit(101);
        }
        String activeProjectName = this.platform.getPreferenceStore().getString(PROP_PROJECT_ACTIVE);
        IWorkspaceRoot root = this.eclipseWorkspace.getRoot();
        Object[] allProjects = root.getProjects();
        if (ArrayUtils.isEmpty((Object[])allProjects)) {
            try {
                this.refreshWorkspaceContents((DBRProgressMonitor)new LoggingProgressMonitor(log));
            }
            catch (Throwable e) {
                log.error((Object)e);
            }
            allProjects = root.getProjects();
        }
        Object[] objectArray = allProjects;
        int n = allProjects.length;
        int n2 = 0;
        while (n2 < n) {
            Object project = objectArray[n2];
            if (project.exists() && !project.isHidden()) {
                ProjectMetadata projectMetadata = new ProjectMetadata((DBPWorkspace)this, (IProject)project, (SMSessionContext)this.workspaceAuthContext);
                this.projects.put((IProject)project, projectMetadata);
                if (this.activeProject == null || !CommonUtils.isEmpty((String)activeProjectName) && project.getName().equals(activeProjectName)) {
                    this.activeProject = projectMetadata;
                }
            }
            ++n2;
        }
        if (this.activeProject != null && !this.activeProject.isOpen()) {
            try {
                this.activeProject.ensureOpen();
            }
            catch (IllegalStateException e) {
                log.error((Object)"Error opening active project", (Throwable)e);
            }
        }
    }

    @NotNull
    protected SMSession acquireWorkspaceSession(@NotNull DBRProgressMonitor monitor) throws DBException {
        return new BasicWorkspaceSession((DBPWorkspace)this);
    }

    public void initializeProjects() {
        this.loadWorkspaceProjects();
        if (DBWorkbench.getPlatform().getApplication().isStandalone() && CommonUtils.isEmpty(this.projects)) {
            try {
                this.createDefaultProject((IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                log.error((Object)"Can't create default project", (Throwable)e);
            }
        }
        if (this.activeProject == null && !this.projects.isEmpty()) {
            this.activeProject = this.projects.values().iterator().next();
            this.platform.getPreferenceStore().setValue(PROP_PROJECT_ACTIVE, this.activeProject.getName());
        }
    }

    public static Properties readWorkspaceInfo(Path metadataFolder) {
        Properties props = new Properties();
        Path versionFile = metadataFolder.resolve("dbeaver-workspace.properties");
        if (Files.exists(versionFile, new LinkOption[0])) {
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (InputStream is = Files.newInputStream(versionFile, new OpenOption[0]);){
                    props.load(is);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
        return props;
    }

    public static void writeWorkspaceInfo(Path metadataFolder, Properties props) {
        Path versionFile = metadataFolder.resolve("dbeaver-workspace.properties");
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (OutputStream os = Files.newOutputStream(versionFile, new OpenOption[0]);){
                props.store(os, "DBeaver workspace version");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    private void loadExtensions(IExtensionRegistry registry) {
        IConfigurationElement[] extElements;
        IConfigurationElement[] iConfigurationElementArray = extElements = registry.getConfigurationElementsFor("org.jkiss.dbeaver.resourceHandler");
        int n = extElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ext = iConfigurationElementArray[n2];
            ResourceHandlerDescriptor handlerDescriptor = new ResourceHandlerDescriptor(ext);
            this.handlerDescriptors.add(handlerDescriptor);
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        this.eclipseWorkspace.removeResourceChangeListener((IResourceChangeListener)this.projectListener);
        Map<IProject, ProjectMetadata> map = this.projects;
        synchronized (map) {
            for (ProjectMetadata project : this.projects.values()) {
                project.dispose();
            }
            this.projects.clear();
        }
        DBVModel.checkGlobalCacheIsEmpty();
        for (ResourceHandlerDescriptor handlerDescriptor : this.handlerDescriptors) {
            handlerDescriptor.dispose();
        }
        this.handlerDescriptors.clear();
        if (!this.projectListeners.isEmpty()) {
            log.warn((Object)("Some project listeners are still register: " + this.projectListeners));
            this.projectListeners.clear();
        }
    }

    @NotNull
    public IWorkspace getEclipseWorkspace() {
        return this.eclipseWorkspace;
    }

    @NotNull
    public List<DBPProject> getProjects() {
        return new ArrayList<DBPProject>(this.projects.values());
    }

    public DBPProject getActiveProject() {
        return this.activeProject;
    }

    public void setActiveProject(DBPProject project) {
        ProjectMetadata oldActiveProject = this.activeProject;
        this.activeProject = (ProjectMetadata)project;
        this.platform.getPreferenceStore().setValue(PROP_PROJECT_ACTIVE, project == null ? "" : project.getName());
        this.fireActiveProjectChange(oldActiveProject, this.activeProject);
    }

    public DBPProject getProject(@NotNull IProject project) {
        return this.projects.get(project);
    }

    public DBPProject getProject(@NotNull String projectName) {
        IProject eProject = this.eclipseWorkspace.getRoot().getProject(projectName);
        if (!eProject.exists()) {
            return null;
        }
        return this.getProject(eProject);
    }

    @NotNull
    public SMSessionContext getAuthContext() {
        return this.workspaceAuthContext;
    }

    public void refreshWorkspaceContents(DBRProgressMonitor monitor) throws DBException {
        block9: {
            try {
                IWorkspaceRoot root = this.eclipseWorkspace.getRoot();
                root.refreshLocal(1, monitor.getNestedMonitor());
                File workspaceLocation = root.getLocation().toFile();
                if (!workspaceLocation.exists()) {
                    return;
                }
                IProject[] iProjectArray = root.getProjects();
                int n = iProjectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject project = iProjectArray[n2];
                    File projectDir = project.getLocation().toFile();
                    if (!projectDir.exists()) {
                        monitor.subTask("Removing unexistent project '" + project.getName() + "'");
                        project.delete(false, true, monitor.getNestedMonitor());
                    }
                    ++n2;
                }
                Object[] wsFiles = workspaceLocation.listFiles();
                if (ArrayUtils.isEmpty((Object[])wsFiles)) break block9;
                monitor.beginTask("Refreshing workspace contents", wsFiles.length);
                Object[] objectArray = wsFiles;
                int n3 = wsFiles.length;
                n = 0;
                while (n < n3) {
                    String projectName;
                    IProject project;
                    File projectConfig;
                    Object wsFile = objectArray[n];
                    if (((File)wsFile).isDirectory() && !((File)wsFile).isHidden() && !((File)wsFile).getName().startsWith(".") && (projectConfig = new File((File)wsFile, ".project")).exists() && !(project = root.getProject(projectName = ((File)wsFile).getName())).exists()) {
                        try {
                            monitor.subTask("Adding project '" + projectName + "'");
                            project.create(monitor.getNestedMonitor());
                        }
                        catch (CoreException coreException) {
                            log.error((Object)("Error adding project '" + projectName + "' to workspace"));
                        }
                    }
                    ++n;
                }
            }
            catch (Throwable e) {
                log.error((Object)"Error refreshing workspce contents", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProjectListener(DBPProjectListener listener) {
        List<DBPProjectListener> list = this.projectListeners;
        synchronized (list) {
            this.projectListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProjectListener(DBPProjectListener listener) {
        List<DBPProjectListener> list = this.projectListeners;
        synchronized (list) {
            this.projectListeners.remove(listener);
        }
    }

    @NotNull
    public DBPPlatform getPlatform() {
        return this.platform;
    }

    public boolean isActive() {
        return true;
    }

    @NotNull
    public Path getAbsolutePath() {
        return this.eclipseWorkspace.getRoot().getLocation().toFile().toPath();
    }

    @NotNull
    public Path getMetadataFolder() {
        return this.getAbsolutePath().resolve(".metadata");
    }

    public void save(DBRProgressMonitor monitor) throws DBException {
        try {
            this.eclipseWorkspace.save(true, monitor.getNestedMonitor());
        }
        catch (CoreException e) {
            throw new DBException("Error saving Eclipse workspace", (Throwable)e);
        }
    }

    private IProject createDefaultProject(IProgressMonitor monitor) throws CoreException {
        String baseProjectName;
        String projectName = baseProjectName = DBWorkbench.getPlatform().getApplication().getDefaultProjectName();
        int i = 1;
        while (true) {
            IProject project;
            if (!(project = this.eclipseWorkspace.getRoot().getProject(projectName)).exists()) {
                project.create(monitor);
                project.open(monitor);
                IProjectDescription description = this.eclipseWorkspace.newProjectDescription(project.getName());
                description.setComment("General DBeaver project");
                description.setNatureIds(new String[]{"org.jkiss.dbeaver.DBeaverNature"});
                project.setDescription(description, monitor);
                return project;
            }
            projectName = String.valueOf(baseProjectName) + i;
            ++i;
        }
    }

    private ResourceHandlerDescriptor getHandlerDescriptor(String id) {
        for (ResourceHandlerDescriptor rhd : this.handlerDescriptors) {
            if (!rhd.getId().equals(id)) continue;
            return rhd;
        }
        return null;
    }

    private ResourceHandlerDescriptor getHandlerDescriptorByRootPath(DBPProject project, String path) {
        for (ResourceHandlerDescriptor rhd : this.handlerDescriptors) {
            String defaultRoot = rhd.getDefaultRoot(project);
            if (defaultRoot == null || !defaultRoot.equals(path)) continue;
            return rhd;
        }
        return null;
    }

    public DBPResourceHandler getResourceHandler(IResource resource) {
        if (DBWorkbench.getPlatform().getApplication().isExclusiveMode()) {
            return null;
        }
        if (resource == null || resource.isHidden() || resource.isPhantom()) {
            return null;
        }
        if (resource.getParent() instanceof IProject && resource.getName().startsWith(".dbeaver-data-sources")) {
            return null;
        }
        if (resource instanceof IFile && !resource.isSynchronized(0)) {
            ContentUtils.syncFile((DBRProgressMonitor)new VoidProgressMonitor(), (IResource)resource);
        }
        DBPResourceHandler handler = null;
        for (ResourceHandlerDescriptor rhd : this.handlerDescriptors) {
            if (!rhd.canHandle(resource)) continue;
            handler = rhd.getHandler();
            break;
        }
        if (handler == null && resource instanceof IFolder) {
            IProject eclipseProject = resource.getProject();
            DBPProject project = this.projects.get(eclipseProject);
            IPath relativePath = resource.getFullPath().makeRelativeTo(eclipseProject.getFullPath());
            while (relativePath.segmentCount() > 0) {
                String folderPath = relativePath.toString();
                ResourceHandlerDescriptor handlerDescriptor = this.getHandlerDescriptorByRootPath(project, folderPath);
                if (handlerDescriptor != null) {
                    handler = handlerDescriptor.getHandler();
                }
                relativePath = relativePath.removeLastSegments(1);
            }
        }
        if (handler == null) {
            handler = DBWorkbench.getPlatform().getDefaultResourceHandler();
        }
        return handler;
    }

    public DBPResourceHandlerDescriptor[] getAllResourceHandlers() {
        return this.handlerDescriptors.toArray(new DBPResourceHandlerDescriptor[0]);
    }

    public IFolder getResourceDefaultRoot(DBPProject project, DBPResourceHandlerDescriptor rhd, boolean forceCreate) {
        if (project == null) {
            return null;
        }
        String defaultRoot = rhd.getDefaultRoot(project);
        if (defaultRoot == null) {
            return null;
        }
        IFolder realFolder = project.getEclipseProject().getFolder(defaultRoot);
        if (forceCreate && !realFolder.exists()) {
            try {
                realFolder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                log.error((Object)("Can't create '" + rhd.getName() + "' root folder '" + realFolder.getName() + "'"), (Throwable)e);
                return realFolder;
            }
        }
        return realFolder;
    }

    public IFolder getResourceDefaultRoot(DBPProject project, Class<? extends DBPResourceHandler> handlerType, boolean forceCreate) {
        if (project == null) {
            return null;
        }
        for (ResourceHandlerDescriptor rhd : this.handlerDescriptors) {
            DBPResourceHandler handler = rhd.getHandler();
            if (handler == null || handler.getClass() != handlerType) continue;
            String defaultRoot = rhd.getDefaultRoot(project);
            if (defaultRoot == null) {
                return null;
            }
            IFolder realFolder = project.getEclipseProject().getFolder(defaultRoot);
            if (forceCreate && !realFolder.exists()) {
                try {
                    realFolder.create(true, true, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    log.error((Object)("Can't create '" + rhd.getName() + "' root folder '" + realFolder.getName() + "'"), (Throwable)e);
                    return realFolder;
                }
            }
            return realFolder;
        }
        return project.getEclipseProject().getFolder(DEFAULT_RESOURCES_ROOT);
    }

    public DBPDataSourceRegistry getDefaultDataSourceRegistry() {
        return this.activeProject == null ? null : this.activeProject.getDataSourceRegistry();
    }

    public DBPResourceHandlerDescriptor[] getResourceHandlerDescriptors() {
        DBPResourceHandlerDescriptor[] result = new DBPResourceHandlerDescriptor[this.handlerDescriptors.size()];
        int i = 0;
        while (i < this.handlerDescriptors.size()) {
            result[i] = this.handlerDescriptors.get(i);
            ++i;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getFileProperties(File file) {
        Map<String, Map<String, Object>> map = this.externalFileProperties;
        synchronized (map) {
            return this.externalFileProperties.get(file.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getFileProperty(File file, String property) {
        Map<String, Map<String, Object>> map = this.externalFileProperties;
        synchronized (map) {
            Map<String, Object> fileProps = this.externalFileProperties.get(file.getAbsolutePath());
            return fileProps == null ? null : fileProps.get(property);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFileProperty(File file, String property, Object value) {
        Map<String, Map<String, Object>> map = this.externalFileProperties;
        synchronized (map) {
            String filePath = file.getAbsolutePath();
            Map<String, Object> fileProps = this.externalFileProperties.get(filePath);
            if (fileProps == null) {
                fileProps = new HashMap<String, Object>();
                this.externalFileProperties.put(filePath, fileProps);
            }
            if (value == null) {
                fileProps.remove(property);
            } else {
                fileProps.put(property, value);
            }
        }
        this.saveExternalFileProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Map<String, Object>> getAllFiles() {
        Map<String, Map<String, Object>> map = this.externalFileProperties;
        synchronized (map) {
            return new LinkedHashMap<String, Map<String, Object>>(this.externalFileProperties);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadExternalFileProperties() {
        Map<String, Map<String, Object>> map = this.externalFileProperties;
        synchronized (map) {
            this.externalFileProperties.clear();
            Path propsFile = GeneralUtils.getMetadataFolder().resolve(EXT_FILES_PROPS_STORE);
            if (Files.exists(propsFile, new LinkOption[0])) {
                try {
                    Throwable throwable = null;
                    Object var4_6 = null;
                    try (InputStream is = Files.newInputStream(propsFile, new OpenOption[0]);){
                        Throwable throwable2 = null;
                        Object var7_11 = null;
                        try (ObjectInputStream ois = new ObjectInputStream(is);){
                            Object object = ois.readObject();
                            if (object instanceof Map) {
                                this.externalFileProperties.putAll((Map)object);
                            } else {
                                log.error((Object)("Bad external files properties data format: " + object));
                            }
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                            } else if (throwable2 != throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            throw throwable2;
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable == null) {
                            throwable = throwable4;
                        } else if (throwable != throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    log.error((Object)"Error saving external files properties", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveExternalFileProperties() {
        Map<String, Map<String, Object>> map = this.externalFileProperties;
        synchronized (map) {
            this.externalFileSaver.schedule(100L);
        }
    }

    private void fireActiveProjectChange(ProjectMetadata oldActiveProject, ProjectMetadata activeProject) {
        DBPProjectListener[] dBPProjectListenerArray = this.getListenersCopy();
        int n = dBPProjectListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            DBPProjectListener listener = dBPProjectListenerArray[n2];
            listener.handleActiveProjectChange((DBPProject)oldActiveProject, (DBPProject)activeProject);
            ++n2;
        }
    }

    private void fireProjectAdd(ProjectMetadata project) {
        DBPProjectListener[] dBPProjectListenerArray = this.getListenersCopy();
        int n = dBPProjectListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            DBPProjectListener listener = dBPProjectListenerArray[n2];
            listener.handleProjectAdd((DBPProject)project);
            ++n2;
        }
    }

    private void fireProjectRemove(ProjectMetadata project) {
        DBPProjectListener[] dBPProjectListenerArray = this.getListenersCopy();
        int n = dBPProjectListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            DBPProjectListener listener = dBPProjectListenerArray[n2];
            listener.handleProjectRemove((DBPProject)project);
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private DBPProjectListener[] getListenersCopy() {
        DBPProjectListener[] listeners;
        List<DBPProjectListener> list = this.projectListeners;
        synchronized (list) {
            listeners = this.projectListeners.toArray(new DBPProjectListener[0]);
        }
        return listeners;
    }

    private void handleResourceChange(ProjectMetadata projectMetadata, IResourceDelta delta) {
        if (delta.getKind() == 2) {
            IPath movedToPath = delta.getMovedToPath();
            if (movedToPath != null) {
                IPath oldPath = delta.getProjectRelativePath();
                IPath newPath = movedToPath.makeRelativeTo(projectMetadata.getEclipseProject().getFullPath());
                projectMetadata.updateResourceCache(oldPath, newPath);
            } else {
                projectMetadata.removeResourceFromCache(delta.getProjectRelativePath());
            }
        } else {
            IResourceDelta[] iResourceDeltaArray = delta.getAffectedChildren(31, 8);
            int n = iResourceDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceDelta childDelta = iResourceDeltaArray[n2];
                this.handleResourceChange(projectMetadata, childDelta);
                ++n2;
            }
        }
    }

    public static String readWorkspaceId() {
        Properties workspaceInfo = BaseWorkspaceImpl.readWorkspaceInfo(GeneralUtils.getMetadataFolder());
        String workspaceId = workspaceInfo.getProperty(WORKSPACE_ID);
        if (CommonUtils.isEmpty((String)workspaceId)) {
            workspaceId = "D" + Long.toString(Math.abs(SecurityUtils.generateRandomLong()), 36).toUpperCase();
            workspaceInfo.setProperty(WORKSPACE_ID, workspaceId);
            BaseWorkspaceImpl.writeWorkspaceInfo(GeneralUtils.getMetadataFolder(), workspaceInfo);
        }
        return workspaceId;
    }

    private class ProjectListener
    implements IResourceChangeListener {
        private ProjectListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            if (event.getType() == 1) {
                Arrays.stream(event.getDelta().getAffectedChildren()).filter(delta -> delta.getResource() instanceof IProject).sorted(Comparator.comparingInt(IResourceDelta::getKind).reversed()).forEach(delta -> {
                    IProject project = (IProject)delta.getResource();
                    if (!BaseWorkspaceImpl.this.projects.containsKey(project)) {
                        if (delta.getKind() == 1) {
                            ProjectMetadata projectMetadata = new ProjectMetadata((DBPWorkspace)BaseWorkspaceImpl.this, project, (SMSessionContext)BaseWorkspaceImpl.this.workspaceAuthContext);
                            BaseWorkspaceImpl.this.projects.put(project, projectMetadata);
                            BaseWorkspaceImpl.this.fireProjectAdd(projectMetadata);
                            if (BaseWorkspaceImpl.this.activeProject == null) {
                                BaseWorkspaceImpl.this.activeProject = projectMetadata;
                                BaseWorkspaceImpl.this.fireActiveProjectChange(null, BaseWorkspaceImpl.this.activeProject);
                            }
                        } else {
                            log.error((Object)("Project '" + delta.getResource().getName() + "' not found in workspace"));
                        }
                    } else if (delta.getKind() == 2) {
                        ProjectMetadata projectMetadata = BaseWorkspaceImpl.this.projects.remove(project);
                        BaseWorkspaceImpl.this.fireProjectRemove(projectMetadata);
                        if (projectMetadata == BaseWorkspaceImpl.this.activeProject) {
                            BaseWorkspaceImpl.this.activeProject = null;
                            BaseWorkspaceImpl.this.fireActiveProjectChange(projectMetadata, null);
                        }
                    } else {
                        ProjectMetadata projectMetadata = BaseWorkspaceImpl.this.projects.get(project);
                        if (projectMetadata != null) {
                            BaseWorkspaceImpl.this.handleResourceChange(projectMetadata, (IResourceDelta)delta);
                        }
                    }
                });
            }
        }
    }

    private class WorkspaceFilesMetadataJob
    extends AbstractJob {
        public WorkspaceFilesMetadataJob() {
            super("External files metadata saver");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(DBRProgressMonitor monitor) {
            Map<String, Map<String, Object>> map = BaseWorkspaceImpl.this.externalFileProperties;
            synchronized (map) {
                Path propsFile = GeneralUtils.getMetadataFolder().resolve(BaseWorkspaceImpl.EXT_FILES_PROPS_STORE);
                try {
                    Throwable throwable = null;
                    Object var5_7 = null;
                    try (OutputStream os = Files.newOutputStream(propsFile, new OpenOption[0]);){
                        Throwable throwable2 = null;
                        Object var8_12 = null;
                        try (ObjectOutputStream oos = new ObjectOutputStream(os);){
                            oos.writeObject(BaseWorkspaceImpl.this.externalFileProperties);
                        }
                        catch (Throwable throwable3) {
                            if (throwable2 == null) {
                                throwable2 = throwable3;
                            } else if (throwable2 != throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                            throw throwable2;
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable == null) {
                            throwable = throwable4;
                        } else if (throwable != throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    log.error((Object)"Error saving external files properties", (Throwable)e);
                }
            }
            return Status.OK_STATUS;
        }
    }
}

