/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.data.transfer.ui.processor.config;

import com.dbeaver.data.transfer.mail.SMTPProfile;
import com.dbeaver.data.transfer.mail.SMTPProfileManager;
import com.dbeaver.data.transfer.ui.internal.DTEEMessages;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.tools.transfer.stream.StreamConsumerSettings;
import org.jkiss.dbeaver.tools.transfer.ui.IDataTransferEventProcessorConfigurator;
import org.jkiss.dbeaver.ui.UIIcon;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.utils.CommonUtils;

public class SendMailEventProcessorConfigurator
implements IDataTransferEventProcessorConfigurator {
    private final List<SMTPProfile> profiles = new ArrayList<SMTPProfile>();
    private SMTPProfile profile;
    private String recipient;
    private String subject;
    private Combo profileCombo;

    public void createControl(@NotNull Composite parent, Object object, final @NotNull Runnable propertyChangeListener) {
        final Composite group = new Composite(parent, 0);
        group.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(3).create());
        group.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).hint(300, -1).create());
        this.profileCombo = UIUtils.createLabelCombo((Composite)group, (String)DTEEMessages.data_transfer_event_processor_send_mail_profile, (int)12);
        this.profileCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SendMailEventProcessorConfigurator.this.profile = SendMailEventProcessorConfigurator.this.profiles.get(SendMailEventProcessorConfigurator.this.profileCombo.getSelectionIndex());
                propertyChangeListener.run();
            }
        });
        ToolBar toolbar = new ToolBar(group, 256);
        UIUtils.createToolItem((ToolBar)toolbar, (String)DTEEMessages.data_transfer_event_processor_send_mail_profile_configure, (DBPImage)UIIcon.CONFIGURATION, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UIUtils.showPreferencesFor((Shell)group.getShell(), null, (String[])new String[]{"com.dbeaver.preferences.mail"});
                SendMailEventProcessorConfigurator.this.refreshProfiles(propertyChangeListener);
            }
        });
        Text recipientText = UIUtils.createLabelText((Composite)group, (String)DTEEMessages.data_transfer_event_processor_send_mail_to, (String)this.recipient);
        recipientText.setToolTipText(DTEEMessages.data_transfer_event_processor_send_mail_to_tip);
        recipientText.addModifyListener(e -> {
            this.recipient = recipientText.getText();
            propertyChangeListener.run();
        });
        ((GridData)recipientText.getLayoutData()).horizontalSpan = 2;
        Text subjectText = UIUtils.createLabelText((Composite)group, (String)DTEEMessages.data_transfer_event_processor_send_mail_subject, (String)this.subject);
        subjectText.addModifyListener(e -> {
            this.subject = subjectText.getText();
            propertyChangeListener.run();
        });
        ((GridData)subjectText.getLayoutData()).horizontalSpan = 2;
        UIUtils.asyncExec(() -> this.refreshProfiles(propertyChangeListener));
    }

    public void loadSettings(@NotNull Map<String, Object> settings) {
        this.profile = SMTPProfileManager.getProfile((String)CommonUtils.toString((Object)settings.get("profile")));
        this.recipient = CommonUtils.toString((Object)settings.get("recipient"));
        this.subject = CommonUtils.toString((Object)settings.get("subject"));
    }

    public void saveSettings(@NotNull Map<String, Object> settings) {
        settings.put("profile", this.profile.getId());
        settings.put("recipient", this.recipient);
        settings.put("subject", this.subject);
    }

    public void resetSettings(@NotNull Map<String, Object> settings) {
    }

    public boolean isComplete() {
        return this.profile != null && !CommonUtils.isEmptyTrimmed((String)this.recipient) && !CommonUtils.isEmptyTrimmed((String)this.subject);
    }

    public boolean isApplicable(@NotNull StreamConsumerSettings configuration) {
        return !configuration.isOutputClipboard();
    }

    private void refreshProfiles(@NotNull Runnable propertyChangeListener) {
        SMTPProfile previousProfile = this.profile;
        this.profile = null;
        this.profiles.clear();
        this.profiles.addAll(SMTPProfileManager.getProfiles());
        this.profileCombo.removeAll();
        for (SMTPProfile profile : this.profiles) {
            this.profileCombo.add(profile.toString());
        }
        int i = 0;
        while (i < this.profiles.size()) {
            if (previousProfile == null || this.profiles.get(i).getId().equals(previousProfile.getId())) {
                this.profileCombo.select(i);
                this.profile = this.profiles.get(i);
                break;
            }
            ++i;
        }
        propertyChangeListener.run();
    }
}

