/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.couchdb.exec;

import com.dbeaver.db.couchdb.CouchDBUtils;
import com.dbeaver.db.couchdb.exec.CouchDBAbstractStatement;
import com.dbeaver.db.couchdb.exec.CouchDBResultSet;
import com.dbeaver.db.couchdb.exec.CouchDBSession;
import com.dbeaver.db.couchdb.model.CouchDBDatabase;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import net.sf.jsqlparser.expression.Expression;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.sql.parser.SQLSemanticProcessor;

public class CouchDBDatabaseStatement
extends CouchDBAbstractStatement {
    private static final Log log = Log.getLog(CouchDBDatabaseStatement.class);
    public static final String[][] QUOTE_STRINGS = new String[][]{{"\"", "\""}};
    private CouchDBDatabase database;
    private final String queryText;
    private long offset;
    private long limit;
    private List<JsonObject> results;

    public CouchDBDatabaseStatement(CouchDBSession session, CouchDBDatabase database, long firstRow, long maxRows, DBDDataFilter dataFilter) throws DBCException {
        super(session);
        this.database = database;
        this.offset = firstRow;
        this.limit = maxRows;
        this.queryText = this.createQueryText(dataFilter);
        if (session.isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleStatementOpen((DBCStatement)this);
        }
    }

    private String createQueryText(DBDDataFilter dataFilter) throws DBCException {
        try {
            StringWriter out = new StringWriter();
            JsonWriter json = this.database.getClient().getGson().newJsonWriter((Writer)out);
            json.beginObject();
            json.name("selector");
            json.beginObject();
            if (dataFilter != null && dataFilter.hasConditions()) {
                this.addSelectorFilter(json, dataFilter);
            }
            json.endObject();
            if (this.offset > 0L) {
                JSONUtils.field((JsonWriter)json, (String)"skip", (long)this.offset);
            }
            if (this.limit > 0L) {
                JSONUtils.field((JsonWriter)json, (String)"limit", (long)this.limit);
            }
            json.endObject();
            json.flush();
            return out.toString();
        }
        catch (Exception e) {
            throw new DBCException("Error constructing JSON query", (Throwable)e);
        }
    }

    private void addSelectorFilter(JsonWriter json, DBDDataFilter dataFilter) throws IOException, DBCException {
        StringBuilder condString = new StringBuilder();
        SQLUtils.appendConditionString((DBDDataFilter)dataFilter, (DBPDataSource)this.database.getDataSource(), null, (StringBuilder)condString, (boolean)true);
        Expression expr = SQLSemanticProcessor.parseCondExpression((String)condString.toString());
        CouchDBUtils.injectSQLExpresstion(json, expr);
    }

    public CouchDBDatabase getDatabase() {
        return this.database;
    }

    public String getQueryString() {
        return this.queryText;
    }

    public boolean executeStatement() throws DBCException {
        if (((CouchDBSession)this.getSession()).isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleStatementExecuteBegin((DBCStatement)this);
        }
        this.results = this.database.getClient().findDocs(this.queryText, JsonObject.class);
        return true;
    }

    @NotNull
    public CouchDBResultSet openResultSet() throws DBCException {
        return new CouchDBResultSet(this, this.results);
    }
}

