/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.couchdb;

import com.dbeaver.db.couchdb.data.CouchDBDocument;
import com.dbeaver.db.couchdb.exec.CouchDBDatabaseStatement;
import com.dbeaver.db.couchdb.model.CouchDBDataSource;
import com.dbeaver.ee.model.document.data.DBMapValue;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sf.jsqlparser.expression.BinaryExpression;
import net.sf.jsqlparser.expression.DateValue;
import net.sf.jsqlparser.expression.DoubleValue;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.Parenthesis;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.TimeValue;
import net.sf.jsqlparser.expression.TimestampValue;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.GreaterThan;
import net.sf.jsqlparser.expression.operators.relational.GreaterThanEquals;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.expression.operators.relational.LikeExpression;
import net.sf.jsqlparser.expression.operators.relational.MinorThan;
import net.sf.jsqlparser.expression.operators.relational.MinorThanEquals;
import net.sf.jsqlparser.expression.operators.relational.NotEqualsTo;
import net.sf.jsqlparser.schema.Column;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.data.json.JSONUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.sql.SQLUtils;

public class CouchDBUtils {
    private static final Log log = Log.getLog(CouchDBUtils.class);
    private static final String OPER_NE = "$ne";
    private static final String OPER_GT = "$gt";
    private static final String OPER_GTE = "$gte";
    private static final String OPER_LT = "$lt";
    private static final String OPER_LTE = "$lte";
    private static final String OPER_REGEX = "$regex";
    private static final String OPER_IN = "$in";

    public static DBPDataKind getAttributeKind(Object value) {
        if (value instanceof String) {
            return DBPDataKind.STRING;
        }
        if (value instanceof Number) {
            return DBPDataKind.NUMERIC;
        }
        if (value instanceof Boolean) {
            return DBPDataKind.BOOLEAN;
        }
        if (value instanceof Date) {
            return DBPDataKind.DATETIME;
        }
        if (value instanceof JsonObject) {
            return DBPDataKind.STRUCT;
        }
        if (value instanceof JsonArray) {
            return DBPDataKind.ARRAY;
        }
        return DBPDataKind.OBJECT;
    }

    public static Object getMapAttributeValue(@NotNull CouchDBDataSource dataSource, Object parent, Object value) {
        if (value instanceof JsonObject) {
            return CouchDBUtils.makeMapValue(dataSource, parent, (JsonObject)value);
        }
        if (value instanceof JsonArray) {
            return CouchDBUtils.makeRawList(dataSource, parent, (JsonArray)value);
        }
        if (value instanceof JsonPrimitive) {
            JsonPrimitive primitive = (JsonPrimitive)value;
            if (primitive.isBoolean()) {
                return primitive.getAsBoolean();
            }
            if (primitive.isNumber()) {
                try {
                    return primitive.getAsLong();
                }
                catch (Exception exception) {
                    try {
                        return primitive.getAsDouble();
                    }
                    catch (Exception exception2) {
                        try {
                            return primitive.getAsBigDecimal();
                        }
                        catch (Exception exception3) {
                            return primitive.getAsString();
                        }
                    }
                }
            }
            return primitive.getAsString();
        }
        if (value instanceof JsonElement) {
            return value.toString();
        }
        return value;
    }

    private static List<Object> makeRawList(@NotNull CouchDBDataSource dataSource, Object parent, JsonArray list) {
        ArrayList<Object> rawList = new ArrayList<Object>();
        for (Object av : list) {
            rawList.add(CouchDBUtils.getMapAttributeValue(dataSource, parent, av));
        }
        return rawList;
    }

    public static DBMapValue<CouchDBDataSource> makeMapValue(@NotNull CouchDBDataSource dataSource, Object parent, JsonObject item) {
        LinkedHashMap<String, Object> rawMap = new LinkedHashMap<String, Object>();
        for (Map.Entry entry : item.entrySet()) {
            rawMap.put((String)entry.getKey(), CouchDBUtils.getMapAttributeValue(dataSource, parent, entry.getValue()));
        }
        return new DBMapValue((DBPDataSource)dataSource, parent, rawMap);
    }

    public static Map<String, Object> unwrapMapValue(DBMapValue<CouchDBDataSource> value) {
        return CouchDBUtils.unwrapPlainMap(value.getRawValue());
    }

    private static Map<String, Object> unwrapPlainMap(Map<String, Object> value) {
        LinkedHashMap<String, Object> dbObject = new LinkedHashMap<String, Object>();
        if (value != null) {
            for (Map.Entry<String, Object> me : value.entrySet()) {
                dbObject.put(me.getKey(), CouchDBUtils.unwrapPlainValue(me.getValue()));
            }
        }
        return dbObject;
    }

    private static List<Object> unwrapPlainList(List<?> value) {
        ArrayList<Object> dbObject = new ArrayList<Object>();
        for (Object item : value) {
            dbObject.add(CouchDBUtils.unwrapPlainValue(item));
        }
        return dbObject;
    }

    public static Object unwrapPlainValue(Object value) {
        if (value instanceof CouchDBDocument) {
            return CouchDBUtils.unwrapMapValue((DBMapValue<CouchDBDataSource>)((CouchDBDocument)((Object)value)).getRootNode());
        }
        if (value instanceof DBMapValue) {
            return CouchDBUtils.unwrapMapValue((DBMapValue<CouchDBDataSource>)((DBMapValue)value));
        }
        if (value instanceof Map) {
            return CouchDBUtils.unwrapPlainMap((Map)value);
        }
        if (value instanceof List) {
            return CouchDBUtils.unwrapPlainList((List)value);
        }
        return value;
    }

    public static void injectSQLExpresstion(JsonWriter json, Expression expr) throws DBCException, IOException {
        if (expr instanceof AndExpression) {
            CouchDBUtils.injectSQLExpresstion(json, ((AndExpression)expr).getLeftExpression());
            CouchDBUtils.injectSQLExpresstion(json, ((AndExpression)expr).getRightExpression());
        } else if (expr instanceof InExpression) {
            Expression leftExpression = ((InExpression)expr).getLeftExpression();
            if (!(leftExpression instanceof Column)) {
                throw new DBCException("IN conditions mast have column on the left side");
            }
            if (!(((InExpression)expr).getRightItemsList() instanceof ExpressionList)) {
                throw new DBCException("IN conditions mast have expression list on the right side");
            }
            ExpressionList itemsList = (ExpressionList)((InExpression)expr).getRightItemsList();
            Column column = (Column)leftExpression;
            String fieldName = CouchDBUtils.unquote(column.getFullyQualifiedName());
            ArrayList<Object> values = new ArrayList<Object>();
            for (Expression exp : itemsList.getExpressions()) {
                Object fieldValue = CouchDBUtils.parseValueExpression(exp);
                values.add(fieldValue);
            }
            CouchDBUtils.makeObjectCondition(json, fieldName, values, OPER_IN);
        } else {
            if (expr instanceof OrExpression) {
                throw new DBCException("OR conditions not supported: " + expr);
            }
            if (expr instanceof BinaryExpression) {
                CouchDBUtils.parseBinaryExpression(json, (BinaryExpression)expr);
            } else if (expr instanceof Parenthesis) {
                CouchDBUtils.injectSQLExpresstion(json, ((Parenthesis)expr).getExpression());
            } else {
                throw new DBCException("Unsupported expression: " + expr);
            }
        }
    }

    private static void parseBinaryExpression(JsonWriter json, BinaryExpression expr) throws DBCException, IOException {
        String operator;
        Expression left = expr.getLeftExpression();
        if (!(left instanceof Column)) {
            throw new DBCException("Unsupported left operand: " + left);
        }
        Column column = (Column)left;
        String fieldName = CouchDBUtils.unquote(column.getFullyQualifiedName());
        Object fieldValue = CouchDBUtils.parseValueExpression(expr.getRightExpression());
        if (expr instanceof EqualsTo) {
            operator = null;
        } else if (expr instanceof NotEqualsTo) {
            operator = OPER_NE;
        } else if (expr instanceof GreaterThan) {
            operator = OPER_GT;
        } else if (expr instanceof GreaterThanEquals) {
            operator = OPER_GTE;
        } else if (expr instanceof MinorThan) {
            operator = OPER_LT;
        } else if (expr instanceof MinorThanEquals) {
            operator = OPER_LTE;
        } else if (expr instanceof LikeExpression) {
            operator = OPER_REGEX;
        } else {
            throw new DBCException("Unsupported operation: " + expr.getStringExpression());
        }
        CouchDBUtils.makeObjectCondition(json, fieldName, fieldValue, operator);
    }

    private static void makeObjectCondition(JsonWriter json, String fieldName, Object value, String operator) throws IOException, DBCException {
        if (operator != null) {
            json.name(fieldName);
            json.beginObject();
            fieldName = operator;
        }
        if (value instanceof String) {
            JSONUtils.field((JsonWriter)json, (String)fieldName, (String)((String)value));
        } else if (value instanceof Number) {
            JSONUtils.field((JsonWriter)json, (String)fieldName, (Number)((Number)value));
        } else if (value instanceof Boolean) {
            JSONUtils.field((JsonWriter)json, (String)fieldName, (boolean)((Boolean)value));
        } else {
            throw new DBCException("Unsupported field value: " + value);
        }
        if (operator != null) {
            json.endObject();
        }
    }

    private static Object parseValueExpression(Expression expr) throws DBCException {
        if (expr instanceof StringValue) {
            return ((StringValue)expr).getValue();
        }
        if (expr instanceof LongValue) {
            return ((LongValue)expr).getValue();
        }
        if (expr instanceof DoubleValue) {
            return ((DoubleValue)expr).getValue();
        }
        if (expr instanceof TimestampValue) {
            return ((TimestampValue)expr).getValue();
        }
        if (expr instanceof TimeValue) {
            return ((TimeValue)expr).getValue();
        }
        if (expr instanceof DateValue) {
            return ((DateValue)expr).getValue();
        }
        if (expr instanceof Column) {
            String literal = CouchDBUtils.unquote(((Column)expr).getFullyQualifiedName());
            if (literal.equals("true") || literal.equals("false")) {
                return Boolean.valueOf(literal);
            }
            throw new DBCException("Unexpected literal: " + expr);
        }
        throw new DBCException("Unsupported value: " + expr);
    }

    private static String unquote(String name) {
        CharSequence[] attrNameParts = SQLUtils.splitFullIdentifier((String)name, (String)".", (String[][])CouchDBDatabaseStatement.QUOTE_STRINGS, (boolean)false);
        return String.join((CharSequence)".", attrNameParts);
    }
}

