/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.oracle.ui.wallet;

import com.dbeaver.db.oracle.ui.wallet.AuthModelWalletMessages;
import java.util.LinkedHashMap;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.ui.IObjectPropertyConfigurator;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.TextWithOpenFolder;
import org.jkiss.utils.CommonUtils;

public class AuthModelWalletConfigurator
implements IObjectPropertyConfigurator<Object, DBPDataSourceContainer> {
    private TextWithOpenFolder walletFolder;

    public void createControl(@NotNull Composite parent, Object object, @NotNull Runnable propertyChangeListener) {
        UIUtils.createLabel((Composite)parent, (String)AuthModelWalletMessages.model_wallet_folder);
        this.walletFolder = new TextWithOpenFolder(parent, AuthModelWalletMessages.model_wallet_folder);
        this.walletFolder.setLayoutData((Object)new GridData(768));
        this.walletFolder.setToolTipText(AuthModelWalletMessages.model_wallet_folder_help);
    }

    public void loadSettings(@NotNull DBPDataSourceContainer dataSource) {
        DBPConnectionConfiguration configuration = dataSource.getConnectionConfiguration();
        this.walletFolder.setText(CommonUtils.notEmpty((String)configuration.getAuthProperty("oracle.wallet.dir")));
    }

    public void saveSettings(@NotNull DBPDataSourceContainer dataSource) {
        DBPConnectionConfiguration configuration = dataSource.getConnectionConfiguration();
        LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
        props.put("oracle.wallet.dir", this.walletFolder.getText());
        configuration.setAuthProperties(props);
    }

    public void resetSettings(@NotNull DBPDataSourceContainer configuration) {
    }

    public boolean isComplete() {
        return false;
    }
}

