/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2dl.text;

import java.util.List;
import org.eclipse.draw2dl.IFigure;
import org.eclipse.draw2dl.geometry.Dimension;
import org.eclipse.draw2dl.geometry.Rectangle;
import org.eclipse.draw2dl.text.BlockFlow;
import org.eclipse.draw2dl.text.FlowFigure;
import org.eclipse.draw2dl.text.FlowFigureLayout;
import org.eclipse.draw2dl.text.PageFlowLayout;

public class FlowPage
extends BlockFlow {
    private Dimension pageSize = new Dimension();
    private int recommendedWidth;
    private int[] pageSizeCacheKeys = new int[3];
    private Dimension[] pageSizeCacheValues = new Dimension[3];

    @Override
    public void addNotify() {
        super.addNotify();
        this.setValid(false);
    }

    @Override
    protected FlowFigureLayout createDefaultFlowLayout() {
        return new PageFlowLayout(this);
    }

    @Override
    public Dimension getMinimumSize(int w, int h) {
        return this.getPreferredSize(w, h);
    }

    @Override
    public void invalidate() {
        this.pageSizeCacheValues = new Dimension[3];
        super.invalidate();
    }

    @Override
    public Dimension getPreferredSize(int width, int h) {
        int i = 0;
        while (i < 3) {
            if (this.pageSizeCacheKeys[i] == width && this.pageSizeCacheValues[i] != null) {
                return this.pageSizeCacheValues[i];
            }
            ++i;
        }
        this.pageSizeCacheKeys[2] = this.pageSizeCacheKeys[1];
        this.pageSizeCacheKeys[1] = this.pageSizeCacheKeys[0];
        this.pageSizeCacheKeys[0] = width;
        this.pageSizeCacheValues[2] = this.pageSizeCacheValues[1];
        this.pageSizeCacheValues[1] = this.pageSizeCacheValues[0];
        int oldWidth = this.getPageWidth();
        this.setPageWidth(width);
        this.validate();
        this.pageSizeCacheValues[0] = this.pageSize.getCopy();
        if (width != oldWidth) {
            this.setPageWidth(oldWidth);
            this.getUpdateManager().addInvalidFigure(this);
        }
        return this.pageSizeCacheValues[0];
    }

    int getPageWidth() {
        return this.recommendedWidth;
    }

    @Override
    public void postValidate() {
        Rectangle r = this.getBlockBox().toRectangle();
        this.pageSize.width = r.width;
        this.pageSize.height = r.height;
        List<IFigure> v = this.getChildren();
        for (IFigure iFigure : v) {
            ((FlowFigure)iFigure).postValidate();
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.setValid(true);
    }

    @Override
    public void setBounds(Rectangle r) {
        if (this.getBounds().equals(r)) {
            return;
        }
        boolean invalidate = this.getBounds().width != r.width || this.getBounds().height != r.height;
        super.setBounds(r);
        int newWidth = r.width;
        if (invalidate || this.getPageWidth() != newWidth) {
            this.setPageWidth(newWidth);
            this.getUpdateManager().addInvalidFigure(this);
        }
    }

    private void setPageWidth(int width) {
        if (this.recommendedWidth == width) {
            return;
        }
        this.recommendedWidth = width;
        super.invalidate();
    }

    @Override
    public void validate() {
        if (this.isValid()) {
            return;
        }
        super.validate();
        this.postValidate();
    }
}

