/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2dl.graph;

import org.eclipse.draw2dl.geometry.Insets;
import org.eclipse.draw2dl.geometry.Point;
import org.eclipse.draw2dl.geometry.PointList;
import org.eclipse.draw2dl.geometry.Rectangle;
import org.eclipse.draw2dl.graph.DirectedGraph;
import org.eclipse.draw2dl.graph.Edge;
import org.eclipse.draw2dl.graph.GraphVisitor;
import org.eclipse.draw2dl.graph.Node;
import org.eclipse.draw2dl.graph.Path;
import org.eclipse.draw2dl.graph.ShortestPathRouter;
import org.eclipse.draw2dl.graph.SubgraphBoundary;
import org.eclipse.draw2dl.graph.VirtualNode;

class RouteEdges
extends GraphVisitor {
    RouteEdges() {
    }

    @Override
    public void revisit(DirectedGraph g) {
        int i = 0;
        while (i < g.edges.size()) {
            SubgraphBoundary boundary;
            Edge edge = (Edge)g.edges.get(i);
            edge.start = new Point(edge.getSourceOffset() + edge.source.x, edge.source.y + edge.source.height);
            if (edge.source instanceof SubgraphBoundary && boundary.getParent().head == (boundary = (SubgraphBoundary)edge.source)) {
                edge.start.y = boundary.getParent().y + boundary.getParent().insets.top;
            }
            edge.end = new Point(edge.getTargetOffset() + edge.target.x, edge.target.y);
            if (edge.vNodes != null) {
                RouteEdges.routeLongEdge(edge, g);
            } else {
                PointList list = new PointList();
                list.addPoint(edge.start);
                list.addPoint(edge.end);
                edge.setPoints(list);
            }
            ++i;
        }
    }

    static void routeLongEdge(Edge edge, DirectedGraph g) {
        ShortestPathRouter router = new ShortestPathRouter();
        Path path = new Path(edge.start, edge.end);
        router.addPath(path);
        int i = 0;
        while (i < edge.vNodes.size()) {
            Insets padding;
            Rectangle o;
            Node neighbor;
            VirtualNode node = (VirtualNode)edge.vNodes.get(i);
            if (node.left != null) {
                neighbor = node.left;
                o = new Rectangle(neighbor.x, neighbor.y, neighbor.width, neighbor.height);
                padding = g.getPadding(neighbor);
                o.width += padding.right + padding.left;
                o.width += edge.getPadding() * 2;
                o.x -= padding.left + edge.getPadding();
                o.union(o.getLocation().translate(-100000, 2));
                router.addObstacle(o);
            }
            if (node.right != null) {
                neighbor = node.right;
                o = new Rectangle(neighbor.x, neighbor.y, neighbor.width, neighbor.height);
                padding = g.getPadding(neighbor);
                o.width += padding.right + padding.left;
                o.width += edge.getPadding() * 2;
                o.x -= padding.left + edge.getPadding();
                o.union(o.getLocation().translate(100000, 2));
                router.addObstacle(o);
            }
            ++i;
        }
        router.setSpacing(0);
        router.solve();
        edge.setPoints(path.getPoints());
    }
}

