/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2dl.graph;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2dl.graph.Node;
import org.eclipse.draw2dl.graph.Rank;
import org.eclipse.draw2dl.graph.Subgraph;

class NestingTree {
    List contents = new ArrayList();
    boolean isLeaf = true;
    int size;
    double sortValue;
    Node subgraph;

    NestingTree() {
    }

    private static void addToNestingTree(Map map, Node child) {
        Subgraph subgraph = child.getParent();
        NestingTree parent = (NestingTree)map.get(subgraph);
        if (parent == null) {
            parent = new NestingTree();
            parent.subgraph = subgraph;
            map.put(subgraph, parent);
            if (subgraph != null) {
                NestingTree.addToNestingTree(map, parent);
            }
        }
        parent.contents.add(child);
    }

    private static void addToNestingTree(Map map, NestingTree branch) {
        Subgraph subgraph = branch.subgraph.getParent();
        NestingTree parent = (NestingTree)map.get(subgraph);
        if (parent == null) {
            parent = new NestingTree();
            parent.subgraph = subgraph;
            map.put(subgraph, parent);
            if (subgraph != null) {
                NestingTree.addToNestingTree(map, parent);
            }
        }
        parent.contents.add(branch);
    }

    static NestingTree buildNestingTreeForRank(Rank rank) {
        HashMap nestingMap = new HashMap();
        int j = 0;
        while (j < rank.count()) {
            Node node = rank.getNode(j);
            NestingTree.addToNestingTree(nestingMap, node);
            ++j;
        }
        return (NestingTree)nestingMap.get(null);
    }

    void calculateSortValues() {
        int total = 0;
        int i = 0;
        while (i < this.contents.size()) {
            Object o = this.contents.get(i);
            if (o instanceof NestingTree) {
                this.isLeaf = false;
                NestingTree e = (NestingTree)o;
                e.calculateSortValues();
                total += (int)(e.sortValue * (double)e.size);
                this.size += e.size;
            } else {
                Node n = (Node)o;
                n.sortValue = n.index;
                total += n.index;
                ++this.size;
            }
            ++i;
        }
        this.sortValue = (double)total / (double)this.size;
    }

    void getSortValueFromSubgraph() {
        if (this.subgraph != null) {
            this.sortValue = this.subgraph.sortValue;
        }
        int i = 0;
        while (i < this.contents.size()) {
            Object o = this.contents.get(i);
            if (o instanceof NestingTree) {
                ((NestingTree)o).getSortValueFromSubgraph();
            }
            ++i;
        }
    }

    void recursiveSort(boolean sortLeaves) {
        int i;
        if (this.isLeaf && !sortLeaves) {
            return;
        }
        boolean change = false;
        do {
            change = false;
            i = 0;
            while (i < this.contents.size() - 1) {
                change |= this.swap(i);
                ++i;
            }
            if (!change) break;
            change = false;
            i = this.contents.size() - 2;
            while (i >= 0) {
                change |= this.swap(i);
                --i;
            }
        } while (change);
        i = 0;
        while (i < this.contents.size()) {
            Object o = this.contents.get(i);
            if (o instanceof NestingTree) {
                ((NestingTree)o).recursiveSort(sortLeaves);
            }
            ++i;
        }
    }

    void repopulateRank(Rank r) {
        int i = 0;
        while (i < this.contents.size()) {
            Object o = this.contents.get(i);
            if (o instanceof Node) {
                r.add(o);
            } else {
                ((NestingTree)o).repopulateRank(r);
            }
            ++i;
        }
    }

    boolean swap(int index) {
        double iR;
        Object left = this.contents.get(index);
        Object right = this.contents.get(index + 1);
        double iL = left instanceof Node ? ((Node)left).sortValue : ((NestingTree)left).sortValue;
        double d = iR = right instanceof Node ? ((Node)right).sortValue : ((NestingTree)right).sortValue;
        if (iL <= iR) {
            return false;
        }
        this.contents.set(index, right);
        this.contents.set(index + 1, left);
        return true;
    }

    public String toString() {
        return "Nesting:" + this.subgraph;
    }
}

